/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf;

import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.PdfImagePanel;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.SignatureField;
import java.awt.Rectangle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisibleSignatureField {
    private static final Logger LOG = LogManager.getLogger(VisibleSignatureField.class);
    private SignatureField signatureField;
    private int x;
    private int y;
    private int width;
    private int height;

    private VisibleSignatureField() {
    }

    public static VisibleSignatureField createFieldFromPanel(SignatureField signatureField, PdfImagePanel panel) {
        LOG.trace("Signaturfeld neu von GUI...");
        LOG.trace("SignatureField x:y - w:h : {}:{} - {}:{}", (Object)Float.valueOf(signatureField.getX()), (Object)Float.valueOf(signatureField.getY()), (Object)Float.valueOf(signatureField.getWidth()), (Object)Float.valueOf(signatureField.getHeight()));
        VisibleSignatureField vsf = new VisibleSignatureField();
        vsf.signatureField = signatureField;
        vsf.x = (int)signatureField.getX();
        vsf.y = (int)signatureField.getY();
        vsf.width = (int)signatureField.getWidth();
        vsf.height = (int)signatureField.getHeight();
        String vsfString = vsf.toString();
        LOG.trace("Signaturfeld => VisibleSignatureField");
        LOG.trace(vsfString);
        LOG.trace("Signaturfeld neu unrotate in Panel...");
        float[] dim = vsf.unrotate(panel, signatureField.getX(), signatureField.getY(), signatureField.getWidth(), signatureField.getHeight());
        vsf.signatureField.setX(dim[0]);
        vsf.signatureField.setY(dim[1]);
        vsf.signatureField.setWidth(dim[2]);
        vsf.signatureField.setHeight(dim[3]);
        return vsf;
    }

    public static VisibleSignatureField createFieldFromPDF(SignatureField signatureField, PdfImagePanel panel) {
        LOG.trace("PDF eigene Signaturfelder ...");
        VisibleSignatureField vsf = new VisibleSignatureField();
        vsf.signatureField = signatureField;
        LOG.trace("existierende Signaturfeld {} rotate ...", (Object)signatureField.getFieldName());
        float[] dim = vsf.rotate(panel, signatureField.getX(), signatureField.getY(), signatureField.getWidth(), signatureField.getHeight());
        vsf.x = (int)dim[0];
        vsf.y = (int)dim[1];
        vsf.width = (int)dim[2];
        vsf.height = (int)dim[3];
        return vsf;
    }

    float[] rotate(PdfImagePanel panel, float myX, float myY, float myWidth, float myHeight) {
        LOG.trace("-- rotate x:y - w:h : {}:{} - {}:{}", (Object)Float.valueOf(myX), (Object)Float.valueOf(myY), (Object)Float.valueOf(myWidth), (Object)Float.valueOf(myHeight));
        LOG.trace("-- panel.cropBox w:h - {}:{}", (Object)panel.cropBoxWidth, (Object)panel.cropBoxHeight);
        float[] ret = new float[4];
        switch (panel.getRotation()) {
            case 90: {
                LOG.trace("90\u00b0 - rechts gedreht");
                ret[0] = (float)panel.cropBoxWidth - (myY + myHeight) * 0.7638889f;
                ret[1] = myX * 0.7638889f;
                ret[2] = myHeight * 0.7638889f;
                ret[3] = myWidth * 0.7638889f;
                break;
            }
            case 180: {
                LOG.trace("180\u00b0 - 2*rechts gedreht");
                ret[0] = (float)panel.cropBoxWidth - (myX + myWidth) * 0.7638889f;
                ret[1] = (float)panel.cropBoxHeight - (myY + myHeight) * 0.7638889f;
                ret[2] = myWidth * 0.7638889f;
                ret[3] = myHeight * 0.7638889f;
                break;
            }
            case 270: {
                LOG.trace("270\u00b0 - 3*rechts=links gedreht");
                ret[0] = myY * 0.7638889f;
                ret[1] = (float)panel.cropBoxHeight - (myX + myWidth) * 0.7638889f;
                ret[2] = myHeight * 0.7638889f;
                ret[3] = myWidth * 0.7638889f;
                break;
            }
            default: {
                LOG.trace("default. rotation : {}", (Object)panel.getRotation());
                LOG.trace("0\u00b0 | 360\u00b0 - PDF ist nicht gedreht");
                ret[0] = myX * 0.7638889f;
                ret[1] = myY * 0.7638889f;
                ret[2] = myWidth * 0.7638889f;
                ret[3] = myHeight * 0.7638889f;
            }
        }
        LOG.trace("-- rotate done x:y - w:h : {}:{} - {}:{}", (Object)Float.valueOf(ret[0]), (Object)Float.valueOf(ret[1]), (Object)Float.valueOf(ret[2]), (Object)Float.valueOf(ret[3]));
        return ret;
    }

    float[] unrotate(PdfImagePanel panel, float myX, float myY, float myWidth, float myHeight) {
        LOG.trace("-- unrotate sigfeld x:y - w:h : {}:{} - {}:{}", (Object)Float.valueOf(myX), (Object)Float.valueOf(myY), (Object)Float.valueOf(myWidth), (Object)Float.valueOf(myHeight));
        LOG.trace("-- panel.cropBox w:h - {}:{}", (Object)panel.cropBoxWidth, (Object)panel.cropBoxHeight);
        float[] ret = new float[4];
        switch (panel.getRotation()) {
            case 90: {
                LOG.trace("90\u00b0 - rechts gedreht");
                ret[0] = myY / 0.7638889f;
                ret[1] = ((float)panel.cropBoxWidth - myX - myWidth) / 0.7638889f;
                ret[2] = myHeight / 0.7638889f;
                ret[3] = myWidth / 0.7638889f;
                break;
            }
            case 180: {
                LOG.trace("180\u00b0 - 2*rechts gedreht");
                ret[0] = ((float)panel.cropBoxWidth - myX - myWidth) / 0.7638889f;
                ret[1] = ((float)panel.cropBoxHeight - myY - myHeight) / 0.7638889f;
                ret[2] = myWidth / 0.7638889f;
                ret[3] = myHeight / 0.7638889f;
                break;
            }
            case 270: {
                LOG.trace("270\u00b0 - 3*rechts=links gedreht");
                ret[0] = ((float)panel.cropBoxHeight - myY - myHeight) / 0.7638889f;
                ret[1] = myX / 0.7638889f;
                ret[2] = myHeight / 0.7638889f;
                ret[3] = myWidth / 0.7638889f;
                break;
            }
            default: {
                LOG.trace("default. rotation : {}", (Object)panel.getRotation());
                LOG.trace("0\u00b0 | 360\u00b0 - PDF nicht gedreht");
                ret[0] = myX / 0.7638889f;
                ret[1] = myY / 0.7638889f;
                ret[2] = myWidth / 0.7638889f;
                ret[3] = myHeight / 0.7638889f;
            }
        }
        LOG.trace("-- unrotate done x:y - w:h : {}:{} - {}:{}", (Object)Float.valueOf(ret[0]), (Object)Float.valueOf(ret[1]), (Object)Float.valueOf(ret[2]), (Object)Float.valueOf(ret[3]));
        return ret;
    }

    public boolean isSignatureFieldPosition(int positionX, int positionY) {
        LOG.trace("");
        boolean isSignatureFieldPosition = false;
        if (positionX >= this.x && positionX <= this.x + this.width && positionY >= this.y && positionY <= this.y + this.height) {
            isSignatureFieldPosition = true;
        }
        return isSignatureFieldPosition;
    }

    public SignatureField getSignatureField() {
        return this.signatureField;
    }

    public void changeDimension(Rectangle r, PdfImagePanel panel) {
        LOG.trace("");
        this.x = (int)(r.getX() + 0.5);
        this.y = (int)(r.getY() + 0.5);
        this.width = (int)(r.getWidth() + 0.5);
        this.height = (int)(r.getHeight() + 0.5);
        LOG.trace("Signaturfeld unrotate ...");
        float[] dim = this.unrotate(panel, this.x, this.y, this.width, this.height);
        this.signatureField.setX(dim[0]);
        this.signatureField.setY(dim[1]);
        this.signatureField.setWidth(dim[2]);
        this.signatureField.setHeight(dim[3]);
    }

    public Rectangle getRect() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : x:y - w:h : " + this.x + ":" + this.y + " - " + this.width + ":" + this.height;
    }
}

