/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf;

import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.AdvancedPDFDialog;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.PdfImagePanel;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.VisibleSignatureField;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

public class Resizer
extends MouseAdapter {
    private boolean resizing = false;
    private boolean dragging = false;
    private static final int PROX_DIST = 3;
    private AdvancedPDFDialog parent;
    private boolean canDrag = false;
    private Point dragFrom = null;

    public Resizer(AdvancedPDFDialog parent, PdfImagePanel r) {
        this.parent = parent;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e == null) {
            return;
        }
        Object object = e.getSource();
        if (!(object instanceof PdfImagePanel)) {
            return;
        }
        PdfImagePanel component = (PdfImagePanel)object;
        if (this.isResizeCursor(component.getCursor())) {
            this.resizing = true;
        } else if (this.isHandCursor(component.getCursor())) {
            this.dragging = true;
            component.setCursor(Cursor.getPredefinedCursor(13));
            this.canDrag = this.isOverSelected(e.getPoint(), component);
            if (component.getSelectedSignatureFieldRect() != null && this.canDrag) {
                Rectangle rect = component.getSelectedSignatureFieldRect();
                this.dragFrom = new Point(e.getX() - rect.x, e.getY() - rect.y);
            }
        } else {
            this.parent.setFocusForSigField(e, component);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e == null) {
            return;
        }
        Object object = e.getSource();
        if (!(object instanceof PdfImagePanel)) {
            return;
        }
        PdfImagePanel component = (PdfImagePanel)object;
        this.canDrag = false;
        if (this.dragging) {
            this.dragging = false;
            component.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.resizing = false;
        }
        if (component.getSelectedSignatureField() != null && component.getSelectedSignatureFieldRect() != null) {
            this.parent.changeSignatureFieldList(component.getSelectedSignatureField(), component.getSelectedSignatureFieldRect());
        }
        if (this.isTempSignField(component.getSelectedSignatureField(), component)) {
            component.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e == null) {
            return;
        }
        Object object = e.getSource();
        if (!(object instanceof PdfImagePanel)) {
            return;
        }
        PdfImagePanel component = (PdfImagePanel)object;
        VisibleSignatureField selected = component.getSelectedSignatureField();
        if (selected == null) {
            return;
        }
        if (!this.isTempSignField(selected, component)) {
            return;
        }
        Rectangle r = component.getSelectedSignatureFieldRect();
        if (r == null) {
            component.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (!this.resizing && this.dragging) {
            this.drag(component, r, e.getPoint());
        }
        if (this.resizing) {
            this.resize(component, r, e.getPoint());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e == null) {
            return;
        }
        if (!(e.getSource() instanceof PdfImagePanel)) {
            return;
        }
        PdfImagePanel component = (PdfImagePanel)e.getSource();
        if (component == null) {
            return;
        }
        Point p = e.getPoint();
        if (p == null) {
            return;
        }
        if (!this.isOverSelected(p, component)) {
            component.setCursor(Cursor.getDefaultCursor());
            return;
        }
        boolean isTempSignField = this.isTempSignField(component.getSelectedSignatureField(), component);
        if (!isTempSignField) {
            component.setCursor(Cursor.getDefaultCursor());
            return;
        }
        Rectangle r = component.getSelectedSignatureFieldRect();
        if (r == null) {
            return;
        }
        switch (this.getOutcode(p, component)) {
            case 2: {
                if (Math.abs(p.y - r.y) >= 3) break;
                component.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 3: {
                if (Math.abs(p.y - r.y) >= 3 || Math.abs(p.x - r.x) >= 3) break;
                component.setCursor(Cursor.getPredefinedCursor(6));
                break;
            }
            case 1: {
                if (Math.abs(p.x - r.x) >= 3) break;
                component.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case 9: {
                if (Math.abs(p.x - r.x) >= 3 || Math.abs(p.y - (r.y + r.height)) >= 3) break;
                component.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 8: {
                if (Math.abs(p.y - (r.y + r.height)) >= 3) break;
                component.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case 12: {
                if (Math.abs(p.x - (r.x + r.width)) >= 3 || Math.abs(p.y - (r.y + r.height)) >= 3) break;
                component.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case 4: {
                if (Math.abs(p.x - (r.x + r.width)) >= 3) break;
                component.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 6: {
                if (Math.abs(p.x - (r.x + r.width)) >= 3 || Math.abs(p.y - r.y) >= 3) break;
                component.setCursor(Cursor.getPredefinedCursor(7));
                break;
            }
            default: {
                component.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }

    private int getOutcode(Point p, PdfImagePanel component) {
        Rectangle r = (Rectangle)component.getSelectedSignatureFieldRect().clone();
        r.grow(-3, -3);
        return r.outcode(p.x, p.y);
    }

    private boolean isOverSelected(Point p, PdfImagePanel component) {
        if (p == null) {
            return false;
        }
        if (component == null) {
            return false;
        }
        Rectangle rectangle = component.getSelectedSignatureFieldRect();
        if (rectangle == null) {
            return false;
        }
        Rectangle r = (Rectangle)rectangle.clone();
        r.grow(3, 3);
        return r.contains(p);
    }

    private boolean isTempSignField(VisibleSignatureField selected, PdfImagePanel component) {
        if (component == null) {
            return false;
        }
        if (selected == null) {
            return false;
        }
        List<VisibleSignatureField> tempFields = component.getTempSignatureFields();
        return tempFields.contains(selected);
    }

    private boolean isResizeCursor(Cursor cursor) {
        return 4 <= cursor.getType() && cursor.getType() <= 11;
    }

    private boolean isHandCursor(Cursor cursor) {
        return cursor == Cursor.getPredefinedCursor(12);
    }

    private void drag(PdfImagePanel component, Rectangle r, Point p) {
        if (component == null) {
            return;
        }
        if (r == null) {
            return;
        }
        if (p == null) {
            return;
        }
        int x = p.x - this.dragFrom.x;
        int y = p.y - this.dragFrom.y;
        boolean isOnCropBox = component.isOnCropBox(x, y, r.width, r.height);
        if (isOnCropBox && this.canDrag) {
            component.setCursor(Cursor.getPredefinedCursor(13));
            r.setRect(x, y, r.width, r.height);
            component.setSelectedSignatureFieldRect(r);
        }
    }

    private void resize(PdfImagePanel component, Rectangle r, Point p) {
        if (component == null) {
            return;
        }
        if (r == null) {
            return;
        }
        if (p == null) {
            return;
        }
        int type = component.getCursor().getType();
        int height = r.height;
        int width = r.width;
        int x = r.x;
        int y = r.y;
        int dx = p.x - r.x;
        int dy = p.y - r.y;
        boolean unexpectedType = false;
        switch (type) {
            case 8: {
                width = r.width;
                height = r.height - dy;
                x = r.x;
                y = r.y + dy;
                break;
            }
            case 6: {
                width = r.width - dx;
                height = r.height - dy;
                x = r.x + dx;
                y = r.y + dy;
                break;
            }
            case 10: {
                width = r.width - dx;
                height = r.height;
                x = r.x + dx;
                y = r.y;
                break;
            }
            case 4: {
                width = r.width - dx;
                height = dy;
                x = r.x + dx;
                y = r.y;
                break;
            }
            case 9: {
                width = r.width;
                height = dy;
                x = r.x;
                y = r.y;
                break;
            }
            case 5: {
                width = dx;
                height = dy;
                x = r.x;
                y = r.y;
                break;
            }
            case 11: {
                width = dx;
                height = r.height;
                x = r.x;
                y = r.y;
                break;
            }
            case 7: {
                width = dx;
                height = r.height - dy;
                x = r.x;
                y = r.y + dy;
                break;
            }
            default: {
                unexpectedType = true;
            }
        }
        if (!unexpectedType && component.isOnCropBox(x, y, width, height)) {
            r.setRect(x, y, width, height);
            component.setSelectedSignatureFieldRect(new Rectangle((int)(r.getX() + 0.5), (int)(r.getY() + 0.5), (int)(r.getWidth() + 0.5), (int)(r.getHeight() + 0.5)));
        }
    }
}

