/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf;

import de.bos_bremen.ecard.client.Utils;
import de.governikus.csl.pdf.sign.PDFVisualSignatureDetails;
import de.governikus.csl.pdf.sign.impl.PDFSignOptionsImpl;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.PDFMetaData;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.Page;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.Rectangle;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.SignatureField;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PdfUtils {
    private static final Logger LOG = LogManager.getLogger(PdfUtils.class);

    private PdfUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static void getPdfMetaData(File pdfFile) {
        PDFMetaData pdfMetaData = null;
        try (FileInputStream fileInputStream = new FileInputStream(pdfFile);){
            pdfMetaData = new PDFMetaData((InputStream)fileInputStream);
            LOG.trace("pdfMetaData exists, da PDF kein Passwortschutz hat : {}", (Object)(pdfMetaData != null ? 1 : 0));
            Utils.closeStream((Closeable)pdfMetaData);
        }
        catch (IOException e) {
            LOG.error("get PDFMetaData failed, wenn PDF ein Passwortschutz hat: {}", (Object)e.getMessage());
            LOG.error("", (Throwable)e);
        }
    }

    public static PDFSignOptionsImpl transform(PDFSignOptionsImpl pdfOptions, Page page) {
        int rotation = page.getRotation();
        LOG.trace("pdfOptions drehen : {} ...", (Object)rotation);
        if (rotation == 0 || rotation == 360) {
            return pdfOptions;
        }
        PDFVisualSignatureDetails vsd = pdfOptions.getVisualSignatureDetails();
        float x = vsd.getPositionX().floatValue();
        float y = vsd.getPositionY().floatValue();
        float w = vsd.getSignatureWidth().floatValue();
        float h = vsd.getSignatureHeight().floatValue();
        SignatureField sf = new SignatureField(x, y, w, h);
        sf.setPageNo(vsd.getPage().intValue());
        sf.setUsableForSigning(true);
        LOG.trace("neu auto sig feld transform ...");
        float[] dim = PdfUtils.transformSfInPage(sf, page);
        vsd.setPositionX(Double.valueOf(dim[0]));
        vsd.setPositionY(Double.valueOf(dim[1]));
        vsd.setSignatureWidth(Double.valueOf(dim[2]));
        vsd.setSignatureHeight(Double.valueOf(dim[3]));
        pdfOptions.setVisualSignatureDetails(vsd);
        LOG.trace("pdfOptions drehen done.");
        return pdfOptions;
    }

    public static float[] transformSfInPage(SignatureField sf, Page pdfPage) {
        LOG.trace("-- transform x:y (%) - w:h (sm) : {}:{} (%) - {}:{} (cm)", (Object)Float.valueOf(sf.getX()), (Object)Float.valueOf(sf.getY()), (Object)Float.valueOf(sf.getWidth()), (Object)Float.valueOf(sf.getHeight()));
        float relativeWidthHF = sf.getWidth() / 21.0f;
        float relativeHeightHF = sf.getHeight() / 29.7f;
        float relativeWidthQF = sf.getWidth() / 29.7f;
        float relativeHeightQF = sf.getHeight() / 21.0f;
        LOG.trace("-- transform HF x:y (%) - w:h (sm) : {}:{} (%) - {}:{} (%)", (Object)Float.valueOf(sf.getX()), (Object)Float.valueOf(sf.getY()), (Object)Float.valueOf(relativeWidthHF), (Object)Float.valueOf(relativeHeightHF));
        LOG.trace("-- transform QF x:y (%) - w:h (sm) : {}:{} (%) - {}:{} (%)", (Object)Float.valueOf(sf.getX()), (Object)Float.valueOf(sf.getY()), (Object)Float.valueOf(relativeWidthQF), (Object)Float.valueOf(relativeHeightQF));
        boolean createAsPortraitFormat = PdfUtils.isCreateAsPortraitFormat(pdfPage);
        float[] ret = new float[4];
        switch (pdfPage.getRotation()) {
            case 90: {
                LOG.trace("90\u00b0 - rechts gedreht");
                if (createAsPortraitFormat) {
                    LOG.trace("PDF in Adobe ist Querformat");
                    ret[0] = 1.0f - sf.getY();
                    ret[1] = sf.getX() + relativeWidthQF;
                } else {
                    LOG.trace("PDF in Adobe ist Hochformat");
                    ret[0] = 1.0f - sf.getY();
                    ret[1] = sf.getX() + relativeWidthHF;
                }
                ret[2] = sf.getHeight();
                ret[3] = sf.getWidth();
                break;
            }
            case 180: {
                LOG.trace("180\u00b0 - 2*rechts gedreht");
                if (createAsPortraitFormat) {
                    LOG.trace("PDF in Adobe ist Hochformat");
                    ret[0] = 1.0f - sf.getX() - relativeWidthHF;
                    ret[1] = 1.0f - sf.getY() + relativeHeightHF;
                } else {
                    LOG.trace("PDF in Adobe ist Querformat");
                    ret[0] = 1.0f - sf.getX() - relativeWidthQF;
                    ret[1] = 1.0f - sf.getY() + relativeHeightQF;
                }
                ret[2] = sf.getWidth();
                ret[3] = sf.getHeight();
                break;
            }
            case 270: {
                LOG.trace("270\u00b0 - 3*rechts=links gedreht");
                if (createAsPortraitFormat) {
                    LOG.trace("PDF in Adobe ist Querformat");
                    ret[0] = sf.getY() - relativeHeightQF;
                    ret[1] = 1.0f - sf.getX();
                } else {
                    LOG.trace("PDF in Adobe ist Hochformat");
                    ret[0] = sf.getY() - relativeHeightHF;
                    ret[1] = 1.0f - sf.getX();
                }
                ret[2] = sf.getHeight();
                ret[3] = sf.getWidth();
                break;
            }
            default: {
                LOG.trace("default");
                LOG.trace("0\u00b0 | 360\u00b0 - PDF ist nicht gedreht");
                if (createAsPortraitFormat) {
                    LOG.trace("PDF in Adobe ist Hochformat");
                } else {
                    LOG.trace("PDF in Adobe ist Querformat");
                }
                ret[0] = sf.getX();
                ret[1] = sf.getY();
                ret[2] = sf.getWidth();
                ret[3] = sf.getHeight();
            }
        }
        LOG.trace("-- berechnet x:y - w:h : {}:{} - {}:{}", (Object)Float.valueOf(ret[0]), (Object)Float.valueOf(ret[1]), (Object)Float.valueOf(ret[2]), (Object)Float.valueOf(ret[3]));
        float[] retNew = PdfUtils.checkAndCorrectXYLimits(ret);
        LOG.trace("-- transform done x:y - w:h : {}:{} - {}:{}", (Object)Float.valueOf(retNew[0]), (Object)Float.valueOf(retNew[1]), (Object)Float.valueOf(retNew[2]), (Object)Float.valueOf(retNew[3]));
        return retNew;
    }

    private static float[] checkAndCorrectXYLimits(float[] sigField) {
        for (int i = 0; i <= 1; ++i) {
            if (sigField[i] < 0.0f) {
                LOG.trace("-- correct ret[{}]={} <0 : soll [0;1]", (Object)i, (Object)Float.valueOf(sigField[i]));
                sigField[i] = 0.0f;
            }
            if (!(sigField[i] > 1.0f)) continue;
            LOG.trace("-- correct ret[{}]={} >1 : soll [0;1]", (Object)i, (Object)Float.valueOf(sigField[i]));
            sigField[i] = 1.0f;
        }
        return sigField;
    }

    private static boolean isCreateAsPortraitFormat(Page page) {
        page.getRotation();
        Rectangle cb = page.getCropBox();
        LOG.trace("-- page.cropBox W:H - {}:{}", (Object)Float.valueOf(cb.getWidth()), (Object)Float.valueOf(cb.getHeight()));
        if (cb.getWidth() < cb.getHeight()) {
            LOG.trace("-- erstellt in Hochformat W < H - {}:{}", (Object)Float.valueOf(cb.getWidth()), (Object)Float.valueOf(cb.getHeight()));
            return true;
        }
        LOG.trace("-- erstellt in Querformat W > H - {}:{}", (Object)Float.valueOf(cb.getWidth()), (Object)Float.valueOf(cb.getHeight()));
        return false;
    }
}

