/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.CurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.governikus.csl.pdf.sign.PDFSignatureInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfInfoSelector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfInfoSelector.class);
    private static final String WARN = "Warnung";
    private static JPanel containerPanel;
    private DefaultListModel<PDFSignatureEntry> checkBoxModel = new DefaultListModel();
    private Map<PDFSignatureInfo.InfoType, Boolean> mapEnabled = new LinkedHashMap<PDFSignatureInfo.InfoType, Boolean>();
    private String sequenceSigner = Messages.getString((String)"visualpdf.pdf.signature.info.sequence.signer");
    private String sequenceLocation = Messages.getString((String)"visualpdf.pdf.signature.info.sequence.location");
    private String sequenceDate = Messages.getString((String)"visualpdf.pdf.signature.info.sequence.date");
    private String sequenceReason = Messages.getString((String)"visualpdf.pdf.signature.info.sequence.reason");
    private String itemSelected = Messages.getString((String)"visualpdf.pdf.signature.info.sequence.item.selected");
    private String itemDeselected = Messages.getString((String)"visualpdf.pdf.signature.info.sequence.item.deselected");
    static Map<PDFSignatureInfo.InfoType, String> MAP_INFO_NAMES;
    private static final String PDF_SIGNATURE_INFO_DEFAULT_CONFIG = "REASON_DESC_VISIBLE, SIGNER_DESC_VISIBLE, LOCATION_DESC_VISIBLE, DATE_DESC_VISIBLE";
    private List<PDFSignatureEntry> defaultEntries = new ArrayList<PDFSignatureEntry>();
    static List<PDFSignatureInfo> PDF_SIGNATURE_INFO_DEFAULT;
    List<PDFSignatureInfo> selectedOrder;
    private JLabel description;
    private JLabel hideShowDescLabel;
    private JCheckBoxList<PDFSignatureEntry> source;
    private JLabel changeOrderLabel;
    private JPanel buttonsPanel;
    private IconButton buttonTop;

    public PdfInfoSelector(List<PDFSignatureInfo> configPdfSignatureInfo) {
        this.selectedOrder = configPdfSignatureInfo;
        this.init();
    }

    public PdfInfoSelector() {
        this.init();
    }

    public void init() {
        List.of(PDFSignatureInfo.InfoType.values()).forEach(infoType -> this.mapEnabled.put((PDFSignatureInfo.InfoType)infoType, Boolean.TRUE));
        log.trace("Workaround: Fehler in default-Reihenfolge korrigieren...");
        this.mapEnabled.clear();
        this.mapEnabled.put(PDFSignatureInfo.InfoType.TYPE_REASON, Boolean.TRUE);
        this.mapEnabled.put(PDFSignatureInfo.InfoType.TYPE_SIGNER, Boolean.TRUE);
        this.mapEnabled.put(PDFSignatureInfo.InfoType.TYPE_LOCATION, Boolean.TRUE);
        this.mapEnabled.put(PDFSignatureInfo.InfoType.TYPE_DATE, Boolean.TRUE);
        this.mapEnabled.entrySet().stream().filter(Map.Entry::getValue).forEach(entry -> this.defaultEntries.add(new PDFSignatureEntry((PDFSignatureInfo.InfoType)entry.getKey(), true)));
        List<PDFSignatureEntry> tempEntries = PdfInfoSelector.infoToEntry(this.selectedOrder);
        tempEntries.forEach(entry -> this.checkBoxModel.addElement((PDFSignatureEntry)entry));
        this.source = new JCheckBoxList<PDFSignatureEntry>((ListModel<PDFSignatureEntry>)this.checkBoxModel);
        this.source.setSelectionMode(0);
        this.source.setCellRenderer(this.createRenderer());
        this.source.setSelectedIndex(0);
        this.buttonTop = this.createTopButton(this.checkBoxModel, this.source);
        IconButton buttonUp = this.createUpButton(this.checkBoxModel, this.source);
        IconButton buttonDown = this.createDownButton(tempEntries, this.checkBoxModel, this.source);
        IconButton buttonBottom = this.createBottomButton(tempEntries, this.checkBoxModel, this.source);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 1));
        this.buttonsPanel.add((Component)this.buttonTop);
        this.buttonsPanel.add((Component)buttonUp);
        this.buttonsPanel.add((Component)buttonDown);
        this.buttonsPanel.add((Component)buttonBottom);
        this.source.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int idx = this.source.getSelectedIndex();
                this.buttonTop.setEnabled(idx != 0);
                buttonUp.setEnabled(idx > 0);
                buttonDown.setEnabled(idx < tempEntries.size() - 1);
                buttonBottom.setEnabled(idx != tempEntries.size() - 1);
            }
        });
        this.initGui();
        containerPanel = this.createContainerPanel(this.source, this.buttonsPanel);
    }

    private void initGui() {
        this.description = this.createFocuableLabel(Messages.getString((String)"visualpdf.pdf.signature.info.sequence.description"));
        this.hideShowDescLabel = this.createFocuableLabel(Messages.getString((String)"visualpdf.pdf.signature.info.sequence.hide.show.description"));
        this.hideShowDescLabel.setFocusTraversalKeysEnabled(false);
        this.hideShowDescLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.getKeyCode() != 9) {
                    return;
                }
                if (e.isShiftDown()) {
                    PdfInfoSelector.this.hideShowDescLabel.transferFocusBackward();
                    e.consume();
                } else {
                    PdfInfoSelector.this.source.requestFocus();
                    e.consume();
                }
            }
        });
        this.source.setFocusTraversalKeysEnabled(false);
        this.source.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.getKeyCode() != 9) {
                    return;
                }
                if (e.isShiftDown()) {
                    PdfInfoSelector.this.hideShowDescLabel.requestFocus();
                    e.consume();
                } else {
                    PdfInfoSelector.this.changeOrderLabel.requestFocus();
                    e.consume();
                }
            }
        });
        this.changeOrderLabel = this.createFocuableLabel(Messages.getString((String)"visualpdf.pdf.signature.info.sequence.change.order.description"));
        this.changeOrderLabel.setFocusTraversalKeysEnabled(false);
        this.changeOrderLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.getKeyCode() != 9) {
                    return;
                }
                if (e.isShiftDown()) {
                    PdfInfoSelector.this.source.requestFocus();
                    e.consume();
                } else {
                    PdfInfoSelector.this.buttonsPanel.requestFocus();
                    e.consume();
                }
            }
        });
        this.buttonsPanel.setFocusable(true);
        this.buttonsPanel.setFocusTraversalKeysEnabled(false);
        this.buttonsPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PdfInfoSelector.this.buttonsPanel.transferFocus();
            }
        });
        this.buttonTop.setFocusTraversalKeysEnabled(false);
        this.buttonTop.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.getKeyCode() != 9) {
                    return;
                }
                if (e.isShiftDown()) {
                    PdfInfoSelector.this.changeOrderLabel.requestFocus();
                    e.consume();
                } else {
                    PdfInfoSelector.this.buttonTop.transferFocus();
                    e.consume();
                }
            }
        });
    }

    public JPanel getContainerPanel() {
        return containerPanel;
    }

    private JPanel createDescription(JLabel descLabel) {
        return this.createLabelPanel(descLabel, null);
    }

    private JPanel createSequencePanel(JCheckBoxList<PDFSignatureEntry> source, JPanel buttons) {
        JPanel sequencePanel = new JPanel(new GridBagLayout());
        sequencePanel = ComponentUtils.setTitledFocusableBorder((JPanel)sequencePanel, (String)"");
        JPanel hideShowPanel = this.createLabelPanel(this.hideShowDescLabel, UIManager.getColor("TitledCurvedBorderText.foreground"));
        JPanel sourcePanel = new JPanel();
        sourcePanel.add(source);
        int colX = 0;
        int rowY = 0;
        sequencePanel.add((Component)hideShowPanel, new GridBagConstraints(colX, rowY, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 15), 0, 0));
        sequencePanel.add((Component)sourcePanel, new GridBagConstraints(colX, ++rowY, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 15), 0, 0));
        JPanel changeOrderPanel = this.createLabelPanel(this.changeOrderLabel, UIManager.getColor("TitledCurvedBorderText.foreground"));
        JPanel butPanel = new JPanel();
        butPanel.add(buttons);
        rowY = 0;
        sequencePanel.add((Component)changeOrderPanel, new GridBagConstraints(++colX, rowY, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 15), 0, 0));
        sequencePanel.add((Component)butPanel, new GridBagConstraints(colX, ++rowY, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 15), 0, 0));
        return sequencePanel;
    }

    private JLabel createFocuableLabel(String labelText) {
        JLabel label = new JLabel(labelText);
        label.setBorder((Border)CurvedBorder.EMPTY_BORDER);
        label.setFocusable(true);
        label.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)label));
        return label;
    }

    private JPanel createLabelPanel(JLabel label, Color panelBorderColor) {
        JPanel panel = new JPanel(new FlowLayout(3, 5, 5));
        panel.add(label);
        if (panelBorderColor != null) {
            label.setForeground(panelBorderColor);
        }
        return panel;
    }

    private JPanel createContainerPanel(JCheckBoxList<PDFSignatureEntry> source, JPanel buttonsPanel) {
        JPanel contPanel = new JPanel();
        contPanel.setLayout(new BoxLayout(contPanel, 1));
        contPanel.add(this.createDescription(this.description));
        contPanel.add(this.createSequencePanel(source, buttonsPanel));
        contPanel.doLayout();
        contPanel.updateUI();
        return contPanel;
    }

    private IconButton createTopButton(DefaultListModel<PDFSignatureEntry> dlmSource, JCheckBoxList<PDFSignatureEntry> source) {
        String key = "visualpdf.pdf.signature.info.sequence.navigate.top";
        IconButton btnTop = this.createNavigateButton(key, "Erste Zeile");
        btnTop.addActionListener(e -> {
            PDFSignatureEntry selectedValue = (PDFSignatureEntry)source.getSelectedValue();
            if (selectedValue == null) {
                JOptionPane.showMessageDialog(null, this.description, WARN, 2);
                return;
            }
            if (selectedValue.isEnabled()) {
                dlmSource.removeElement(selectedValue);
                dlmSource.add(0, selectedValue);
                source.setSelectedIndex(0);
            }
        });
        return btnTop;
    }

    private IconButton createUpButton(DefaultListModel<PDFSignatureEntry> dlmSource, JCheckBoxList<PDFSignatureEntry> source) {
        String key = "visualpdf.pdf.signature.info.sequence.navigate.up";
        IconButton btnUp = this.createNavigateButton(key, "Nach oben");
        btnUp.addActionListener(e -> {
            int currentIdx;
            PDFSignatureEntry selectedValue = (PDFSignatureEntry)source.getSelectedValue();
            if (selectedValue == null) {
                JOptionPane.showMessageDialog(null, this.description, WARN, 2);
                return;
            }
            if (selectedValue.isEnabled() && (currentIdx = source.getSelectedIndex()) > 0) {
                dlmSource.removeElement(selectedValue);
                dlmSource.add(currentIdx - 1, selectedValue);
                source.setSelectedIndex(currentIdx - 1);
            }
        });
        return btnUp;
    }

    private IconButton createDownButton(List<PDFSignatureEntry> entries, DefaultListModel<PDFSignatureEntry> dlmSource, JCheckBoxList<PDFSignatureEntry> source) {
        String key = "visualpdf.pdf.signature.info.sequence.navigate.down";
        IconButton btnDown = this.createNavigateButton(key, "Nach unten");
        btnDown.addActionListener(e -> {
            int currentIdx;
            PDFSignatureEntry selectedValue = (PDFSignatureEntry)source.getSelectedValue();
            if (selectedValue == null) {
                JOptionPane.showMessageDialog(null, this.description, WARN, 2);
                return;
            }
            if (selectedValue.isEnabled() && (currentIdx = source.getSelectedIndex()) < entries.size() - 1) {
                dlmSource.removeElement(selectedValue);
                dlmSource.add(currentIdx + 1, selectedValue);
                source.setSelectedIndex(currentIdx + 1);
            }
        });
        return btnDown;
    }

    private IconButton createBottomButton(List<PDFSignatureEntry> entries, DefaultListModel<PDFSignatureEntry> dlmSource, JCheckBoxList<PDFSignatureEntry> source) {
        String key = "visualpdf.pdf.signature.info.sequence.navigate.bottom";
        IconButton btnBottom = this.createNavigateButton(key, "Letzte Zeile");
        btnBottom.addActionListener(e -> {
            int currentIdx;
            PDFSignatureEntry selectedValue = (PDFSignatureEntry)source.getSelectedValue();
            if (selectedValue == null) {
                JOptionPane.showMessageDialog(null, this.description, WARN, 2);
                return;
            }
            if (selectedValue.isEnabled() && (currentIdx = source.getSelectedIndex()) != entries.size() - 1) {
                dlmSource.removeElement(selectedValue);
                dlmSource.add(entries.size() - 1, selectedValue);
                source.setSelectedIndex(entries.size() - 1);
            }
        });
        return btnBottom;
    }

    private IconButton createNavigateButton(String key, String testDefaultText) {
        IconButton button = new IconButton(key, true);
        if (button.getText() == null || button.getText().isEmpty()) {
            button.setText(testDefaultText);
            ImageIcon icon = new ImageIcon("src\\main\\resources\\resources\\pdf.gif");
            button.setIcon((Icon)icon);
        }
        button.setBorder((Border)CurvedBorder.EMPTY_BORDER);
        button.getInsets(new Insets(0, 0, 0, 0));
        button.setOpaque(true);
        button.setRolloverEnabled(true);
        button.addFocusListener(ComponentUtils.createFocusListenerForIcon((IconButton)button));
        button.addMouseListener((MouseListener)ComponentUtils.createMouseAdapterForNavigateButton((IconButton)button));
        return button;
    }

    private DefaultListCellRenderer createRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component base = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (base instanceof JLabel) {
                    JLabel baseJLabel = (JLabel)base;
                    if (value instanceof PDFSignatureEntry) {
                        PDFSignatureEntry entry = (PDFSignatureEntry)value;
                        if (cellHasFocus) {
                            entry.setForeground(Color.WHITE);
                            entry.setBackground(SignerTheme.SIGNER_BLUE);
                        } else {
                            entry.setForeground(Color.BLACK);
                            entry.setBackground(isSelected ? SignerTheme.BOREUM_PETROL_LIGHT : baseJLabel.getBackground());
                        }
                        Object entryText = "";
                        switch (entry.getInfoType()) {
                            case TYPE_SIGNER: {
                                entryText = "\"" + PdfInfoSelector.this.sequenceSigner + "\" ";
                                break;
                            }
                            case TYPE_LOCATION: {
                                entryText = "\"" + PdfInfoSelector.this.sequenceLocation + "\" ";
                                break;
                            }
                            case TYPE_DATE: {
                                entryText = "\"" + PdfInfoSelector.this.sequenceDate + "\" ";
                                break;
                            }
                            case TYPE_REASON: {
                                entryText = "\"" + PdfInfoSelector.this.sequenceReason + "\" ";
                            }
                        }
                        entry.setText((String)entryText + (String)(entry.isSelected() ? PdfInfoSelector.this.itemSelected + "      " : PdfInfoSelector.this.itemDeselected));
                        base = entry;
                    }
                }
                return base;
            }
        };
    }

    public static int showDialog(JPanel containerPanel) {
        JFrame frame = new JFrame();
        frame.setResizable(true);
        Object[] optionenS = new String[]{Messages.getString((String)"dialog.config.dialog.visual.pdf.signature.info.sequence.option0", (String)"Speichern"), Messages.getString((String)"dialog.config.dialog.visual.pdf.signature.info.sequence.option1", (String)"Zur\u00fccksetzen"), Messages.getString((String)"dialog.config.dialog.visual.pdf.signature.info.sequence.option2", (String)"Abbrechen")};
        return JOptionPane.showOptionDialog(frame, containerPanel, Messages.getString((String)"config.dialog.visualpdf.pdf.signature.info.sequence.title"), 1, 3, null, optionenS, optionenS[0]);
    }

    public List<PDFSignatureInfo> getOrder(int option) {
        List<PDFSignatureEntry> selectedCheckBox;
        switch (option) {
            case 0: {
                log.info("Speichern = 0 : {}", (Object)option);
                selectedCheckBox = Collections.list(this.checkBoxModel.elements());
                break;
            }
            case 1: {
                log.info("Zur\u00fccksetzen = 1 : {}", (Object)option);
                selectedCheckBox = this.defaultEntries;
                break;
            }
            default: {
                log.info("2.Abbrechen/-1.Schlie\u00dfen : {}", (Object)option);
                return this.selectedOrder;
            }
        }
        selectedCheckBox.stream().forEach(e -> log.info("selected : {}", (Object)e.getText()));
        List<PDFSignatureInfo> selectedSequence = selectedCheckBox.stream().map(PDFSignatureEntry::getInfo).collect(Collectors.toList());
        return selectedSequence;
    }

    public static List<PDFSignatureInfo> fromString(String pdfSignatureInfoXml) {
        log.debug("input : {}", (Object)pdfSignatureInfoXml);
        if (pdfSignatureInfoXml == null || pdfSignatureInfoXml.isEmpty()) {
            return PdfInfoSelector.getDefaultList();
        }
        String pdfInfoString = pdfSignatureInfoXml;
        pdfInfoString = pdfInfoString.replace(" ", "");
        ArrayList<String> pdfInfoStringList = new ArrayList<String>(Arrays.asList(pdfInfoString.split(",")));
        ArrayList<PDFSignatureInfo> pdfSignatureInfoList = new ArrayList<PDFSignatureInfo>();
        pdfInfoStringList.stream().forEach(stringValue -> pdfSignatureInfoList.add(PDFSignatureInfo.valueOf((String)stringValue)));
        log.debug("output : {}", pdfInfoStringList);
        return pdfSignatureInfoList;
    }

    public static String toConfigString(List<PDFSignatureInfo> pdfSignatureInfoList) {
        if (pdfSignatureInfoList == null || pdfSignatureInfoList.isEmpty()) {
            return "";
        }
        log.debug("input : {}", pdfSignatureInfoList);
        String configString = pdfSignatureInfoList.toString().replace("[", "");
        configString = configString.replace("]", "");
        log.debug("output : {}", (Object)configString);
        return configString;
    }

    public static List<PDFSignatureEntry> infoToEntry(List<PDFSignatureInfo> infoList) {
        if (infoList == null) {
            log.warn("Nutzerdefinierte Liste ist null, defaultListe wird verwendet: REASON_DESC_VISIBLE, SIGNER_DESC_VISIBLE, LOCATION_DESC_VISIBLE, DATE_DESC_VISIBLE");
            log.debug("Grund:, Unterzeichnet von:, Ort:, Datum:");
            infoList = PdfInfoSelector.getDefaultList();
        }
        ArrayList<PDFSignatureEntry> entryList = new ArrayList<PDFSignatureEntry>();
        for (PDFSignatureInfo info : infoList) {
            PDFSignatureEntry tmpEntry = new PDFSignatureEntry(info.getInfoType(), true);
            tmpEntry.setSelected(PDFSignatureInfo.DescriptionType.DESCRIPTION_VISIBLE == info.getDescriptionType());
            entryList.add(tmpEntry);
            log.debug("input={} -> output:{}", (Object)info.name(), (Object)tmpEntry.getInfo());
        }
        return entryList;
    }

    public static List<PDFSignatureInfo> getDefaultList() {
        return PDF_SIGNATURE_INFO_DEFAULT;
    }

    public static String getDefaultConfig() {
        return PDF_SIGNATURE_INFO_DEFAULT_CONFIG;
    }

    public static void testMain(String[] args) {
        System.setProperty("log4j2.configurationFile", "src\\main\\resources\\log4j2.xml");
        GUIUtils.setSignerThemeInUIManager();
        String configSelectedOrder = "REASON_DESC_VISIBLE,  DATE_DESC_INVISIBLE,  LOCATION_DESC_INVISIBLE,  SIGNER_DESC_VISIBLE";
        PdfInfoSelector pdfInfoSelector = new PdfInfoSelector(PdfInfoSelector.fromString(configSelectedOrder));
        int decision = PdfInfoSelector.showDialog(containerPanel);
        List<PDFSignatureInfo> selectedOrder = pdfInfoSelector.getOrder(decision);
        log.info("output : {}", (Object)selectedOrder.toString());
        System.exit(0);
    }

    static {
        Cloneable tmp = new LinkedHashMap<PDFSignatureInfo.InfoType, String>();
        tmp.put(PDFSignatureInfo.InfoType.TYPE_REASON, "Grund");
        tmp.put(PDFSignatureInfo.InfoType.TYPE_SIGNER, "Unterzeichnet von");
        tmp.put(PDFSignatureInfo.InfoType.TYPE_LOCATION, "Ort");
        tmp.put(PDFSignatureInfo.InfoType.TYPE_DATE, "Datum");
        MAP_INFO_NAMES = Collections.unmodifiableMap(tmp);
        tmp = new ArrayList();
        tmp.add(PDFSignatureInfo.REASON_DESC_VISIBLE);
        tmp.add(PDFSignatureInfo.SIGNER_DESC_VISIBLE);
        tmp.add(PDFSignatureInfo.LOCATION_DESC_VISIBLE);
        tmp.add(PDFSignatureInfo.DATE_DESC_VISIBLE);
        PDF_SIGNATURE_INFO_DEFAULT = Collections.unmodifiableList(tmp);
    }

    public static class JCheckBoxList<T extends JCheckBox>
    extends JList<T> {
        private static final long serialVersionUID = -5419704840630685725L;

        public JCheckBoxList() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int index = this.locationToIndex(e.getPoint());
                    if (index == -1) {
                        return;
                    }
                    if (e.getPoint().getX() > 25.0) {
                        return;
                    }
                    JCheckBox checkbox = (JCheckBox)this.getModel().getElementAt(index);
                    if (!checkbox.isEnabled()) {
                        return;
                    }
                    checkbox.setSelected(!checkbox.isSelected());
                    this.repaint();
                }
            });
        }

        public JCheckBoxList(ListModel<T> model) {
            this();
            this.setModel(model);
        }
    }

    static class PDFSignatureEntry
    extends JCheckBox {
        private static final long serialVersionUID = 1L;
        private PDFSignatureInfo.InfoType infoType;

        public PDFSignatureEntry(PDFSignatureInfo.InfoType info, boolean enabled) {
            super(MAP_INFO_NAMES.get(info), enabled);
            this.infoType = info;
            this.setMargin(new Insets(7, 7, 7, 7));
        }

        public PDFSignatureInfo.InfoType getInfoType() {
            return this.infoType;
        }

        public void setInfoType(PDFSignatureInfo.InfoType infoType) {
            this.infoType = infoType;
        }

        public PDFSignatureInfo getInfo() {
            PDFSignatureInfo.DescriptionType d = super.isSelected() ? PDFSignatureInfo.DescriptionType.DESCRIPTION_VISIBLE : PDFSignatureInfo.DescriptionType.DESCRIPTION_INVISIBLE;
            return List.of(PDFSignatureInfo.values()).stream().filter(info -> info.getDescriptionType() == d && info.getInfoType() == this.infoType).findFirst().orElse(null);
        }
    }
}

