/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf;

import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.AdvancedPDFDialog;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.Resizer;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.VisibleSignatureField;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.Page;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.SignatureField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PdfImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(PdfImagePanel.class);
    public static final Color COLOR_CROP_BOX = new Color(255, 0, 0, 100);
    public static final Color COLOR_TEXT_SIGFIELDS = new Color(0, 0, 0, 128);
    public static final Color COLOR_EXISTING_SIGFIELDS = new Color(60, 179, 113, 128);
    public static final Color COLOR_NEW_SIGFIELDS = new Color(255, 215, 0, 128);
    public static final int RESOLUTION = 55;
    public static final float POINTS = 72.0f;
    public static final float SCALE = 0.7638889f;
    private static float scaling = 0.7638889f;
    int cropBoxWidth;
    int cropBoxHeight;
    private int rotation;
    private ImageIcon imageIcon;
    private transient Page page;
    private Dimension size;
    private transient Graphics graphics;
    private transient List<VisibleSignatureField> tempSignatureFields;
    private transient List<VisibleSignatureField> pageSignatureFields;
    private Rectangle selectedSignatureFieldRect;
    private transient VisibleSignatureField selectedSignatureField;
    private final Font sigFieldFont;
    private final Font minFont;

    public PdfImagePanel(AdvancedPDFDialog parent, BufferedImage bufferedImage, Page page) {
        LOG.trace("");
        this.page = page;
        this.imageIcon = new ImageIcon(bufferedImage);
        PdfImagePanel.setScaling(0.7638889f);
        this.size = new Dimension(this.imageIcon.getImage().getWidth(null), this.imageIcon.getImage().getHeight(null));
        LOG.trace("PDF-Seite-Image : {}", (Object)this.size);
        Resizer resizer = new Resizer(parent, this);
        this.addMouseListener(resizer);
        this.addMouseMotionListener(resizer);
        this.setPreferredSize(this.size);
        this.setMinimumSize(this.size);
        this.setMaximumSize(this.size);
        this.setSize(this.size);
        this.setLayout(null);
        this.rotation = page.getRotation();
        LOG.trace("page rotation : {}", (Object)this.rotation);
        this.setCropBoxDimension(this.rotateCropBox(page));
        this.sigFieldFont = (Font)UIManager.get("Label.font");
        this.minFont = this.sigFieldFont.deriveFont(8.0f);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.graphics = g;
        this.drawPageImage();
        this.drawBox();
        this.drawPageSignatureFields();
        this.drawTmpSignatureFields();
        this.drawSelectedSignatureField();
    }

    private void drawPageImage() {
        if (this.graphics == null) {
            return;
        }
        this.graphics.drawImage(this.imageIcon.getImage(), 0, 0, null);
    }

    private void drawBox() {
        this.graphics.setColor(COLOR_CROP_BOX);
        if (this.page.getCropBox() != null || this.page.getMediaBox() != null) {
            this.graphics.drawRect(0, 0, this.cropBoxWidth - 1, this.cropBoxHeight - 1);
        } else if (this.page.getCropBox() == null) {
            LOG.trace("page.getCropBox() == null");
            LOG.error("Beschreibbare Bereich in PDF-Seite ist nicht vorhanden.");
        }
    }

    private Font scaleFont(Graphics g, VisibleSignatureField vsf) {
        Font ret = this.sigFieldFont;
        char[] name = vsf.getSignatureField().getFieldName().toCharArray();
        int len = g.getFontMetrics(ret).charsWidth(name, 0, name.length);
        float fontSize = (float)vsf.getWidth() * 0.9f / (float)len * (float)ret.getSize();
        if (fontSize > (float)this.sigFieldFont.getSize()) {
            return this.sigFieldFont;
        }
        if (fontSize < 8.0f) {
            return this.minFont;
        }
        return ret.deriveFont(fontSize);
    }

    private void drawPageSignatureFields() {
        for (VisibleSignatureField signatureField : this.getPageSignatureFields()) {
            this.graphics.setColor(COLOR_EXISTING_SIGFIELDS);
            this.graphics.fillRect(signatureField.getX(), signatureField.getY(), signatureField.getWidth(), signatureField.getHeight());
            this.graphics.getFontMetrics(this.sigFieldFont).getStringBounds("ToolTipText", this.graphics).getWidth();
            this.graphics.setFont(this.scaleFont(this.graphics, signatureField));
            this.graphics.setColor(COLOR_TEXT_SIGFIELDS);
            this.graphics.drawString(signatureField.getSignatureField().getFieldName(), signatureField.getX() + 3, signatureField.getY() + this.graphics.getFont().getSize() + 2);
        }
    }

    private void drawTmpSignatureFields() {
        if (this.tempSignatureFields == null) {
            return;
        }
        if (this.page == null) {
            return;
        }
        for (VisibleSignatureField signatureField : this.tempSignatureFields) {
            LOG.trace("Signaturfeld neu : {}", (Object)signatureField.getSignatureField().getFieldName());
            if (this.page.getPageNo() != signatureField.getSignatureField().getPageNo()) continue;
            this.graphics.setColor(COLOR_NEW_SIGFIELDS);
            this.graphics.fillRect(signatureField.getX(), signatureField.getY(), signatureField.getWidth(), signatureField.getHeight());
            Font f = this.scaleFont(this.graphics, signatureField);
            this.graphics.setFont(f);
            this.graphics.setColor(COLOR_TEXT_SIGFIELDS);
            this.graphics.drawString(signatureField.getSignatureField().getFieldName(), signatureField.getX() + 3, signatureField.getY() + this.graphics.getFont().getSize() + 2);
        }
    }

    private void drawSelectedSignatureField() {
        if (this.selectedSignatureField == null) {
            return;
        }
        if (this.page == null) {
            return;
        }
        if (this.page.getPageNo() != this.selectedSignatureField.getSignatureField().getPageNo()) {
            return;
        }
        this.graphics.setColor(COLOR_TEXT_SIGFIELDS);
        int selectedX = this.selectedSignatureField.getX();
        int selectedY = this.selectedSignatureField.getY();
        int selectedWidth = this.selectedSignatureField.getWidth();
        int selectedHeight = this.selectedSignatureField.getHeight();
        if (this.selectedSignatureFieldRect == null) {
            this.selectedSignatureFieldRect = new Rectangle(selectedX, selectedY, selectedWidth, selectedHeight);
        }
        ((Graphics2D)this.graphics).draw(this.selectedSignatureFieldRect);
        Rectangle borderRect = new Rectangle(selectedX - 1, selectedY - 1, selectedWidth + 2, selectedHeight + 2);
        ((Graphics2D)this.graphics).draw(borderRect);
    }

    private static void setScaling(float value) {
        scaling = value;
    }

    public static int scaled(Float floatValue) {
        return Math.abs(Math.round(floatValue.floatValue() * scaling));
    }

    private int[] rotateCropBox(Page page) {
        int rotationPrivate = page.getRotation();
        de.governikus.csl.pdf.sign.impl.pdfbox.metadata.Rectangle rect = page.getCropBox();
        LOG.trace("Rotation {}, CropBox - W:H - {}:{}", (Object)rotationPrivate, (Object)Float.valueOf(rect.getWidth()), (Object)Float.valueOf(rect.getHeight()));
        int[] cropBoxDimension = new int[2];
        if (rotationPrivate == 90 || rotationPrivate == 270) {
            cropBoxDimension[0] = PdfImagePanel.scaled(Float.valueOf(rect.getHeight()));
            cropBoxDimension[1] = PdfImagePanel.scaled(Float.valueOf(rect.getWidth()));
        } else {
            cropBoxDimension[0] = PdfImagePanel.scaled(Float.valueOf(rect.getWidth()));
            cropBoxDimension[1] = PdfImagePanel.scaled(Float.valueOf(rect.getHeight()));
        }
        LOG.trace("CropBox : W:H - {}:{}", (Object)cropBoxDimension[0], (Object)cropBoxDimension[1]);
        return cropBoxDimension;
    }

    public static int unscaled(Integer intValue) {
        return Math.abs(Math.round(72.0f * (float)intValue.intValue() / 55.0f));
    }

    public static int unscaled(Float floatValue) {
        return Math.abs(Math.round(72.0f * floatValue.floatValue() / 55.0f));
    }

    public List<VisibleSignatureField> getTempSignatureFields() {
        if (this.tempSignatureFields == null) {
            this.tempSignatureFields = new ArrayList<VisibleSignatureField>();
        }
        return this.tempSignatureFields;
    }

    public List<VisibleSignatureField> getPageSignatureFields() {
        if (this.pageSignatureFields == null) {
            this.pageSignatureFields = new ArrayList<VisibleSignatureField>();
            for (SignatureField signatureField : this.page.getSignatureFields()) {
                this.pageSignatureFields.add(VisibleSignatureField.createFieldFromPDF(signatureField, this));
            }
        }
        return this.pageSignatureFields;
    }

    public void setTempSignatureFields(List<VisibleSignatureField> tempSignatureFields) {
        this.tempSignatureFields = tempSignatureFields;
    }

    public Rectangle getSelectedSignatureFieldRect() {
        return this.selectedSignatureFieldRect;
    }

    public VisibleSignatureField getSelectedSignatureField() {
        return this.selectedSignatureField;
    }

    public void setSelectedSignatureField(VisibleSignatureField selectedSignatureField) {
        LOG.trace("");
        this.selectedSignatureField = selectedSignatureField;
        if (selectedSignatureField == null) {
            this.setSelectedSignatureFieldRect(null);
        } else {
            LOG.trace("set selected : {}", (Object)selectedSignatureField.getSignatureField().getFieldName());
            this.setSelectedSignatureFieldRect(selectedSignatureField.getRect());
        }
    }

    public void setSelectedSignatureFieldRect(Rectangle selectedSignatureFieldRect) {
        this.selectedSignatureFieldRect = selectedSignatureFieldRect;
    }

    public boolean isOnCropBox(int positionX, int positionY, float sigFieldWidth, float sigFieldHeight) {
        boolean isOnCropBox = true;
        if (this.page.getCropBox() == null || this.page.getMediaBox() == null) {
            return false;
        }
        if (positionX < 0 || positionY < 0) {
            LOG.trace("Position x:y - {}:{}", (Object)positionX, (Object)positionY);
            isOnCropBox = false;
        }
        if (isOnCropBox && (float)positionX + sigFieldWidth > (float)this.cropBoxWidth || (float)positionY + sigFieldHeight > (float)this.cropBoxHeight) {
            LOG.trace("Position x:y - {}:{}", (Object)positionX, (Object)positionY);
            LOG.trace("sigField w:h - {}:{}", (Object)Float.valueOf(sigFieldWidth), (Object)Float.valueOf(sigFieldHeight));
            LOG.trace("cropBox  w:h - {}:{}", (Object)this.cropBoxWidth, (Object)this.cropBoxHeight);
            isOnCropBox = false;
        }
        return isOnCropBox;
    }

    public int getRotation() {
        LOG.trace("Rotation : {}\u00b0", (Object)this.rotation);
        return this.rotation;
    }

    private void setCropBoxDimension(int[] cropBoxDim) {
        this.cropBoxWidth = cropBoxDim[0];
        this.cropBoxHeight = cropBoxDim[1];
    }
}

