/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class PDFGlassPane
extends JComponent {
    private static final long serialVersionUID = 1L;
    private transient BufferedImage image;
    private Point location;

    public void moveIt(Point location) {
        Point oldLocation = this.location;
        SwingUtilities.convertPointFromScreen(location, this);
        this.location = location;
        Rectangle newClip = new Rectangle(this.location.x - this.image.getWidth() / 2, this.location.y - this.image.getHeight() / 2, this.image.getWidth(), this.image.getHeight());
        newClip.add(new Rectangle(oldLocation.x - this.image.getWidth() / 2, oldLocation.y - this.image.getHeight() / 2, this.image.getWidth(), this.image.getHeight()));
        this.repaint(newClip);
    }

    public void hideIt() {
        this.setVisible(false);
    }

    public void showIt(BufferedImage image, Point location) {
        this.image = image;
        SwingUtilities.convertPointFromScreen(location, this);
        this.location = location;
        this.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.image == null) {
            return;
        }
        if (this.location == null) {
            return;
        }
        int x = this.location.x - this.image.getWidth() / 2;
        int y = this.location.y - this.image.getHeight() / 2;
        g.drawImage(this.image, x, y, null);
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

