/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.action.AbstractSignerAction;
import de.bos_bremen.ecard.client.action.ContextSensitiveHelpAction;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.gui.dialog.RedundantErrorDialog;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.PDFGlassPane;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.PdfImagePanel;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.SignatureFieldDataModel;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.VisibleSignatureField;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.PDFMetaData;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.Page;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.SignatureField;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.DefaultFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.rendering.ImageType;

public class AdvancedPDFDialog
extends JFrame
implements ImageObserver {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(AdvancedPDFDialog.class);
    private static final String ONE_SQUARE = "oneSquare";
    private final String pageStringSplitter = " " + Messages.getString((String)"dialog.pdf.navigate.page.splitter") + " ";
    private static final Integer HORIZONTAL_SIGFIELD_PADDING = 5;
    private static final Integer VERTICAL_SIGFIELD_PADDING = 5;
    private int numberOfPages = 0;
    private transient List<Page> pdfPages;
    private int selectedPage = 0;
    private int selectedPageGUI = 1;
    private transient BufferedImage pdfFirstPageImage;
    private transient BufferedImage pdfLastPageImage;
    private JPanel pdfPanel;
    private JTextField numberOfPagesTextField;
    private PdfImagePanel pdfImagePanel;
    private transient HashMap<SignatureField, Integer> signableSignatureFieldMap;
    private transient HashMap<SignatureField, Integer> allSignatureFieldMap;
    private PDFGlassPane glassPane;
    private transient BufferedImage glassPaneImage;
    private JPanel westPanel;
    private JSpinner rowCount;
    private JSpinner columnCount;
    private JTextField sigField;
    private final File selectedPdfFile;
    private transient PDFMetaData pdfMetaData;
    private final SignatureFieldDataModel signatureFieldListModel = new SignatureFieldDataModel();
    private JTable signatureFieldTable = null;
    private final IconButton undoButton = new IconButton();
    private final IconButton assumeButton = new IconButton();
    private final IconButton cancelButton = new IconButton();
    private transient VisibleSignatureField selectedSignatureField;
    private transient ProcessI process = null;
    private transient SignConfig signConfig = null;
    private static final float CORRECTION = 2.8346457f;
    private Integer sigFieldWidth;
    private Integer sigFieldHeight;

    public AdvancedPDFDialog(ProcessName processName, File pdfFile) {
        LOG.trace("");
        if (Document.getInstance().getFrame() != null) {
            this.setIconImage(Document.getInstance().getFrame().getIconImage());
            GUIUtils.setSignerThemeInUIManager();
        }
        this.addWindowListener(new CleanUpWindowListener());
        if (processName != null) {
            this.process = Document.getInstance().getProcessFactory().getProcess(processName);
            this.signConfig = (SignConfig)this.process.getConfig();
        }
        this.selectedPdfFile = pdfFile;
        if (this.selectedPdfFile != null) {
            this.setTitle(Messages.getString((String)"dialog.pdf.exists.title") + " " + this.selectedPdfFile.getName());
            try (FileInputStream fileInputStream = new FileInputStream(this.selectedPdfFile);){
                this.pdfMetaData = new PDFMetaData((InputStream)fileInputStream);
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        } else {
            this.setTitle(Messages.getString((String)"dialog.pdf.title"));
        }
        this.setDefaultCloseOperation(1);
        this.initMetaData();
        this.initGUI();
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        LOG.trace("screenSize : {}:{}", (Object)screenSize.width, (Object)screenSize.height);
        LOG.trace("component  : {}:{}", (Object)this.getWidth(), (Object)this.getHeight());
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        this.setResizable(true);
        LOG.trace("prefered size : {}:{}", (Object)this.getPreferredSize().getWidth(), (Object)this.getPreferredSize().getHeight());
        int w = (int)this.getPreferredSize().getWidth() >= screenSize.width ? screenSize.width : (int)this.getPreferredSize().getWidth();
        int h = (int)this.getPreferredSize().getHeight() >= screenSize.height ? screenSize.height : (int)this.getPreferredSize().getHeight();
        LOG.trace("size : {}:{}", (Object)w, (Object)h);
        this.setMaximumSize(new Dimension(screenSize.width, screenSize.height));
        this.setSize(new Dimension(w, h));
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setVisible(true);
    }

    private void initMetaData() {
        LOG.trace("");
        if (this.pdfMetaData == null) {
            LOG.trace("pdf metadata ist null.");
            return;
        }
        LOG.trace("pdf metadata vorhanden...");
        try {
            this.numberOfPages = this.pdfMetaData.getNumberOfPages();
            this.pdfPages = this.pdfMetaData.getPages();
            if (this.pdfPages == null || this.pdfPages.isEmpty()) {
                LOG.error("pdfPages is null");
                return;
            }
            this.pdfFirstPageImage = this.pdfPages.get(this.selectedPage).generatePage(ImageType.ARGB, 0.7638889f);
            this.pdfLastPageImage = this.pdfPages.get(this.numberOfPages - 1).generatePage(ImageType.ARGB, 0.7638889f);
            this.signableSignatureFieldMap = new HashMap();
            this.allSignatureFieldMap = new HashMap();
            int p = 1;
            for (Page page : this.pdfPages) {
                if (!this.pdfPages.isEmpty()) {
                    LOG.trace("page {}", (Object)p);
                    for (SignatureField signatureField : page.getSignatureFields()) {
                        this.allSignatureFieldMap.put(signatureField, p);
                        if (!signatureField.isUsableForSigning()) continue;
                        this.signableSignatureFieldMap.put(signatureField, p);
                    }
                }
                ++p;
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
    }

    private void initGUI() {
        LOG.trace("");
        this.getContentPane().setLayout(new BorderLayout());
        this.glassPane = new PDFGlassPane();
        this.setGlassPane(this.glassPane);
        this.westPanel = this.createWestPanel();
        this.add((Component)this.westPanel, "West");
        this.add((Component)this.createEastPanel(), "East");
        this.add((Component)this.createContentPanel(), "Center");
        this.invalidate();
        this.repaint();
        LOG.trace("done");
    }

    private JPanel createEastPanel() {
        JPanel pageEastPanel = new JPanel(new BorderLayout());
        pageEastPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 10));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString((String)"dialog.pdf.existing.signaturefields.header")));
        JPanel descPanel = new JPanel(new BorderLayout());
        descPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel descriptionLabel = new JLabel(Messages.getString((String)"dialog.pdf.existing.signaturefields.description"));
        descPanel.add((Component)ComponentUtils.makeFocusable((JComponent)descriptionLabel), "Center");
        topPanel.add((Component)descPanel, "North");
        topPanel.add((Component)this.createSignatureFieldList(), "Center");
        pageEastPanel.add((Component)topPanel, "Center");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 18, 2));
        this.undoButton.setAction((Action)((Object)new UndoAction(this)));
        this.undoButton.setEnabled(false);
        this.cancelButton.setAction((Action)((Object)new CancelAction(this)));
        this.assumeButton.setAction((Action)((Object)new AssumeAction(this)));
        this.assumeButton.setEnabled(false);
        this.undoButton.setText(null);
        this.cancelButton.setText(null);
        this.assumeButton.setText(null);
        Insets insets = new Insets(0, 0, 0, 0);
        int row = 0;
        int column = 0;
        IconButton helpButton = new IconButton();
        String signerHelpPath = System.getProperty("signer.helppath");
        if (signerHelpPath != null && !signerHelpPath.isEmpty()) {
            ContextSensitiveHelpAction helpAction = new ContextSensitiveHelpAction((Component)this, "dialog.pdf.button");
            helpAction.setHelpId(Messages.getString((String)"dialog.pdf.button.action.contextsinsitivehelp.id"));
            helpButton.setAction((Action)helpAction);
            helpButton.setText(null);
            buttonPanel.add((Component)helpButton, new GridBagConstraints(column, row, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 150), 0, 0));
        }
        buttonPanel.add((Component)this.undoButton, new GridBagConstraints(++column, row, 1, 1, 1.0, 0.0, 13, 0, insets, 0, 0));
        buttonPanel.add((Component)this.assumeButton, new GridBagConstraints(++column, row, 1, 1, 1.0, 0.0, 13, 0, insets, 0, 0));
        buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(++column, row, 1, 1, 1.0, 0.0, 13, 0, insets, 0, 0));
        pageEastPanel.add((Component)buttonPanel, "South");
        return pageEastPanel;
    }

    protected void copyFile(File sourceFile, File destFile) throws IOException {
        LOG.trace("");
        if (!sourceFile.exists()) {
            LOG.error("source file is null");
            return;
        }
        if (!destFile.exists() && !destFile.createNewFile()) {
            LOG.error("could not create folder: {}", (Object)destFile);
            return;
        }
        try (FileChannel source = new FileInputStream(sourceFile).getChannel();){
            LOG.trace("");
            try (FileChannel destination = new FileOutputStream(destFile).getChannel();){
                LOG.trace("");
                destination.transferFrom(source, 0L, source.size());
                try {
                    LOG.trace("");
                    Files.delete(sourceFile.toPath());
                }
                catch (IOException ex) {
                    sourceFile.deleteOnExit();
                }
            }
        }
    }

    private JScrollPane createSignatureFieldList() {
        LOG.trace("");
        this.signatureFieldTable = new JTable(this.signatureFieldListModel);
        this.signatureFieldTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getKeyCode() != 127) {
                    return;
                }
                LOG.trace("");
                if (AdvancedPDFDialog.this.pdfImagePanel == null) {
                    return;
                }
                if (AdvancedPDFDialog.this.pdfImagePanel.getSelectedSignatureField() == null) {
                    return;
                }
                if (AdvancedPDFDialog.this.pdfImagePanel.getPageSignatureFields().contains(AdvancedPDFDialog.this.pdfImagePanel.getSelectedSignatureField())) {
                    return;
                }
                LOG.trace("");
                AdvancedPDFDialog.this.pdfImagePanel.getTempSignatureFields().remove(AdvancedPDFDialog.this.pdfImagePanel.getSelectedSignatureField());
                AdvancedPDFDialog.this.signatureFieldListModel.setRowCount(0);
                for (Map.Entry<SignatureField, Integer> next : AdvancedPDFDialog.this.signableSignatureFieldMap.entrySet()) {
                    AdvancedPDFDialog.this.signatureFieldListModel.addRow(new Object[]{Boolean.FALSE, next.getKey().getFieldName(), next.getValue()});
                }
                List<VisibleSignatureField> tempSignatureFields = AdvancedPDFDialog.this.pdfImagePanel.getTempSignatureFields();
                for (VisibleSignatureField visibleSignatureField : tempSignatureFields) {
                    SignatureField sf = visibleSignatureField.getSignatureField();
                    AdvancedPDFDialog.this.signatureFieldListModel.addRow(new Object[]{Boolean.FALSE, sf.getFieldName(), sf.getPageNo()});
                }
                AdvancedPDFDialog.this.pdfImagePanel.setSelectedSignatureField(null);
                AdvancedPDFDialog.this.assumeButton.setEnabled(false);
                if (tempSignatureFields.isEmpty()) {
                    AdvancedPDFDialog.this.undoButton.setEnabled(false);
                }
                AdvancedPDFDialog.this.invalidate();
                AdvancedPDFDialog.this.repaint();
            }
        });
        this.signatureFieldTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.signatureFieldTable.getTableHeader().setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.signatureFieldTable.setRowHeight(Document.getInstance().getFontSize().getHeaderSize() + 4);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(0);
        this.signatureFieldTable.getColumnModel().getColumn(1).setCellRenderer(rightRenderer);
        this.signatureFieldTable.getColumnModel().getColumn(2).setCellRenderer(rightRenderer);
        this.signatureFieldTable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.signatureFieldTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.signatureFieldTable.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.signatureFieldTable.setSelectionMode(0);
        this.signatureFieldTable.getSelectionModel().addListSelectionListener(this::changeSelectedSignatureField);
        for (Map.Entry<SignatureField, Integer> next : this.signableSignatureFieldMap.entrySet()) {
            this.signatureFieldListModel.addRow(new Object[]{Boolean.FALSE, next.getKey().getFieldName(), next.getValue()});
        }
        JScrollPane signatureFieldScrollPane = new JScrollPane();
        signatureFieldScrollPane.setViewportView(this.signatureFieldTable);
        signatureFieldScrollPane.setPreferredSize(new Dimension(300, 260));
        signatureFieldScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return signatureFieldScrollPane;
    }

    private JPanel createWestPanel() {
        JPanel pageWestPanel = new JPanel(new BorderLayout());
        pageWestPanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 12, 0));
        JPanel shapes = new JPanel(new GridLayout(3, 1));
        shapes.setBorder(BorderFactory.createTitledBorder(Messages.getString((String)"dialog.pdf.shapes.header")));
        JPanel descPanel = new JPanel(new BorderLayout());
        descPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JLabel description = new JLabel(Messages.getString((String)"dialog.pdf.shapes.description"));
        ComponentUtils.makeFocusable((JComponent)description);
        descPanel.add((Component)description, "North");
        shapes.add(descPanel);
        JLabel squareLabel = this.createOneSquareLabel();
        shapes.add(squareLabel);
        JLabel multiSquareLabel = this.createMultiSqaureLabel();
        shapes.add(multiSquareLabel);
        pageWestPanel.add((Component)shapes, "North");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString((String)"dialog.pdf.details.header")));
        topPanel.add((Component)this.createDetailPanel(), "North");
        pageWestPanel.add((Component)topPanel, "Center");
        return pageWestPanel;
    }

    private JPanel createDetailPanel() {
        JPanel detailPanel = new JPanel(new GridLayout(6, 2, 0, 5));
        detailPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.sigField = new JTextField(8);
        this.sigField.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.sigField));
        this.sigField.setText(Messages.getString((String)"dialog.pdf.details.name.default"));
        JLabel labelFor = new JLabel(Messages.getString((String)"dialog.pdf.details.name"));
        labelFor.setLabelFor(this.sigField);
        detailPanel.add(labelFor);
        detailPanel.add(this.sigField);
        int width = 120;
        int height = 30;
        if (this.signConfig != null) {
            width = (int)this.signConfig.getPdfSignatureExtentionVisualWidth() * 10;
            height = (int)this.signConfig.getPdfSignatureExtentionVisualHeight() * 10;
        }
        JSpinner fieldWidth = new JSpinner(new SpinnerNumberModel(width, 1, 1000, 1));
        ComponentUtils.addFocusListenerFor((JComponent)fieldWidth);
        JSpinner.NumberEditor compWidth = (JSpinner.NumberEditor)fieldWidth.getEditor();
        labelFor = new JLabel(Messages.getString((String)"dialog.pdf.details.width"));
        labelFor.setLabelFor(compWidth);
        compWidth.getFormat().setMinimumFractionDigits(1);
        compWidth.getFormat().setMaximumFractionDigits(1);
        JFormattedTextField jTextFieldWidth = (JFormattedTextField)compWidth.getComponent(0);
        DefaultFormatter formatterWidth = (DefaultFormatter)jTextFieldWidth.getFormatter();
        formatterWidth.setCommitsOnValidEdit(true);
        fieldWidth.addChangeListener(e -> {
            if (this.selectedSignatureField != null) {
                this.changeSelectedSignatureFieldSize(ResizeField.WIDTH);
            }
            this.sigFieldWidth = Math.round((float)PdfImagePanel.scaled(Float.valueOf(((Number)fieldWidth.getValue()).floatValue())) * 2.8346457f);
        });
        detailPanel.add(labelFor);
        detailPanel.add(fieldWidth);
        JSpinner fieldHeight = new JSpinner(new SpinnerNumberModel(height, 1, 1000, 1));
        ComponentUtils.addFocusListenerFor((JComponent)fieldHeight);
        JSpinner.NumberEditor compHeight = (JSpinner.NumberEditor)fieldHeight.getEditor();
        labelFor = new JLabel(Messages.getString((String)"dialog.pdf.details.height"));
        labelFor.setLabelFor(compHeight);
        compHeight.getFormat().setMinimumFractionDigits(1);
        compHeight.getFormat().setMaximumFractionDigits(1);
        JFormattedTextField jTextFieldHeight = (JFormattedTextField)compHeight.getComponent(0);
        DefaultFormatter formatterHeight = (DefaultFormatter)jTextFieldHeight.getFormatter();
        formatterHeight.setCommitsOnValidEdit(true);
        fieldHeight.addChangeListener(e -> {
            if (this.selectedSignatureField != null) {
                this.changeSelectedSignatureFieldSize(ResizeField.HEIGHT);
            }
            this.sigFieldHeight = Math.round((float)PdfImagePanel.scaled(Float.valueOf(((Number)fieldHeight.getValue()).floatValue())) * 2.8346457f);
        });
        detailPanel.add(labelFor);
        detailPanel.add(fieldHeight);
        this.sigFieldWidth = Math.round((float)PdfImagePanel.scaled(Float.valueOf(((Number)fieldWidth.getValue()).floatValue())) * 2.8346457f);
        this.sigFieldHeight = Math.round((float)PdfImagePanel.scaled(Float.valueOf(((Number)fieldHeight.getValue()).floatValue())) * 2.8346457f);
        JLabel header = new JLabel(Messages.getString((String)"dialog.pdf.details.count.header"));
        detailPanel.add(ComponentUtils.makeFocusable((JComponent)header));
        detailPanel.add(new JLabel(""));
        this.columnCount = new JSpinner(new SpinnerNumberModel(2, 1, 99, 1));
        ComponentUtils.addFocusListenerFor((JComponent)this.columnCount);
        labelFor = new JLabel(Messages.getString((String)"dialog.pdf.details.count.columns"));
        labelFor.setLabelFor(this.columnCount.getEditor());
        detailPanel.add(labelFor);
        detailPanel.add(this.columnCount);
        this.rowCount = new JSpinner(new SpinnerNumberModel(2, 1, 99, 1));
        ComponentUtils.addFocusListenerFor((JComponent)this.rowCount);
        labelFor = new JLabel(Messages.getString((String)"dialog.pdf.details.count.rows"));
        labelFor.setLabelFor(this.rowCount.getEditor());
        detailPanel.add(labelFor);
        detailPanel.add(this.rowCount);
        return detailPanel;
    }

    protected void changeSelectedSignatureFieldSize(ResizeField resizeField) {
        if (this.selectedSignatureField == null) {
            return;
        }
        if (!this.pdfImagePanel.getTempSignatureFields().contains(this.selectedSignatureField)) {
            return;
        }
        LOG.trace("");
        for (VisibleSignatureField tmpVisibleSignatureField : this.pdfImagePanel.getTempSignatureFields()) {
            LOG.trace("");
            if (!tmpVisibleSignatureField.equals(this.selectedSignatureField)) continue;
            LOG.trace("");
            switch (resizeField) {
                case WIDTH: {
                    tmpVisibleSignatureField.setWidth(this.sigFieldWidth);
                    tmpVisibleSignatureField.getSignatureField().setWidth((float)this.sigFieldWidth.intValue());
                    break;
                }
                case HEIGHT: {
                    tmpVisibleSignatureField.setHeight(this.sigFieldHeight);
                    tmpVisibleSignatureField.getSignatureField().setHeight((float)this.sigFieldHeight.intValue());
                    break;
                }
                default: {
                    tmpVisibleSignatureField.setWidth(this.sigFieldWidth);
                    tmpVisibleSignatureField.getSignatureField().setWidth((float)this.sigFieldWidth.intValue());
                    tmpVisibleSignatureField.setHeight(this.sigFieldHeight);
                    tmpVisibleSignatureField.getSignatureField().setHeight((float)this.sigFieldHeight.intValue());
                }
            }
            if (this.pdfImagePanel.isOnCropBox(tmpVisibleSignatureField.getX(), tmpVisibleSignatureField.getY(), tmpVisibleSignatureField.getWidth(), tmpVisibleSignatureField.getHeight())) {
                this.selectedSignatureField = tmpVisibleSignatureField;
                this.pdfImagePanel.setSelectedSignatureField(this.selectedSignatureField);
                this.pdfImagePanel.invalidate();
                this.pdfImagePanel.repaint();
                this.invalidate();
                this.repaint();
                break;
            }
            Document.getInstance().displayRedundantMessages((Component)this, "pdf.error.notoncropbox", 1);
        }
    }

    private JPanel createContentPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.pdfPanel = new JPanel(new BorderLayout());
        this.numberOfPagesTextField = new JTextField(this.selectedPageGUI + this.pageStringSplitter + this.numberOfPages);
        this.numberOfPagesTextField.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.numberOfPagesTextField));
        if (this.signConfig.getPdfSignatureExtentionPage() != -1) {
            this.selectedPage = 0;
            this.selectedPageGUI = 1;
            this.createPdfPanel(this.selectedPage);
            this.numberOfPagesTextField.setText(this.selectedPageGUI + this.pageStringSplitter + this.numberOfPages);
        } else {
            this.selectedPage = this.numberOfPages - 1;
            this.selectedPageGUI = this.numberOfPages;
            this.createPdfPanel(this.selectedPage);
            this.numberOfPagesTextField.setText(this.selectedPageGUI + this.pageStringSplitter + this.numberOfPages);
        }
        JPanel contentPDF = new JPanel(new BorderLayout());
        contentPDF.add((Component)this.pdfPanel, "Center");
        contentPDF.add((Component)this.createNavigationPanel(), "South");
        contentPanel.add((Component)contentPDF, "Center");
        return contentPanel;
    }

    private void createPdfPanel(int pageNumber) {
        LOG.trace("");
        if (pageNumber > this.numberOfPages - 1 || pageNumber < 0) {
            return;
        }
        this.pdfPanel.removeAll();
        Page page = this.pdfPages.get(pageNumber);
        LOG.trace("page.getCropBox() : {}", (Object)page.getCropBox());
        try {
            ArrayList<VisibleSignatureField> oldTempSignatureFields = new ArrayList();
            if (this.pdfImagePanel != null) {
                oldTempSignatureFields = this.pdfImagePanel.getTempSignatureFields();
            }
            this.pdfImagePanel = pageNumber == 0 ? new PdfImagePanel(this, this.pdfFirstPageImage, page) : (pageNumber == this.numberOfPages - 1 ? new PdfImagePanel(this, this.pdfLastPageImage, page) : new PdfImagePanel(this, page.generatePage(ImageType.ARGB, 0.7638889f), page));
            this.pdfImagePanel.setTempSignatureFields(oldTempSignatureFields);
            this.invalidate();
            this.repaint();
            this.pdfImagePanel.invalidate();
            this.pdfImagePanel.repaint();
            this.pdfPanel.add((Component)this.pdfImagePanel, "Center");
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
        this.pack();
    }

    void setFocusForSigField(MouseEvent e, PdfImagePanel pdfImagePanel) {
        if (e == null) {
            return;
        }
        LOG.trace("");
        VisibleSignatureField newSelectedSignatureField = null;
        for (VisibleSignatureField visibleSignatureField : pdfImagePanel.getPageSignatureFields()) {
            if (!visibleSignatureField.getSignatureField().isUsableForSigning() || !visibleSignatureField.isSignatureFieldPosition(e.getX(), e.getY())) continue;
            LOG.info("select pdf-feld : {}", (Object)visibleSignatureField.getSignatureField().getFieldName());
            newSelectedSignatureField = visibleSignatureField;
            break;
        }
        for (VisibleSignatureField visibleSignatureField : pdfImagePanel.getTempSignatureFields()) {
            if (!visibleSignatureField.getSignatureField().isUsableForSigning() || !visibleSignatureField.isSignatureFieldPosition(e.getX(), e.getY())) continue;
            LOG.trace("select temp-feld : {}", (Object)visibleSignatureField.getSignatureField().getFieldName());
            newSelectedSignatureField = visibleSignatureField;
            break;
        }
        if (newSelectedSignatureField != null && newSelectedSignatureField.getRect() != null) {
            this.selectedSignatureField = newSelectedSignatureField;
            this.assumeButton.setEnabled(true);
            this.signatureFieldTable = this.clearSelection(this.signatureFieldTable);
            for (int i = 0; i < this.signatureFieldTable.getRowCount(); ++i) {
                String fieldName = (String)this.signatureFieldTable.getValueAt(i, 1);
                if (!fieldName.equals(this.selectedSignatureField.getSignatureField().getFieldName())) continue;
                this.signatureFieldTable.setValueAt(Boolean.TRUE, i, 0);
                this.signatureFieldTable.changeSelection(i, 0, false, false);
                this.signatureFieldTable.requestFocus();
                this.assumeButton.setEnabled(true);
                break;
            }
            pdfImagePanel.setSelectedSignatureField(this.selectedSignatureField);
        } else {
            this.signatureFieldTable = this.clearSelection(this.signatureFieldTable);
            this.selectedSignatureField = null;
            this.assumeButton.setEnabled(false);
            pdfImagePanel.setSelectedSignatureField(null);
        }
        this.invalidate();
        this.repaint();
    }

    void setFocusForSigField(VisibleSignatureField newSelectedSignatureField, PdfImagePanel pdfImagePanel) {
        LOG.trace("");
        if (newSelectedSignatureField != null && newSelectedSignatureField.getRect() != null) {
            this.selectedSignatureField = newSelectedSignatureField;
            this.assumeButton.setEnabled(true);
            this.signatureFieldTable = this.clearSelection(this.signatureFieldTable);
            for (int i = 0; i < this.signatureFieldTable.getRowCount(); ++i) {
                String fieldName = (String)this.signatureFieldTable.getValueAt(i, 1);
                if (!fieldName.equals(this.selectedSignatureField.getSignatureField().getFieldName())) continue;
                this.signatureFieldTable.setValueAt(Boolean.TRUE, i, 0);
                this.signatureFieldTable.changeSelection(i, 0, false, false);
                this.signatureFieldTable.requestFocus();
                this.assumeButton.setEnabled(true);
                break;
            }
            pdfImagePanel.setSelectedSignatureField(this.selectedSignatureField);
        } else {
            this.signatureFieldTable = this.clearSelection(this.signatureFieldTable);
            this.selectedSignatureField = null;
            this.assumeButton.setEnabled(false);
            pdfImagePanel.setSelectedSignatureField(null);
        }
    }

    private JPanel createNavigationPanel() {
        LOG.trace("");
        JPanel navPanel = new JPanel(new FlowLayout(1, 30, 5));
        IconButton firstPageButton = new IconButton();
        firstPageButton.setAction((Action)((Object)new BeginningAction(this)));
        IconButton pageBackButton = new IconButton();
        pageBackButton.setAction((Action)((Object)new LeftAction(this)));
        IconButton lastPageButton = new IconButton();
        lastPageButton.setAction((Action)((Object)new EndAction(this)));
        IconButton pageForwardButton = new IconButton();
        pageForwardButton.setAction((Action)((Object)new RightAction(this)));
        this.numberOfPagesTextField = new JTextField(this.selectedPageGUI + this.pageStringSplitter + this.numberOfPages);
        this.numberOfPagesTextField.setHorizontalAlignment(0);
        this.numberOfPagesTextField.setMargin(new Insets(3, 3, 3, 3));
        this.numberOfPagesTextField.setPreferredSize(new Dimension(120, 30));
        this.numberOfPagesTextField.setBorder(SignerTheme.TEXTFIELD_FOCUSLESS);
        this.numberOfPagesTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AdvancedPDFDialog.this.numberOfPagesTextField.setBorder(SignerTheme.TEXTFIELD_FOCUSED);
                AdvancedPDFDialog.this.numberOfPagesTextField.setText("");
            }

            @Override
            public void focusLost(FocusEvent e) {
                AdvancedPDFDialog.this.numberOfPagesTextField.setBorder(SignerTheme.TEXTFIELD_FOCUSLESS);
                AdvancedPDFDialog.this.numberOfPagesTextField.setText(AdvancedPDFDialog.this.selectedPageGUI + AdvancedPDFDialog.this.pageStringSplitter + AdvancedPDFDialog.this.numberOfPages);
            }
        });
        this.numberOfPagesTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AdvancedPDFDialog.this.handledKeyPressedEvent(e);
            }
        });
        navPanel.add((Component)firstPageButton);
        navPanel.add((Component)pageBackButton);
        navPanel.add(this.numberOfPagesTextField);
        navPanel.add((Component)pageForwardButton);
        navPanel.add((Component)lastPageButton);
        return navPanel;
    }

    private void handledKeyPressedEvent(KeyEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (e == null) {
                return;
            }
            if (e.getKeyCode() != 10) {
                return;
            }
            LOG.trace("ENTER");
            for (int i = 0; i < this.numberOfPagesTextField.getText().length(); ++i) {
                String text = this.numberOfPagesTextField.getText();
                try {
                    int parseInputPage = Integer.parseInt(text);
                    if (Character.isDigit(text.charAt(i)) && parseInputPage >= 0 && parseInputPage <= this.numberOfPages) {
                        this.selectedPageGUI = parseInputPage;
                        this.selectedPage = parseInputPage - 1;
                        this.createPdfPanel(this.selectedPage);
                        this.numberOfPagesTextField.setText(parseInputPage + this.pageStringSplitter + this.numberOfPages);
                        break;
                    }
                    this.numberOfPagesTextField.setText(parseInputPage + this.pageStringSplitter + this.numberOfPages);
                    this.numberOfPagesTextField.requestFocus();
                    continue;
                }
                catch (Exception e2) {
                    this.numberOfPagesTextField.setText(this.selectedPageGUI + this.pageStringSplitter + this.numberOfPages);
                }
            }
        });
    }

    public void changeSignatureFieldList(VisibleSignatureField visibleSignatureField, Rectangle rectangle) {
        LOG.trace("");
        for (VisibleSignatureField tmpSigField : this.pdfImagePanel.getTempSignatureFields()) {
            if (!tmpSigField.getSignatureField().equals(visibleSignatureField.getSignatureField())) continue;
            tmpSigField.changeDimension(rectangle, this.pdfImagePanel);
            this.pdfImagePanel.setSelectedSignatureField(tmpSigField);
            this.pdfImagePanel.invalidate();
            this.pdfImagePanel.repaint();
            this.undoButton.setEnabled(true);
            this.assumeButton.setEnabled(true);
            break;
        }
        this.invalidate();
        this.repaint();
        LOG.trace("init gui done");
    }

    private MouseMotionListener createMouseMotionAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                if (me == null) {
                    return;
                }
                Object object = me.getSource();
                if (!(object instanceof JLabel)) {
                    return;
                }
                JLabel jLabel = (JLabel)object;
                if (AdvancedPDFDialog.this.glassPaneImage == null && AdvancedPDFDialog.this.pdfPages != null && !AdvancedPDFDialog.this.pdfPages.isEmpty() && AdvancedPDFDialog.this.sigField != null) {
                    Integer rows = (Integer)AdvancedPDFDialog.this.rowCount.getValue();
                    Integer columns = (Integer)AdvancedPDFDialog.this.columnCount.getValue();
                    if (jLabel.getName().equals(AdvancedPDFDialog.ONE_SQUARE)) {
                        rows = 1;
                        columns = 1;
                    }
                    AdvancedPDFDialog.this.glassPaneImage = AdvancedPDFDialog.this.createPreview(rows, columns);
                    if (AdvancedPDFDialog.this.glassPaneImage != null) {
                        Point p = new Point(me.getLocationOnScreen().x, me.getLocationOnScreen().y);
                        AdvancedPDFDialog.this.glassPane.showIt(AdvancedPDFDialog.this.glassPaneImage, p);
                    }
                }
                if (AdvancedPDFDialog.this.glassPaneImage != null && AdvancedPDFDialog.this.glassPane.getImage() != null) {
                    AdvancedPDFDialog.this.glassPane.setCursor(Cursor.getPredefinedCursor(13));
                    AdvancedPDFDialog.this.glassPane.moveIt(me.getLocationOnScreen());
                }
            }
        };
    }

    private BufferedImage createPreview(Integer rows, Integer columns) {
        LOG.trace("");
        BufferedImage preview = null;
        if (rows == 1 && columns == 1) {
            preview = new BufferedImage(this.sigFieldWidth, this.sigFieldHeight, 2);
            Graphics2D g2d = preview.createGraphics();
            g2d.setColor(PdfImagePanel.COLOR_NEW_SIGFIELDS);
            g2d.fillRect(0, 0, this.sigFieldWidth, this.sigFieldHeight);
        } else {
            int previewWith = 0;
            for (int i = 0; i < columns; ++i) {
                previewWith += this.sigFieldWidth.intValue();
                if (i == columns - 1) continue;
                previewWith += HORIZONTAL_SIGFIELD_PADDING.intValue();
            }
            int previewHeight = 0;
            for (int i = 0; i < rows; ++i) {
                previewHeight += this.sigFieldHeight.intValue();
                if (i == rows - 1) continue;
                previewHeight += VERTICAL_SIGFIELD_PADDING.intValue();
            }
            preview = new BufferedImage(previewWith, previewHeight, 2);
            Graphics2D g2d = preview.createGraphics();
            int x = 0;
            for (int i = 0; i < columns; ++i) {
                int y = 0;
                for (int j = 0; j < rows; ++j) {
                    g2d.setColor(PdfImagePanel.COLOR_NEW_SIGFIELDS);
                    g2d.fillRect(x, y, this.sigFieldWidth, this.sigFieldHeight);
                    y += this.sigFieldHeight.intValue();
                    if (j == rows - 1) continue;
                    y += VERTICAL_SIGFIELD_PADDING.intValue();
                }
                x += this.sigFieldWidth.intValue();
                if (i == columns - 1) continue;
                x += HORIZONTAL_SIGFIELD_PADDING.intValue();
            }
        }
        return preview;
    }

    private MouseListener createMouseListenerAdapter(final ImageIcon focusless, final ImageIcon focused) {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(final MouseEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getSource() == null) {
                    return;
                }
                Object object = e.getSource();
                if (!(object instanceof JLabel)) {
                    return;
                }
                JLabel square = (JLabel)object;
                square.setCursor(Cursor.getPredefinedCursor(12));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LOG.trace("");
                        int mouseLocationX = e.getPoint().x;
                        int mouseLocationY = e.getPoint().y;
                        Integer rows = (Integer)AdvancedPDFDialog.this.rowCount.getValue();
                        Integer columns = (Integer)AdvancedPDFDialog.this.columnCount.getValue();
                        Object object = e.getSource();
                        if (!(object instanceof JLabel)) {
                            return;
                        }
                        JLabel jLabel = (JLabel)object;
                        String labelName = jLabel.getName();
                        if (AdvancedPDFDialog.ONE_SQUARE.equals(labelName)) {
                            int leftBorder = 5;
                            int topBorder = 130;
                            int roundX = mouseLocationX - AdvancedPDFDialog.this.sigFieldWidth / 2 - AdvancedPDFDialog.this.westPanel.getWidth() + leftBorder;
                            int roundY = mouseLocationY - AdvancedPDFDialog.this.sigFieldHeight / 2 + topBorder;
                            LOG.trace("Signaturfeld angelegt X:Y - {}:{}", (Object)roundX, (Object)roundY);
                            if (AdvancedPDFDialog.this.pdfImagePanel.isOnCropBox(roundX, roundY, AdvancedPDFDialog.this.sigFieldWidth.intValue(), AdvancedPDFDialog.this.sigFieldHeight.intValue())) {
                                SignatureField sf = new SignatureField((float)roundX, (float)roundY, (float)AdvancedPDFDialog.this.sigFieldWidth.intValue(), (float)AdvancedPDFDialog.this.sigFieldHeight.intValue());
                                sf.setFieldName(this.getFieldName());
                                sf.setPageNo(AdvancedPDFDialog.this.selectedPageGUI);
                                sf.setUsableForSigning(true);
                                VisibleSignatureField vsf = VisibleSignatureField.createFieldFromPanel(sf, AdvancedPDFDialog.this.pdfImagePanel);
                                AdvancedPDFDialog.this.pdfImagePanel.getTempSignatureFields().add(vsf);
                                if (AdvancedPDFDialog.this.signatureFieldListModel != null) {
                                    AdvancedPDFDialog.this.signatureFieldListModel.addRow(new Object[]{Boolean.FALSE, sf.getFieldName(), sf.getPageNo()});
                                } else {
                                    JPanel eastPanel = AdvancedPDFDialog.this.createEastPanel();
                                    AdvancedPDFDialog.this.add((Component)eastPanel, "East");
                                    eastPanel.invalidate();
                                    eastPanel.revalidate();
                                    eastPanel.repaint();
                                }
                                AdvancedPDFDialog.this.undoButton.setEnabled(true);
                                AdvancedPDFDialog.this.assumeButton.setEnabled(true);
                                AdvancedPDFDialog.this.setFocusForSigField(vsf, AdvancedPDFDialog.this.pdfImagePanel);
                                AdvancedPDFDialog.this.pdfImagePanel.setCursor(Cursor.getPredefinedCursor(12));
                            } else {
                                JLabel messageLabel = new JLabel(Messages.getString((String)"dialog.pdf.error.notoncropbox.message"));
                                JOptionPane.showMessageDialog(null, ComponentUtils.makeFocusable((JComponent)messageLabel), Messages.getString((String)"dialog.pdf.error.notoncropbox.title"), 0);
                            }
                        } else if ("multiSquare".equals(labelName)) {
                            int previewWith = 0;
                            for (int i = 0; i < columns; ++i) {
                                previewWith += AdvancedPDFDialog.this.sigFieldWidth.intValue();
                                if (i == columns - 1) continue;
                                previewWith += HORIZONTAL_SIGFIELD_PADDING.intValue();
                            }
                            int previewHeight = 0;
                            for (int i = 0; i < rows; ++i) {
                                previewHeight += AdvancedPDFDialog.this.sigFieldHeight.intValue();
                                if (i == rows - 1) continue;
                                previewHeight += VERTICAL_SIGFIELD_PADDING.intValue();
                            }
                            int roundX = mouseLocationX - AdvancedPDFDialog.this.westPanel.getWidth() + 5;
                            int roundY = mouseLocationY + 250;
                            boolean showError = false;
                            int y = roundY - previewHeight / 2;
                            for (int j = 0; j < rows; ++j) {
                                int x = roundX - previewWith / 2;
                                for (int i = 0; i < columns; ++i) {
                                    if (AdvancedPDFDialog.this.pdfImagePanel.isOnCropBox(x, y, AdvancedPDFDialog.this.sigFieldWidth.intValue(), AdvancedPDFDialog.this.sigFieldHeight.intValue())) {
                                        SignatureField sf = new SignatureField((float)x, (float)y, (float)AdvancedPDFDialog.this.sigFieldWidth.intValue(), (float)AdvancedPDFDialog.this.sigFieldHeight.intValue());
                                        sf.setFieldName(this.getFieldName());
                                        sf.setPageNo(AdvancedPDFDialog.this.selectedPageGUI);
                                        sf.setUsableForSigning(true);
                                        VisibleSignatureField vsf = VisibleSignatureField.createFieldFromPanel(sf, AdvancedPDFDialog.this.pdfImagePanel);
                                        AdvancedPDFDialog.this.pdfImagePanel.getTempSignatureFields().add(vsf);
                                        if (AdvancedPDFDialog.this.signatureFieldListModel != null) {
                                            AdvancedPDFDialog.this.signatureFieldListModel.addRow(new Object[]{Boolean.FALSE, sf.getFieldName(), sf.getPageNo()});
                                        } else {
                                            JPanel eastPanel = AdvancedPDFDialog.this.createEastPanel();
                                            AdvancedPDFDialog.this.add((Component)eastPanel, "East");
                                            eastPanel.invalidate();
                                            eastPanel.revalidate();
                                            eastPanel.repaint();
                                        }
                                        AdvancedPDFDialog.this.undoButton.setEnabled(true);
                                        AdvancedPDFDialog.this.assumeButton.setEnabled(true);
                                        x += AdvancedPDFDialog.this.sigFieldWidth.intValue();
                                        if (i != columns - 1) {
                                            x += HORIZONTAL_SIGFIELD_PADDING.intValue();
                                        }
                                        AdvancedPDFDialog.this.setFocusForSigField(vsf, AdvancedPDFDialog.this.pdfImagePanel);
                                        continue;
                                    }
                                    if (showError) continue;
                                    JLabel messageLabel = new JLabel(Messages.getString((String)"dialog.pdf.error.notoncropbox.message"));
                                    JOptionPane.showMessageDialog(null, ComponentUtils.makeFocusable((JComponent)messageLabel), Messages.getString((String)"dialog.pdf.error.notoncropbox.title"), 0);
                                    showError = true;
                                }
                                y += AdvancedPDFDialog.this.sigFieldHeight.intValue();
                                if (j == rows - 1) continue;
                                y += VERTICAL_SIGFIELD_PADDING.intValue();
                            }
                        }
                        AdvancedPDFDialog.this.pdfImagePanel.invalidate();
                        AdvancedPDFDialog.this.glassPane.hideIt();
                        AdvancedPDFDialog.this.glassPaneImage = null;
                    }

                    private String getFieldName() {
                        int counter = 1;
                        String fieldName = AdvancedPDFDialog.this.sigField.getText() + counter;
                        while (this.fieldNameExist(fieldName)) {
                            fieldName = AdvancedPDFDialog.this.sigField.getText() + ++counter;
                        }
                        return fieldName;
                    }

                    private boolean fieldNameExist(String fieldName) {
                        LOG.trace("");
                        for (SignatureField tmpSignatureField : AdvancedPDFDialog.this.allSignatureFieldMap.keySet()) {
                            if (!tmpSignatureField.getFieldName().equals(fieldName)) continue;
                            LOG.trace("Signaturfeldname : {}", (Object)fieldName);
                            return true;
                        }
                        for (VisibleSignatureField tmpVisibleSignatureField : AdvancedPDFDialog.this.pdfImagePanel.getTempSignatureFields()) {
                            SignatureField tmpSignatureField = tmpVisibleSignatureField.getSignatureField();
                            if (!tmpSignatureField.getFieldName().equals(fieldName)) continue;
                            LOG.trace("Signaturfeldname : {}", (Object)fieldName);
                            return true;
                        }
                        LOG.trace("Signaturfeld hat keinen Namen.");
                        return false;
                    }
                });
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getSource() == null) {
                    return;
                }
                Object object = e.getSource();
                if (!(object instanceof JLabel)) {
                    return;
                }
                JLabel square = (JLabel)object;
                square.setCursor(Cursor.getPredefinedCursor(12));
                square.setIcon(focused);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getSource() == null) {
                    return;
                }
                Object object = e.getSource();
                if (!(object instanceof JLabel)) {
                    return;
                }
                JLabel square = (JLabel)object;
                square.setCursor(Cursor.getDefaultCursor());
                square.setIcon(focusless);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getSource() == null) {
                    return;
                }
                Object object = e.getSource();
                if (!(object instanceof JLabel)) {
                    return;
                }
                JLabel square = (JLabel)object;
                square.setCursor(Cursor.getPredefinedCursor(13));
            }
        };
    }

    private void changeSelectedSignatureField(ListSelectionEvent e) {
        LOG.trace("");
        if (e == null) {
            return;
        }
        if (this.signatureFieldTable == null) {
            return;
        }
        this.signatureFieldTable = this.clearSelection(this.signatureFieldTable);
        int selectedRow = this.signatureFieldTable.getSelectionModel().getLeadSelectionIndex();
        if (this.signatureFieldTable.getRowCount() > 1) {
            this.signatureFieldTable.setValueAt(Boolean.TRUE, selectedRow, 0);
            this.assumeButton.setEnabled(true);
            int signatureFieldPage = (Integer)this.signatureFieldTable.getValueAt(selectedRow, 2);
            if (this.selectedPage != signatureFieldPage - 1) {
                this.selectedPage = signatureFieldPage - 1;
                this.selectedPageGUI = signatureFieldPage;
                this.createPdfPanel(this.selectedPage);
                this.numberOfPagesTextField.setText(this.selectedPageGUI + this.pageStringSplitter + this.numberOfPages);
            }
            for (VisibleSignatureField visibleSignatureField : this.pdfImagePanel.getPageSignatureFields()) {
                if (!visibleSignatureField.getSignatureField().getFieldName().equals(this.signatureFieldTable.getValueAt(selectedRow, 1))) continue;
                this.selectedSignatureField = visibleSignatureField;
                break;
            }
            for (VisibleSignatureField visibleSignatureField : this.pdfImagePanel.getTempSignatureFields()) {
                if (!visibleSignatureField.getSignatureField().getFieldName().equals(this.signatureFieldTable.getValueAt(selectedRow, 1))) continue;
                this.selectedSignatureField = visibleSignatureField;
                break;
            }
        }
        if (this.selectedSignatureField == null) {
            return;
        }
        if (this.selectedSignatureField.getRect() == null) {
            return;
        }
        this.pdfImagePanel.setSelectedSignatureField(this.selectedSignatureField);
        this.invalidate();
        this.repaint();
    }

    private JTable clearSelection(JTable privateSignatureFieldTable) {
        for (int i = 0; i < privateSignatureFieldTable.getRowCount(); ++i) {
            privateSignatureFieldTable.setValueAt(Boolean.FALSE, i, 0);
        }
        return privateSignatureFieldTable;
    }

    public HashMap<SignatureField, Integer> getSignableSignatureFieldMap() {
        return this.signableSignatureFieldMap;
    }

    private FocusListener createFocusListener(final ImageIcon iconFocusless, final ImageIcon iconFocused) {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JLabel label = (JLabel)e.getSource();
                label.setCursor(Cursor.getPredefinedCursor(12));
                label.setIcon(iconFocused);
            }

            @Override
            public void focusLost(FocusEvent e) {
                JLabel label = (JLabel)e.getSource();
                label.setCursor(Cursor.getDefaultCursor());
                label.setIcon(iconFocusless);
            }
        };
    }

    private JLabel createOneSquareLabel() {
        ImageIcon iconFocusless = this.createOneFocuslessIcon();
        ImageIcon iconFocused = this.createOneFocusedIcon();
        JLabel squareLabel = new JLabel(iconFocusless);
        squareLabel.setName(ONE_SQUARE);
        squareLabel.setFocusable(true);
        squareLabel.getAccessibleContext().setAccessibleName("Ein Signaturfeld.");
        squareLabel.setToolTipText(MultiLineTooltips.wrapToolTip((String)"Gr\u00f6\u00dfe in Details einstellen."));
        squareLabel.addMouseMotionListener(this.createMouseMotionAdapter());
        squareLabel.addMouseListener(this.createMouseListenerAdapter(iconFocusless, iconFocused));
        squareLabel.addFocusListener(this.createFocusListener(iconFocusless, iconFocused));
        return squareLabel;
    }

    private ImageIcon createOneFocuslessIcon() {
        BufferedImage squareImage = new BufferedImage(120, 120, 2);
        Graphics2D squareG2d = squareImage.createGraphics();
        squareG2d.setStroke(new BasicStroke(1.0f));
        squareG2d.setColor(new Color(128, 128, 128));
        squareG2d.drawRect(31, 31, 56, 56);
        return new ImageIcon(squareImage);
    }

    private ImageIcon createOneFocusedIcon() {
        BufferedImage squareImageFocused = new BufferedImage(120, 120, 2);
        Graphics2D squareG2dFocused = squareImageFocused.createGraphics();
        squareG2dFocused.setStroke(new BasicStroke(2.0f));
        squareG2dFocused.setColor(SignerTheme.BOREUM_PETROL);
        squareG2dFocused.drawRect(25, 25, 68, 68);
        return new ImageIcon(squareImageFocused);
    }

    private JLabel createMultiSqaureLabel() {
        ImageIcon multiFocusless = this.createMultiFocuslessIcon();
        ImageIcon multiFocused = this.createMultiFocusedIcon();
        JLabel multiSquareLabel = new JLabel(multiFocusless);
        multiSquareLabel.setName("multiSquare");
        multiSquareLabel.setFocusable(true);
        multiSquareLabel.getAccessibleContext().setAccessibleName("Multi Signaturfeld.");
        multiSquareLabel.setToolTipText(MultiLineTooltips.wrapToolTip((String)"Gr\u00f6\u00dfe und Anzahl der Felder in Details einstellen."));
        multiSquareLabel.addMouseListener(this.createMouseListenerAdapter(multiFocusless, multiFocused));
        multiSquareLabel.addMouseMotionListener(this.createMouseMotionAdapter());
        multiSquareLabel.addFocusListener(this.createFocusListener(multiFocusless, multiFocused));
        return multiSquareLabel;
    }

    private ImageIcon createMultiFocuslessIcon() {
        BufferedImage multiSquareImage = new BufferedImage(120, 120, 2);
        Graphics2D g2d = multiSquareImage.createGraphics();
        g2d.setColor(new Color(128, 128, 128));
        Stroke old = g2d.getStroke();
        BasicStroke s = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{1.0f, 3.0f}, 0.0f);
        g2d.drawRect(31, 31, 28, 28);
        g2d.setStroke(s);
        g2d.drawRect(62, 31, 28, 28);
        g2d.drawRect(31, 62, 28, 28);
        g2d.drawRect(62, 62, 28, 28);
        g2d.setStroke(old);
        return new ImageIcon(multiSquareImage);
    }

    private ImageIcon createMultiFocusedIcon() {
        BufferedImage multiSquareImage = new BufferedImage(120, 120, 2);
        Graphics2D g2d = multiSquareImage.createGraphics();
        g2d.setColor(SignerTheme.BOREUM_PETROL);
        BasicStroke s = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{1.0f, 3.0f}, 0.0f);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawRect(25, 25, 34, 34);
        g2d.setStroke(s);
        g2d.drawRect(62, 25, 34, 34);
        g2d.drawRect(25, 62, 34, 34);
        g2d.drawRect(62, 62, 34, 34);
        g2d.setStroke(new BasicStroke(2.0f));
        return new ImageIcon(multiSquareImage);
    }

    private class CleanUpWindowListener
    extends WindowAdapter {
        private CleanUpWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Utils.closeStream((Closeable)AdvancedPDFDialog.this.pdfMetaData);
        }
    }

    private class UndoAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;

        protected UndoAction(Component parent) {
            super("dialog.pdf.button.undo", parent);
            LOG.trace("");
            this.setKeyAndIcon(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            SwingUtilities.invokeLater(() -> {
                LOG.trace("");
                AdvancedPDFDialog.this.signatureFieldListModel.setRowCount(0);
                for (Map.Entry<SignatureField, Integer> next : AdvancedPDFDialog.this.signableSignatureFieldMap.entrySet()) {
                    AdvancedPDFDialog.this.signatureFieldListModel.addRow(new Object[]{Boolean.FALSE, next.getKey().getFieldName(), next.getValue()});
                }
                AdvancedPDFDialog.this.pdfImagePanel.setTempSignatureFields(new ArrayList<VisibleSignatureField>());
                AdvancedPDFDialog.this.pdfImagePanel.setSelectedSignatureField(null);
                AdvancedPDFDialog.this.pdfImagePanel.invalidate();
                AdvancedPDFDialog.this.pdfImagePanel.repaint();
                AdvancedPDFDialog.this.undoButton.setEnabled(false);
                AdvancedPDFDialog.this.assumeButton.setEnabled(false);
                AdvancedPDFDialog.this.invalidate();
                AdvancedPDFDialog.this.repaint();
            });
        }
    }

    private class CancelAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;

        protected CancelAction(Component parent) {
            super("dialog.pdf.button.cancel", parent);
            LOG.trace("");
            this.setKeyAndIcon(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            LOG.trace("");
            AdvancedPDFDialog.this.setVisible(false);
        }
    }

    private class AssumeAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;

        protected AssumeAction(Component parent) {
            super("dialog.pdf.button.assume", parent);
            LOG.trace("");
            this.setKeyAndIcon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent arg0) {
            LOG.trace("");
            FileOutputStream fileOutputStream = null;
            try {
                if (AdvancedPDFDialog.this.pdfMetaData != null) {
                    for (VisibleSignatureField sf : AdvancedPDFDialog.this.pdfImagePanel.getTempSignatureFields()) {
                        float x = sf.getSignatureField().getX();
                        float y = sf.getSignatureField().getY();
                        float height = sf.getSignatureField().getHeight();
                        float width = sf.getSignatureField().getWidth();
                        SignatureField saveField = new SignatureField(x, y, width, height);
                        saveField.setPageNo(sf.getSignatureField().getPageNo());
                        saveField.setFieldName(sf.getSignatureField().getFieldName());
                        saveField.setUsableForSigning(sf.getSignatureField().isUsableForSigning());
                        AdvancedPDFDialog.this.pdfMetaData.addSignatureField(saveField);
                    }
                    if (!AdvancedPDFDialog.this.pdfImagePanel.getTempSignatureFields().isEmpty()) {
                        File tempPdfFile = File.createTempFile("SignerAvancedPdf", ".pdf", Step.getTempFolder());
                        fileOutputStream = new FileOutputStream(tempPdfFile);
                        AdvancedPDFDialog.this.pdfMetaData.saveFile((OutputStream)fileOutputStream);
                        ((OutputStream)fileOutputStream).close();
                        AdvancedPDFDialog.this.copyFile(tempPdfFile, AdvancedPDFDialog.this.selectedPdfFile);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("show error : pdf.error.could_not_store");
                ErrorDialog.showDialog((Component)AdvancedPDFDialog.this, (String)"pdf.error.could_not_store", (String)ex.toString());
            }
            finally {
                Utils.closeStream(fileOutputStream);
            }
            if (AdvancedPDFDialog.this.selectedSignatureField != null) {
                SignConfig config = (SignConfig)AdvancedPDFDialog.this.process.getConfig();
                config.setSelectedSignatureField(AdvancedPDFDialog.this.selectedSignatureField.getSignatureField());
                AdvancedPDFDialog.this.setVisible(false);
            } else {
                RedundantErrorDialog.showDialog((Component)AdvancedPDFDialog.this, (String)Messages.getString((String)"dialog.pdf.signaturefields.selected"), (String)Messages.getString((String)"dialog.error.title"));
                this.reinit();
            }
        }

        private void reinit() {
            LOG.trace("");
            AdvancedPDFDialog.this.initMetaData();
            AdvancedPDFDialog.this.signatureFieldListModel.setRowCount(0);
            for (Map.Entry<SignatureField, Integer> next : AdvancedPDFDialog.this.signableSignatureFieldMap.entrySet()) {
                AdvancedPDFDialog.this.signatureFieldListModel.addRow(new Object[]{Boolean.FALSE, next.getKey().getFieldName(), next.getValue()});
            }
            AdvancedPDFDialog.this.pdfImagePanel.setTempSignatureFields(new ArrayList<VisibleSignatureField>());
            AdvancedPDFDialog.this.pdfImagePanel.setSelectedSignatureField(null);
            AdvancedPDFDialog.this.pdfImagePanel.invalidate();
            AdvancedPDFDialog.this.pdfImagePanel.repaint();
            AdvancedPDFDialog.this.undoButton.setEnabled(false);
            AdvancedPDFDialog.this.assumeButton.setEnabled(false);
            AdvancedPDFDialog.this.invalidate();
            AdvancedPDFDialog.this.repaint();
        }
    }

    static enum ResizeField {
        BOTH,
        WIDTH,
        HEIGHT;

    }

    private class BeginningAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;

        protected BeginningAction(Component parent) {
            super("dialog.pdf.button.navigate.beginning", parent);
            LOG.trace("");
            this.setKeyAndIcon(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            SwingUtilities.invokeLater(() -> {
                LOG.trace("");
                AdvancedPDFDialog.this.selectedPage = 0;
                AdvancedPDFDialog.this.selectedPageGUI = 1;
                AdvancedPDFDialog.this.createPdfPanel(AdvancedPDFDialog.this.selectedPage);
                AdvancedPDFDialog.this.numberOfPagesTextField.setText(AdvancedPDFDialog.this.selectedPageGUI + AdvancedPDFDialog.this.pageStringSplitter + AdvancedPDFDialog.this.numberOfPages);
            });
        }
    }

    private class LeftAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;

        protected LeftAction(Component parent) {
            super("dialog.pdf.button.navigate.left", parent);
            LOG.trace("");
            this.setKeyAndIcon(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            SwingUtilities.invokeLater(() -> {
                LOG.trace("");
                if (AdvancedPDFDialog.this.selectedPage > 0) {
                    --AdvancedPDFDialog.this.selectedPage;
                    --AdvancedPDFDialog.this.selectedPageGUI;
                    AdvancedPDFDialog.this.createPdfPanel(AdvancedPDFDialog.this.selectedPage);
                    AdvancedPDFDialog.this.numberOfPagesTextField.setText(AdvancedPDFDialog.this.selectedPageGUI + AdvancedPDFDialog.this.pageStringSplitter + AdvancedPDFDialog.this.numberOfPages);
                }
            });
        }
    }

    private class EndAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;

        protected EndAction(Component parent) {
            super("dialog.pdf.button.navigate.end", parent);
            LOG.trace("");
            this.setKeyAndIcon(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            SwingUtilities.invokeLater(() -> {
                LOG.trace("");
                AdvancedPDFDialog.this.selectedPage = AdvancedPDFDialog.this.numberOfPages - 1;
                AdvancedPDFDialog.this.selectedPageGUI = AdvancedPDFDialog.this.numberOfPages;
                AdvancedPDFDialog.this.createPdfPanel(AdvancedPDFDialog.this.selectedPage);
                AdvancedPDFDialog.this.numberOfPagesTextField.setText(AdvancedPDFDialog.this.selectedPageGUI + AdvancedPDFDialog.this.pageStringSplitter + AdvancedPDFDialog.this.numberOfPages);
            });
        }
    }

    private class RightAction
    extends AbstractSignerAction {
        private static final long serialVersionUID = 1L;

        protected RightAction(Component parent) {
            super("dialog.pdf.button.navigate.right", parent);
            LOG.trace("");
            this.setKeyAndIcon(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            SwingUtilities.invokeLater(() -> {
                LOG.trace("");
                if (AdvancedPDFDialog.this.selectedPage < AdvancedPDFDialog.this.numberOfPages - 1) {
                    ++AdvancedPDFDialog.this.selectedPage;
                    ++AdvancedPDFDialog.this.selectedPageGUI;
                    AdvancedPDFDialog.this.createPdfPanel(AdvancedPDFDialog.this.selectedPage);
                    AdvancedPDFDialog.this.numberOfPagesTextField.setText(AdvancedPDFDialog.this.selectedPageGUI + AdvancedPDFDialog.this.pageStringSplitter + AdvancedPDFDialog.this.numberOfPages);
                }
            });
        }
    }
}

