/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components.imagedisplay;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFVisualisationTyp;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFVisualisationTypEnum;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;

public class ImageComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final int SIZE = 75;
    private Color bgColor = null;
    private transient Image scaledImage = null;
    private Dimension dim = new Dimension(75, 75);
    private transient PDFVisualisationTyp pdfVisualisationTyp;

    public ImageComponent(PDFVisualisationTyp typ) {
        this.pdfVisualisationTyp = typ;
        this.setPreferredSize(this.dim);
        this.setMinimumSize(this.dim);
        this.setFocusable(true);
        this.addFocusListener(ComponentUtils.createFocusListenerFor((JComponent)this));
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void clear() {
        this.scaledImage = null;
        this.repaint();
    }

    public void setStdImage(Image image, String imageName) {
        this.scaledImage = image;
        this.setToolTipText(imageName);
        this.repaint();
    }

    public void setImage(Image image, String imageName) {
        this.scaledImage = image == null ? null : this.scale(image);
        this.setToolTipText(imageName);
        this.repaint();
    }

    private Image scale(Image srcImage) {
        int srcHeight;
        int srcWidth = srcImage.getWidth(null);
        Image neuImage = srcWidth > (srcHeight = srcImage.getHeight(null)) ? srcImage.getScaledInstance(75, -1, 8) : srcImage.getScaledInstance(-1, 75, 8);
        return neuImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.scaledImage != null) {
            int x = (75 - this.scaledImage.getWidth(null)) / 2;
            int y = (75 - this.scaledImage.getHeight(null)) / 2;
            g.drawImage(this.scaledImage, x, y, this);
        } else {
            if (this.bgColor == null) {
                g.clearRect(0, 0, 75, 75);
            } else {
                g.setColor(this.bgColor);
                g.fillRect(0, 0, 75, 75);
            }
            g.setColor(Color.black);
            if (this.pdfVisualisationTyp.getTyp().equals((Object)PDFVisualisationTypEnum.BOTH) || this.pdfVisualisationTyp.getTyp().equals((Object)PDFVisualisationTypEnum.IMAGE)) {
                g.drawString(Messages.getString((String)"config.dialog.visualpdf.visualisation.preview.error"), 0, 25);
            }
        }
    }
}

