/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizationPanel
extends ProcessConfigComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VisualizationPanel.class);
    private JPanel content;
    private static final String DELETE_SOURCE_COMPONENT_KEY = "delete_source";
    private JCheckBox buttonUseCounter;
    private JSpinner spinner;
    private JCheckBox useDeleteSource;
    private final ProcessI process;
    private LicenceTyp visualisationLicenceTyp = LicenceTyp.enable;
    private LicenceTyp deleteSourceLicenceTyp = LicenceTyp.enable;
    private int tempCounter;
    private boolean tempUseCounter;

    public VisualizationPanel(ProcessI process, LicenceTyp visualisationlicenceTyp) {
        this.process = process;
        this.visualisationLicenceTyp = visualisationlicenceTyp;
        this.initContent();
        this.initGUI();
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)((Object)this));
    }

    private void initContent() {
        this.content = new JPanel(new GridBagLayout());
    }

    private void initGUI() {
        int gridy = 0;
        JComponentUtils.setLookByLicence((JComponent)this.initVisualisationGUI(), (LicenceTyp)this.visualisationLicenceTyp, (JPanel)this.content, (GridBagConstraints)new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 10, 5), 0, 0));
        JComponentUtils.setLookByLicence((JComponent)this.initDeleteSourceGUI(), (LicenceTyp)this.deleteSourceLicenceTyp, (JPanel)this.content, (GridBagConstraints)new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 10, 5), 0, 0));
    }

    protected JComponent initVisualisationGUI() {
        JPanel visualisationPanel = new JPanel(new GridBagLayout());
        visualisationPanel = ComponentUtils.setTitledFocusableBorder((JPanel)visualisationPanel, (String)Messages.getString((String)"config.dialog.visualization.title"));
        this.buttonUseCounter = new JCheckBox(Messages.getString((String)"config.dialog.button.counter"));
        this.buttonUseCounter.setToolTipText(Messages.getString((String)"config.dialog.button.counter.tooltip"));
        this.buttonUseCounter.addActionListener(e -> this.spinner.setEnabled(this.buttonUseCounter.isSelected()));
        JLabel percentTitleLabel = new JLabel(Messages.getString((String)"config.dialog.button.percent.label"));
        percentTitleLabel.setFocusable(true);
        percentTitleLabel.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)percentTitleLabel));
        SpinnerNumberModel model = new SpinnerNumberModel(50, 0, 100, 1);
        this.spinner = new JSpinner(model);
        this.spinner.setEnabled(false);
        this.spinner.setToolTipText(Messages.getString((String)"config.dialog.button.percent.tooltip"));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.spinner, "##0");
        this.spinner.setEditor(editor);
        JLabel description = new JLabel(Messages.getString((String)"config.dialog.button.counter.text"));
        description.setFocusable(true);
        description.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)description));
        visualisationPanel.add((Component)description, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 18, 0, new Insets(5, 20, 5, 5), 0, 0));
        JPanel buttonUseCounterPanel = ComponentUtils.layoutCheckbox((JCheckBox)this.buttonUseCounter);
        visualisationPanel.add((Component)buttonUseCounterPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 18, 0, new Insets(5, 15, 5, 5), 0, 0));
        visualisationPanel.add((Component)percentTitleLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 20, 10, 5), 0, 0));
        visualisationPanel.add((Component)this.spinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 10, 5), 0, 0));
        return visualisationPanel;
    }

    protected JComponent initDeleteSourceGUI() {
        double[] colWeights = new double[]{1.0};
        GridBagPanel result = new GridBagPanel(colWeights);
        result.setBorder((Border)ComponentUtils.createTitledCurvedBorder((String)DELETE_SOURCE_COMPONENT_KEY));
        JLabel description = new JLabel(Messages.getString((String)"config.dialog.delete_source.label"));
        description.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)description));
        description.setFocusable(true);
        this.useDeleteSource = new JCheckBox(" " + Messages.getString((String)"config.dialog.delete_source.title"));
        JPanel useDeleteSourceCheckBoxPanel = ComponentUtils.layoutCheckbox((JCheckBox)this.useDeleteSource);
        result.addComponent((Container)result, (Component)description, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 20, 10, 5), 0, 0));
        result.addComponent((Container)result, (Component)useDeleteSourceCheckBoxPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 10, 5), 0, 0));
        return result;
    }

    public JComponent getView() {
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.content, "North");
        return result;
    }

    public void setCounter(int count) {
        this.spinner.setValue(count);
    }

    public int getCounter() {
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException pe) {
            JComponent editor = this.spinner.getEditor();
            if (editor instanceof JSpinner.DefaultEditor) {
                JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
                defaultEditor.getTextField().setValue(this.spinner.getValue());
            }
            this.spinner.setValue(0);
        }
        return (Integer)this.spinner.getValue();
    }

    public void setUseCounter(boolean useCounter) {
        this.spinner.setEnabled(useCounter);
        this.buttonUseCounter.setSelected(useCounter);
    }

    public boolean getUseCounter() {
        return this.buttonUseCounter.isSelected();
    }

    public String getHelpContext() {
        return Messages.getResource((String)"config.dialog.visualization.helpcontext");
    }

    public Icon getIcon() {
        return ComponentUtils.getIcon((String)"action.sign");
    }

    public String getTitle() {
        return Messages.getString((String)"config.dialog.visualization");
    }

    public void load() {
        log.trace("load Einstellungen/{} : SignConfig -> GUI ...", (Object)this.getTitle());
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        this.setCounter(signConfig.getPercentOfViewed());
        this.setUseCounter(signConfig.isUseViewFile());
        this.setUseDeleteSource(signConfig.useDeleteSource());
    }

    public void save() {
        log.trace("save Einstellungen/{} : GUI -> SignConfig ...", (Object)this.getTitle());
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        signConfig.setPercentOfViewed(this.getCounter());
        signConfig.setUseViewFile(this.getUseCounter());
        signConfig.useDeleteSource(this.getUseDeleteSource());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.storeValues();
        this.content.removeAll();
        this.initGUI();
        this.restoreValues();
        this.content.revalidate();
    }

    protected void storeValues() {
        this.tempCounter = this.getCounter();
        this.tempUseCounter = this.getUseCounter();
    }

    protected void restoreValues() {
        this.setCounter(this.tempCounter);
        this.setUseCounter(this.tempUseCounter);
    }

    public LicenceTyp getLicenceTyp() {
        return this.visualisationLicenceTyp;
    }

    public void setLicenceTyp(LicenceTyp newVisualisationLicenceTyp) {
        this.visualisationLicenceTyp = newVisualisationLicenceTyp;
    }

    public void setUseDeleteSource(boolean newUseDeleteSource) {
        this.useDeleteSource.setSelected(newUseDeleteSource);
    }

    public boolean getUseDeleteSource() {
        return this.useDeleteSource.isSelected();
    }
}

