/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.action.SelectedFileHandler;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.gui.MultiLineTooltips;
import de.bos_bremen.ecard.client.gui.SignerTheme;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.GridBagPanel;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.gui.view.component.buttons.AccessibleRadioButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.IconButton;
import de.bos_bremen.ecard.client.gui.view.component.buttons.TitledCurvedBorder;
import de.bos_bremen.ecard.client.gui.view.component.textfields.MaximumLengthTextField;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.imagedisplay.ImageComponent;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.PdfInfoSelector;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.CentimeterTextField;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.FontColorComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.FontFamilyComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.FontFormatComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.FontSizeComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFDateFormatComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFImageLayoutComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFOnPageComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFStdImage;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFStdImageComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFUserImage;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFVisualisationTyp;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFVisualisationTypComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFVisualisationTypEnum;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.TextImageRelationComboBox;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.positionselector.PositionSelector;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplatePopupMenu;
import de.governikus.csl.pdf.sign.PDFSignatureInfo;
import de.governikus.csl.pdf.sign.TextColor;
import de.governikus.csl.pdf.sign.TextFormatting;
import de.governikus.csl.pdf.sign.VisibleSignatureLayout;
import de.governikus.csl.pdf.sign.impl.visual.FontEnum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VisualPDFPanel
extends ProcessConfigComponent
implements SelectedFileHandler,
ItemListener {
    private static final Logger LOG = LogManager.getLogger(VisualPDFPanel.class);
    private static final String PDF_IMAGEFILE_CERT = "/resources/certificate_128.png";
    private static final String PDF_IMAGEFILE_BALLPEN = "/resources/ballpen_128.png";
    private final ProcessI process;
    private JPanel content;
    private AccessibleRadioButton useIssuerFromCertificate;
    private AccessibleRadioButton useIssuerName;
    private MaximumLengthTextField issuerTextField;
    private JCheckBox buttonUseDate;
    private PDFDateFormatComboBox dateFormatComboBox;
    private IconButton pdfInfoSequenceButton;
    private FontFamilyComboBox fontFamilyComboBox;
    private FontColorComboBox fontColorComboBox;
    private FontSizeComboBox fontSizeComboBox;
    private FontFormatComboBox fontFormatComboBox;
    private PDFVisualisationTypComboBox visualisationTypComboBox;
    private PDFImageLayoutComboBox imageLayoutComboBox;
    private JCheckBox createSignaturefield;
    private PDFOnPageComboBox onPageComboBox;
    private IconButton chooseImageButton;
    private PDFStdImageComboBox stdImageComboBox;
    private ImageComponent imageDisplay;
    private AccessibleRadioButton stdImage;
    private AccessibleRadioButton userImage;
    private PositionSelector positionSelector;
    private PDFUserImage ownImage;
    private JCheckBox useAutoFontSize;
    private JCheckBox pdfACompatibility;
    private CentimeterTextField visualisationHeight;
    private CentimeterTextField visualisationWidth;
    private TextImageRelationComboBox textImageRelation;
    private LicenceTyp licenceTyp = null;
    private boolean tempUseIssuesFromCertificate;
    private String tempIssuerText;
    private boolean tempUseDate;
    private String tempDateFormat;
    private PDFVisualisationTypEnum tempVisualisationTyp;
    private VisibleSignatureLayout tempVisibleSignatureLayout;
    private int tempOnPageIndex;
    private double tempVisualisationHeight;
    private double tempVisualisationWidth;
    private Double tempPositionX;
    private Double tempPositionY;
    private double tempImageRatio;
    private FontEnum tempFontFamily;
    private int tempFontSize;
    private boolean tempUseAutoFont;
    private TextColor tempTextColor;
    private TextFormatting tempTextFormatting;
    private String tempImageURI;
    private boolean tempVisibleSignatureField;
    private boolean tempInvisibleSignatureField;
    private boolean tempCreateSignatureField;
    private String lastFolderName = System.getProperty("user.home");
    private AccessibleRadioButton visibleSignatureField;
    private AccessibleRadioButton invisibleSignatureField;
    private final Insets insets = new Insets(5, 5, 0, 5);
    private final Insets insetsBottom = new Insets(5, 5, 5, 5);
    private List<PDFSignatureInfo> pdfSignatureInfo;

    public VisualPDFPanel(ProcessI process, LicenceTyp licenceTyp) {
        this.process = process;
        this.licenceTyp = licenceTyp;
        this.ownImage = new PDFUserImage();
        this.initContent();
        this.initGUI();
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)((Object)this));
    }

    private void initContent() {
        this.content = new JPanel(new BorderLayout());
    }

    private void initGUI() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this.getSignatureFieldDecisionPanel(), "North");
        contentPanel.add((Component)this.initVisualisation(), "Center");
        JScrollPane scrollPane = GUIUtils.createScrollPaneFor((JPanel)contentPanel);
        this.content.add((Component)scrollPane, "Center");
    }

    private JPanel getExtensionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel = ComponentUtils.setTitledFocusableBorder((JPanel)panel, (String)Messages.getString((String)"config.dialog.visualpdf.informations.title"));
        JLabel issuerLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.informations.issuer"));
        issuerLabel.setHorizontalAlignment(11);
        this.useIssuerFromCertificate = new AccessibleRadioButton(Messages.getString((String)"config.dialog.visualpdf.informations.issuer.fromcertificate"));
        this.useIssuerFromCertificate.getAccessibleContext().setAccessibleName(Messages.getString((String)"config.dialog.visualpdf.informations.issuer.fromcertificate.accessname"));
        this.useIssuerName = new AccessibleRadioButton(Messages.getString((String)"config.dialog.visualpdf.informations.issuer.name"));
        String accessname = Messages.getString((String)"config.dialog.visualpdf.informations.issuer.name.accessname");
        this.useIssuerName.getAccessibleContext().setAccessibleName(accessname);
        this.useIssuerName.setToolTipText(Messages.getString((String)"config.dialog.visualpdf.informations.issuer.name.tooltip"));
        this.issuerTextField = new MaximumLengthTextField(50);
        this.issuerTextField.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.issuerTextField));
        this.issuerTextField.setToolTipText(accessname);
        this.useIssuerFromCertificate.addActionListener(e -> this.issuerTextField.setEnabled(this.useIssuerName.isSelected()));
        this.useIssuerName.addActionListener(e -> this.issuerTextField.setEnabled(this.useIssuerName.isSelected()));
        ButtonGroup whichIssuer = new ButtonGroup();
        whichIssuer.add((AbstractButton)this.useIssuerFromCertificate);
        whichIssuer.add((AbstractButton)this.useIssuerName);
        this.buttonUseDate = new JCheckBox(Messages.getString((String)"config.dialog.visualpdf.informations.date") + " ");
        this.buttonUseDate.setHorizontalTextPosition(2);
        this.buttonUseDate.addActionListener(e -> this.dateFormatComboBox.setEnabled(this.buttonUseDate.isSelected()));
        JPanel buttonUseDatePanel = ComponentUtils.layoutCheckbox((JCheckBox)this.buttonUseDate);
        JLabel dateFormatLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.informations.dateformat"));
        dateFormatLabel.setHorizontalAlignment(11);
        dateFormatLabel.setLabelFor(this.dateFormatComboBox);
        this.dateFormatComboBox = new PDFDateFormatComboBox();
        this.dateFormatComboBox.setEnabled(this.buttonUseDate.isSelected());
        JPanel row3 = new JPanel(new GridBagLayout());
        row3.add((Component)buttonUseDatePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 15), 0, 0));
        row3.add((Component)dateFormatLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 5, 0, 5), 0, 0));
        row3.add((Component)this.dateFormatComboBox, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 5), 0, 0));
        int columnX = 0;
        int rowY = 0;
        panel.add((Component)issuerLabel, new GridBagConstraints(columnX, rowY, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 5, 0, 5), 0, 0));
        panel.add((Component)this.useIssuerFromCertificate, new GridBagConstraints(++columnX, rowY, 2, 1, 0.0, 0.0, 18, 2, this.insets, 0, 0));
        panel.add((Component)this.useIssuerName, new GridBagConstraints(columnX, ++rowY, 1, 1, 0.0, 0.0, 18, 0, this.insets, 0, 0));
        panel.add((Component)this.issuerTextField, new GridBagConstraints(++columnX, rowY, 2, 1, 0.0, 0.0, 18, 2, this.insets, 0, 0));
        columnX = 0;
        panel.add((Component)row3, new GridBagConstraints(columnX, ++rowY, 4, 1, 0.0, 0.0, 21, 2, this.insets, 0, 0));
        columnX = 4;
        rowY = 1;
        panel.add((Component)this.getSequencePanel(), new GridBagConstraints(columnX, rowY, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 60, 0, 5), 0, 0));
        return panel;
    }

    private GridBagPanel initVisualisation() {
        GridBagPanel panel = new GridBagPanel();
        TitledCurvedBorder border = ComponentUtils.createTitledCurvedBorder((String)"visualpdf.visualisation");
        panel.setBorder((Border)border);
        panel.setFocusable(true);
        panel.addComponentWholeNextRow((Container)panel, (Component)this.getVisualisationPanel());
        return panel;
    }

    private JPanel getVisualisationPanel() {
        GridBagPanel panel = new GridBagPanel();
        panel.addComponentWholeNextRow((Container)panel, (Component)this.getExtensionsPanel(), new Insets(2, 20, 0, 5));
        panel.addComponentWholeNextRow((Container)panel, (Component)this.getSignatureFieldPanel(), new Insets(2, 20, 0, 5));
        panel.addComponentWholeNextRow((Container)panel, (Component)this.createViuaslisationFontGraphic(), new Insets(2, 20, 0, 5));
        return panel;
    }

    private JPanel getSignatureFieldDecisionPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel = ComponentUtils.setTitledFocusableBorder((JPanel)panel, (String)Messages.getString((String)"config.dialog.visualpdf.visualisation.signaturefield.decision"));
        panel.add((Component)this.createVisualisationTop001(), "West");
        return panel;
    }

    private JPanel getTemplatePanel() {
        String key = "config.dialog.visualpdf.visualisation.template";
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2, 0, 0));
        Icon icon = ComponentUtils.getIcon((String)key);
        IconButton button = new IconButton();
        button.setIcon(icon);
        button.setText(Messages.getString((String)key));
        button.setToolTipText(MultiLineTooltips.wrapToolTip((String)Messages.getString((String)"config.dialog.visualpdf.visualisation.template.tooltip")));
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        SignatureFieldTemplatePopupMenu popup = new SignatureFieldTemplatePopupMenu(this, (JComponent)button, signConfig);
        button.addActionListener((ActionListener)popup);
        panel.add((Component)button);
        panel.repaint();
        return panel;
    }

    private JPanel getSequencePanel() {
        String key = "config.dialog.visualpdf.pdf.signature.info.sequence";
        this.pdfInfoSequenceButton = new IconButton();
        this.pdfInfoSequenceButton.addActionListener(actionEvent -> this.createSequenceDialog());
        this.pdfInfoSequenceButton.setIcon(ComponentUtils.getIcon((String)key));
        this.pdfInfoSequenceButton.setText(Messages.getString((String)key));
        this.pdfInfoSequenceButton.setToolTipText(MultiLineTooltips.wrapToolTip((String)Messages.getString((String)"config.dialog.visualpdf.pdf.signature.info.sequence.tooltip")));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2, 0, 0));
        panel.add((Component)this.pdfInfoSequenceButton);
        return panel;
    }

    private void createSequenceDialog() {
        PdfInfoSelector pdfInfoSelector = new PdfInfoSelector(this.pdfSignatureInfo);
        int decision = PdfInfoSelector.showDialog(pdfInfoSelector.getContainerPanel());
        this.pdfSignatureInfo = pdfInfoSelector.getOrder(decision);
    }

    private JPanel createVisualisationTop001() {
        GridBagPanel panel = new GridBagPanel();
        this.visibleSignatureField = new AccessibleRadioButton(Messages.getString((String)"config.dialog.visualpdf.pdfsignature.signaturefield.visible"));
        this.visibleSignatureField.addActionListener(e -> {
            this.pdfInfoSequenceButton.setEnabled(this.visibleSignatureField.isSelected());
            if (this.visibleSignatureField.isSelected()) {
                this.visualisationTypComboBox.setTyp(PDFVisualisationTypEnum.TEXT);
                this.visualisationTypComboBox.setEnabled(true);
            }
            this.enableComponents(((PDFVisualisationTyp)this.visualisationTypComboBox.getSelectedItem()).getTyp());
        });
        this.invisibleSignatureField = new AccessibleRadioButton(Messages.getString((String)"config.dialog.visualpdf.pdfsignature.signaturefield.invisible"));
        this.invisibleSignatureField.addActionListener(e -> {
            this.pdfInfoSequenceButton.setEnabled(!this.invisibleSignatureField.isSelected());
            if (this.invisibleSignatureField.isSelected()) {
                this.visualisationTypComboBox.setTyp(PDFVisualisationTypEnum.NONE);
                this.visualisationTypComboBox.setEnabled(false);
            }
            this.enableComponents(((PDFVisualisationTyp)this.visualisationTypComboBox.getSelectedItem()).getTyp());
        });
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.invisibleSignatureField);
        group.add((AbstractButton)this.visibleSignatureField);
        Insets insetsLeftRight = new Insets(5, 20, 0, 40);
        panel.addComponent((Container)panel, (Component)this.invisibleSignatureField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insetsLeftRight, 0, 0));
        panel.addComponent((Container)panel, (Component)this.visibleSignatureField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insetsLeftRight, 0, 0));
        this.visualisationTypComboBox = new PDFVisualisationTypComboBox();
        this.visualisationTypComboBox.addItemListener(this);
        this.imageLayoutComboBox = new PDFImageLayoutComboBox();
        JLabel typLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.typ"));
        typLabel.setLabelFor(this.visualisationTypComboBox);
        typLabel.setHorizontalAlignment(11);
        JLabel layoutLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.imagelayout"));
        layoutLabel.setLabelFor(this.imageLayoutComboBox);
        layoutLabel.setHorizontalAlignment(11);
        int colWidth = (int)layoutLabel.getPreferredSize().getWidth();
        this.setColDimension(layoutLabel, colWidth);
        this.textImageRelation = new TextImageRelationComboBox();
        this.textImageRelation.setToolTipText(MultiLineTooltips.wrapToolTip((String)Messages.getString((String)"config.dialog.visualpdf.visualisation.position.relation.tooltip")));
        JLabel relationLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.position.relation"));
        relationLabel.setHorizontalAlignment(11);
        relationLabel.setLabelFor(this.textImageRelation);
        Insets insetsLeft = new Insets(5, 20, 0, 5);
        panel.addComponent((Container)panel, (Component)typLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, insetsLeft, 0, 0));
        panel.addComponent((Container)panel, (Component)layoutLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, insetsLeft, 0, 0));
        panel.addComponent((Container)panel, (Component)relationLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 2, insetsLeft, 0, 0));
        panel.addComponent((Container)panel, (Component)this.visualisationTypComboBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.imageLayoutComboBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.textImageRelation, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.getTemplatePanel(), new GridBagConstraints(4, 1, 1, 3, 0.0, 1.0, 10, 1, new Insets(0, 60, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getSignatureFieldPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel = ComponentUtils.setTitledFocusableBorder((JPanel)panel, (String)Messages.getString((String)"config.dialog.visualpdf.visualisation.signaturefield.title"));
        this.createSignaturefield = new JCheckBox(" " + Messages.getString((String)"config.dialog.visualpdf.visualisation.signaturefield.create"));
        this.createSignaturefield.addActionListener(e -> this.enableComponents(((PDFVisualisationTyp)this.visualisationTypComboBox.getSelectedItem()).getTyp()));
        JPanel createSignaturefieldPanel = ComponentUtils.layoutCheckbox((JCheckBox)this.createSignaturefield);
        int row = 0;
        int column = 0;
        panel.add((Component)createSignaturefieldPanel, new GridBagConstraints(column, row, 2, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.createVisualisationPage(), new GridBagConstraints(column, ++row, 1, 1, 1.0, 1.0, 11, 0, new Insets(0, 40, 0, 0), 0, 0));
        panel.add((Component)this.createVisualisationHeightWidth(), new GridBagConstraints(++column, row, 1, 1, 1.0, 1.0, 12, 2, new Insets(5, 0, 0, 0), 0, 0));
        JLabel positionLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.position"));
        panel.add((Component)positionLabel, new GridBagConstraints(++column, row, 1, 1, 1.0, 1.0, 12, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.createPositionSelector(), new GridBagConstraints(++column, 0, 1, 2, 1.0, 1.0, 16, 3, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createVisualisationPage() {
        GridBagPanel panel = new GridBagPanel();
        this.onPageComboBox = new PDFOnPageComboBox();
        JLabel onpageLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.onpage"));
        onpageLabel.setLabelFor(this.onPageComboBox);
        onpageLabel.setHorizontalAlignment(11);
        panel.addComponent((Container)panel, (Component)onpageLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.addComponent((Container)panel, (Component)this.onPageComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createVisualisationHeightWidth() {
        GridBagPanel panel = new GridBagPanel();
        Font font = (Font)UIManager.get("Label.font");
        this.visualisationHeight = new CentimeterTextField(1.0, 99.9);
        this.visualisationHeight.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.visualisationHeight));
        this.visualisationHeight.setFont(font);
        this.visualisationHeight.setColumns(4);
        this.visualisationHeight.addFocusListener(new VisualisationFrameChangeListener());
        JLabel heightLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.position.height"));
        heightLabel.setHorizontalAlignment(11);
        heightLabel.setLabelFor(this.visualisationHeight);
        this.visualisationWidth = new CentimeterTextField(1.0, 99.9);
        this.visualisationWidth.setFont(font);
        this.visualisationWidth.setColumns(4);
        this.visualisationWidth.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.visualisationWidth));
        this.visualisationWidth.addFocusListener(new VisualisationFrameChangeListener());
        JLabel widthLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.position.width"));
        widthLabel.setHorizontalAlignment(11);
        widthLabel.setLabelFor(this.visualisationWidth);
        panel.addComponent((Container)panel, (Component)heightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 10, 0, 5), 0, 0));
        panel.addComponent((Container)panel, (Component)this.visualisationHeight, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.addComponent((Container)panel, (Component)widthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.addComponent((Container)panel, (Component)this.visualisationWidth, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 10), 0, 0));
        return panel;
    }

    private GridBagPanel createPositionSelector() {
        double[] colWeights = new double[]{1.0};
        GridBagPanel panel = new GridBagPanel(colWeights);
        this.positionSelector = new PositionSelector(102, 142);
        this.positionSelector.setGridColumns(10);
        this.positionSelector.setGridRows(14);
        this.positionSelector.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.positionSelector.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                VisualPDFPanel.this.positionSelector.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            }

            @Override
            public void focusGained(FocusEvent e) {
                VisualPDFPanel.this.positionSelector.setBorder(SignerTheme.TEXTFIELD_FOCUSED);
            }
        });
        JLabel positionLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.position"));
        positionLabel.setHorizontalAlignment(11);
        positionLabel.setLabelFor(this.positionSelector);
        positionLabel.setToolTipText(Messages.getResource((String)"config.dialog.visualpdf.visualisation.position.tooltip"));
        positionLabel.setDisplayedMnemonic("P".charAt(0));
        panel.addComponent((Container)panel, (Component)this.positionSelector, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createViuaslisationFontGraphic() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(this.createVisualisationFont());
        panel.add(this.createVisualisationGraphic());
        return panel;
    }

    private JPanel createVisualisationFont() {
        double[] colWeights = new double[]{0.1, 0.1};
        GridBagPanel panel = new GridBagPanel(colWeights);
        TitledCurvedBorder border = new TitledCurvedBorder(Messages.getString((String)"config.dialog.visualpdf.visualisation.font.title"));
        panel.setBorder((Border)border);
        panel.setFocusable(true);
        String useAutoFontSizeLabel = Messages.getString((String)"config.dialog.visualpdf.visualisation.fontsize.autoresize");
        this.useAutoFontSize = new JCheckBox(useAutoFontSizeLabel);
        int colWidth = (int)this.useAutoFontSize.getPreferredSize().getWidth();
        this.setColDimension(this.useAutoFontSize, colWidth);
        JPanel useAutoFontSizePanel = ComponentUtils.layoutCheckbox((JCheckBox)this.useAutoFontSize);
        this.pdfACompatibility = new JCheckBox("");
        this.pdfACompatibility.getAccessibleContext().setAccessibleName(Messages.getString((String)"config.dialog.visualpdf.visualisation.pdfacompatibility.label"));
        this.pdfACompatibility.addActionListener(e -> {
            Object patt32132$temp = this.visualisationTypComboBox.getSelectedItem();
            if (patt32132$temp instanceof PDFVisualisationTyp) {
                PDFVisualisationTyp pDFVisualisationTyp = (PDFVisualisationTyp)patt32132$temp;
                this.enableComponents(pDFVisualisationTyp.getTyp());
            }
        });
        JPanel pdfACompatibilityPanel = ComponentUtils.layoutCheckbox((JCheckBox)this.pdfACompatibility);
        this.fontColorComboBox = new FontColorComboBox();
        this.setColDimension(this.fontColorComboBox, colWidth);
        this.fontFamilyComboBox = new FontFamilyComboBox();
        this.setColDimension(this.fontFamilyComboBox, colWidth);
        this.fontFormatComboBox = new FontFormatComboBox();
        this.setColDimension(this.fontFormatComboBox, colWidth);
        this.fontSizeComboBox = new FontSizeComboBox();
        this.setColDimension(this.fontSizeComboBox, colWidth);
        JLabel pdfACompatibilityLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.pdfacompatibility.label"));
        pdfACompatibilityLabel.setHorizontalAlignment(11);
        this.setColDimension(pdfACompatibilityLabel, pdfACompatibilityLabel.getPreferredSize().width);
        JLabel fontFamilyLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.fontfamily"));
        fontFamilyLabel.setHorizontalAlignment(11);
        fontFamilyLabel.setLabelFor(this.fontFamilyComboBox);
        JLabel fontColorLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.fontcolor"));
        fontColorLabel.setHorizontalAlignment(11);
        fontColorLabel.setLabelFor(this.fontColorComboBox);
        JLabel fontSizeLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.fontsize"));
        fontSizeLabel.setHorizontalAlignment(11);
        fontSizeLabel.setLabelFor(this.fontSizeComboBox);
        this.useAutoFontSize.getAccessibleContext().setAccessibleName(fontSizeLabel.getText() + " " + useAutoFontSizeLabel);
        this.useAutoFontSize.setToolTipText(MultiLineTooltips.wrapToolTip((String)Messages.getString((String)"config.dialog.visualpdf.visualisation.fontsize.autoresize.tooltip")));
        JLabel fontFormatLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.fontformat"));
        fontFormatLabel.setHorizontalAlignment(11);
        fontFormatLabel.setLabelFor(this.fontFormatComboBox);
        int gridy = 0;
        panel.addComponent((Container)panel, (Component)pdfACompatibilityLabel, new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)pdfACompatibilityPanel, new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)fontFamilyLabel, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.fontFamilyComboBox, new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)fontColorLabel, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.fontColorComboBox, new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)fontSizeLabel, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.fontSizeComboBox, new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)useAutoFontSizePanel, new GridBagConstraints(1, ++gridy, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)fontFormatLabel, new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 13, 0, this.insetsBottom, 0, 0));
        panel.addComponent((Container)panel, (Component)this.fontFormatComboBox, new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 17, 0, this.insetsBottom, 0, 0));
        return panel;
    }

    private JPanel createVisualisationGraphic() {
        GridBagPanel panel = new GridBagPanel();
        TitledCurvedBorder border = new TitledCurvedBorder(Messages.getString((String)"config.dialog.visualpdf.visualisation.image.title"));
        panel.setBorder((Border)border);
        panel.setFocusable(true);
        panel.setToolTipText(MultiLineTooltips.wrapToolTip((String)Messages.getString((String)"config.dialog.visualpdf.visualisation.image.tooltip")));
        JLabel previewLabel = new JLabel(Messages.getString((String)"config.dialog.visualpdf.visualisation.preview"));
        previewLabel.setHorizontalAlignment(11);
        previewLabel.setFocusable(true);
        previewLabel.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)previewLabel));
        this.imageDisplay = new ImageComponent((PDFVisualisationTyp)this.visualisationTypComboBox.getSelectedItem());
        this.imageDisplay.setBgColor(panel.getBackground());
        previewLabel.setLabelFor(this.imageDisplay);
        panel.addComponent((Container)panel, (Component)this.createWhichImageButtonGroup(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 11, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)previewLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.imageDisplay, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0));
        return panel;
    }

    private JPanel createWhichImageButtonGroup() {
        WhichImageActionListener whichImageActionListener = new WhichImageActionListener();
        this.stdImage = new AccessibleRadioButton("");
        this.stdImage.addActionListener((ActionListener)whichImageActionListener);
        this.stdImage.getAccessibleContext().setAccessibleName(Messages.getString((String)"config.dialog.visualpdf.visualisation.stdimage.accessname"));
        this.stdImageComboBox = new PDFStdImageComboBox();
        this.stdImageComboBox.setToolTipText(Messages.getString((String)"config.dialog.visualpdf.visualisation.stdimage.tooltip"));
        this.stdImageComboBox.addActionListener(new StdImageSelectorActionListener());
        this.userImage = new AccessibleRadioButton("");
        this.userImage.addActionListener((ActionListener)whichImageActionListener);
        this.userImage.getAccessibleContext().setAccessibleName(Messages.getString((String)"config.dialog.visualpdf.visualisation.userimage.accessname"));
        this.userImage.setToolTipText(MultiLineTooltips.wrapToolTip((String)Messages.getString((String)"config.dialog.visualpdf.visualisation.userimage.tooltip")));
        this.chooseImageButton = new IconButton();
        this.chooseImageButton.setAction(Document.getInstance().getActionFactory().createLoadPDFSignatureImageAction((SelectedFileHandler)this));
        double[] colWeights = new double[]{0.0, 0.1};
        GridBagPanel panel = new GridBagPanel(colWeights);
        panel.addComponent((Container)panel, (Component)this.stdImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.stdImageComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.userImage, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insets, 0, 0));
        panel.addComponent((Container)panel, (Component)this.chooseImageButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, this.insets, 0, 0));
        ButtonGroup whichImageButtonGroup = new ButtonGroup();
        whichImageButtonGroup.add((AbstractButton)this.stdImage);
        whichImageButtonGroup.add((AbstractButton)this.userImage);
        this.stdImage.setSelected(true);
        whichImageButtonGroup.setSelected(this.stdImage.getModel(), true);
        return panel;
    }

    public String getHelpContext() {
        return Messages.getResource((String)"config.dialog.visualpdf.helpcontext");
    }

    public Icon getIcon() {
        return ComponentUtils.getIcon((String)"config.dialog.visualpdf");
    }

    public String getTitle() {
        return Messages.getString((String)"config.dialog.visualpdf");
    }

    public void load() {
        LOG.trace("load Einstellungen/{} : SignConfig -> GUI ...", (Object)this.getTitle());
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        this.visibleSignatureField.setSelected(signConfig.visibleSignatureField());
        this.invisibleSignatureField.setSelected(!signConfig.visibleSignatureField());
        this.useIssuerFromCertificate.setSelected(signConfig.useSignatureIssuer());
        this.useIssuerName.setSelected(!signConfig.useSignatureIssuer());
        this.issuerTextField.setText(signConfig.getPdfSignatureExtentionSignatureIssuer());
        this.buttonUseDate.setSelected(signConfig.useDate());
        this.dateFormatComboBox.setDateFormat(signConfig.getPdfSignatureExtentionDateFormat());
        this.visualisationTypComboBox.setTyp(signConfig.getPdfSignatureExtentionVisualisationTyp());
        if (signConfig.getPdfSignatureExtentionVisualisationTyp().equals((Object)PDFVisualisationTypEnum.NONE)) {
            this.invisibleSignatureField.setSelected(true);
            this.visualisationTypComboBox.setEnabled(false);
        }
        this.imageLayoutComboBox.setVisibleSignatureLayout(signConfig.getPdfSignatureExtentionVisibleSignatureLayout());
        this.onPageComboBox.setOnPageIndex(signConfig.getPdfSignatureExtentionPage());
        this.visualisationHeight.setCM(signConfig.getPdfSignatureExtentionVisualHeight());
        this.visualisationWidth.setCM(signConfig.getPdfSignatureExtentionVisualWidth());
        this.positionSelector.setPositionX(signConfig.getPdfSignatureExtentionPositionX());
        this.positionSelector.setPositionY(signConfig.getPdfSignatureExtentionPositionY());
        this.textImageRelation.setImageRatio(signConfig.getPdfSignatureExtentionImageRatio());
        this.positionSelector.setCursorHeightInCentimeter(this.visualisationHeight.getCM());
        this.positionSelector.setCursorWidthInCentimeter(this.visualisationWidth.getCM());
        this.fontFamilyComboBox.setFontEnum(signConfig.getPdfSignatureExtentionFont());
        this.fontSizeComboBox.setFontSize(signConfig.getPdfSignatureExtentionFontSize());
        this.useAutoFontSize.setSelected(signConfig.useDynamicTextSize());
        this.pdfACompatibility.setSelected(signConfig.getPdfSignatureExtentionPdfACompatibility());
        this.fontColorComboBox.setTextColor(signConfig.getPdfSignatureExtentionTextColor());
        this.fontFormatComboBox.setTextFormatting(signConfig.getPdfSignatureExtentionTextFormatting());
        this.createSignaturefield.setSelected(signConfig.createSignatureField());
        this.pdfSignatureInfo = signConfig.getPdfSignatureInfo();
        this.pdfInfoSequenceButton.setEnabled(this.visibleSignatureField.isSelected());
        String imageFilePath = signConfig.getPdfSignatureExtentionImageFile();
        if (imageFilePath != null && !imageFilePath.isEmpty()) {
            try {
                this.setImageURI(new URI(imageFilePath));
            }
            catch (URISyntaxException e) {
                LOG.error("Angabe fuer <imagefile> in Einstellungen ist nicht gueltig: {}", (Object)imageFilePath, (Object)e);
            }
        }
        this.enableComponents(signConfig.getPdfSignatureExtentionVisualisationTyp());
    }

    public void save() {
        LOG.trace("save Einstellungen/{} : GUI -> SignConfig ...", (Object)this.getTitle());
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        signConfig.setUseDynamicPdfSignatureExtention(this.visibleSignatureField.isSelected());
        signConfig.useSignatureIssuer(this.useIssuerFromCertificate.isSelected());
        signConfig.setPdfSignatureExtentionSignatureIssuer(this.issuerTextField.getText());
        signConfig.useDate(this.buttonUseDate.isSelected());
        signConfig.setPdfSignatureExtentionDateFormat(this.dateFormatComboBox.getDateFormat());
        signConfig.setPdfSignatureExtentionVisualisationTyp(this.visualisationTypComboBox.getTyp());
        signConfig.setPdfSignatureExtentionVisibleSignatureLayout(this.imageLayoutComboBox.getVisibleSignatureLayout());
        signConfig.setPdfSignatureExtentionPage(this.onPageComboBox.getOnPageIndex());
        signConfig.setPdfSignatureExtentionVisualHeight(this.visualisationHeight.getCM());
        signConfig.setPdfSignatureExtentionVisualWidth(this.visualisationWidth.getCM());
        signConfig.setPdfSignatureExtentionPositionX(this.positionSelector.getPositionX());
        signConfig.setPdfSignatureExtentionPositionY(this.positionSelector.getPositionY());
        signConfig.setPdfSignatureExtentionImageRatio(this.textImageRelation.getImageRatio());
        signConfig.setPdfSignatureExtentionFont(this.fontFamilyComboBox.getFontEnum());
        signConfig.setPdfSignatureExtentionFontSize(this.fontSizeComboBox.getFontSize());
        signConfig.useDynamicTextSize(this.useAutoFontSize.isSelected());
        signConfig.setPdfSignatureExtentionPdfACompatibility(this.pdfACompatibility.isSelected());
        signConfig.setPdfSignatureExtentionTextColor(this.fontColorComboBox.getTextColor());
        signConfig.setPdfSignatureExtentionTextFormatting(this.fontFormatComboBox.getTextFormatting());
        URI uri = this.getImageURI();
        signConfig.setPdfSignatureExtentionImageFile(uri != null ? uri.toString() : "");
        signConfig.setCreateSignatureField(this.createSignaturefield.isSelected());
        signConfig.setPdfSignatureInfo(this.pdfSignatureInfo);
    }

    public JComponent getView() {
        return this.content;
    }

    public JFrame getJFrame() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.storeValues();
        this.content.removeAll();
        this.initGUI();
        this.restoreValues();
        this.content.revalidate();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.tempVisibleSignatureField = this.visibleSignatureField.isSelected();
        this.tempInvisibleSignatureField = this.invisibleSignatureField.isSelected();
        this.tempUseIssuesFromCertificate = this.useIssuerFromCertificate.isSelected();
        this.tempVisualisationTyp = this.visualisationTypComboBox.getTyp();
        this.tempVisibleSignatureLayout = this.imageLayoutComboBox.getVisibleSignatureLayout();
        this.tempUseAutoFont = this.useAutoFontSize.isSelected();
        properties.setProperty("visualisationTyp", this.visualisationTypComboBox.getTyp().name());
        properties.setProperty("visibleSignatureLayout", this.imageLayoutComboBox.getVisibleSignatureLayout().name());
        properties.setProperty("useDynamicPdfSignature", "" + this.visibleSignatureField.isSelected());
        properties.setProperty("useSignatureIssuer", "" + this.useIssuerFromCertificate.isSelected());
        properties.setProperty("imageRatio", "" + this.textImageRelation.getImageRatio());
        properties.setProperty("page", "" + this.onPageComboBox.getOnPageIndex());
        properties.setProperty("textFormatting", this.fontFormatComboBox.getTextFormatting().name());
        properties.setProperty("signatureIssuer", this.issuerTextField.getText());
        properties.setProperty("textFont", this.fontFamilyComboBox.getFontEnum().name());
        properties.setProperty("visualHeight", "" + this.visualisationHeight.getCM());
        properties.setProperty("visualWidth", "" + this.visualisationWidth.getCM());
        properties.setProperty("useDynamicTextSize", "" + this.useAutoFontSize.isSelected());
        properties.setProperty("positionY", "" + this.positionSelector.getPositionY());
        properties.setProperty("positionX", "" + this.positionSelector.getPositionX());
        properties.setProperty("useDate", "" + this.buttonUseDate.isSelected());
        properties.setProperty("dateFormat", this.dateFormatComboBox.getDateFormat());
        properties.setProperty("pdfACompatibility", "" + this.pdfACompatibility.isSelected());
        properties.setProperty("textSize", "" + this.fontSizeComboBox.getFontSize());
        properties.setProperty("textColor", this.fontColorComboBox.getTextColor().name());
        URI uri = this.getImageURI();
        properties.setProperty("imagefile", uri != null ? uri.toString() : "");
        properties.setProperty("createSignatureField", "" + this.createSignaturefield.isSelected());
        return properties;
    }

    private void storeValues() {
        this.tempVisibleSignatureField = this.visibleSignatureField.isSelected();
        this.tempInvisibleSignatureField = this.invisibleSignatureField.isSelected();
        this.tempUseIssuesFromCertificate = this.useIssuerFromCertificate.isSelected();
        this.tempIssuerText = this.issuerTextField.getText();
        this.tempUseDate = this.buttonUseDate.isSelected();
        this.tempDateFormat = this.dateFormatComboBox.getDateFormat();
        this.tempVisualisationTyp = this.visualisationTypComboBox.getTyp();
        this.tempVisibleSignatureLayout = this.imageLayoutComboBox.getVisibleSignatureLayout();
        this.tempOnPageIndex = this.onPageComboBox.getOnPageIndex();
        this.tempVisualisationHeight = this.visualisationHeight.getCM();
        this.tempVisualisationWidth = this.visualisationWidth.getCM();
        this.tempPositionX = this.positionSelector.getPositionX();
        this.tempPositionY = this.positionSelector.getPositionY();
        this.tempImageRatio = this.textImageRelation.getImageRatio();
        this.tempFontFamily = this.fontFamilyComboBox.getFontEnum();
        this.tempFontSize = this.fontSizeComboBox.getFontSize();
        this.tempUseAutoFont = this.useAutoFontSize.isSelected();
        this.tempTextColor = this.fontColorComboBox.getTextColor();
        this.tempTextFormatting = this.fontFormatComboBox.getTextFormatting();
        URI uri = this.getImageURI();
        this.tempImageURI = uri != null ? uri.toString() : "";
        this.tempCreateSignatureField = this.createSignaturefield.isSelected();
    }

    private void restoreValues() {
        this.visibleSignatureField.setSelected(this.tempVisibleSignatureField);
        this.invisibleSignatureField.setSelected(this.tempInvisibleSignatureField);
        this.useIssuerFromCertificate.setSelected(this.tempUseIssuesFromCertificate);
        this.useIssuerName.setSelected(!this.tempUseIssuesFromCertificate);
        this.issuerTextField.setText(this.tempIssuerText);
        this.buttonUseDate.setSelected(this.tempUseDate);
        this.dateFormatComboBox.setDateFormat(this.tempDateFormat);
        this.visualisationTypComboBox.setTyp(this.tempVisualisationTyp);
        this.imageLayoutComboBox.setVisibleSignatureLayout(this.tempVisibleSignatureLayout);
        this.onPageComboBox.setOnPageIndex(this.tempOnPageIndex);
        this.visualisationHeight.setCM(this.tempVisualisationHeight);
        this.visualisationWidth.setCM(this.tempVisualisationWidth);
        this.positionSelector.setPositionX(this.tempPositionX);
        this.positionSelector.setPositionY(this.tempPositionY);
        this.textImageRelation.setImageRatio(this.tempImageRatio);
        this.positionSelector.setCursorHeightInCentimeter(this.visualisationHeight.getCM());
        this.positionSelector.setCursorWidthInCentimeter(this.visualisationWidth.getCM());
        this.fontFamilyComboBox.setFontEnum(this.tempFontFamily);
        this.fontSizeComboBox.setFontSize(this.tempFontSize);
        this.useAutoFontSize.setSelected(this.tempUseAutoFont);
        this.fontColorComboBox.setTextColor(this.tempTextColor);
        this.fontFormatComboBox.setTextFormatting(this.tempTextFormatting);
        this.createSignaturefield.setSelected(this.tempCreateSignatureField);
        String imageFilePath = this.tempImageURI;
        if (imageFilePath != null && !imageFilePath.isEmpty()) {
            try {
                this.setImageURI(new URI(this.tempImageURI));
            }
            catch (URISyntaxException e) {
                LOG.error("<imagefile> in Einstellungen ist nicht gueltig: {}", (Object)imageFilePath, (Object)e);
            }
        }
    }

    public File getLastFolder() {
        return new File(this.lastFolderName);
    }

    public void setFileToLoad(File selectedFile) {
        if (selectedFile == null) {
            LOG.error("File wird erwartet: {}", (Object)selectedFile);
            return;
        }
        this.lastFolderName = selectedFile.getParent();
        if (selectedFile.toString().contains("http") && !selectedFile.toString().startsWith("jar:")) {
            String uriString = selectedFile.toString().substring(selectedFile.toString().indexOf("http"));
            uriString = uriString.replace(new StringBuilder("http:/"), new StringBuilder("http://"));
            try {
                URI fileURL = new URI(uriString);
                this.ownImage.setUri(fileURL);
            }
            catch (URISyntaxException e) {
                LOG.error("", (Throwable)e);
            }
        } else {
            this.ownImage.setImageFile(selectedFile);
        }
        this.imageDisplay.setImage(this.ownImage.getImage(), this.ownImage.getUri().toString());
    }

    public void setFilesToLoad(File[] arg0) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e == null) {
            return;
        }
        Object object = e.getSource();
        if (!(object instanceof PDFVisualisationTypComboBox)) {
            return;
        }
        PDFVisualisationTypComboBox cb = (PDFVisualisationTypComboBox)object;
        if (e.getStateChange() != 1) {
            return;
        }
        PDFVisualisationTyp vTyp = (PDFVisualisationTyp)cb.getSelectedItem();
        if (this.licenceTyp.isEditable()) {
            this.enableComponents(vTyp.getTyp());
            if (vTyp.getTyp().equals((Object)PDFVisualisationTypEnum.NONE)) {
                SwingUtilities.invokeLater(() -> {
                    this.invisibleSignatureField.setSelected(true);
                    this.visualisationTypComboBox.setEnabled(false);
                    this.invisibleSignatureField.requestFocus();
                    this.invisibleSignatureField.requestFocusInWindow();
                });
            }
        }
    }

    private void enableComponents(PDFVisualisationTypEnum typ) {
        if (this.licenceTyp == null || !this.licenceTyp.isEditable()) {
            JComponentUtils.setLookByLicence((JComponent)this.content, (LicenceTyp)this.licenceTyp);
            return;
        }
        boolean enabled = !typ.equals((Object)PDFVisualisationTypEnum.NONE);
        this.createSignaturefield.setEnabled(enabled);
        if (!this.createSignaturefield.isEnabled()) {
            this.createSignaturefield.setSelected(false);
        }
        this.onPageComboBox.setEnabled(enabled && this.createSignaturefield.isSelected());
        this.enablePositionComponents(enabled && this.createSignaturefield.isSelected());
        this.setIssuerFieldsEnable(enabled);
        if (typ.equals((Object)PDFVisualisationTypEnum.NONE)) {
            this.enableFontComponents(false);
            this.imageLayoutComboBox.setEnabled(false);
            this.textImageRelation.setEnabled(false);
            this.enableAdditionalInfos(false);
            this.enableImageComponents(false);
        }
        if (typ.equals((Object)PDFVisualisationTypEnum.TEXT)) {
            this.enableFontComponents(true);
            this.imageLayoutComboBox.setEnabled(false);
            this.enableAdditionalInfos(true);
            this.enableImageComponents(false);
        }
        if (typ.equals((Object)PDFVisualisationTypEnum.BOTH)) {
            this.enableFontComponents(true);
            this.imageLayoutComboBox.setEnabled(true);
            this.textImageRelation.setEnabled(true);
            this.enableAdditionalInfos(true);
            this.enableImageComponents(true);
        }
        if (typ.equals((Object)PDFVisualisationTypEnum.IMAGE)) {
            this.enableFontComponents(false);
            this.imageLayoutComboBox.setEnabled(false);
            this.textImageRelation.setEnabled(false);
            this.enableAdditionalInfos(false);
            this.enableImageComponents(true);
        }
        this.content.repaint();
    }

    private void setIssuerFieldsEnable(boolean enable) {
        this.useIssuerFromCertificate.setSelected(!enable);
        this.useIssuerName.setEnabled(enable);
        this.issuerTextField.setEnabled(enable);
        this.buttonUseDate.setEnabled(enable);
        if (!enable) {
            this.buttonUseDate.setSelected(enable);
        }
    }

    private void enablePositionComponents(boolean b) {
        this.positionSelector.setEnabled(b);
        this.visualisationHeight.setEnabled(b);
        this.visualisationWidth.setEnabled(b);
    }

    private void enableFontComponents(boolean b) {
        this.pdfACompatibility.setEnabled(b);
        this.fontFamilyComboBox.setEnabled(b && !this.pdfACompatibility.isSelected());
        this.fontColorComboBox.setEnabled(b && !this.pdfACompatibility.isSelected());
        this.fontSizeComboBox.setEnabled(b);
        this.fontFormatComboBox.setEnabled(b);
        this.useAutoFontSize.setEnabled(b);
    }

    private void enableAdditionalInfos(boolean enable) {
        this.useIssuerFromCertificate.setEnabled(enable);
        this.useIssuerName.setEnabled(enable);
        this.issuerTextField.setEnabled(enable && this.useIssuerName.isSelected());
        this.buttonUseDate.setEnabled(enable);
        this.dateFormatComboBox.setEnabled(enable && this.buttonUseDate.isSelected());
    }

    private void enableImageComponents(boolean b) {
        if (!b) {
            this.imageDisplay.clear();
        }
        this.stdImage.setEnabled(b);
        this.stdImageComboBox.setEnabled(b && this.stdImage.isSelected());
        this.userImage.setEnabled(b);
        this.chooseImageButton.setEnabled(b && this.userImage.isSelected());
        this.imageDisplay.setEnabled(b);
        if (b) {
            if (this.stdImage.isSelected()) {
                PDFStdImage stdimage = (PDFStdImage)this.stdImageComboBox.getSelectedItem();
                this.imageDisplay.setStdImage(stdimage.getImage(), stdimage.getDisplayText());
            }
            if (this.userImage.isSelected()) {
                if (this.ownImage.exists()) {
                    this.imageDisplay.setImage(this.ownImage.getImage(), this.ownImage.getUri().toString());
                } else {
                    this.imageDisplay.clear();
                }
            }
        }
    }

    private void setColDimension(JComponent comp, int colWidth) {
        Dimension pd = comp.getPreferredSize();
        pd.width = colWidth;
        Dimension mind = comp.getMinimumSize();
        mind.width = colWidth;
        comp.setPreferredSize(pd);
        comp.setMinimumSize(mind);
    }

    private URI getImageURI() {
        URI uri = null;
        if (this.stdImage.isSelected()) {
            uri = ((PDFStdImage)this.stdImageComboBox.getSelectedItem()).getUri();
        }
        if (this.userImage.isSelected() && this.ownImage != null) {
            uri = this.ownImage.getUri();
        }
        return uri;
    }

    private void setImageURI(URI uri) {
        LOG.trace((Object)uri);
        if (uri == null) {
            LOG.warn("URI wird erwartet: {}", (Object)uri);
            return;
        }
        if (uri.getScheme() == null) {
            LOG.warn("URI wird erwartet: {}", (Object)uri);
            return;
        }
        if (uri.toString().contains(PDF_IMAGEFILE_CERT) || uri.toString().contains(PDF_IMAGEFILE_BALLPEN)) {
            this.stdImage.setSelected(true);
            if (uri.toString().contains(PDF_IMAGEFILE_CERT)) {
                this.stdImageComboBox.setSelectedIndex(0);
                return;
            }
            if (uri.toString().contains(PDF_IMAGEFILE_BALLPEN)) {
                this.stdImageComboBox.setSelectedIndex(1);
                return;
            }
        }
        this.userImage.setSelected(true);
        if (uri.getScheme().equals("file")) {
            File f = new File(uri);
            if (f.exists()) {
                this.ownImage.setImageFile(f);
                this.imageDisplay.setImage(this.ownImage.getImage(), uri.toString());
            } else {
                LOG.warn("<imagefile> nicht gefunden: {}", (Object)uri);
            }
        } else if (uri.getScheme().equals("http")) {
            this.ownImage.setUri(uri);
            this.imageDisplay.setImage(this.ownImage.getImage(), uri.toString());
        }
    }

    public LicenceTyp getLicenceTyp() {
        return this.licenceTyp;
    }

    public void setLicenceTyp(LicenceTyp licenceTyp) {
        this.licenceTyp = licenceTyp;
        this.enableComponents(this.visualisationTypComboBox.getTyp());
    }

    private class VisualisationFrameChangeListener
    implements FocusListener {
        private VisualisationFrameChangeListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (VisualPDFPanel.this.visualisationHeight.isEditValid() && VisualPDFPanel.this.visualisationWidth.isEditValid() && VisualPDFPanel.this.positionSelector != null) {
                VisualPDFPanel.this.positionSelector.setCursorHeightInCentimeter(VisualPDFPanel.this.visualisationHeight.getCM());
                VisualPDFPanel.this.positionSelector.setCursorWidthInCentimeter(VisualPDFPanel.this.visualisationWidth.getCM());
            }
        }
    }

    private class WhichImageActionListener
    implements ActionListener {
        private WhichImageActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (VisualPDFPanel.this.stdImage.isSelected()) {
                PDFStdImage psi = (PDFStdImage)VisualPDFPanel.this.stdImageComboBox.getSelectedItem();
                VisualPDFPanel.this.imageDisplay.setStdImage(psi.getImage(), psi.getDisplayText());
                VisualPDFPanel.this.stdImageComboBox.setEnabled(true);
                VisualPDFPanel.this.chooseImageButton.setEnabled(false);
            }
            if (VisualPDFPanel.this.userImage.isSelected()) {
                if (VisualPDFPanel.this.ownImage.exists()) {
                    VisualPDFPanel.this.imageDisplay.setImage(VisualPDFPanel.this.ownImage.getImage(), VisualPDFPanel.this.ownImage.getUri().toString());
                } else {
                    VisualPDFPanel.this.imageDisplay.clear();
                }
                VisualPDFPanel.this.stdImageComboBox.setEnabled(false);
                VisualPDFPanel.this.chooseImageButton.setEnabled(true);
            }
        }
    }

    private class StdImageSelectorActionListener
    implements ActionListener {
        private StdImageSelectorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PDFStdImage psi = (PDFStdImage)VisualPDFPanel.this.stdImageComboBox.getSelectedItem();
            VisualPDFPanel.this.imageDisplay.setStdImage(psi.getImage(), psi.getDisplayText());
        }
    }
}

