/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.governikus.csl.server.AuthService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GovernikusServerPanel
extends ProcessConfigComponent {
    private static final Logger LOG = LogManager.getLogger(GovernikusServerPanel.class);
    private final ProcessI process;
    private LicenceTyp licenceTyp = null;
    private JPanel content;
    private JTextField authServiceUrl;
    private JTextField authServiceClient;
    private JTextField authServiceRealm;
    private JTextField authServiceSecret;
    private JTextField signServiceUrl;
    private JTextField timestampServiceUrl;
    private JTextField timestampProfileID;

    public GovernikusServerPanel(ProcessI process, LicenceTyp licenceTyp) {
        this.licenceTyp = licenceTyp;
        this.process = process;
        this.initContent();
        this.initGUI();
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)((Object)this));
    }

    protected void initContent() {
        this.content = new JPanel(new BorderLayout());
    }

    protected void initGUI() {
        JPanel p = new JPanel(new GridBagLayout());
        this.content = ComponentUtils.setTitledFocusableBorder((JPanel)this.content, (String)Messages.getString((String)"config.dialog.governikus.title"));
        JLabel description = new JLabel(Messages.getString((String)"config.dialog.governikus.description"));
        description.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)description));
        description.setFocusable(true);
        GridBagConstraints wholeNextRow = new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 10, 5), 0, 0);
        p.add((Component)description, wholeNextRow);
        p.add((Component)this.getAuthPanel(), wholeNextRow);
        p.add((Component)this.getSignServicePanel(), wholeNextRow);
        description = new JLabel(Messages.getString((String)"config.dialog.timestampserver.description"));
        description.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)description));
        description.setFocusable(true);
        p.add((Component)description, wholeNextRow);
        p.add((Component)this.getTimestampPanel(), wholeNextRow);
        JComponentUtils.setLookByLicence((JComponent)this.content, (LicenceTyp)this.licenceTyp);
        this.content.add((Component)p, "North");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        LOG.trace("PropertyChange  : {}", (Object)this.getTitle());
        LOG.trace("event source  : {}", evt.getSource());
        this.content.removeAll();
        this.initGUI();
        this.content.revalidate();
    }

    public void save() {
        LOG.info("save View-{} -> SignConfig ...", (Object)this.getTitle());
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        signConfig.setAuthService(this.getAuthService(), this.getAuthServiceRealm(), this.getAuthServiceClient(), this.getAuthServiceSecret());
        signConfig.setTimestampService(this.getTimestampService(), this.getTimestampProfileID());
        signConfig.setSignService(this.getSignService());
    }

    public void load() {
        LOG.trace("load Einstellungen/Governikus : SignConfig -> View-{} ...", (Object)this.getTitle());
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        this.setAuthService(signConfig.getAuthService());
        this.setTimestampService(signConfig.getTimestampService().getUrl());
        this.setTimestampProfileID(signConfig.getTimestampService().getProfileID());
        this.setSignService(signConfig.getSignService().getUrl());
    }

    public String getTitle() {
        return Messages.getString((String)"config.dialog.governikus");
    }

    public String getHelpContext() {
        return Messages.getResource((String)"config.dialog.governikus.helpcontext");
    }

    public Icon getIcon() {
        return ComponentUtils.getIcon((String)"config.dialog.governikus");
    }

    public LicenceTyp getLicenceTyp() {
        return this.licenceTyp;
    }

    public void setLicenceTyp(LicenceTyp licenceTyp) {
        this.licenceTyp = licenceTyp;
    }

    public JComponent getView() {
        return this.content;
    }

    private JPanel getAuthPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result = ComponentUtils.setTitledFocusableBorder((JPanel)result, (String)Messages.getString((String)"config.dialog.authenticationservice.title"));
        Insets insetsLeft = new Insets(5, 20, 0, 5);
        Insets insetsRight = new Insets(5, 5, 0, 20);
        int y = 0;
        JLabel l = new JLabel(Messages.getString((String)"config.dialog.authenticationservice.host"));
        result.add((Component)l, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.authServiceUrl = new JTextField();
        l.setLabelFor(this.authServiceUrl);
        this.authServiceUrl.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.authServiceUrl));
        result.add((Component)this.authServiceUrl, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        l = new JLabel(Messages.getString((String)"config.dialog.authenticationservice.realm"));
        result.add((Component)l, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.authServiceRealm = new JTextField();
        l.setLabelFor(this.authServiceRealm);
        this.authServiceRealm.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.authServiceRealm));
        result.add((Component)this.authServiceRealm, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        l = new JLabel(Messages.getString((String)"config.dialog.authenticationservice.client"));
        result.add((Component)l, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.authServiceClient = new JTextField();
        l.setLabelFor(this.authServiceClient);
        this.authServiceClient.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.authServiceClient));
        result.add((Component)this.authServiceClient, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        l = new JLabel(Messages.getString((String)"config.dialog.authenticationservice.secret"));
        result.add((Component)l, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.authServiceSecret = new JTextField();
        l.setLabelFor(this.authServiceSecret);
        this.authServiceSecret.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.authServiceSecret));
        result.add((Component)this.authServiceSecret, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        return result;
    }

    private JPanel getSignServicePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result = ComponentUtils.setTitledFocusableBorder((JPanel)result, (String)Messages.getString((String)"config.dialog.signservice.title"));
        int row = 0;
        JLabel l = new JLabel(Messages.getString((String)"config.dialog.signservice.host"));
        result.add((Component)l, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 0, 5), 0, 0));
        this.signServiceUrl = new JTextField();
        l.setLabelFor(this.signServiceUrl);
        this.signServiceUrl.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.signServiceUrl));
        result.add((Component)this.signServiceUrl, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 20), 0, 0));
        return result;
    }

    private JPanel getTimestampPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result = ComponentUtils.setTitledFocusableBorder((JPanel)result, (String)Messages.getString((String)"config.dialog.timestampserver.title"));
        Insets insetsLeft = new Insets(5, 20, 0, 5);
        Insets insetsRight = new Insets(5, 5, 0, 20);
        Insets insetsLeftBottom = new Insets(5, 20, 0, 5);
        Insets insetsRightBottom = new Insets(5, 5, 0, 20);
        JLabel l = new JLabel(Messages.getString((String)"config.dialog.timestampserver.host"));
        result.add((Component)l, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.timestampServiceUrl = new JTextField();
        l.setLabelFor(this.timestampServiceUrl);
        this.timestampServiceUrl.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.timestampServiceUrl));
        result.add((Component)this.timestampServiceUrl, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        l = new JLabel(Messages.getString((String)"config.dialog.timestampserver.profile"));
        result.add((Component)l, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, insetsLeftBottom, 0, 0));
        this.timestampProfileID = new JTextField();
        l.setLabelFor(this.timestampProfileID);
        this.timestampProfileID.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.timestampProfileID));
        result.add((Component)this.timestampProfileID, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, insetsRightBottom, 0, 0));
        return result;
    }

    public String getAuthService() {
        return this.authServiceUrl.getText();
    }

    public void setAuthService(AuthService as) {
        this.authServiceUrl.setText(as.getUrl());
        this.authServiceRealm.setText(as.getRealm());
        this.authServiceClient.setText(as.getClient());
        this.authServiceSecret.setText(as.getSecret());
    }

    public String getAuthServiceRealm() {
        return this.authServiceRealm.getText();
    }

    public String getAuthServiceClient() {
        return this.authServiceClient.getText();
    }

    public String getAuthServiceSecret() {
        return this.authServiceSecret.getText();
    }

    public String getTimestampService() {
        return this.timestampServiceUrl.getText();
    }

    public void setTimestampService(String value) {
        this.timestampServiceUrl.setText(value);
    }

    public String getTimestampProfileID() {
        return this.timestampProfileID.getText();
    }

    public void setTimestampProfileID(String value) {
        this.timestampProfileID.setText(value);
    }

    public String getSignService() {
        return this.signServiceUrl.getText();
    }

    public void setSignService(String host) {
        this.signServiceUrl.setText(host);
    }
}

