/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui.dialog.config.components;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.gui.dialog.config.ComponentUtils;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.view.component.JComponentUtils;
import de.bos_bremen.ecard.client.gui.view.component.LocaleChanger;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.governikus.csl.server.BNotK;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BNotKServerPanel
extends ProcessConfigComponent {
    private static final Logger LOG = LogManager.getLogger(BNotKServerPanel.class);
    private final ProcessI process;
    private LicenceTyp licenceTyp = null;
    private JPanel content;
    private JCheckBox useService;
    private JTextField idProviderInitialUrl;
    private JTextField idProviderAugmentedUrl;
    private JTextField keyManagerUrl;
    private JTextField signServerUrl;

    public BNotKServerPanel(ProcessI process, LicenceTyp licenceTyp) {
        this.licenceTyp = licenceTyp;
        this.process = process;
        this.initContent();
        this.initGUI();
        LocaleChanger.getInstance().addObserver((PropertyChangeListener)((Object)this));
    }

    public JComponent getView() {
        return this.content;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.content.removeAll();
        this.initGUI();
        this.content.revalidate();
    }

    public void save() {
        LOG.info("");
        LOG.trace("save {} : GUI -> SignConfig", (Object)this.getTitle());
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        signConfig.setBNotK(this.getBNotK());
    }

    public void load() {
        LOG.info("");
        LOG.trace("load Einstellungen/{} : SignConfig -> GUI ...", (Object)this.getTitle());
        SignConfig signConfig = (SignConfig)this.process.getConfig();
        this.setBNotKService(signConfig.getBNotK());
    }

    public String getTitle() {
        return Messages.getString((String)"config.dialog.BNotK");
    }

    public String getHelpContext() {
        return Messages.getResource((String)"config.dialog.BNotK.helpcontext");
    }

    public Icon getIcon() {
        return ComponentUtils.getIcon((String)"config.dialog.BNotK");
    }

    public LicenceTyp getLicenceTyp() {
        return this.licenceTyp;
    }

    public void setLicenceTyp(LicenceTyp licenceTyp) {
        this.licenceTyp = licenceTyp;
    }

    protected void initContent() {
        this.content = new JPanel(new BorderLayout());
    }

    protected void initGUI() {
        JPanel p = new JPanel(new GridBagLayout());
        this.content = ComponentUtils.setTitledFocusableBorder((JPanel)this.content, (String)Messages.getString((String)"config.dialog.BNotK.title"));
        JLabel description = new JLabel(Messages.getString((String)"config.dialog.BNotK.description"));
        description.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)description));
        description.setFocusable(true);
        GridBagConstraints wholeNextRow = new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 10, 5), 0, 0);
        p.add((Component)description, wholeNextRow);
        p.add((Component)this.getPanel(), wholeNextRow);
        p.add((Component)this.getHintPanel(), wholeNextRow);
        JComponentUtils.setLookByLicence((JComponent)this.content, (LicenceTyp)this.licenceTyp);
        this.content.add((Component)p, "North");
    }

    private JPanel getPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result = ComponentUtils.setTitledFocusableBorder((JPanel)result, (String)Messages.getString((String)"config.dialog.BNotK.config"));
        Insets insetsLeft = new Insets(5, 10, 0, 5);
        Insets insetsRight = new Insets(5, 5, 0, 10);
        int y = 0;
        this.useService = new JCheckBox(" " + Messages.getString((String)"config.dialog.BNotK.used"));
        result.add((Component)this.useService, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, insetsLeft, 0, 0));
        this.useService.addActionListener(new SelectedActionListener());
        JLabel l = new JLabel(Messages.getString((String)"config.dialog.BNotK.idProviderInitialUrl"));
        result.add((Component)l, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.idProviderInitialUrl = new JTextField();
        this.idProviderInitialUrl.setEditable(false);
        l.setLabelFor(this.idProviderInitialUrl);
        this.idProviderInitialUrl.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.idProviderInitialUrl));
        result.add((Component)this.idProviderInitialUrl, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        l = new JLabel(Messages.getString((String)"config.dialog.BNotK.idProviderAugmentedUrl"));
        result.add((Component)l, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.idProviderAugmentedUrl = new JTextField();
        this.idProviderAugmentedUrl.setEditable(false);
        l.setLabelFor(this.idProviderAugmentedUrl);
        this.idProviderAugmentedUrl.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.idProviderAugmentedUrl));
        result.add((Component)this.idProviderAugmentedUrl, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        l = new JLabel(Messages.getString((String)"config.dialog.BNotK.keyManagerUrl"));
        result.add((Component)l, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.keyManagerUrl = new JTextField();
        this.keyManagerUrl.setEditable(false);
        l.setLabelFor(this.keyManagerUrl);
        this.keyManagerUrl.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.keyManagerUrl));
        result.add((Component)this.keyManagerUrl, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        l = new JLabel(Messages.getString((String)"config.dialog.BNotK.signServerUrl"));
        result.add((Component)l, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, insetsLeft, 0, 0));
        this.signServerUrl = new JTextField();
        this.signServerUrl.setEditable(false);
        l.setLabelFor(this.signServerUrl);
        this.signServerUrl.addFocusListener(ComponentUtils.createFocusListenerFor((JTextField)this.signServerUrl));
        result.add((Component)this.signServerUrl, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 2, insetsRight, 0, 0));
        return result;
    }

    private JPanel getHintPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result = ComponentUtils.setTitledFocusableBorder((JPanel)result, (String)Messages.getString((String)"config.dialog.BNotK.hint.title"));
        JLabel description = new JLabel(Messages.getString((String)"config.dialog.BNotK.hint.description"));
        description.addFocusListener(ComponentUtils.createFocusListenerFor((JLabel)description));
        description.setFocusable(true);
        result.add((Component)description, "Center");
        return result;
    }

    public BNotK getBNotK() {
        BNotK result = new BNotK();
        result.setIdProviderInitialUrl(this.idProviderInitialUrl.getText());
        result.setIdProviderAugmentedUrl(this.idProviderAugmentedUrl.getText());
        result.setKeyManagerUrl(this.keyManagerUrl.getText());
        result.setSignServerUrl(this.signServerUrl.getText());
        return result;
    }

    private void setBNotKService(BNotK service) {
        this.useService.setSelected(service.isValid());
        this.idProviderInitialUrl.setText(service.getIdProviderInitialUrl());
        this.idProviderAugmentedUrl.setText(service.getIdProviderAugmentedUrl());
        this.keyManagerUrl.setText(service.getKeyManagerUrl());
        this.signServerUrl.setText(service.getSignServerUrl());
    }

    private class SelectedActionListener
    implements ActionListener {
        private SelectedActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BNotKServerPanel.this.useService.isSelected()) {
                BNotKServerPanel.this.idProviderInitialUrl.setText("https://login.bnotk.de/auth/realms/RemoteSignature/auth/tls");
                BNotKServerPanel.this.idProviderAugmentedUrl.setText("https://login.bnotk.de/auth/realms/RemoteSignature/id-token/sad");
                BNotKServerPanel.this.keyManagerUrl.setText("https://eid.bnotk.de/KeyManager/api/resources/certificates?");
                BNotKServerPanel.this.signServerUrl.setText("https://eid.bnotk.de/ServerSigningApplication/api/signing");
            } else {
                BNotKServerPanel.this.idProviderInitialUrl.setText(null);
                BNotKServerPanel.this.idProviderAugmentedUrl.setText(null);
                BNotKServerPanel.this.keyManagerUrl.setText(null);
                BNotKServerPanel.this.signServerUrl.setText(null);
            }
        }
    }
}

