/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.gui;

import de.bos_bremen.ecard.client.AbstractProcessHelper;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.model.BooleanTriState;
import de.bos_bremen.ecard.client.model.HashedFile;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.XMLSignatureType;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignProcess;
import de.bos_bremen.ecard.client.sign.gui.step.SelectFilesView;
import de.bos_bremen.ecard.client.sign.model.formular.process.SignProcessFormular;
import de.governikus.csl.cms.sign.doc.impl.CMSDetachedSignedDocumentImpl;
import de.governikus.csl.sign.SignedDocument;
import de.governikus.csl.sign.impl.DetachedSignedDocumentWithContentDocumentImpl;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.util.SimpleDataHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.activation.DataHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignProcessHelper
extends AbstractProcessHelper {
    private static final Logger LOG = LogManager.getLogger(SignProcessHelper.class);
    private SignProcessFormular signFormular;

    public ProcessFormular fillSignFormular(String serialnumber, String[] inputFile, TargetFolderType targetFolderType, String outputFolder, SignatureType signatureType, PDFSignatureType pdfSignatureType, String advancedPDFReason, String advancedPDFLocation, XMLSignatureType xmlSignatureType, BooleanTriState createTimestamp, boolean replaceFiles) {
        ProcessFormular processesFormular = null;
        ProcessI process = de.bos_bremen.ecard.client.model.Document.getInstance().getProcessFactory().getProcess(SignProcess.PROCESS_NAME);
        LOG.info("fill Sign Formular ...");
        if (process != null) {
            processesFormular = de.bos_bremen.ecard.client.model.Document.getInstance().getProcessFactory().getProcessesFormular(process);
            LOG.info("fillSignFormular : ProcessFormular : {}", (Object)processesFormular);
            if (processesFormular instanceof SignProcessFormular) {
                SignProcessFormular signProcessFormular = (SignProcessFormular)processesFormular;
                LOG.info("fillSignFormular : sign");
                this.signFormular = signProcessFormular;
                this.signFormular.addBlockRequest();
                ArrayList<ProcessSignedFile> inputFileList = new ArrayList<ProcessSignedFile>();
                try {
                    if (inputFile != null) {
                        Object content;
                        int i;
                        ArrayList<File> files = new ArrayList<File>();
                        ArrayList<String> remoteFiles = new ArrayList<String>();
                        for (i = 0; i < inputFile.length; ++i) {
                            LOG.info("Von {} : [{}] = {}", (Object)inputFile.length, (Object)i, (Object)inputFile[i]);
                            if (inputFile[i].startsWith("http://") || inputFile[i].startsWith("https://")) {
                                remoteFiles.add(inputFile[i]);
                                continue;
                            }
                            files.add(new File(inputFile[i]));
                        }
                        for (i = 0; i < inputFile.length; ++i) {
                            File file;
                            if (inputFile[i].startsWith("http://") || inputFile[i].startsWith("https://") || ((File)(content = new File(inputFile[i]))).isDirectory() || !files.contains(file = new File(((File)content).getAbsolutePath() + ".p7s")) || !((File)content).exists() || !file.exists() || !SignProcessHelper.checkCMSDetachedMatch((File)content, file)) continue;
                            this.signFormular.setSignatureType(SignatureType.detachedPKCS7);
                            ProcessSignedFile psf = new ProcessSignedFile(file);
                            psf.setDetachedFile((File)content);
                            psf.multipleCmsSignatures = true;
                            inputFileList.add(psf);
                            files.remove(content);
                            files.remove(file);
                        }
                        inputFile = new String[files.size() + remoteFiles.size()];
                        int j = 0;
                        for (File file : files) {
                            inputFile[j] = ((File)files.get(j)).getAbsolutePath();
                            ++j;
                        }
                        content = remoteFiles.iterator();
                        while (content.hasNext()) {
                            String string;
                            inputFile[j] = string = (String)content.next();
                            ++j;
                        }
                        this.getInputfiles(inputFile, inputFileList, true);
                        ArrayList<HashedFile> toBeRemoved = new ArrayList<HashedFile>();
                        for (ProcessSignedFile psf : inputFileList) {
                            if (!psf.multipleCmsSignatures) continue;
                            toBeRemoved.add(psf.getFile());
                        }
                        ProcessSignedFile[] processSignedFileArray = inputFileList.toArray(new ProcessSignedFile[inputFileList.size()]);
                        for (int i2 = 0; i2 < processSignedFileArray.length; ++i2) {
                            if (processSignedFileArray[i2].multipleCmsSignatures || !toBeRemoved.contains(processSignedFileArray[i2].getFile())) continue;
                            inputFileList.remove(processSignedFileArray[i2]);
                        }
                    }
                }
                catch (SignerException e) {
                    LOG.error("", (Throwable)e);
                }
                if (replaceFiles) {
                    this.signFormular.removeAllFiles();
                }
                if (inputFileList != null) {
                    LOG.info("Fuege die FileInputListe dem Formular hinzu");
                    for (ProcessSignedFile processFile : inputFileList) {
                        this.signFormular.addSelectedFile(processFile);
                        LOG.info("add source file {} --> to SignProcessFormular:SelectedFiles", (Object)processFile.getFile());
                    }
                }
                if (!targetFolderType.equals((Object)TargetFolderType.useDefault)) {
                    this.signFormular.setTargetFolderType(TargetFolderType.valueOf((String)targetFolderType.toString()));
                }
                if (!"".equals(outputFolder)) {
                    this.signFormular.setTargetFolder(outputFolder);
                }
                if (!signatureType.equals((Object)SignatureType.useDefault)) {
                    this.signFormular.setSignatureType(SignatureType.valueOf((String)signatureType.toString()));
                }
                if (pdfSignatureType != PDFSignatureType.useDefault) {
                    this.signFormular.setPDFSignatureType(pdfSignatureType);
                }
                if (!"".equals(advancedPDFReason)) {
                    this.signFormular.setPDFSignatureReason(advancedPDFReason);
                }
                if (!"".equals(advancedPDFLocation)) {
                    this.signFormular.setPDFSignatureLocation(advancedPDFLocation);
                }
                if (!createTimestamp.equals((Object)BooleanTriState.useDefault)) {
                    this.signFormular.createTimestamp(BooleanTriState.yes.equals((Object)createTimestamp));
                }
                if (xmlSignatureType != XMLSignatureType.useDefault) {
                    this.signFormular.setXMLSignatureType(xmlSignatureType);
                }
                this.signFormular.setSerialnumber(serialnumber);
                this.signFormular.removeBlockRequest();
            }
        }
        LOG.info("fillSignFormular : {}", processesFormular);
        return processesFormular;
    }

    protected ProcessSignedFile createProcessSignedFile(File file) {
        return SelectFilesView.createProcessSignedFile(file, this.signFormular);
    }

    public static boolean checkCMSDetachedMatch(File content, File signature) {
        CMSDetachedSignedDocumentImpl detachedSignatureDocument = null;
        try {
            detachedSignatureDocument = new CMSDetachedSignedDocumentImpl((DataHandler)new SimpleDataHandler((InputStream)new FileInputStream(signature), "application/pkcs7-signature"));
            DetachedSignedDocumentWithContentDocumentImpl.checkDocumentPair((SignedDocument)detachedSignatureDocument, (Document)new FileDocumentImpl(content, "id"));
        }
        catch (Exception fnfe) {
            LOG.debug("Files do not match.");
            return false;
        }
        return true;
    }
}

