/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.control.step;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.ecard.client.BoreumHttpClient;
import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.control.step.WorkingResult;
import de.bos_bremen.ecard.client.control.step.working.ResultInput;
import de.bos_bremen.ecard.client.control.step.working.WorkingStep;
import de.bos_bremen.ecard.client.gui.dialog.ConnectServerWaitWindow;
import de.bos_bremen.ecard.client.gui.dialog.ErrorDialog;
import de.bos_bremen.ecard.client.model.Config;
import de.bos_bremen.ecard.client.model.DetachableFile;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.HashedFile;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.ProcessSignedFile;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.SubsequentProcess;
import de.bos_bremen.ecard.client.model.TargetFolderType;
import de.bos_bremen.ecard.client.model.ViewableProcessFile;
import de.bos_bremen.ecard.client.model.XMLSignatureType;
import de.bos_bremen.ecard.client.model.error.ErrorCode;
import de.bos_bremen.ecard.client.model.error.FileExistException;
import de.bos_bremen.ecard.client.model.error.FileInUseException;
import de.bos_bremen.ecard.client.model.error.SignerException;
import de.bos_bremen.ecard.client.model.formular.FormularChangedEvent;
import de.bos_bremen.ecard.client.model.keyprovider.KeyProvider;
import de.bos_bremen.ecard.client.model.keyprovider.SignServiceInterface;
import de.bos_bremen.ecard.client.model.keyprovider.SignServiceKey;
import de.bos_bremen.ecard.client.model.licence.Licence;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.SignFunction;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.AdvancedPDFDialog;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.PdfUtils;
import de.bos_bremen.ecard.client.sign.gui.step.SignView;
import de.bos_bremen.ecard.client.sign.model.formular.process.SignProcessFormular;
import de.bos_bremen.ecard.client.sign.model.formular.process.impl.SignFormular;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplate;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.SignatureNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.SignaturePinRelatedException;
import de.bos_bremen.gov2.jca_provider.SignatureRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.SignatureWrongPINException;
import de.governikus.csc.authentication.keycloak.client.KeycloakAuthClient;
import de.governikus.csc.tsp.service.client.AuthenticatedTimestampServiceClient;
import de.governikus.csc.tsp.service.client.TSPResponseData;
import de.governikus.csl.ECardProgressListener;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.pdf.sign.PDFSignMessageCode;
import de.governikus.csl.pdf.sign.PDFSigningPrepareException;
import de.governikus.csl.pdf.sign.PDFVisualSignatureDetails;
import de.governikus.csl.pdf.sign.impl.PDFSignOptionsImpl;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.PDFMetaData;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.Page;
import de.governikus.csl.server.AuthService;
import de.governikus.csl.server.TimestampService;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.PrivateKeyResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.TimestampServiceResource;
import de.governikus.csl.uom.res.TimestampServiceResourceReference;
import de.governikus.csl.uom.res.TimestampServiceResourceReferenceParameter;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.UnsignedProperty;
import de.governikus.csl.uom.sign.ades.AdESSignCreationPolicy;
import de.governikus.csl.uom.sign.impl.SignOptionsBuilder;
import de.governikus.csl.uom.sign.impl.SignerInfoBuilder;
import de.governikus.csl.uom.sign.props.CertifiedRole;
import de.governikus.csl.uom.sign.props.SignatureTimestamp;
import de.governikus.csl.uom.sign.props.SignerRole;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import de.governikus.csl.uom.sign.props.SigningTime;
import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampToken;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.authorization.client.util.HttpResponseException;

public class Sign
extends WorkingStep {
    private static final String ANSI = "-ansi";
    private static final Logger LOG = LogManager.getLogger(Sign.class);
    private boolean transactionStarted = false;

    public Sign() {
        super(StepFactory.StepName.sign);
    }

    public void setJComponent() {
        this.viewPanel = new SignView(this);
    }

    public void setDefaults(XMLProperties propertiesForNode) {
        super.setDefaults(propertiesForNode);
        this.notifyAllStateChangeListener(null, propertiesForNode);
    }

    private void beginTransaction(KeyProvider keyProvider) {
        PrivateKey privateKey;
        if (keyProvider == null || !((privateKey = keyProvider.getKey()) instanceof OCFPrivateKey)) {
            return;
        }
        OCFPrivateKey oCFPrivateKey = (OCFPrivateKey)privateKey;
        this.transactionStarted = oCFPrivateKey.getCardService().beginTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTransaction(KeyProvider keyProvider) {
        PrivateKey privateKey;
        if (keyProvider == null || !((privateKey = keyProvider.getKey()) instanceof OCFPrivateKey)) {
            return;
        }
        OCFPrivateKey oCFPrivateKey = (OCFPrivateKey)privateKey;
        try {
            oCFPrivateKey.getCardService().endTransaction(this.transactionStarted);
        }
        finally {
            this.transactionStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SubsequentProcess process) {
        LOG.info("------- Start Signieren ... -------");
        long start = System.currentTimeMillis();
        this.reset();
        this.buildWorkingResult();
        if (!this.checkedViewedFiles()) {
            this.parent.isFinished(false);
            return;
        }
        Document documentInstance = Document.getInstance();
        SignFormular signFormular = (SignFormular)this.form;
        if (!this.canMoveToTargetFolder(signFormular)) {
            LOG.trace("ErrorCode.CANNOT_WRITE_TO_FOLDER");
            this.finished(process, documentInstance.getWorkingResults().size());
            return;
        }
        List<KeyProvider> keyProviderList = signFormular.getKeyProvider(KeyUsage.SIGN);
        KeyProvider keyProvider = keyProviderList.get(0);
        if (this.isExpired(keyProvider)) {
            LOG.trace("KEY_EXPIRED oder KEY_NOT_YET_VALID");
            this.finished(process, documentInstance.getWorkingResults().size());
            return;
        }
        this.beginTransaction(keyProvider);
        try {
            documentInstance.notifyProgressListeners(ECardProgressListener.ProgressType.CALCULATE_HASH_FOR_SIGNATURE, -1);
            LOG.info("Stapel von Dokumenten signieren ...");
            List workingResultList = documentInstance.getWorkingResults();
            int errorCounter = 0;
            boolean cancelled = false;
            signFormular.addBlockRequest();
            for (int i = 0; workingResultList != null && i < workingResultList.size(); ++i) {
                documentInstance.resetLastErrorObject();
                WorkingResult workingResult = (WorkingResult)workingResultList.get(i);
                LOG.info("");
                LOG.info("Datei {} vom Stapel signieren : {}", (Object)i, (Object)workingResult.getSourceFile().getName());
                if (cancelled) {
                    LOG.info("report ErrorCode.FILE_CANCELLED: {}", (Object)workingResult.getSourceFile());
                    documentInstance.reportError(ErrorCode.FILE_CANCELLED, false, new Object[]{workingResult.getSourceFile()});
                    workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                    continue;
                }
                LOG.trace("checkSourceFileBeforeProcess ...");
                if (!this.checkSourceFileBeforeProcess(workingResult, signFormular.getTargetFolderType())) {
                    cancelled = documentInstance.getLastReportedErrorObject().abortError();
                    ++errorCounter;
                    continue;
                }
                LOG.trace("checkSourceFileBeforeProcess : ok");
                HashedFile sourceFile = signFormular.getSelectedFiles().get(i).getFile();
                if (sourceFile.isPdfEncrypted()) {
                    LOG.error("pdf is encrypted : {}", (Object)sourceFile.getName());
                    documentInstance.reportError(ErrorCode.PDF_ENCRYPTED, true, new Object[]{workingResult.getSourceFile()});
                    workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
                    workingResult.setCurrentState(WorkingResult.Status.ERROR);
                    cancelled = documentInstance.getLastReportedErrorObject().abortError();
                    ++errorCounter;
                    LOG.info("Nutzerauswahl : cancelled");
                    continue;
                }
                LOG.trace("pdf is not encrypted : {}", (Object)sourceFile.getName());
                workingResult.setCurrentState(WorkingResult.Status.WORKING);
                String resultFileName = this.getResultFileName(signFormular, workingResult);
                LOG.debug("Sign ResultFileName : {}", (Object)resultFileName);
                WorkingStep.Repeat currentRepeat = this.canMoveToTargetFolder(signFormular, workingResult, resultFileName);
                if (WorkingStep.Repeat.CANCEL == this.lastRepeat) {
                    LOG.info("Nutzerauswahl : CANCEL");
                    cancelled = true;
                    ++errorCounter;
                    continue;
                }
                if (WorkingStep.Repeat.SKIP.equals((Object)currentRepeat) || WorkingStep.Repeat.SKIP_ALL.equals((Object)currentRepeat)) {
                    LOG.info("Nutzerauswahl : {}", (Object)currentRepeat);
                    ++errorCounter;
                    continue;
                }
                try {
                    SignerRole signerRole = null;
                    ArrayList certifiedRoleList = new ArrayList();
                    if (!certifiedRoleList.isEmpty()) {
                        signerRole = new SignerRole(true, certifiedRoleList.toArray(new CertifiedRole[0]));
                    }
                    LOG.trace("run sign...");
                    this.sign(signFormular, workingResult, resultFileName, keyProvider, signerRole);
                    LOG.trace("run sign done");
                    if (workingResult.getCurrentState().equals((Object)WorkingResult.Status.ERROR)) {
                        ++errorCounter;
                    }
                    this.notifyProgressListener(null, workingResultList);
                    continue;
                }
                catch (IOException e) {
                    LOG.error("", (Throwable)e);
                    workingResult.getResult().clear();
                    workingResult.setCurrentState(WorkingResult.Status.ERROR);
                    ++errorCounter;
                    continue;
                }
                catch (CoreException e) {
                    boolean aborted;
                    LOG.error("", (Throwable)e);
                    ErrorCode ec = this.reportError(e);
                    boolean bl = aborted = ErrorCode.UNKNOWN.equals((Object)ec) || ErrorCode.PIN_INPUT_CANCEL.equals((Object)ec) || ErrorCode.TOO_MANY_WRONG_PINS.equals((Object)ec) || ErrorCode.CARD_NOT_YET_INITIALIZED.equals((Object)ec) || ErrorCode.PDF_SIGNATURE_VISUALISATION_TOO_BIG.equals((Object)ec) || ErrorCode.CMS_MULTIPLE_DETACHED_CONTENT_SIGNATURE_MISMATCH.equals((Object)ec);
                    if (aborted) {
                        cancelled = true;
                        workingResult.setCurrentState(WorkingResult.Status.ERROR);
                        ++errorCounter;
                    }
                    workingResult.getResult().clear();
                    SignaturePinRelatedException spre = this.extractPinException(e);
                    if (spre != null) {
                        if (spre instanceof SignatureWrongPINException) {
                            --i;
                            continue;
                        }
                        if (spre instanceof SignaturePINInputCancelledException) {
                            cancelled = true;
                            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                            continue;
                        }
                        if (!(spre instanceof SignatureRetryCounterExpiredException)) continue;
                        cancelled = true;
                        workingResult.setCurrentState(WorkingResult.Status.ERROR);
                        continue;
                    }
                    cancelled = true;
                    workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                    ++errorCounter;
                    continue;
                }
                catch (FileExistException | FileInUseException e) {
                    LOG.error("", e);
                    workingResult.getResult().clear();
                    workingResult.setCurrentState(WorkingResult.Status.ABORTED);
                    ++errorCounter;
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Unerwarteter Fehler", (Throwable)e);
                    workingResult.setCurrentState(WorkingResult.Status.ERROR);
                    ++errorCounter;
                    continue;
                }
                finally {
                    this.notifyProgressListener(null, workingResult);
                    documentInstance.resetLastErrorObject();
                }
            }
            signFormular.removeBlockRequest();
            LOG.trace("cancelled:{}, errorCounter:{}", (Object)cancelled, (Object)errorCounter);
            this.displayFinishDialog(cancelled, errorCounter);
            this.state = WorkingStep.WorkingState.CALLING_SUBSEQUENT_PROCESS;
            if (process != null) {
                super.callSubsequentProcess(process);
            }
            this.deleteOriginalFiles(workingResultList, cancelled);
            this.state = WorkingStep.WorkingState.FINISHED;
            this.notifyProgressListener(null, workingResultList);
            this.notifyAllStateChangeListener(null, workingResultList);
            this.parent.isFinished(true);
        }
        finally {
            this.endTransaction(keyProvider);
        }
        long end = System.currentTimeMillis();
        LOG.info("Sign completed : {}sec", (Object)((double)(end - start) / 1000.0));
        LOG.info("------- Signieren abgeschlossen -------");
    }

    private void deleteOriginalFiles(List<WorkingResult> workingResultList, boolean cancelled) {
        LOG.trace("----");
        if (this.checkDeleteConditions(cancelled)) {
            return;
        }
        SignConfig config = (SignConfig)this.parent.getConfig();
        if (!config.useDeleteSource()) {
            return;
        }
        LOG.trace("");
        for (WorkingResult workingResult : workingResultList) {
            DetachableFile sourceFile = workingResult.getSourceFile();
            LOG.debug("source file to delete : {}", (Object)sourceFile);
            List result = workingResult.getResult();
            if (result == null || result.isEmpty()) continue;
            File targetFile = (File)result.get(0);
            if (sourceFile == null || targetFile == null) continue;
            if (!targetFile.getParent().equals(sourceFile.getParent())) {
                LOG.debug("target file: {}", (Object)targetFile);
                if (!sourceFile.delete()) {
                    LOG.debug("could not delete file: {}", (Object)sourceFile);
                    continue;
                }
                LOG.info("source file deleted : {}", (Object)sourceFile);
                LOG.info("");
                continue;
            }
            LOG.info("Quel- und Zielverzeichnis sind gleich : {}", (Object)targetFile.getParent());
            LOG.info("... Queldateien werden nicht gel\u00f6scht.");
        }
    }

    private boolean checkDeleteConditions(boolean cancelled) {
        SignConfig config = (SignConfig)this.parent.getConfig();
        return cancelled && !config.useDeleteSource();
    }

    private ErrorCode reportError(CoreException e) {
        ErrorCode errorCode = ErrorCode.UNKNOWN;
        SignaturePinRelatedException spre = this.extractPinException(e);
        if (spre != null) {
            if (spre instanceof SignaturePINInputCancelledException) {
                errorCode = ErrorCode.PIN_INPUT_CANCEL;
            } else if (spre instanceof SignatureWrongPINException) {
                errorCode = ErrorCode.INVALID_PIN;
            } else if (spre instanceof SignatureRetryCounterExpiredException) {
                errorCode = ErrorCode.TOO_MANY_WRONG_PINS;
            } else if (spre instanceof SignatureNotYetInitializedException) {
                errorCode = ErrorCode.CARD_NOT_YET_INITIALIZED;
            }
        } else if (e instanceof PDFSigningPrepareException) {
            PDFSigningPrepareException pDFSigningPrepareException = (PDFSigningPrepareException)e;
            LOG.error("PDFSigningPrepareException : {}", (Object)e.getMessage());
            if (pDFSigningPrepareException.getMessageCode() == PDFSignMessageCode.PDF_NOT_ENOUGH_SPACE_FOR_VIS_SIG) {
                LOG.trace("ErrorCode.PDF_SIGNATURE_VISUALISATION_TOO_BIG");
                errorCode = ErrorCode.PDF_SIGNATURE_VISUALISATION_TOO_BIG;
            } else {
                LOG.trace("Unerwartete PDFSigningPrepareException : {}", (Object)e.getMessage());
                LOG.trace("ErrorCode.UNKNOWN");
                errorCode = ErrorCode.UNKNOWN;
            }
        } else if (e.getCause() instanceof IllegalArgumentException && e.getCause().getMessage().equals("illegal content document not matching to detached signature document")) {
            LOG.error("ErrorCode.CMS_MULTIPLE_DETACHED_CONTENT_SIGNATURE_MISMATCH");
            errorCode = ErrorCode.CMS_MULTIPLE_DETACHED_CONTENT_SIGNATURE_MISMATCH;
        } else {
            LOG.error("Unerwarteter Fehler : {}", (Object)e.getMessage());
            errorCode = ErrorCode.UNKNOWN;
        }
        LOG.error("ErrorCode : {} : {}", (Object)errorCode, (Object)errorCode.getDescription());
        if (errorCode == ErrorCode.UNKNOWN) {
            LOG.error("Details: {}", (Object)e.getMessage());
            String errorMessage = e.getMessage() == null ? Messages.getString((String)"dialog.optionPane.error.nodetails") : e.getMessage();
            Document.getInstance().displayErrorMessages(null, "optionPane.error", errorCode.getDescription(), errorMessage);
        } else {
            LOG.error("report error: {}={}", (Object)errorCode, (Object)errorCode.getDescription());
            Document.getInstance().reportError(errorCode, false, new Object[]{""});
        }
        return errorCode;
    }

    private SignaturePinRelatedException extractPinException(CoreException ce) {
        Throwable e = ce;
        while ((e = e.getCause()) != null) {
            if (!(e instanceof SignaturePinRelatedException)) continue;
            SignaturePinRelatedException signaturePinRelatedException = (SignaturePinRelatedException)e;
            return signaturePinRelatedException;
        }
        return null;
    }

    private boolean isExpired(KeyProvider keyProvider) {
        Document documentInstance = Document.getInstance();
        try {
            keyProvider.getCertificate().checkValidity();
        }
        catch (CertificateExpiredException ex) {
            String str = keyProvider.getDisplayName(keyProvider.getSelectedAlias());
            LOG.debug("{} {}: {}", (Object)ErrorCode.KEY_EXPIRED, (Object)ErrorCode.KEY_EXPIRED.getReturnCode(), (Object)keyProvider.getSelectedAlias());
            documentInstance.reportError(ErrorCode.KEY_EXPIRED, false, new Object[]{str});
            return true;
        }
        catch (CertificateNotYetValidException e) {
            String str = keyProvider.getDisplayName(keyProvider.getSelectedAlias());
            LOG.debug("{} {}: {}", (Object)ErrorCode.KEY_NOT_YET_VALID, (Object)ErrorCode.KEY_NOT_YET_VALID.getReturnCode(), (Object)keyProvider.getSelectedAlias());
            documentInstance.reportError(ErrorCode.KEY_NOT_YET_VALID, false, new Object[]{str});
            return true;
        }
        return false;
    }

    private void signXML(SignFormular signFormular, WorkingResult workingResult, String resultFileName, SignOptionsBuilder sob) throws FileExistException, IOException, FileInUseException, CoreException {
        LOG.trace("");
        DetachableFile sourceFile = workingResult.getSourceFile();
        LOG.info(resultFileName);
        File signedFile = SignFunction.getInstance().signXML(Sign.getTempFolder(), (File)sourceFile, resultFileName, sob);
        File resultFile = this.moveResultDocumentToTargetFolder(signFormular, (File)sourceFile, signedFile, true, false, false);
        workingResult.addResultFile(resultFile);
        File copyOriginalDocument = this.copyOriginalDocument(signFormular, (File)workingResult.getSourceFile());
        if (copyOriginalDocument != null) {
            workingResult.addResultFile(copyOriginalDocument);
        }
        workingResult.setCurrentState(WorkingResult.Status.FINISHED);
    }

    private String getSelectedSignatureField(File signedFile) {
        LOG.trace("");
        ArrayList<String> signatureFields = new ArrayList<String>();
        try (PDDocument pd = PDDocument.load((File)signedFile);){
            for (PDSignatureField sf : pd.getSignatureFields()) {
                LOG.info("signature field: {} ({})", (Object)sf.getPartialName(), (Object)(sf.getSignature() != null ? 1 : 0));
                if (sf.getSignature() != null) continue;
                signatureFields.add(sf.getPartialName());
            }
        }
        catch (IOException ex) {
            LOG.error("", (Throwable)ex);
        }
        if (signatureFields.isEmpty()) {
            LOG.trace("keine signaturfelder in pdf gefunden - neu anlegen.");
            return null;
        }
        LOG.info("signature field found");
        if (signatureFields.size() == 1) {
            LOG.info("one signature field found");
            return (String)signatureFields.get(0);
        }
        return this.selectSignatureField(signedFile);
    }

    private synchronized String selectSignatureField(File file) {
        LOG.info("show select signature field dialog");
        AdvancedPDFDialog advancedPDFDialog = new AdvancedPDFDialog(this.getParent().getProcessName(), file);
        while (advancedPDFDialog.isVisible()) {
            try {
                ((Object)((Object)this)).wait(500L);
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    LOG.debug(e.getMessage());
                }
                Thread.currentThread().interrupt();
            }
        }
        SignConfig signConfig = (SignConfig)this.parent.getConfig();
        if (signConfig != null && signConfig.getSelectedSignatureField() != null) {
            LOG.trace("Signaturfeld ausgew\u00e4hlt.");
            return signConfig.getSelectedSignatureField().getFieldName();
        }
        LOG.info("Signaturfeld-Auswahl abgebrochen.");
        return null;
    }

    private void sign(SignFormular signFormular, WorkingResult workingResult, String resultFileName, KeyProvider keyProvider, SignerRole signerRole) throws FileExistException, IOException, FileInUseException, CoreException {
        PDFSignatureType pdfSignatureType;
        boolean shouldCreatePDFInline;
        LOG.trace("");
        XMLSignatureType xmlSignatureType = signFormular.getXMLSignatureType();
        boolean shouldCreateXMLInline = this.shouldCreateXMLInline(workingResult, xmlSignatureType);
        PrivateKeyResource keyResource = this.fetchPrivateKeyResource(keyProvider);
        AuthService authService = SignerValidationProcessor.getInstance().getAuthService();
        String algoIdSignature = this.fetchAlgoIdSignature(keyProvider, shouldCreateXMLInline);
        String algoIdDigest = AlgorithmService.getSignatureForJCAName((String)XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(algoIdSignature)).getDigestAlgorithm().getURI();
        SignerInfoBuilder sib = new SignerInfoBuilder();
        if (keyResource.getCertificate().certificate().getPublicKey().getAlgorithm().equals("EC")) {
            if (shouldCreateXMLInline) {
                algoIdSignature = algoIdSignature.replace(ANSI, "");
            } else if (!algoIdSignature.contains(ANSI)) {
                algoIdSignature = algoIdSignature.concat(ANSI);
            }
        }
        sib.setSignatureAlgorithmURI(algoIdSignature);
        sib.setKey((PrivateKeyResourceReferenceParameter)keyResource);
        if (signerRole != null) {
            sib.addSignedProperty((SignedProperty)signerRole);
        }
        if (keyResource.getCertificate().certificate() != null) {
            SigningCertificate signingCertificate = new SigningCertificate(new ConstraintSignPolicy.EncodingConstraint[0]);
            signingCertificate.setDigestAlgorithmURI(algoIdDigest);
            signingCertificate.addCertificate(keyResource.getCertificate().certificate());
            sib.addSignedProperty((SignedProperty)signingCertificate);
        }
        sib.addSignedProperty((SignedProperty)new SigningTime(new ConstraintSignPolicy.EncodingConstraint[0]));
        SignOptionsBuilder sob = new SignOptionsBuilder();
        sob.setPolicy((SignPolicy)AdESSignCreationPolicy.AdES_EN_B_B);
        sob.addSignerInfo(sib.build());
        if (Boolean.TRUE.equals(signFormular.createTimestamp()) && authService != null) {
            KeycloakDeployment keycloakDeployment = authService.getKeycloakDeployment();
            SignServiceKey.KeycloakHttpClient kac = new SignServiceKey.KeycloakHttpClient(SignerValidationProcessor.getInstance().getNewHttpClient());
            keycloakDeployment.setClient((HttpClient)kac);
            if (authService.getUsername() == null) {
                authService.requestUsernamePassword();
            }
            KeycloakAuthClient keycloakAuthClient = new KeycloakAuthClient(keycloakDeployment, authService.getUsername(), authService.getPassword());
            this.setTimestamp(sob, sib, keycloakAuthClient);
        }
        if (shouldCreatePDFInline = this.shouldCreatePDFInline(workingResult, pdfSignatureType = signFormular.getPDFSignatureType())) {
            LOG.trace("signPDF...");
            this.signPDF(signFormular, workingResult, resultFileName, sob);
            return;
        }
        if (shouldCreateXMLInline) {
            LOG.trace("signXML...");
            this.signXML(signFormular, workingResult, resultFileName, sob);
            return;
        }
        LOG.trace("signCMS...");
        this.signCMS(signFormular, workingResult, sob);
    }

    private String fetchAlgoIdSignature(KeyProvider keyProvider, boolean shouldCreateXMLInline) {
        String algoIdSignature = keyProvider.getSignatureAlgorithm();
        LOG.debug("algoIdSignature : {}", (Object)algoIdSignature);
        if (!(keyProvider instanceof SignServiceInterface)) {
            algoIdSignature = XMLOIDJCEAlgorithmMapper.getMapper().mapJCEAlgorithmXML(this.getSignatureAlgorithm(shouldCreateXMLInline, keyProvider.getSignatureAlgorithm()));
        }
        return algoIdSignature;
    }

    private PrivateKeyResource fetchPrivateKeyResource(KeyProvider keyProvider) throws IOException {
        PrivateKeyResource keyResource = keyProvider.getPrivateKeyResourceImpl();
        if (keyResource == null) {
            LOG.error("Schluessel ist null : {} ", (Object)keyProvider.getSelectedAlias());
            throw new IOException("Schluessel ist null : " + keyProvider.getSelectedAlias());
        }
        return keyResource;
    }

    private boolean shouldCreatePDFInline(WorkingResult workingResult, PDFSignatureType pdfSignatureType) {
        return PDFSignatureType.pdfInline.equals((Object)pdfSignatureType) && workingResult.getSourceFile().getName().toLowerCase().endsWith(".pdf");
    }

    private boolean shouldCreateXMLInline(WorkingResult workingResult, XMLSignatureType xmlSignatureType) {
        return XMLSignatureType.xmlInline.equals((Object)xmlSignatureType) && workingResult.getSourceFile().getName().toLowerCase().endsWith(".xml");
    }

    private void setTimestamp(SignOptionsBuilder sob, SignerInfoBuilder sib, final KeycloakAuthClient keycloakAuthClient) {
        AuthService authService = SignerValidationProcessor.getInstance().getAuthService();
        if (authService == null) {
            LOG.warn("AuthService is null");
            return;
        }
        final TimestampService timestampService = SignerValidationProcessor.getInstance().getTimestampService();
        if (timestampService == null) {
            LOG.warn("TimestampService is null");
            return;
        }
        LOG.info("TimestampService is required");
        SignatureTimestamp signatureTimestamp = new SignatureTimestamp("http://www.w3.org/2001/04/xmlenc#sha256");
        sib.addUnsignedProperty((UnsignedProperty)signatureTimestamp);
        TimestampServiceResourceReference tsrr = new TimestampServiceResourceReference("RemoteTimestampService", ResourceAreaType.REMOTE, TimestampServiceResource.class);
        TimestampServiceResource tsr = new TimestampServiceResource((ResourceReference)tsrr){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TimeStampToken getTimeStamp(String digestAlgorithmURI, byte[] digestValue) {
                ConnectServerWaitWindow waitWindow = new ConnectServerWaitWindow((Component)Document.getInstance().getFrame());
                waitWindow.showWindow();
                try {
                    TSPResponseData tsp = Sign.this.requestTSP(timestampService, keycloakAuthClient, digestValue);
                    TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(tsp.getTimestampedData()));
                    return timeStampToken;
                }
                catch (Exception e) {
                    Sign.this.closeWaitWindow(waitWindow);
                    LOG.error("show error : error.timestamp", (Throwable)e);
                    ErrorDialog.showDialog((Component)Sign.this.viewPanel, (String)"error.timestamp", (String)Messages.getString((String)"dialog.error.timestamp.message"), (String)timestampService.getUrl());
                    TimeStampToken timeStampToken = null;
                    return timeStampToken;
                }
                finally {
                    Sign.this.closeWaitWindow(waitWindow);
                }
            }
        };
        sob.setDefaultTimestampService((TimestampServiceResourceReferenceParameter)tsr);
    }

    private String getSignatureAlgorithm(boolean shouldCreateXMLInline, String signatureAlgorithm) {
        if (shouldCreateXMLInline && signatureAlgorithm.endsWith("ECDSA") && !signatureAlgorithm.endsWith("CVC-ECDSA")) {
            return signatureAlgorithm.replace("ECDSA", "CVC-ECDSA");
        }
        return signatureAlgorithm;
    }

    private void signPDF(SignFormular signFormular, WorkingResult workingResult, String resultFileName, SignOptionsBuilder sob) throws FileExistException, IOException, FileInUseException, CoreException {
        LOG.trace("");
        SignConfig signConfig = (SignConfig)this.parent.getConfig();
        SignatureFieldTemplate template = this.getPdfSignatureFieldTemplate(signFormular, signConfig);
        PDFSignOptionsImpl pdfOptions = null;
        DetachableFile sourceFile = workingResult.getSourceFile();
        if (template.useSignatureField()) {
            LOG.info("signature field is enabled");
            pdfOptions = new PDFSignOptionsImpl();
            PDFVisualSignatureDetails pdfVsdetails = template.getPDFOptions();
            pdfVsdetails.setInfoSettings(signConfig.getPdfSignatureInfo());
            pdfOptions.setVisualSignatureDetails(pdfVsdetails);
            this.setSignatureReason(pdfOptions, signFormular.getPDFSignatureReason());
            this.setSignatureLocation(pdfOptions, signFormular.getPDFSignatureLocation());
            String signatureField = this.getSelectedSignatureField((File)workingResult.getSourceFile());
            LOG.trace("signatureField: {}", (Object)signatureField);
            if (signatureField != null) {
                LOG.info("signatureField: {}", (Object)signatureField);
                pdfOptions.setSignatureFieldName(signatureField);
            } else {
                LOG.trace("Keine leere Signaturfelder gefunden bzw. Signaturfeld-Auswahl wurde abgebrochen.");
                if (!template.createSignatureField()) {
                    LOG.trace("... soll angelegt werden : false");
                    pdfOptions = new PDFSignOptionsImpl();
                    pdfOptions.setVisualSignatureDetails(null);
                    this.setSignatureReason(pdfOptions, signFormular.getPDFSignatureReason());
                    this.setSignatureLocation(pdfOptions, signFormular.getPDFSignatureLocation());
                } else {
                    LOG.trace("... soll angelegt werden : true");
                    PDFVisualSignatureDetails vsd = pdfOptions.getVisualSignatureDetails();
                    LOG.trace("Signaturfeld in config - X:Y - {}:{}", (Object)vsd.getPositionX(), (Object)vsd.getPositionY());
                    LOG.trace("Signaturfeld in config - h:w - {}:{}", (Object)vsd.getSignatureWidth(), (Object)vsd.getSignatureHeight());
                    PDFMetaData pdfMetaData = null;
                    try (FileInputStream fileInputStream = new FileInputStream(sourceFile.getAbsoluteFile());){
                        pdfMetaData = new PDFMetaData((InputStream)fileInputStream);
                        LOG.trace("PDF hat kein Passwortschutz, d.h. kann signiert werden : {}", (Object)(pdfMetaData != null ? 1 : 0));
                        int padeLastFirst = template.getPDFOptions().getPage();
                        int pdfPageNumber = padeLastFirst == 1 ? 0 : pdfMetaData.getPages().size() - 1;
                        Page page = (Page)pdfMetaData.getPages().get(pdfPageNumber);
                        pdfOptions = PdfUtils.transform(pdfOptions, page);
                        Utils.closeStream((Closeable)pdfMetaData);
                    }
                    catch (IOException e) {
                        LOG.error("get PDFMetaData failed : {}", (Object)e.getMessage());
                        LOG.error("", (Throwable)e);
                    }
                }
            }
        } else {
            LOG.trace("Keine Sichtbare Signaturfeld anlegen.");
            pdfOptions = new PDFSignOptionsImpl();
            pdfOptions.setVisualSignatureDetails(null);
            this.setSignatureReason(pdfOptions, signFormular.getPDFSignatureReason());
            this.setSignatureLocation(pdfOptions, signFormular.getPDFSignatureLocation());
        }
        LOG.info(resultFileName);
        File signedFile = SignFunction.getInstance().signPDF(Sign.getTempFolder(), (File)sourceFile, resultFileName, pdfOptions, sob);
        LOG.debug("signedFile: {}", (Object)signedFile);
        File resultFile = this.moveResultDocumentToTargetFolder(signFormular, (File)sourceFile, signedFile, true, false, false);
        workingResult.addResultFile(resultFile);
        workingResult.setCurrentState(WorkingResult.Status.FINISHED);
    }

    private void setSignatureReason(PDFSignOptionsImpl pdfOptions, String r) {
        if (r == null || r.isEmpty()) {
            pdfOptions.setSignerReason(null);
        } else {
            pdfOptions.setSignerReason(r);
        }
    }

    private void setSignatureLocation(PDFSignOptionsImpl pdfOptions, String r) {
        if (r == null || r.isEmpty()) {
            pdfOptions.setSignerLocation(null);
        } else {
            pdfOptions.setSignerLocation(r);
        }
    }

    private void signCMS(SignFormular signFormular, WorkingResult workingResult, SignOptionsBuilder sob) throws FileExistException, IOException, FileInUseException, CoreException {
        File copyOriginalDocument;
        boolean enveloped = signFormular.getSignatureType() == SignatureType.envelopedPKCS7;
        LOG.info("enveloped? {}", (Object)enveloped);
        DetachableFile sourceFile = workingResult.getSourceFile();
        File contentFile = null;
        ViewableProcessFile viewableProcessFile = workingResult.getProcessFile();
        if (viewableProcessFile instanceof ProcessSignedFile) {
            ProcessSignedFile processSignedFile = (ProcessSignedFile)viewableProcessFile;
            contentFile = processSignedFile.getDetachedFile();
        }
        LOG.info("SignFunction signCMS ...");
        File signedFile = SignFunction.getInstance().signCMS(Sign.getTempFolder(), (File)sourceFile, contentFile, enveloped, sob);
        LOG.info("SignFunction signCMS done ");
        File resultFile = this.moveResultDocumentToTargetFolder(signFormular, (File)sourceFile, signedFile, true, false, false, true, contentFile == null);
        workingResult.addResultFile(resultFile);
        if (!enveloped && (copyOriginalDocument = this.copyOriginalDocument(signFormular, (File)(contentFile == null ? workingResult.getSourceFile() : contentFile))) != null) {
            workingResult.addResultFile(copyOriginalDocument);
        }
        workingResult.setCurrentState(WorkingResult.Status.FINISHED);
    }

    private String getResultFileName(SignProcessFormular signFormular, WorkingResult workingResult) {
        PDFSignatureType pdfSignatureType = signFormular.getPDFSignatureType();
        boolean createPDFInline = this.shouldCreatePDFInline(workingResult, pdfSignatureType);
        XMLSignatureType xmlSignatureType = signFormular.getXMLSignatureType();
        boolean createXMLInline = this.shouldCreateXMLInline(workingResult, xmlSignatureType);
        Object resultFileName = workingResult.getSourceFile().getName();
        if (createPDFInline) {
            resultFileName = ((String)resultFileName).substring(0, ((String)resultFileName).lastIndexOf(".")) + "_signed.pdf";
            LOG.debug("Sign PADES ResultFileName : {}", resultFileName);
        } else if (createXMLInline) {
            resultFileName = ((String)resultFileName).substring(0, ((String)resultFileName).lastIndexOf(".")) + "_signed.xml";
            LOG.debug("Sign XADES ResultFileName : {}", resultFileName);
        } else {
            ProcessSignedFile processSignedFile;
            ViewableProcessFile viewableProcessFile = workingResult.getProcessFile();
            if (!(viewableProcessFile instanceof ProcessSignedFile) || (processSignedFile = (ProcessSignedFile)viewableProcessFile).getDetachedFile() == null) {
                resultFileName = (String)resultFileName + ".p7s";
                LOG.debug("Sign CADES ResultFileName : {}", resultFileName);
            } else {
                LOG.debug("unexpected ? ResultFileName : {}", resultFileName);
            }
        }
        return resultFileName;
    }

    public SubsequentProcess getDefaultSubsequentProcess() {
        return Config.getInstance().getSubsequentProcess(this.parent.getSubsequentProcessUID());
    }

    public void formularChanged(FormularChangedEvent event) {
        FormularChangedEvent newEvent = new FormularChangedEvent(event.allChangedFormularClasses);
        newEvent.addChangedFormular(this.stepName);
        super.formularChanged(newEvent);
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(Licence.Keys.general_actions_settings_subsequentprocess.toString(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/timestamp", LicenceTyp.enable);
        return processLicenceTypes;
    }

    private boolean checkedViewedFiles() {
        LicenceTyp visualizationLicence = Document.getInstance().getProductFunctions().getLicence("process/sign/options/visualization");
        if (visualizationLicence != null && visualizationLicence.useInProcess() && ((SignConfig)this.parent.getConfig()).isUseViewFile()) {
            int percent = ((SignConfig)this.parent.getConfig()).getPercentOfViewed();
            int seenFiles = 0;
            for (WorkingResult result : Document.getInstance().getWorkingResults()) {
                if (!result.getProcessFile().hasSeen()) continue;
                ++seenFiles;
            }
            if (!Document.getInstance().getWorkingResults().isEmpty()) {
                if ((seenFiles = seenFiles * 100 / Document.getInstance().getWorkingResults().size()) < percent) {
                    String message = MessageFormat.format(Messages.getString((String)"config.dialog.visualization.message"), percent);
                    Document.getInstance().showMessageDialogText((Component)Document.getInstance().getFrame(), message);
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    protected boolean checkResult(ResultInput resultInput) {
        return false;
    }

    private boolean canMoveToTargetFolder(SignFormular formular) {
        if (formular.getTargetFolderType() != TargetFolderType.oneSpecial) {
            return true;
        }
        if (Utils.canWrite((String)formular.getTargetFolder())) {
            return true;
        }
        Document documentInstance = Document.getInstance();
        documentInstance.reportError(ErrorCode.CANNOT_WRITE_TO_FOLDER, false, new Object[]{formular.getTargetFolder()});
        List workingResultList = documentInstance.getWorkingResults();
        for (WorkingResult workingResult : workingResultList) {
            workingResult.setErrorObject(documentInstance.getLastReportedErrorObject());
            workingResult.setCurrentState(WorkingResult.Status.ERROR);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private WorkingStep.Repeat canMoveToTargetFolder(SignFormular formular, WorkingResult workingResult, String resultFileName) {
        Sign.LOG.trace("");
        documentInstance = Document.getInstance();
        createDetached = SignatureType.detachedPKCS7.equals((Object)formular.getSignatureType());
        var8_6 = workingResult.getProcessFile();
        if (!(var8_6 instanceof ProcessSignedFile)) ** GOTO lbl-1000
        processSignedFile = (ProcessSignedFile)var8_6;
        if (processSignedFile.multipleCmsSignatures) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        multipleCmsSignatures = v0;
        sourceFile /* !! */  = workingResult.getSourceFile();
        if (multipleCmsSignatures) {
            sourceFile /* !! */  = ((ProcessSignedFile)workingResult.getProcessFile()).getDetachedFile();
        }
        Sign.LOG.debug("Sign ResultFileName : {}", (Object)resultFileName);
        currentRepeat = this.canMoveDocumentsToTargetFolder(formular.getTargetFolderType(), formular.getTargetFolder(), formular.getLocalCopyFolder(), (File)sourceFile /* !! */ , resultFileName, createDetached, multipleCmsSignatures);
        Sign.LOG.debug("Sign Repeat : {}", (Object)currentRepeat);
        if (WorkingStep.Repeat.CANCEL == currentRepeat || WorkingStep.Repeat.SKIP == currentRepeat || WorkingStep.Repeat.SKIP_ALL == currentRepeat) {
            workingResult.setCurrentState(WorkingResult.Status.ABORTED);
            Sign.LOG.trace("reportError ...");
            documentInstance.reportError(ErrorCode.FILE_CANCELLED, false, new Object[]{workingResult.getSourceFile()});
        }
        return currentRepeat;
    }

    private void finished(SubsequentProcess process, int errorCounter) {
        Document documentInstance = Document.getInstance();
        List workingResultList = documentInstance.getWorkingResults();
        documentInstance.notifyProgressListeners(ECardProgressListener.ProgressType.CALCULATE_HASH_FOR_SIGNATURE, 1);
        this.displayFinishDialog(true, errorCounter);
        this.state = WorkingStep.WorkingState.CALLING_SUBSEQUENT_PROCESS;
        if (process != null) {
            super.callSubsequentProcess(process);
        }
        this.state = WorkingStep.WorkingState.FINISHED;
        this.notifyProgressListener(null, workingResultList);
        this.notifyAllStateChangeListener(null, workingResultList);
        this.parent.isFinished(true);
    }

    private void reset() {
        this.lastRepeat = null;
        this.fullRepeat = null;
        Document.getInstance().resetLastErrorObject();
    }

    private SignatureFieldTemplate getPdfSignatureFieldTemplate(SignFormular signFormular, SignConfig signConfig) {
        SignatureFieldTemplate template = signFormular.getSelectedPdfTemplate();
        if (template == null) {
            template = new SignatureFieldTemplate(null, Messages.getString((String)"config.dialog.visualpdf.visualisation.template.none"));
        }
        LOG.info("Signaturfeld Template : {}", (Object)template.getName());
        try {
            template.load();
        }
        catch (IOException ex) {
            LOG.error("", (Throwable)ex);
        }
        if (template.isDummy()) {
            template.fillTemplateFromSignConfig(signConfig);
        }
        return template;
    }

    public TSPResponseData requestTSP(TimestampService timestampService, KeycloakAuthClient keycloak, byte[] hashed) throws SignerException {
        try {
            BoreumHttpClient httpClientTimestampService = SignerValidationProcessor.getInstance().getNewHttpClient();
            AuthenticatedTimestampServiceClient c = new AuthenticatedTimestampServiceClient(new URI(timestampService.getUrl()), (de.governikus.csl.transport.HttpClient)httpClientTimestampService, keycloak);
            return c.timestamp(hashed, timestampService.getProfileID(), true);
        }
        catch (CoreException | URISyntaxException | HttpResponseException ex) {
            AuthService authService = SignerValidationProcessor.getInstance().getAuthService();
            authService.setUsername(null);
            LOG.error("error while requestTSP : {}", (Object)ex.getMessage());
            throw new SignerException(ErrorCode.TIMESTAMP_SERVICE_ERROR, ex);
        }
    }

    private void closeWaitWindow(ConnectServerWaitWindow waitWindow) {
        if (waitWindow == null) {
            return;
        }
        waitWindow.closeWindow();
    }
}

