/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.control.step;

import de.bos_bremen.ecard.client.control.step.KeyProviderStep;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.KeyUsage;
import de.bos_bremen.ecard.client.model.ProcessPolicy;
import de.bos_bremen.ecard.client.model.formular.steps.SelectKeysFormular;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.gui.step.SelectKeysView;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectKeys
extends KeyProviderStep {
    private static final Logger LOG = LogManager.getLogger(SelectKeys.class);

    public SelectKeys() {
        super(StepFactory.StepName.selectkeys, KeyUsage.SIGN);
    }

    public void setJComponent() {
        this.viewPanel = new SelectKeysView(this);
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signaturelevel", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/software", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signservice", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/BNotK", LicenceTyp.enable);
        return processLicenceTypes;
    }

    public boolean setProcessFormular(StepFormular form) {
        if (!(form instanceof SelectKeysFormular)) {
            return false;
        }
        return super.setProcessFormular(form);
    }

    public String getSerialnumber() {
        SelectKeysFormular selectKeysFormular;
        String cardSerialnumber = this.getFromConfigCardProvider();
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SelectKeysFormular && (selectKeysFormular = (SelectKeysFormular)stepFormular).getSerialnumber() != null && !selectKeysFormular.getSerialnumber().trim().isEmpty()) {
            String serialnumberParam = selectKeysFormular.getSerialnumber();
            LOG.debug("serialnumber aus Request {}", (Object)serialnumberParam);
            return serialnumberParam;
        }
        LOG.debug("serialnumber aus Config : '{}'", (Object)(cardSerialnumber == null || cardSerialnumber.trim().isEmpty() ? " ist in Konfiguration nicht gespeichert." : cardSerialnumber));
        return cardSerialnumber;
    }

    public Path getSWkeyStore() {
        LOG.trace("");
        String keyStorePathString = this.getFromConfigSWProvider();
        if (keyStorePathString == null || keyStorePathString.trim().isEmpty()) {
            return null;
        }
        LOG.trace(keyStorePathString);
        Path keyStorePath = Path.of(keyStorePathString, new String[0]);
        LOG.trace("Path : {}", (Object)keyStorePath);
        LOG.debug("sign/selectkeys/keyprovider/_0/softwareKP : {}", keyStorePath == null ? " ist nicht konfiguriert." : keyStorePath);
        return keyStorePath;
    }

    public ProcessPolicy getProcessPolicy() {
        return Document.getInstance().getProcessPolicy();
    }
}

