/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.control.step;

import de.bos_bremen.ecard.client.control.step.SkippableStep;
import de.bos_bremen.ecard.client.control.step.StepFactory;
import de.bos_bremen.ecard.client.gui.GUIUtils;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.PDFSignatureType;
import de.bos_bremen.ecard.client.model.SignatureType;
import de.bos_bremen.ecard.client.model.XMLSignatureType;
import de.bos_bremen.ecard.client.model.formular.steps.StepFormular;
import de.bos_bremen.ecard.client.model.licence.LicenceTyp;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.gui.step.OptionsView;
import de.bos_bremen.ecard.client.sign.model.formular.steps.SignOptionFormular;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplate;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Options
extends SkippableStep {
    private static final String SIGNATURE_TYPE_KEY = "signatureType";
    private static final String PDFSIGNATURE_TYPE_KEY = "pdfSignatureType";
    private static final String XMLSIGNATURE_TYPE_KEY = "xmlSignatureType";
    private static final String EXTERNAL_TIME_STAMP_KEY = "isExternalTimeStamp";
    private static final String PDF_SIGNATURE_REASON_KEY = "pdfSignatureReason";
    private static final String PDF_SIGNATURE_LOCATION_KEY = "pdfSignatureLocation";
    private JComponent lastSelectedJComponent;

    public Options() {
        super(StepFactory.StepName.options);
    }

    public void setJComponent() {
        this.viewPanel = GUIUtils.createScrollPaneFor((JPanel)new OptionsView(this));
    }

    public SignatureType getSignatureType() {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            return signOptionFormular.getSignatureType();
        }
        return null;
    }

    public void setSignatureType(SignatureType signatureType) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            signOptionFormular.setSignatureType(signatureType);
        }
        this.stepProperties.put((Object)SIGNATURE_TYPE_KEY, (Object)(signatureType != null ? signatureType.toString() : SignatureType.envelopedPKCS7.toString()));
    }

    public void createTimestamp(boolean createTimestamp) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            signOptionFormular.createTimestamp(createTimestamp);
        }
        this.stepProperties.put((Object)EXTERNAL_TIME_STAMP_KEY, (Object)Boolean.toString(createTimestamp));
    }

    public boolean createTimestamp() {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            Boolean create = signOptionFormular.createTimestamp();
            return create != null && create != false;
        }
        return false;
    }

    public void setPDFSignatureType(PDFSignatureType pdfSignatureType) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            signOptionFormular.setPDFSignatureType(pdfSignatureType);
        }
        this.stepProperties.put((Object)PDFSIGNATURE_TYPE_KEY, (Object)pdfSignatureType.name());
    }

    public PDFSignatureType getPDFSignatureType() {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof SignOptionFormular)) {
            return PDFSignatureType.noPdfInline;
        }
        SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
        if (signOptionFormular.getPDFSignatureType() == null) {
            return signOptionFormular.getDefaultPDFSignatureType();
        }
        return signOptionFormular.getPDFSignatureType();
    }

    public void setXMLSignatureType(XMLSignatureType xmlSignatureType) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            signOptionFormular.setXMLSignatureType(xmlSignatureType);
        }
        this.stepProperties.put((Object)XMLSIGNATURE_TYPE_KEY, (Object)xmlSignatureType.name());
    }

    public XMLSignatureType getXMLSignatureType() {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof SignOptionFormular)) {
            return XMLSignatureType.noXmlInline;
        }
        SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
        if (signOptionFormular.getXMLSignatureType() == null) {
            return signOptionFormular.getDefaultXMLSignatureType();
        }
        return signOptionFormular.getXMLSignatureType();
    }

    public String getPDFSignatureReason() {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof SignOptionFormular)) {
            return "";
        }
        SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
        if (signOptionFormular.getPDFSignatureReason() == null) {
            return "";
        }
        return signOptionFormular.getPDFSignatureReason();
    }

    public void setPDFSignatureReason(String strings) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            signOptionFormular.setPDFSignatureReason(strings);
        }
        this.stepProperties.put((Object)PDF_SIGNATURE_REASON_KEY, (Object)(strings != null ? strings : ""));
    }

    public String getPDFSignatureLocation() {
        StepFormular stepFormular = this.form;
        if (!(stepFormular instanceof SignOptionFormular)) {
            return "";
        }
        SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
        if (signOptionFormular.getPDFSignatureLocation() == null) {
            return "";
        }
        return signOptionFormular.getPDFSignatureLocation();
    }

    public void setPDFSignatureLocation(String strings) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            signOptionFormular.setPDFSignatureLocation(strings);
        }
        this.stepProperties.put((Object)PDF_SIGNATURE_LOCATION_KEY, (Object)(strings != null ? strings : ""));
    }

    public boolean setProcessFormular(StepFormular form) {
        if (!(form instanceof SignOptionFormular)) {
            return false;
        }
        if (!super.setProcessFormular(form)) {
            return false;
        }
        this.form = form;
        SignOptionFormular signFormular = (SignOptionFormular)this.form;
        if (signFormular.createTimestamp() == null) {
            signFormular.createTimestamp(Boolean.parseBoolean(this.stepProperties.getProperty(EXTERNAL_TIME_STAMP_KEY, Boolean.toString(signFormular.getDefaultCreateTimestamp()))));
        }
        if (signFormular.getPDFSignatureType() == null) {
            String str = this.stepProperties.getProperty(PDFSIGNATURE_TYPE_KEY, signFormular.getDefaultPDFSignatureType().name());
            if ("automaticPdfInline".equalsIgnoreCase(str) || "advancedPdfInline".equalsIgnoreCase(str)) {
                str = PDFSignatureType.pdfInline.name();
            }
            signFormular.setPDFSignatureType(PDFSignatureType.valueOf((String)str));
        }
        if (signFormular.getXMLSignatureType() == null) {
            signFormular.setXMLSignatureType(XMLSignatureType.valueOf((String)this.stepProperties.getProperty(XMLSIGNATURE_TYPE_KEY, signFormular.getDefaultXMLSignatureType().name())));
        }
        if (signFormular.getSignatureType() == null) {
            signFormular.setSignatureType(SignatureType.valueOf((String)this.stepProperties.getProperty(SIGNATURE_TYPE_KEY, signFormular.getDefaultSignatureType().toString())));
        }
        if (signFormular.getPDFSignatureReason() == null) {
            signFormular.setPDFSignatureReason(this.stepProperties.getProperty(PDF_SIGNATURE_REASON_KEY, signFormular.getDefaultPDFSignatureReason()));
        }
        if (signFormular.getPDFSignatureLocation() == null) {
            signFormular.setPDFSignatureLocation(this.stepProperties.getProperty(PDF_SIGNATURE_LOCATION_KEY, signFormular.getDefaultPDFSignatureLocation()));
        }
        return true;
    }

    public boolean isStateComplete() {
        boolean timestampOK;
        boolean complete = false;
        boolean signTypeOK = false;
        SignatureType signatureType = this.getSignatureType();
        if (signatureType != null) {
            switch (signatureType) {
                case envelopedPKCS7: {
                    signTypeOK = Document.getInstance().getProductFunctions().getLicence(this.getLicenceTypKey() + "/signformat/pkcs7enveloped").useInProcess();
                    break;
                }
                case detachedPKCS7: {
                    signTypeOK = Document.getInstance().getProductFunctions().getLicence(this.getLicenceTypKey() + "/signformat/pkcs7detached").useInProcess();
                    break;
                }
                default: {
                    signTypeOK = false;
                }
            }
        }
        if (Document.getInstance().getProductFunctions().getLicence(this.getLicenceTypKey() + "/timestamp").useInProcess()) {
            SignConfig config = (SignConfig)this.getParent().getConfig();
            timestampOK = !this.createTimestamp() || config.isTimestampServiceSet();
        } else {
            this.createTimestamp(false);
            timestampOK = true;
        }
        if (Document.getInstance().getProductFunctions().getLicence(this.getLicenceTypKey()).useInProcess() && timestampOK && signTypeOK) {
            complete = true;
        }
        return complete;
    }

    public HashMap<String, LicenceTyp> getDefaultLicenceTypes() {
        HashMap<String, LicenceTyp> processLicenceTypes = new HashMap<String, LicenceTyp>();
        processLicenceTypes.put(this.getLicenceTypKey(), LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signformat", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signformat/pkcs7detached", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signformat/pdfinline", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signformat/osci", LicenceTyp.hide_disable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signformat/ubl", LicenceTyp.hide_disable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signformat/pkcs7enveloped", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/extended_pdfsignature", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/extended_pdfsignature/reason", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/timestamp", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/visualization", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/signservice", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/governikus", LicenceTyp.enable);
        processLicenceTypes.put(this.getLicenceTypKey() + "/BNotK", LicenceTyp.enable);
        return processLicenceTypes;
    }

    public JComponent getLastSelectedJComponent() {
        return this.lastSelectedJComponent;
    }

    public void setLastSelectedJComponent(JComponent lastSelectedJC) {
        this.lastSelectedJComponent = lastSelectedJC;
    }

    public void setSelectedPdfTemplate(SignatureFieldTemplate t) {
        StepFormular stepFormular = this.form;
        if (stepFormular instanceof SignOptionFormular) {
            SignOptionFormular signOptionFormular = (SignOptionFormular)stepFormular;
            signOptionFormular.setSelectedPdfTemplate(t);
        }
    }
}

