/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.control.process.impl;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.control.process.ProcessI;
import de.bos_bremen.ecard.client.control.process.ProcessName;
import de.bos_bremen.ecard.client.control.process.impl.Process;
import de.bos_bremen.ecard.client.control.step.Step;
import de.bos_bremen.ecard.client.gui.dialog.config.ProcessConfigComponent;
import de.bos_bremen.ecard.client.gui.dialog.config.components.ResetConfigPanel;
import de.bos_bremen.ecard.client.model.Document;
import de.bos_bremen.ecard.client.model.formular.process.ProcessFormular;
import de.bos_bremen.ecard.client.model.licence.ProductFunctions;
import de.bos_bremen.ecard.client.sign.control.process.impl.SignConfig;
import de.bos_bremen.ecard.client.sign.control.step.Options;
import de.bos_bremen.ecard.client.sign.control.step.SelectFiles;
import de.bos_bremen.ecard.client.sign.control.step.SelectKeys;
import de.bos_bremen.ecard.client.sign.control.step.SelectTargetDir;
import de.bos_bremen.ecard.client.sign.control.step.Sign;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.BNotKServerPanel;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.GovernikusServerPanel;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.SignResetPanel;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.VisualPDFPanel;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.VisualizationPanel;
import de.bos_bremen.ecard.client.sign.gui.view.component.table.AdvancedPDFPopUpMenu;
import de.bos_bremen.ecard.client.sign.model.formular.process.SignProcessFormular;
import de.bos_bremen.ecard.client.sign.model.formular.process.impl.SignFormular;
import de.bos_bremen.ecard.client.util.XMLProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignProcess
extends Process {
    private static final Logger LOG = LogManager.getLogger(SignProcess.class);
    public static final ProcessName PROCESS_NAME = new ProcessName("sign", 0);
    private SignConfig signConfig;
    private List<ProcessConfigComponent> processConfigComponent = null;

    public SignProcess() {
        super(null);
        this.getConfig();
        this.addStep(new SelectFiles());
        this.addStep((Step)new Options());
        this.addStep((Step)new SelectKeys());
        this.addStep((Step)new SelectTargetDir());
        this.addStep((Step)new Sign());
    }

    private void addConfigComponents() {
        this.processConfigComponent = new ArrayList<ProcessConfigComponent>();
        String licenceTypKey = "process/sign/options";
        ProductFunctions productFunctions = Document.getInstance().getProductFunctions();
        VisualizationPanel visuPanel = new VisualizationPanel((ProcessI)this, productFunctions.getLicence(licenceTypKey + "/visualization"));
        GovernikusServerPanel governikusServerPanel = new GovernikusServerPanel((ProcessI)this, productFunctions.getLicence(licenceTypKey + "/governikus"));
        BNotKServerPanel bNotKServerPanel = new BNotKServerPanel((ProcessI)this, productFunctions.getLicence(licenceTypKey + "/BNotK"));
        VisualPDFPanel visualPDFPanel = new VisualPDFPanel((ProcessI)this, productFunctions.getLicence(licenceTypKey + "/extended_pdfsignature"));
        this.processConfigComponent.add(visuPanel);
        this.processConfigComponent.add(governikusServerPanel);
        this.processConfigComponent.add(bNotKServerPanel);
        this.processConfigComponent.add(visualPDFPanel);
    }

    public ProcessName getProcessName() {
        return PROCESS_NAME;
    }

    public boolean startProcess(ProcessFormular processFormular) {
        LOG.info("Start Sign Process");
        super.startProcess(processFormular);
        if (!(processFormular instanceof SignProcessFormular)) {
            return false;
        }
        this.form = processFormular;
        return true;
    }

    protected boolean couldHideAfterProcess() {
        return true;
    }

    public boolean canOpenProcessFile() {
        return true;
    }

    public boolean canOpenResultFile() {
        return true;
    }

    public ProcessFormular createNewFormular() {
        return new SignFormular();
    }

    public ProcessFormular createNewFormular(ProcessFormular arg0) {
        ProcessFormular processFormular = this.form;
        if (processFormular instanceof SignFormular) {
            SignFormular signFormular = (SignFormular)processFormular;
            return new SignFormular(signFormular);
        }
        return new SignFormular();
    }

    public List<ProcessConfigComponent> getConfigComponents() {
        if (this.processConfigComponent == null) {
            this.addConfigComponents();
        }
        return this.processConfigComponent;
    }

    public ResetConfigPanel getResetConfigPanel() {
        return new SignResetPanel(this.getProcessName(), false);
    }

    public SignConfig getConfig() {
        if (this.signConfig == null) {
            this.signConfig = new SignConfig();
        }
        return this.signConfig;
    }

    public XMLProperties getProperties() {
        XMLProperties properties = super.getProperties();
        this.getConfig().store(properties);
        return properties;
    }

    public void setProperties(XMLProperties properties) {
        super.setProperties(properties);
        this.getConfig().load(properties);
    }

    public void addProcessRessourceBundle() {
        String bundleName = "de.bos_bremen.ecard.client.sign.sign";
        ResourceBundle signResourceBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        Messages.addResourceBundle((String)bundleName, (ResourceBundle)signResourceBundle);
    }

    public boolean canRunProcess() {
        return false;
    }

    public boolean canShowPopUpMenu() {
        return true;
    }

    public JPopupMenu getPopUpMenu(JTable table, File file) {
        if (file == null || !file.exists() || (double)file.length() == 0.0) {
            return null;
        }
        if (!file.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
            return null;
        }
        if (!Document.getInstance().getProductFunctions().getLicence("process/sign/options/extended_pdfsignature").isVisible()) {
            return null;
        }
        return new AdvancedPDFPopUpMenu(file, this.getProcessName());
    }
}

