/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign.control.process.impl;

import de.bos_bremen.ecard.client.control.process.ProcessConfigI;
import de.bos_bremen.ecard.client.model.keyprovider.CertificateQuality;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdf.PdfInfoSelector;
import de.bos_bremen.ecard.client.sign.gui.dialog.config.components.pdfsignature.PDFVisualisationTypEnum;
import de.bos_bremen.ecard.client.sign.template.SignatureFieldTemplate;
import de.bos_bremen.ecard.client.util.XMLProperties;
import de.governikus.csl.SignerValidationProcessor;
import de.governikus.csl.pdf.sign.PDFSignatureInfo;
import de.governikus.csl.pdf.sign.TextColor;
import de.governikus.csl.pdf.sign.TextFormatting;
import de.governikus.csl.pdf.sign.VisibleSignatureLayout;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.SignatureField;
import de.governikus.csl.pdf.sign.impl.visual.FontEnum;
import de.governikus.csl.server.AuthService;
import de.governikus.csl.server.BNotK;
import de.governikus.csl.server.SignService;
import de.governikus.csl.server.TimestampService;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignConfig
implements ProcessConfigI {
    private static final String PDF_SIGNATURE_INFO = "pdfSignatureInfo";
    private static final Logger LOG = LogManager.getLogger(SignConfig.class);
    private AuthService authService = new AuthService();
    private TimestampService timestampService = new TimestampService();
    private SignService signService = new SignService();
    private BNotK bNotK = new BNotK();
    private boolean useViewFile = false;
    private int percentOfViewed = 0;
    private PDFVisualisationTypEnum pdfSignatureExtentionVisualisationTyp = PDFVisualisationTypEnum.TEXT;
    private int pdfSignatureExtentionPage = 1;
    private FontEnum pdfSignatureExtentionFont = FontEnum.TIMES;
    private TextColor pdfSignatureExtentionTextColor = TextColor.Black;
    private TextFormatting pdfSignatureExtentionTextFormatting = TextFormatting.center;
    private boolean pdfSignatureExtentionPDFACompatibility = true;
    private int pdfSignatureExtentionFontSize = 16;
    private boolean pdfSignatureExtentionUseDynamicTextSize = true;
    private double pdfSignatureExtentionPositionX = 0.5;
    private double pdfSignatureExtentionPositionY = 0.2;
    private VisibleSignatureLayout pdfSignatureExtentionVisibleSignatureLayout = null;
    public static final String PDF_IMAGEFILE_CERT = "jar:file:/lib/boreum-framework.jar!/resources/certificate_128.png";
    private String pdfSignatureExtentionImageFile = "jar:file:/lib/boreum-framework.jar!/resources/certificate_128.png";
    private String pdfSignatureExtentionSignatureIssuer = "";
    private boolean pdfSignatureExtentionUseSignatureIssuer = true;
    private boolean pdfSignatureExtentionVisibleSignatureField = true;
    private boolean pdfSignatureExtentionCreateSignatureField = false;
    private double pdfSignatureExtentionVisualWidth = 5.0;
    private double pdfSignatureExtentionVisualHeight = 3.0;
    private double pdfSignatureExtentionImageRatio = 0.25;
    private boolean pdfSignatureExtentionUseDate = false;
    private String pdfSignatureExtentionDateFormat = "";
    private SignatureField selectedSignatureField = null;
    private boolean deleteSource = false;
    private CertificateQuality signatureLevel = CertificateQuality.indetermined;
    private List<PDFSignatureInfo> pdfSignatureInfo = PdfInfoSelector.getDefaultList();

    public boolean load(XMLProperties props) {
        LOG.trace("load root/process/sign...");
        if (props == null) {
            return false;
        }
        boolean returnValue = true;
        XMLProperties governikusSCProperties = props.getPropertiesForNode("governikus_sc");
        this.getGovernikusSCProperties((Properties)governikusSCProperties);
        XMLProperties bNotKProperties = props.getPropertiesForNode("BNotK");
        this.getBNotKProperties((Properties)bNotKProperties);
        XMLProperties pdfSignatureProperties = props.getPropertiesForNode("pdfSignatureExtention");
        this.getPdfSignatureProperties((Properties)pdfSignatureProperties);
        XMLProperties viewFileProperties = props.getPropertiesForNode("fileVisualization");
        this.getVisualisationProperties((Properties)viewFileProperties);
        this.deleteSource = Boolean.valueOf(props.getProperty("deleteSource", "false"));
        String value = props.getProperty("signatureLevel", CertificateQuality.indetermined.name());
        this.signatureLevel = CertificateQuality.valueOf((String)value);
        return returnValue;
    }

    private void getVisualisationProperties(Properties viewFileProperties) {
        if (viewFileProperties == null || viewFileProperties.isEmpty()) {
            this.setViewFileSettingsDefault();
            return;
        }
        if (viewFileProperties.getProperty("useVisualization") != null) {
            this.useViewFile = Boolean.parseBoolean(viewFileProperties.getProperty("useVisualization"));
        }
        if (viewFileProperties.getProperty("percent") != null) {
            try {
                this.percentOfViewed = Integer.parseInt(viewFileProperties.getProperty("percent"));
            }
            catch (NumberFormatException e) {
                LOG.debug(e.getMessage());
            }
        }
    }

    private void getGovernikusSCProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        this.authService.setUrl(properties.getProperty("authService", ""));
        this.authService.setRealm(properties.getProperty("authServiceRealm", ""));
        this.authService.setClient(properties.getProperty("authServiceClient", ""));
        this.authService.setSecret(properties.getProperty("authServiceSecret", ""));
        SignerValidationProcessor.getInstance().setAuthService(this.authService);
        this.timestampService.setUrl(properties.getProperty("timestampService", ""));
        this.timestampService.setProfileID(properties.getProperty("timestampServiceProfileID", ""));
        SignerValidationProcessor.getInstance().setTimestampService(this.timestampService);
        this.signService.setUrl(properties.getProperty("signService", ""));
        SignerValidationProcessor.getInstance().setSignService(this.signService);
    }

    private void getBNotKProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        this.bNotK.setIdProviderInitialUrl(properties.getProperty("idProviderInitialUrl", ""));
        this.bNotK.setIdProviderAugmentedUrl(properties.getProperty("idProviderAugmentedUrl", ""));
        this.bNotK.setKeyManagerUrl(properties.getProperty("keyManagerUrl", ""));
        this.bNotK.setSignServerUrl(properties.getProperty("signServerUrl", ""));
        SignerValidationProcessor.getInstance().setBNotK(this.bNotK);
    }

    private void getPdfSignatureProperties(Properties pdfSignatureProperties) {
        if (pdfSignatureProperties == null || pdfSignatureProperties.isEmpty()) {
            this.setPDFSignDefault();
            return;
        }
        if (pdfSignatureProperties.getProperty(PDF_SIGNATURE_INFO) != null) {
            try {
                String temp = pdfSignatureProperties.getProperty(PDF_SIGNATURE_INFO);
                this.pdfSignatureInfo = PdfInfoSelector.fromString(temp);
                LOG.info("{} = {}", (Object)PDF_SIGNATURE_INFO, this.pdfSignatureInfo);
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (pdfSignatureProperties.getProperty("visualisationTyp") != null) {
            try {
                this.pdfSignatureExtentionVisualisationTyp = PDFVisualisationTypEnum.valueOf(pdfSignatureProperties.getProperty("visualisationTyp"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (pdfSignatureProperties.getProperty("page") != null) {
            try {
                this.pdfSignatureExtentionPage = Integer.parseInt(pdfSignatureProperties.getProperty("page"));
            }
            catch (NumberFormatException e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("textFont") != null) {
            try {
                this.pdfSignatureExtentionFont = FontEnum.valueOf((String)((String)pdfSignatureProperties.get("textFont")));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("textColor") != null) {
            try {
                this.pdfSignatureExtentionTextColor = TextColor.valueOf((String)((String)pdfSignatureProperties.get("textColor")));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("pdfACompatibility") != null) {
            try {
                this.pdfSignatureExtentionPDFACompatibility = Boolean.valueOf((String)pdfSignatureProperties.get("pdfACompatibility"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("textSize") != null) {
            try {
                this.pdfSignatureExtentionFontSize = Integer.parseInt((String)pdfSignatureProperties.get("textSize"));
            }
            catch (NumberFormatException e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("useDynamicTextSize") != null) {
            try {
                this.pdfSignatureExtentionUseDynamicTextSize = Boolean.valueOf((String)pdfSignatureProperties.get("useDynamicTextSize"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("textFormatting") != null) {
            try {
                this.pdfSignatureExtentionTextFormatting = TextFormatting.valueOf((String)((String)pdfSignatureProperties.get("textFormatting")));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("positionX") != null) {
            try {
                this.pdfSignatureExtentionPositionX = Double.valueOf((String)pdfSignatureProperties.get("positionX"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("positionY") != null) {
            try {
                this.pdfSignatureExtentionPositionY = Double.valueOf((String)pdfSignatureProperties.get("positionY"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (pdfSignatureProperties.getProperty("visualWidth") != null) {
            try {
                this.pdfSignatureExtentionVisualWidth = Double.valueOf(pdfSignatureProperties.getProperty("visualWidth"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (pdfSignatureProperties.getProperty("visualHeight") != null) {
            try {
                this.pdfSignatureExtentionVisualHeight = Double.valueOf(pdfSignatureProperties.getProperty("visualHeight"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (pdfSignatureProperties.getProperty("imageRatio") != null) {
            try {
                this.pdfSignatureExtentionImageRatio = Double.valueOf(pdfSignatureProperties.getProperty("imageRatio"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("visibleSignatureLayout") != null) {
            try {
                this.pdfSignatureExtentionVisibleSignatureLayout = VisibleSignatureLayout.valueOf((String)((String)pdfSignatureProperties.get("visibleSignatureLayout")));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("imagefile") != null) {
            try {
                this.pdfSignatureExtentionImageFile = (String)pdfSignatureProperties.get("imagefile");
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("signatureIssuer") != null) {
            try {
                this.pdfSignatureExtentionSignatureIssuer = (String)pdfSignatureProperties.get("signatureIssuer");
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("useSignatureIssuer") != null) {
            try {
                this.pdfSignatureExtentionUseSignatureIssuer = Boolean.valueOf((String)pdfSignatureProperties.get("useSignatureIssuer"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("useDynamicPdfSignature") != null) {
            try {
                this.pdfSignatureExtentionVisibleSignatureField = Boolean.parseBoolean((String)pdfSignatureProperties.get("useDynamicPdfSignature"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("createSignatureField") != null) {
            try {
                this.pdfSignatureExtentionCreateSignatureField = Boolean.parseBoolean((String)pdfSignatureProperties.get("createSignatureField"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("useDate") != null) {
            try {
                this.pdfSignatureExtentionUseDate = Boolean.valueOf((String)pdfSignatureProperties.get("useDate"));
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if ((String)pdfSignatureProperties.get("dateFormat") != null) {
            try {
                this.pdfSignatureExtentionDateFormat = (String)pdfSignatureProperties.get("dateFormat");
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
    }

    public void store(XMLProperties props) {
        LOG.trace("store SignConfig in root/process/sign");
        XMLProperties governikusSCProperties = new XMLProperties();
        governikusSCProperties.setProperty("authService", this.authService.getUrl() != null ? this.authService.getUrl() : "");
        governikusSCProperties.setProperty("authServiceRealm", this.authService.getRealm() != null ? this.authService.getRealm() : "");
        governikusSCProperties.setProperty("authServiceClient", this.authService.getClient() != null ? this.authService.getClient() : "");
        governikusSCProperties.setProperty("authServiceSecret", this.authService.getSecret() != null ? this.authService.getSecret() : "");
        governikusSCProperties.setProperty("signService", this.signService.getUrl() != null ? this.signService.getUrl() : "");
        governikusSCProperties.setProperty("timestampService", this.timestampService.getUrl() != null ? this.timestampService.getUrl() : "");
        governikusSCProperties.setProperty("timestampServiceProfileID", this.timestampService.getProfileID() != null ? this.timestampService.getProfileID() : "");
        props.addAll("governikus_sc", (Properties)governikusSCProperties);
        XMLProperties bNotKProperties = new XMLProperties();
        bNotKProperties.setProperty("idProviderInitialUrl", this.bNotK.getIdProviderInitialUrl() != null ? this.bNotK.getIdProviderInitialUrl() : "");
        bNotKProperties.setProperty("idProviderAugmentedUrl", this.bNotK.getIdProviderAugmentedUrl() != null ? this.bNotK.getIdProviderAugmentedUrl() : "");
        bNotKProperties.setProperty("keyManagerUrl", this.bNotK.getKeyManagerUrl() != null ? this.bNotK.getKeyManagerUrl() : "");
        bNotKProperties.setProperty("signServerUrl", this.bNotK.getSignServerUrl() != null ? this.bNotK.getSignServerUrl() : "");
        props.addAll("BNotK", (Properties)bNotKProperties);
        XMLProperties pdfSignatureProperties = new XMLProperties();
        pdfSignatureProperties.setProperty("visualisationTyp", this.pdfSignatureExtentionVisualisationTyp.toString());
        pdfSignatureProperties.setProperty("page", "" + this.pdfSignatureExtentionPage);
        pdfSignatureProperties.setProperty("textFont", this.pdfSignatureExtentionFont != null ? this.pdfSignatureExtentionFont.toString() : "");
        pdfSignatureProperties.setProperty("textColor", this.pdfSignatureExtentionTextColor != null ? this.pdfSignatureExtentionTextColor.toString() : "");
        pdfSignatureProperties.setProperty("pdfACompatibility", "" + this.pdfSignatureExtentionPDFACompatibility);
        pdfSignatureProperties.setProperty("textSize", "" + this.pdfSignatureExtentionFontSize);
        pdfSignatureProperties.setProperty("useDynamicTextSize", "" + this.pdfSignatureExtentionUseDynamicTextSize);
        pdfSignatureProperties.setProperty("textFormatting", this.pdfSignatureExtentionTextFormatting != null ? this.pdfSignatureExtentionTextFormatting.toString() : "");
        pdfSignatureProperties.setProperty("positionX", "" + this.pdfSignatureExtentionPositionX);
        pdfSignatureProperties.setProperty("positionY", "" + this.pdfSignatureExtentionPositionY);
        pdfSignatureProperties.setProperty("visualHeight", "" + this.pdfSignatureExtentionVisualHeight);
        pdfSignatureProperties.setProperty("visualWidth", "" + this.pdfSignatureExtentionVisualWidth);
        pdfSignatureProperties.setProperty("imageRatio", "" + this.pdfSignatureExtentionImageRatio);
        pdfSignatureProperties.setProperty("visibleSignatureLayout", this.pdfSignatureExtentionVisibleSignatureLayout != null ? this.pdfSignatureExtentionVisibleSignatureLayout.name() : "");
        pdfSignatureProperties.setProperty("imagefile", this.pdfSignatureExtentionImageFile != null ? this.pdfSignatureExtentionImageFile : PDF_IMAGEFILE_CERT);
        pdfSignatureProperties.setProperty("signatureIssuer", this.pdfSignatureExtentionSignatureIssuer != null ? this.pdfSignatureExtentionSignatureIssuer : "");
        pdfSignatureProperties.setProperty("useSignatureIssuer", "" + this.pdfSignatureExtentionUseSignatureIssuer);
        pdfSignatureProperties.setProperty("useDynamicPdfSignature", "" + this.pdfSignatureExtentionVisibleSignatureField);
        pdfSignatureProperties.setProperty("createSignatureField", "" + this.pdfSignatureExtentionCreateSignatureField);
        pdfSignatureProperties.setProperty("useDate", "" + this.pdfSignatureExtentionUseDate);
        pdfSignatureProperties.setProperty("dateFormat", this.pdfSignatureExtentionDateFormat != null ? this.pdfSignatureExtentionDateFormat : "");
        pdfSignatureProperties.setProperty(PDF_SIGNATURE_INFO, this.pdfSignatureInfo != null ? PdfInfoSelector.toConfigString(this.pdfSignatureInfo) : "");
        props.addAll("pdfSignatureExtention", (Properties)pdfSignatureProperties);
        XMLProperties viewFileProperties = new XMLProperties();
        viewFileProperties.setProperty("useVisualization", Boolean.toString(this.useViewFile));
        viewFileProperties.setProperty("percent", "" + this.percentOfViewed);
        props.addAll("fileVisualization", (Properties)viewFileProperties);
        props.setProperty("deleteSource", Boolean.toString(this.deleteSource));
        props.setProperty("signatureLevel", this.signatureLevel.name());
        LOG.trace("");
    }

    public boolean isUseViewFile() {
        return this.useViewFile;
    }

    public void setUseViewFile(boolean useViewFile) {
        this.useViewFile = useViewFile;
    }

    public void setPercentOfViewed(int percent) {
        this.percentOfViewed = percent;
    }

    public int getPercentOfViewed() {
        return this.percentOfViewed;
    }

    public void setAuthService(String url, String realm, String client, String secret) {
        this.authService.setUrl(url);
        this.authService.setRealm(realm);
        this.authService.setClient(client);
        this.authService.setSecret(secret);
        SignerValidationProcessor.getInstance().setAuthService(this.authService);
    }

    public AuthService getAuthService() {
        return this.authService;
    }

    public void setSignService(String url) {
        this.signService.setUrl(url);
    }

    public SignService getSignService() {
        return this.signService;
    }

    public TimestampService getTimestampService() {
        return this.timestampService;
    }

    public void setTimestampService(String url, String profile) {
        this.timestampService.setUrl(url);
        this.timestampService.setProfileID(profile);
        SignerValidationProcessor.getInstance().setTimestampService(this.timestampService);
    }

    public boolean isTimestampServiceSet() {
        return this.timestampService.isValid();
    }

    public void setBNotK(BNotK bNotK) {
        this.bNotK = bNotK;
        SignerValidationProcessor.getInstance().setBNotK(bNotK);
    }

    public BNotK getBNotK() {
        return this.bNotK;
    }

    public PDFVisualisationTypEnum getPdfSignatureExtentionVisualisationTyp() {
        return this.pdfSignatureExtentionVisualisationTyp;
    }

    public void setPdfSignatureExtentionVisualisationTyp(PDFVisualisationTypEnum pdfSignatureExtentionVisualisationTyp) {
        this.pdfSignatureExtentionVisualisationTyp = pdfSignatureExtentionVisualisationTyp;
    }

    public int getPdfSignatureExtentionPage() {
        return this.pdfSignatureExtentionPage;
    }

    public void setPdfSignatureExtentionPage(int pdfSignatureExtentionPage) {
        this.pdfSignatureExtentionPage = pdfSignatureExtentionPage;
    }

    public FontEnum getPdfSignatureExtentionFont() {
        return this.pdfSignatureExtentionFont;
    }

    public void setPdfSignatureExtentionFont(FontEnum pdfSignatureExtentionFont) {
        this.pdfSignatureExtentionFont = pdfSignatureExtentionFont;
    }

    public int getPdfSignatureExtentionFontSize() {
        return this.pdfSignatureExtentionFontSize;
    }

    public void setPdfSignatureExtentionFontSize(int pdfSignatureExtentionFontSize) {
        this.pdfSignatureExtentionFontSize = pdfSignatureExtentionFontSize;
    }

    public boolean useDynamicTextSize() {
        return this.pdfSignatureExtentionUseDynamicTextSize;
    }

    public void useDynamicTextSize(boolean pdfSignatureExtentionUseDynamicTextSize) {
        this.pdfSignatureExtentionUseDynamicTextSize = pdfSignatureExtentionUseDynamicTextSize;
    }

    public TextColor getPdfSignatureExtentionTextColor() {
        return this.pdfSignatureExtentionTextColor;
    }

    public void setPdfSignatureExtentionTextColor(TextColor pdfSignatureExtentionTextColor) {
        this.pdfSignatureExtentionTextColor = pdfSignatureExtentionTextColor;
    }

    public double getPdfSignatureExtentionPositionX() {
        return this.pdfSignatureExtentionPositionX;
    }

    public void setPdfSignatureExtentionPositionX(double pdfSignatureExtentionCreateSignatureField) {
        this.pdfSignatureExtentionPositionX = pdfSignatureExtentionCreateSignatureField;
    }

    public double getPdfSignatureExtentionPositionY() {
        return this.pdfSignatureExtentionPositionY;
    }

    public void setPdfSignatureExtentionPositionY(double pdfSignatureExtentionPositionY) {
        this.pdfSignatureExtentionPositionY = pdfSignatureExtentionPositionY;
    }

    public double getPdfSignatureExtentionVisualWidth() {
        return this.pdfSignatureExtentionVisualWidth;
    }

    public void setPdfSignatureExtentionVisualWidth(double pdfSignatureExtentionVisualWidth) {
        this.pdfSignatureExtentionVisualWidth = pdfSignatureExtentionVisualWidth;
    }

    public double getPdfSignatureExtentionVisualHeight() {
        return this.pdfSignatureExtentionVisualHeight;
    }

    public void setPdfSignatureExtentionVisualHeight(double pdfSignatureExtentionVisualHeight) {
        this.pdfSignatureExtentionVisualHeight = pdfSignatureExtentionVisualHeight;
    }

    public double getPdfSignatureExtentionImageRatio() {
        return this.pdfSignatureExtentionImageRatio;
    }

    public void setPdfSignatureExtentionImageRatio(double pdfSignatureExtentionImageRatio) {
        this.pdfSignatureExtentionImageRatio = pdfSignatureExtentionImageRatio;
    }

    public TextFormatting getPdfSignatureExtentionTextFormatting() {
        return this.pdfSignatureExtentionTextFormatting;
    }

    public void setPdfSignatureExtentionTextFormatting(TextFormatting pdfSignatureExtentionTextFormatting) {
        this.pdfSignatureExtentionTextFormatting = pdfSignatureExtentionTextFormatting;
    }

    public VisibleSignatureLayout getPdfSignatureExtentionVisibleSignatureLayout() {
        return this.pdfSignatureExtentionVisibleSignatureLayout;
    }

    public void setPdfSignatureExtentionVisibleSignatureLayout(VisibleSignatureLayout pdfSignatureExtentionVisibleSignatureLayout) {
        this.pdfSignatureExtentionVisibleSignatureLayout = pdfSignatureExtentionVisibleSignatureLayout;
    }

    public String getPdfSignatureExtentionImageFile() {
        return this.pdfSignatureExtentionImageFile;
    }

    public void setPdfSignatureExtentionImageFile(String pdfSignatureExtentionImageFile) {
        this.pdfSignatureExtentionImageFile = pdfSignatureExtentionImageFile;
    }

    public String getPdfSignatureExtentionSignatureIssuer() {
        return this.pdfSignatureExtentionSignatureIssuer;
    }

    public void setPdfSignatureExtentionSignatureIssuer(String pdfSignatureExtentionSignatureIssuer) {
        this.pdfSignatureExtentionSignatureIssuer = pdfSignatureExtentionSignatureIssuer;
    }

    public boolean useSignatureIssuer() {
        return this.pdfSignatureExtentionUseSignatureIssuer;
    }

    public void useSignatureIssuer(boolean useSignatureIssuer) {
        this.pdfSignatureExtentionUseSignatureIssuer = useSignatureIssuer;
    }

    public boolean useDate() {
        return this.pdfSignatureExtentionUseDate;
    }

    public void useDate(boolean useDate) {
        this.pdfSignatureExtentionUseDate = useDate;
    }

    public String getPdfSignatureExtentionDateFormat() {
        return this.pdfSignatureExtentionDateFormat;
    }

    public void setPdfSignatureExtentionDateFormat(String pdfSignatureExtentionDateFormat) {
        this.pdfSignatureExtentionDateFormat = pdfSignatureExtentionDateFormat;
    }

    public boolean getPdfSignatureExtentionPdfACompatibility() {
        return this.pdfSignatureExtentionPDFACompatibility;
    }

    public void setPdfSignatureExtentionPdfACompatibility(boolean pdfACompatibility) {
        this.pdfSignatureExtentionPDFACompatibility = pdfACompatibility;
    }

    public SignatureField getSelectedSignatureField() {
        return this.selectedSignatureField;
    }

    public void setSelectedSignatureField(SignatureField selectedSignatureField) {
        this.selectedSignatureField = selectedSignatureField;
    }

    public boolean visibleSignatureField() {
        return this.pdfSignatureExtentionVisibleSignatureField;
    }

    public void setUseDynamicPdfSignatureExtention(boolean pdfSignatureExtentionVisibleSignatureField) {
        this.pdfSignatureExtentionVisibleSignatureField = pdfSignatureExtentionVisibleSignatureField;
    }

    public boolean createSignatureField() {
        return this.pdfSignatureExtentionCreateSignatureField;
    }

    public void setCreateSignatureField(boolean pdfSignatureExtentionCreateSignatureField) {
        this.pdfSignatureExtentionCreateSignatureField = pdfSignatureExtentionCreateSignatureField;
    }

    public boolean useDeleteSource() {
        return this.deleteSource;
    }

    public void useDeleteSource(boolean deleteSource) {
        this.deleteSource = deleteSource;
    }

    public CertificateQuality getSignatureLevel() {
        return this.signatureLevel;
    }

    public void setSignatureLevel(CertificateQuality sl) {
        this.signatureLevel = sl;
    }

    public List<PDFSignatureInfo> getPdfSignatureInfo() {
        return this.pdfSignatureInfo;
    }

    public void setPdfSignatureInfo(List<PDFSignatureInfo> pdfSignatureInfo) {
        this.pdfSignatureInfo = pdfSignatureInfo;
    }

    public void loadPdfSignatureExtentionInTemplate(SignatureFieldTemplate template) throws IOException {
        template.load();
        template.fillSignConfigFromTemplate(this);
    }

    public void storePdfSignatureExtentionInTemplate(SignatureFieldTemplate template) {
        template.fillTemplateFromSignConfig(this);
        template.store();
    }

    private void setViewFileSettingsDefault() {
        this.useViewFile = false;
        this.percentOfViewed = 0;
    }

    private void setPDFSignDefault() {
        this.pdfSignatureExtentionVisualisationTyp = PDFVisualisationTypEnum.TEXT;
        this.pdfSignatureExtentionPage = 1;
        this.pdfSignatureExtentionFont = FontEnum.TIMES;
        this.pdfSignatureExtentionTextColor = TextColor.Black;
        this.pdfSignatureExtentionTextFormatting = TextFormatting.center;
        this.pdfSignatureExtentionPDFACompatibility = true;
        this.pdfSignatureExtentionFontSize = 16;
        this.pdfSignatureExtentionUseDynamicTextSize = true;
        this.pdfSignatureExtentionPositionX = 0.5;
        this.pdfSignatureExtentionPositionY = 0.2;
        this.pdfSignatureExtentionVisibleSignatureLayout = null;
        this.pdfSignatureExtentionImageFile = PDF_IMAGEFILE_CERT;
        this.pdfSignatureExtentionSignatureIssuer = "";
        this.pdfSignatureExtentionUseSignatureIssuer = true;
        this.pdfSignatureExtentionVisibleSignatureField = true;
        this.pdfSignatureExtentionCreateSignatureField = false;
        this.pdfSignatureExtentionVisualWidth = 5.0;
        this.pdfSignatureExtentionVisualHeight = 3.0;
        this.pdfSignatureExtentionImageRatio = 0.25;
        this.pdfSignatureExtentionUseDate = false;
        this.pdfSignatureExtentionDateFormat = "";
        this.selectedSignatureField = null;
        this.deleteSource = false;
        this.signatureLevel = CertificateQuality.indetermined;
        this.pdfSignatureInfo = PdfInfoSelector.getDefaultList();
    }
}

