/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.sign;

import de.bos_bremen.ecard.client.Messages;
import de.bos_bremen.ecard.client.Utils;
import de.bos_bremen.ecard.client.sign.BoreumInstanceProvider;
import de.governikus.base.validators.signature.cms.CMSSignatureValidator;
import de.governikus.base.validators.signature.core.SignatureValidatorResult;
import de.governikus.csl.SignerTempDataManager;
import de.governikus.csl.cms.sign.doc.impl.CMSDetachedSignedDocumentImpl;
import de.governikus.csl.cms.sign.impl.CMSSignPluginImpl;
import de.governikus.csl.pdf.sign.PDFSignOptions;
import de.governikus.csl.pdf.sign.PDFVisualSignatureDetails;
import de.governikus.csl.pdf.sign.impl.PDFSignOptionsImpl;
import de.governikus.csl.pdf.sign.impl.pdfbox.PDFSignPluginImpl;
import de.governikus.csl.sign.SignedDocument;
import de.governikus.csl.sign.impl.DetachedSignedDocumentWithContentDocumentImpl;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.core.SignatureRequest;
import de.governikus.csl.uom.core.SignedDataResponseImpl;
import de.governikus.csl.uom.core.impl.DataToBeSignedImpl;
import de.governikus.csl.uom.docs.StreamDocument;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.impl.UnparsedDocument;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.sign.ades.AdESSignCreationPolicy;
import de.governikus.csl.uom.sign.impl.SignOptionsBuilder;
import de.governikus.csl.uom.sign.impl.SignerInfoImpl;
import de.governikus.csl.uom.sign.props.PDFSignerReason;
import de.governikus.csl.uom.sign.props.ProductionPlace;
import de.governikus.csl.uom.util.Environment;
import de.governikus.csl.uom.util.SimpleDataHandler;
import de.governikus.csl.xml.sign.impl.XMLSignPluginImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;

public class SignFunction {
    private static final String TEXT_PLAIN = "text/plain";
    private static final Logger LOG = LogManager.getLogger(SignFunction.class);
    private static SignFunction instance;
    private static BoreumInstanceProvider boreumInstanceProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignFunction getInstance() {
        Class<SignFunction> clazz = SignFunction.class;
        synchronized (SignFunction.class) {
            if (instance == null) {
                instance = new SignFunction();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File signCMS(File tempFolder, File file, File contentFile, boolean enveloped, SignOptionsBuilder sob) throws IOException, CoreException {
        File file2;
        LOG.info("file to sign: {}", (Object)file.getName());
        LOG.info("contentFile:  {}", (Object)(contentFile == null ? "kein" : contentFile.getName()));
        FileInputStream is = null;
        try {
            File resultFile = File.createTempFile("signedFile", ".p7s", tempFolder);
            resultFile.deleteOnExit();
            LOG.debug("temp signedFile try : {}", (Object)resultFile);
            StreamDocument sdoc = null;
            SignRequest signRequest = null;
            if (contentFile == null) {
                is = new FileInputStream(file);
                sdoc = new StreamDocument("id", file.getName(), (InputStream)is, TEXT_PLAIN);
                signRequest = this.createCMSSignRequest(sdoc, enveloped, sob);
            } else {
                FileDocumentImpl fdi = new FileDocumentImpl(contentFile, "id");
                signRequest = this.createCMSMultipleSignRequest(file, fdi, enveloped, sob);
            }
            CMSSignPluginImpl plugin = new CMSSignPluginImpl();
            SignedDataResponse sign = plugin.sign(signRequest, (Environment)SignerTempDataManager.getInstance().getEnviromentImpl());
            SignedDataResponseImpl response = (SignedDataResponseImpl)sign;
            SignedData signedData = response.getSignedData();
            Document signature = signedData.getSignature();
            try (InputStream fis = Files.newInputStream(contentFile == null ? file.toPath() : contentFile.toPath(), new OpenOption[0]);){
                SignatureValidatorResult result = CMSSignatureValidator.validateCmsSignature(signature.getInputStream(), fis);
                if (result != SignatureValidatorResult.VALID) {
                    LOG.error("CmsSignature ist: {}", (Object)result);
                    throw new CoreException(MessageFormat.format(Messages.getString((String)"step.sign.csm.signature.is.invalid"), "SignatureValidatorResult." + result));
                }
                LOG.info("CmsSignature ist: {}", (Object)result);
            }
            try (FileOutputStream signedContent = new FileOutputStream(resultFile);){
                InputStream is2 = signature.getInputStream();
                SignFunction.handleContent(is2, signedContent);
            }
            LOG.debug("temp signedFile done : {}", (Object)resultFile);
            file2 = resultFile;
        }
        catch (Throwable throwable) {
            Utils.closeStream(is);
            throw throwable;
        }
        Utils.closeStream((Closeable)is);
        return file2;
    }

    public File signPDF(File tempFolder, File source, String resultFileName, PDFSignOptionsImpl pdfSignOptions, SignOptionsBuilder sob) throws IOException, CoreException {
        LOG.trace("");
        File signedFile = new File(tempFolder, resultFileName);
        LOG.debug("temp signedFile try... : {}", (Object)signedFile);
        try (FileInputStream is = new FileInputStream(source);){
            StreamDocument sdoc = new StreamDocument("id", source.getName(), (InputStream)is, TEXT_PLAIN);
            PDFVisualSignatureDetails visualSignatureDetails = pdfSignOptions.getVisualSignatureDetails();
            LOG.trace("\n\t InfoSettings : {}", visualSignatureDetails == null ? "keine" : visualSignatureDetails.getInfoSettings());
            SignRequest signRequest = this.createPDFSignRequest(sdoc, (PDFSignOptions)pdfSignOptions, sob);
            PDFSignPluginImpl plugin = new PDFSignPluginImpl();
            plugin.initialize((InstanceProvider)boreumInstanceProvider);
            LOG.trace("PDFSignPlugin sign ...");
            SignedDataResponse sign = plugin.sign(signRequest, (Environment)SignerTempDataManager.getInstance().getEnviromentImpl());
            LOG.trace("PDFSignPlugin sign done");
            SignedDataResponseImpl response = (SignedDataResponseImpl)sign;
            SignedData signedData = response.getSignedData();
            Document signature = signedData.getSignature();
            try (FileOutputStream fos = new FileOutputStream(signedFile);
                 InputStream is2 = signature.getInputStream();){
                Utils.toOutputStream((InputStream)is2, (OutputStream)fos);
            }
            LOG.debug("signedFile done : {}", (Object)signedFile);
            File file = signedFile;
            return file;
        }
    }

    private SignRequest createCMSMultipleSignRequest(File signature, FileDocumentImpl sdoc, boolean enveloped, SignOptionsBuilder sob) throws FileNotFoundException, CoreException {
        HashSet<Class> inputDocumentClasses = new HashSet<Class>();
        inputDocumentClasses.add(StreamDocument.class);
        inputDocumentClasses.add(UnparsedDocument.class);
        CMSDetachedSignedDocumentImpl detachedSignatureDocument1 = new CMSDetachedSignedDocumentImpl((DataHandler)new SimpleDataHandler((InputStream)new FileInputStream(signature), "application/pkcs7-signature"));
        DetachedSignedDocumentWithContentDocumentImpl d2 = null;
        try {
            d2 = new DetachedSignedDocumentWithContentDocumentImpl((SignedDocument)detachedSignatureDocument1, (Document)sdoc);
        }
        catch (IllegalArgumentException iae) {
            throw new CoreException((Throwable)iae);
        }
        List dtbs = DataToBeSignedImpl.getList((Document[])new Document[]{d2});
        SignatureType signatureType = enveloped ? SignatureType.ENVELOPED : SignatureType.DETACHED;
        sob.setPluginID(Plugin.PluginID.SIGN_CMS.getID());
        sob.setSignatureType(signatureType);
        SignOptions options = sob.build();
        return new SignatureRequest(options, dtbs);
    }

    private SignRequest createCMSSignRequest(StreamDocument sdoc, boolean enveloped, SignOptionsBuilder sob) {
        List dtbs = DataToBeSignedImpl.getList((Document[])new Document[]{sdoc});
        HashSet<Class<StreamDocument>> inputDocumentClasses = new HashSet<Class<StreamDocument>>();
        inputDocumentClasses.add(StreamDocument.class);
        SignatureType signatureType = enveloped ? SignatureType.ENVELOPED : SignatureType.DETACHED;
        sob.setPluginID(Plugin.PluginID.SIGN_CMS.getID());
        sob.setSignatureType(signatureType);
        SignOptions options = sob.build();
        return new SignatureRequest(options, dtbs);
    }

    private SignRequest createXMLSignRequest(StreamDocument sdoc, SignOptionsBuilder sob) {
        List dtbs = DataToBeSignedImpl.getList((Document[])new Document[]{sdoc});
        HashSet<Class<StreamDocument>> inputDocumentClasses = new HashSet<Class<StreamDocument>>();
        inputDocumentClasses.add(StreamDocument.class);
        sob.setInputDocumentFormatClasses(inputDocumentClasses);
        sob.setPluginID(Plugin.PluginID.SIGN_XML.getID());
        sob.setSignatureType(SignatureType.DETACHED);
        SignOptions options = sob.build();
        return new SignatureRequest(options, dtbs);
    }

    private SignRequest createPDFSignRequest(StreamDocument sdoc, PDFSignOptions pdfSignOptions, SignOptionsBuilder sob) {
        HashSet<Class<StreamDocument>> inputDocumentClasses = new HashSet<Class<StreamDocument>>();
        inputDocumentClasses.add(StreamDocument.class);
        sob.setInputDocumentFormatClasses(inputDocumentClasses);
        sob.setPluginID(Plugin.PluginID.SIGN_PDF.getID());
        sob.setPolicy((SignPolicy)AdESSignCreationPolicy.AdES_EN_B_B);
        sob.setSignatureType(SignatureType.ENVELOPED);
        SignOptions signOptions = sob.build();
        List dtbs = DataToBeSignedImpl.getList((Document[])new Document[]{sdoc});
        SignOptions merge = signOptions;
        if (pdfSignOptions != null) {
            if (pdfSignOptions.getVisualSignatureDetails() == null) {
                SignerInfoImpl sii = (SignerInfoImpl)merge.getSignerInfos().iterator().next();
                if (pdfSignOptions.getSignerReason() != null && !pdfSignOptions.getSignerReason().isEmpty()) {
                    sii.getSignedProperties().add((Object)new PDFSignerReason(pdfSignOptions.getSignerReason()));
                }
                if (pdfSignOptions.getSignerLocation() != null && !pdfSignOptions.getSignerLocation().isEmpty()) {
                    sii.getSignedProperties().add((Object)new ProductionPlace(pdfSignOptions.getSignerLocation(), "", "", "", ""));
                }
            } else {
                merge = pdfSignOptions.merge(signOptions);
            }
        }
        return new SignatureRequest(merge, dtbs);
    }

    public File signXML(File tempFolder, File source, String resultFileName, SignOptionsBuilder sob) throws CoreException, IOException {
        File signedFile = new File(tempFolder, resultFileName);
        LOG.debug("temp signedFile try : {}", (Object)signedFile);
        try (FileInputStream is = new FileInputStream(source);){
            StreamDocument sdoc = new StreamDocument("id", source.getName(), (InputStream)is, TEXT_PLAIN);
            SignRequest signRequest = this.createXMLSignRequest(sdoc, sob);
            XMLSignPluginImpl plugin = new XMLSignPluginImpl();
            SignedDataResponse sign = plugin.sign(signRequest, (Environment)SignerTempDataManager.getInstance().getEnviromentImpl());
            SignedDataResponseImpl response = (SignedDataResponseImpl)sign;
            SignedData signedData = response.getSignedData();
            Document signature = signedData.getSignature();
            try (FileOutputStream fos = new FileOutputStream(signedFile);){
                InputStream is2 = signature.getInputStream();
                Utils.toOutputStream((InputStream)is2, (OutputStream)fos);
            }
            LOG.debug("signedFile done : {}", (Object)signedFile);
            File file = signedFile;
            return file;
        }
    }

    public static void addSigningCertificateV2(JcaSignerInfoGeneratorBuilder signerInfoGenerator, Certificate[] signerCertChain) {
        Attribute essCertIDv2Attribute = SignFunction.createSigningCertificateV2(signerCertChain);
        if (essCertIDv2Attribute != null) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)essCertIDv2Attribute);
            AttributeTable attributeTable = new AttributeTable(v);
            DefaultSignedAttributeTableGenerator cmsAttributeTableGenerator = new DefaultSignedAttributeTableGenerator(attributeTable);
            signerInfoGenerator.setSignedAttributeGenerator((CMSAttributeTableGenerator)cmsAttributeTableGenerator);
        }
    }

    public static Attribute createSigningCertificateV2(Certificate ... x509cert) {
        if (x509cert == null || x509cert.length == 0) {
            throw new IllegalArgumentException("Certificate chain null or empty.");
        }
        String digestAlgorithmName = "SHA256";
        AlgorithmIdentifier digestAlgorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithmName);
            ESSCertIDv2[] essCertIds = new ESSCertIDv2[x509cert.length];
            for (int i = 0; i < x509cert.length; ++i) {
                Certificate certificate = x509cert[i];
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    byte[] cert = x509Certificate.getEncoded();
                    byte[] digest = md.digest(cert);
                    essCertIds[i] = new ESSCertIDv2(digestAlgorithmIdentifier, digest);
                    continue;
                }
                LOG.warn("Given certificate isn't a X509Certificate.");
            }
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(essCertIds);
            return new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)signingCertificateV2));
        }
        catch (CertificateEncodingException e) {
            LOG.debug("Something went wrong during attribute creation, [{}] {}", (Object)e.getClass().getName(), (Object)e.getLocalizedMessage());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.debug(e.getMessage());
        }
        return null;
    }

    public static void handleContent(InputStream inputStream, OutputStream signedContent) throws IOException {
        byte[] buffer = new byte[4096];
        try (InputStream is = inputStream;){
            int r;
            while ((r = is.read(buffer)) > 0) {
                signedContent.write(buffer, 0, r);
            }
        }
    }

    static {
        boreumInstanceProvider = new BoreumInstanceProvider();
    }
}

