/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESTimestamp;
import de.governikus.csl.xades.XAdESValidationContext;
import java.util.Date;
import java.util.List;

public class CheckTimestampDates
extends AbstractValidationCriterion<XAdESSignature, XAdESSignatureValidationResult, XAdESValidationContext> {
    public void verify(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        Date date;
        Date maxDate = null;
        List timestamps = signature.getSignatureTimestamps();
        if (timestamps != null) {
            for (Timestamp ts : timestamps) {
                Date date2 = ts.getGenerationTime();
                if (maxDate != null && date2.compareTo(maxDate) <= 0) continue;
                maxDate = date2;
            }
        }
        if ((timestamps = signature.getSignedDataTimestamps()) != null) {
            for (Timestamp ts : timestamps) {
                Date date2 = ts.getGenerationTime();
                if (maxDate != null && date2.compareTo(maxDate) <= 0) continue;
                maxDate = date2;
            }
        }
        List<XAdESTimestamp> sigAndRefsTimestamps = signature.getSigAndRefsTimestamps();
        List<XAdESTimestamp> refsOnlyTimestamps = signature.getRefsOnlyTimestamps();
        if (maxDate == null || sigAndRefsTimestamps == null && refsOnlyTimestamps == null) {
            this.setResult(result, SVPFactory.createResultOk());
            return;
        }
        if (sigAndRefsTimestamps != null) {
            for (WritableTimestamp writableTimestamp : sigAndRefsTimestamps) {
                date = writableTimestamp.getGenerationTime();
                if (date.compareTo(maxDate) > 0) continue;
                this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"xades_sig_and_refs_ts_prior_to_signature_ts"}));
                return;
            }
        }
        if (refsOnlyTimestamps != null) {
            for (WritableTimestamp writableTimestamp : refsOnlyTimestamps) {
                date = writableTimestamp.getGenerationTime();
                if (date.compareTo(maxDate) > 0) continue;
                this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"xades_refs_only_ts_prior_to_signature_ts"}));
                return;
            }
        }
        this.setResult(result, SVPFactory.createResultOk());
    }

    private void setResult(XAdESSignatureValidationResult result, ValidationResult validationResultImpl) {
        result.setXadesTimestampOrderCheck(validationResultImpl);
    }
}

