/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.criteria;

import de.governikus.csl.core.impl.SignatureValidationDataAttachmentImpl;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.CRLReference;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.OCSPReference;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.xades.QualifyingPropertiesHolder;
import de.governikus.csl.xades.XAdESDefinition;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESUtil;
import de.governikus.csl.xades.XAdESValidationContext;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.etsi.uri._01903.v1_3.CRLRefType;
import org.etsi.uri._01903.v1_3.CRLRefsType;
import org.etsi.uri._01903.v1_3.CertIDListType;
import org.etsi.uri._01903.v1_3.CertIDListV2Type;
import org.etsi.uri._01903.v1_3.CertIDType;
import org.etsi.uri._01903.v1_3.CertificateValuesType;
import org.etsi.uri._01903.v1_3.CertifiedRolesListType;
import org.etsi.uri._01903.v1_3.ClaimedRolesListType;
import org.etsi.uri._01903.v1_3.CompleteCertificateRefsType;
import org.etsi.uri._01903.v1_3.CompleteRevocationRefsType;
import org.etsi.uri._01903.v1_3.CounterSignatureType;
import org.etsi.uri._01903.v1_3.OCSPRefType;
import org.etsi.uri._01903.v1_3.OCSPRefsType;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesReferenceType;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesType;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.etsi.uri._01903.v1_3.SignaturePolicyIdentifierType;
import org.etsi.uri._01903.v1_3.SignatureProductionPlaceType;
import org.etsi.uri._01903.v1_3.SignatureProductionPlaceV2Type;
import org.etsi.uri._01903.v1_3.SignedDataObjectPropertiesType;
import org.etsi.uri._01903.v1_3.SignedPropertiesType;
import org.etsi.uri._01903.v1_3.SignedSignaturePropertiesType;
import org.etsi.uri._01903.v1_3.SignerRoleType;
import org.etsi.uri._01903.v1_3.SignerRoleV2Type;
import org.etsi.uri._01903.v1_3.UnsignedDataObjectPropertiesType;
import org.etsi.uri._01903.v1_3.UnsignedPropertiesType;
import org.etsi.uri._01903.v1_3.UnsignedSignaturePropertiesType;
import org.etsi.uri._01903.v1_3.XAdESTimeStampType;
import org.w3._2000._09.xmldsig.KeyInfoType;
import org.w3._2000._09.xmldsig.ObjectType;
import org.w3._2000._09.xmldsig.ReferenceType;
import org.w3._2000._09.xmldsig.SignatureType;
import org.w3._2000._09.xmldsig.SignedInfoType;

public class CheckSpecConformity
extends AbstractValidationCriterion<XAdESSignature, XAdESSignatureValidationResult, XAdESValidationContext> {
    public void verify(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        AlgorithmManager algorithmManager = context.getConfiguration().getAlgorithmManager();
        ArrayList<String> errors = new ArrayList<String>();
        SignatureType signatureType = signature.getRawSignedData();
        KeyInfoType kexInfo = signatureType.getKeyInfo();
        List<QualifyingPropertiesHolder> qualifyingPropertiesHolder = signature.getRawQualifyingProperties();
        if (qualifyingPropertiesHolder == null || qualifyingPropertiesHolder.isEmpty()) {
            errors.add("xades_no_qualifying_properties");
        } else {
            SignedInfoType signedInfo = signatureType.getSignedInfo();
            List references = signedInfo.getReference();
            this.checkQualifyingProperties(signatureType, qualifyingPropertiesHolder, context, errors);
            for (QualifyingPropertiesHolder qph : qualifyingPropertiesHolder) {
                QualifyingPropertiesType qualifyingProperties = qph.getProperties();
                SignedPropertiesType signedProperties = qualifyingProperties.getSignedProperties();
                UnsignedPropertiesType unsignedProperties = qualifyingProperties.getUnsignedProperties();
                X509Certificate signingCertificate = (X509Certificate)signature.getSigningCertificate().getWrappedCertificate();
                Set<SignatureValidationDataAttachment<X509Certificate>> keyInfoCerts = XAdESUtil.extractCertificatesFromKeyInfo(kexInfo);
                List<X509CRL> keyInfoRevocationValues = XAdESUtil.getRevocationValuesFromKeyInfo(kexInfo);
                this.checkSigningCertificateIsProtected(signature, references, signingCertificate, kexInfo, keyInfoCerts, context, errors);
                if (signedProperties != null) {
                    this.checkSignedProperties(signedProperties, references, context, errors);
                    SignedSignaturePropertiesType signedSignatureProperties = signedProperties.getSignedSignatureProperties();
                    this.checkSignedSignatureProperties(signedSignatureProperties, context, errors);
                    SignedDataObjectPropertiesType signedDataObjectProperties = signedProperties.getSignedDataObjectProperties();
                    this.checkSignedDataObjectProperties(signedDataObjectProperties, context, errors);
                } else {
                    errors.add("xades_signed_properties_empty");
                }
                this.checkUnsignedProperties(unsignedProperties, context, errors);
                if (unsignedProperties == null) continue;
                this.checkUnsignedSignatureProperties(signature, result, unsignedProperties.getUnsignedSignatureProperties(), keyInfoCerts, keyInfoRevocationValues, references, context, errors, algorithmManager);
                this.checkUnsignedDataObjectProperties(unsignedProperties.getUnsignedDataObjectProperties(), references, context, errors);
            }
        }
        ValidationResult vr = this.buildResult(errors);
        this.setResult(result, vr);
    }

    private void setResult(XAdESSignatureValidationResult result, ValidationResult vr) {
        result.setSpecificationConformityCheck(vr);
    }

    private void checkUnsignedDataObjectProperties(UnsignedDataObjectPropertiesType unsignedDataObjectProperties, List<ReferenceType> references, XAdESValidationContext context, List<String> errors) {
        if (unsignedDataObjectProperties == null) {
            return;
        }
        if (context.getFormatDefinitionToCheck().isEN()) {
            List properties;
            String id = unsignedDataObjectProperties.getId();
            if (this.isReferenced(references, id)) {
                errors.add("xades_unsigned_data_object_properties_protected");
            }
            if ((properties = unsignedDataObjectProperties.getUnsignedDataObjectProperty()).isEmpty()) {
                errors.add("xades_unsigned_data_object_properties_empty");
            }
        }
    }

    private void checkSignedDataObjectProperties(SignedDataObjectPropertiesType signedDataObjectProperties, XAdESValidationContext context, List<String> errors) {
        if (signedDataObjectProperties == null) {
            return;
        }
        if (context.getFormatDefinitionToCheck().isEN()) {
            List allDataObjectTimestamps = signedDataObjectProperties.getAllDataObjectsTimeStamp();
            List dataObjectFormats = signedDataObjectProperties.getDataObjectFormat();
            List commitmentType = signedDataObjectProperties.getCommitmentTypeIndication();
            List individualObjectTimestamps = signedDataObjectProperties.getIndividualDataObjectsTimeStamp();
            List any = signedDataObjectProperties.getAny();
            if (allDataObjectTimestamps.isEmpty() && dataObjectFormats.isEmpty() && commitmentType.isEmpty() && individualObjectTimestamps.isEmpty() && any.isEmpty()) {
                errors.add("xades_signed_data_object_properties_empty");
            }
        }
    }

    private void checkSignedSignatureProperties(SignedSignaturePropertiesType signedSignatureProperties, XAdESValidationContext context, List<String> errors) {
        boolean v2IsExisting;
        if (signedSignatureProperties == null) {
            return;
        }
        SignerRoleType signerRoleV1 = signedSignatureProperties.getSignerRole();
        SignerRoleV2Type signerRoleV2 = signedSignatureProperties.getSignerRoleV2();
        CertIDListType signingCertificateV1 = signedSignatureProperties.getSigningCertificate();
        CertIDListV2Type signingCertificateV2 = signedSignatureProperties.getSigningCertificateV2();
        SignatureProductionPlaceType signatureProductionPlaceV1 = signedSignatureProperties.getSignatureProductionPlace();
        SignatureProductionPlaceV2Type signatureProductionPlaceV2 = signedSignatureProperties.getSignatureProductionPlaceV2();
        SignaturePolicyIdentifierType policyIdentifier = signedSignatureProperties.getSignaturePolicyIdentifier();
        XMLGregorianCalendar signingTime = signedSignatureProperties.getSigningTime();
        boolean v1IsExisting = signatureProductionPlaceV1 != null || signerRoleV1 != null || signingCertificateV1 != null;
        boolean bl = v2IsExisting = signatureProductionPlaceV2 != null || signerRoleV2 != null || signingCertificateV2 != null;
        if (context.getFormatDefinitionToCheck().isEN()) {
            if (v1IsExisting) {
                errors.add("xades_signed_signature_properties_old_values");
            }
            if (!v2IsExisting && policyIdentifier == null && signingTime == null) {
                errors.add("xades_signed_signature_properties_empty");
            }
        } else if (signerRoleV1 != null) {
            ClaimedRolesListType claimedRoles = signerRoleV1.getClaimedRoles();
            CertifiedRolesListType certifiedRoles = signerRoleV1.getCertifiedRoles();
            if ((claimedRoles == null || claimedRoles.getClaimedRole().isEmpty()) && (certifiedRoles == null || certifiedRoles.getCertifiedRole().isEmpty())) {
                errors.add("xades_signer_role_contains_no_role");
            }
        }
    }

    private void checkUnsignedProperties(UnsignedPropertiesType unsignedProperties, XAdESValidationContext context, List<String> errors) {
        if (unsignedProperties == null) {
            return;
        }
        if (context.getFormatDefinitionToCheck().isEN()) {
            boolean empty;
            boolean bl = empty = unsignedProperties.getUnsignedDataObjectProperties() == null && unsignedProperties.getUnsignedSignatureProperties() == null;
            if (empty) {
                errors.add("xades_unsigned_properties_empty");
            }
        }
    }

    private void checkQualifyingProperties(SignatureType signature, List<QualifyingPropertiesHolder> qualifyingPropertiesHolder, XAdESValidationContext context, List<String> errors) {
        ObjectType container = null;
        boolean differentContainer = false;
        int numDirectIncorporation = 0;
        int numQualifyingPropertiesWithSignedValues = 0;
        for (QualifyingPropertiesHolder qph : qualifyingPropertiesHolder) {
            QualifyingPropertiesReferenceType reference;
            boolean empty;
            QualifyingPropertiesType properties = qph.getProperties();
            String target = properties.getTarget();
            if (target == null) {
                errors.add("xades_qualifying_properties_target_missing");
            } else if (!target.equals("#" + signature.getId())) {
                errors.add("xades_qualifying_properties_no_signature");
            }
            if (!context.getFormatDefinitionToCheck().isEN()) continue;
            SignedPropertiesType signedProperties = properties.getSignedProperties();
            if (signedProperties != null) {
                ++numQualifyingPropertiesWithSignedValues;
            }
            boolean bl = empty = signedProperties == null && properties.getUnsignedProperties() == null;
            if (empty) {
                errors.add("xades_qualifying_properties_empty");
            }
            ObjectType curContainer = qph.getContainer();
            if (container == null) {
                container = curContainer;
            } else if (curContainer != container) {
                differentContainer = true;
            }
            if ((reference = qph.getReference()) != null) continue;
            ++numDirectIncorporation;
        }
        if (differentContainer) {
            errors.add("xades_qualifying_properties_in_different_objects");
        }
        if (numDirectIncorporation > 1) {
            errors.add("xades_qualifying_properties_multiple_instances");
        }
        if (numQualifyingPropertiesWithSignedValues > 1) {
            errors.add("xades_qualifying_properties_multiple_instances_with_signed_properties");
        }
    }

    private void checkUnsignedSignatureProperties(XAdESSignature signature, XAdESSignatureValidationResult result, UnsignedSignaturePropertiesType unsignedSignatureProperties, Set<SignatureValidationDataAttachment<X509Certificate>> keyInfoCerts, List<X509CRL> keyInfoRevocationValues, List<ReferenceType> references, XAdESValidationContext context, List<String> errors, AlgorithmManager algorithmManager) {
        if (unsignedSignatureProperties == null) {
            return;
        }
        int numCertValues = 0;
        ArrayList<CompleteCertificateRefsType> completeCertRefsV1 = new ArrayList<CompleteCertificateRefsType>();
        ArrayList<CompleteCertificateRefsType> attributeCertRefsV1 = new ArrayList<CompleteCertificateRefsType>();
        ArrayList<XAdESTimeStampType> signatureTimestamps = new ArrayList<XAdESTimeStampType>();
        ArrayList<XAdESTimeStampType> sigAndRefsTimestampsV1 = new ArrayList<XAdESTimeStampType>();
        ArrayList<XAdESTimeStampType> refsTimestampsV1 = new ArrayList<XAdESTimeStampType>();
        ArrayList<XAdESTimeStampType> archiveTimestampsV1 = new ArrayList<XAdESTimeStampType>();
        ArrayList<CounterSignatureType> counterSignatures = new ArrayList<CounterSignatureType>();
        ArrayList<CompleteRevocationRefsType> revocationRefs = new ArrayList<CompleteRevocationRefsType>();
        ArrayList<CompleteRevocationRefsType> attributeRevocationRefs = new ArrayList<CompleteRevocationRefsType>();
        ArrayList<RevocationValuesType> revocationValues = new ArrayList<RevocationValuesType>();
        ArrayList<RevocationValuesType> attributeRevocationValues = new ArrayList<RevocationValuesType>();
        ArrayList<CertificateValuesType> certificateValues = new ArrayList<CertificateValuesType>();
        ArrayList<CertificateValuesType> attrAuthoritiesCertValues = new ArrayList<CertificateValuesType>();
        ArrayList other = new ArrayList();
        List data = unsignedSignatureProperties.getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs();
        for (Object o : data) {
            String name = null;
            String ns = null;
            if (o instanceof JAXBElement) {
                JAXBElement elem = (JAXBElement)o;
                o = elem.getValue();
                QName qname = elem.getName();
                name = qname.getLocalPart();
                ns = qname.getNamespaceURI();
            }
            if (o instanceof CompleteRevocationRefsType) {
                CompleteRevocationRefsType revoRefs = (CompleteRevocationRefsType)o;
                if ("CompleteRevocationRefs".equalsIgnoreCase(name)) {
                    revocationRefs.add(revoRefs);
                    if (revoRefs.getCRLRefs() != null || revoRefs.getOCSPRefs() != null || revoRefs.getOtherRefs() != null) continue;
                    errors.add("xades_complete_revocation_refs_empty");
                    continue;
                }
                if (!"AttributeRevocationRefs".equalsIgnoreCase(name)) continue;
                attributeRevocationRefs.add(revoRefs);
                continue;
            }
            if (o instanceof CertificateValuesType) {
                CertificateValuesType cvt = (CertificateValuesType)o;
                if ("CertificateValues".equalsIgnoreCase(name)) {
                    ++numCertValues;
                    certificateValues.add(cvt);
                    continue;
                }
                if (!"AttrAuthoritiesCertValues".equalsIgnoreCase(name)) continue;
                attrAuthoritiesCertValues.add(cvt);
                continue;
            }
            if (o instanceof CompleteCertificateRefsType) {
                CompleteCertificateRefsType ccrt = (CompleteCertificateRefsType)o;
                if ("CompleteCertificateRefs".equalsIgnoreCase(name)) {
                    completeCertRefsV1.add(ccrt);
                    continue;
                }
                if (!"AttributeCertificateRefs".equalsIgnoreCase(name)) continue;
                attributeCertRefsV1.add(ccrt);
                continue;
            }
            if (o instanceof RevocationValuesType) {
                RevocationValuesType rvt = (RevocationValuesType)o;
                if ("RevocationValues".equalsIgnoreCase(name)) {
                    revocationValues.add(rvt);
                    continue;
                }
                if (!"AttributeRevocationValues".equalsIgnoreCase(name)) continue;
                attributeRevocationValues.add(rvt);
                continue;
            }
            if (o instanceof CounterSignatureType) {
                CounterSignatureType cst = (CounterSignatureType)o;
                counterSignatures.add(cst);
                continue;
            }
            if (o instanceof XAdESTimeStampType) {
                XAdESTimeStampType tst = (XAdESTimeStampType)o;
                if ("SignatureTimeStamp".equalsIgnoreCase(name)) {
                    signatureTimestamps.add(tst);
                    continue;
                }
                if ("SigAndRefsTimeStamp".equalsIgnoreCase(name)) {
                    sigAndRefsTimestampsV1.add(tst);
                    continue;
                }
                if ("RefsOnlyTimeStamp".equalsIgnoreCase(name)) {
                    refsTimestampsV1.add(tst);
                    continue;
                }
                if (!"ArchiveTimeStamp".equalsIgnoreCase(name) || "http://uri.etsi.org/01903/v1.4.1#".equalsIgnoreCase(ns)) continue;
                archiveTimestampsV1.add(tst);
                continue;
            }
            other.add(o);
        }
        if (context.getFormatDefinitionToCheck().isEN()) {
            String id = unsignedSignatureProperties.getId();
            if (this.isReferenced(references, id)) {
                errors.add("xades_unsigned_signature_properties_protected");
            }
            if (!(completeCertRefsV1.isEmpty() && attributeCertRefsV1.isEmpty() && sigAndRefsTimestampsV1.isEmpty() && refsTimestampsV1.isEmpty() && archiveTimestampsV1.isEmpty())) {
                errors.add("xades_unsigned_signature_properties_old_values");
            }
            if (signatureTimestamps.isEmpty() && counterSignatures.isEmpty() && attributeRevocationValues.isEmpty() && revocationValues.isEmpty() && attrAuthoritiesCertValues.isEmpty() && attributeRevocationRefs.isEmpty() && certificateValues.isEmpty() && revocationRefs.isEmpty() && other.isEmpty()) {
                errors.add("xades_unsigned_signature_properties_empty");
            }
        } else {
            if (revocationRefs.size() > 1) {
                errors.add("xades_multiple_complete_revocation_refs");
            }
            if (numCertValues > 1) {
                errors.add("xades_multiple_certificate_values");
            }
            if (!completeCertRefsV1.isEmpty()) {
                if (numCertValues >= 1) {
                    this.checkCertificateReferences(completeCertRefsV1, signature.getAttachedCertificates(), keyInfoCerts, errors, algorithmManager);
                }
                HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
                HashSet<SignatureValidationDataAttachment<X509Certificate>> certs2 = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
                boolean insert = false;
                for (PublicKeyCertificateValidationResult certCheckResult = result.getSigningCertificateValidationResult(); certCheckResult != null; certCheckResult = certCheckResult.getSigningCertificateValidationResult()) {
                    if (insert) {
                        X509Certificate cert = (X509Certificate)certCheckResult.getCert().getWrappedCertificate();
                        certs.add(cert);
                        certs2.add((SignatureValidationDataAttachment<X509Certificate>)new SignatureValidationDataAttachmentImpl((Object)cert));
                        continue;
                    }
                    insert = true;
                }
                this.checkCertificateReferences(completeCertRefsV1, certs2, null, errors, algorithmManager);
                this.checkCertificateReferences(completeCertRefsV1, certs, errors, algorithmManager);
            }
            if (revocationValues.size() > 1) {
                errors.add("xades_multiple_revocation_values");
            }
            if (!revocationRefs.isEmpty() && !revocationValues.isEmpty()) {
                this.checkRevocationReferences(revocationRefs, signature.getAttachedCRLs(), signature.getAttachedOCSPValues(), keyInfoRevocationValues, errors, algorithmManager);
            }
        }
    }

    private void checkRevocationReferences(List<CompleteRevocationRefsType> revocationRefs, List<SignatureValidationDataAttachment<CRL>> attachedCRLs, List<SignatureValidationDataAttachment<OCSPResp>> list, List<X509CRL> keyInfoRevocationValues, List<String> errors, AlgorithmManager algorithmManager) {
        for (CompleteRevocationRefsType revoRef : revocationRefs) {
            OCSPRefsType ocspRef;
            CRLRefsType crlRef = revoRef.getCRLRefs();
            if (crlRef != null) {
                this.checkCRLReference(crlRef, attachedCRLs, keyInfoRevocationValues, errors, algorithmManager);
            }
            if ((ocspRef = revoRef.getOCSPRefs()) == null) continue;
            this.checkOCSPReference(list, errors, algorithmManager, ocspRef);
        }
    }

    private void checkOCSPReference(List<SignatureValidationDataAttachment<OCSPResp>> list, List<String> errors, AlgorithmManager algorithmManager, OCSPRefsType ocspRef) {
        for (OCSPRefType ref : ocspRef.getOCSPRef()) {
            boolean found;
            OCSPReference oRef = XAdESUtil.createOCSPReference(ref, algorithmManager);
            if (oRef == null || (found = this.checkOCSPReference(oRef, list))) continue;
            errors.add("xades_complete_revocation_refs_not_in_revocation_values");
            return;
        }
    }

    private boolean checkOCSPReference(OCSPReference oRef, List<SignatureValidationDataAttachment<OCSPResp>> list) {
        if (list != null) {
            for (SignatureValidationDataAttachment<OCSPResp> ocsp : list) {
                if (!oRef.isReferenced((OCSPResp)ocsp.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private void checkCRLReference(CRLRefsType crlRef, List<SignatureValidationDataAttachment<CRL>> attachedCRLs, List<X509CRL> keyInfoRevocationValues, List<String> errors, AlgorithmManager algorithmManager) {
        for (CRLRefType ref : crlRef.getCRLRef()) {
            boolean found;
            CRLReference cRef = XAdESUtil.createCRLReference(ref, algorithmManager);
            if (cRef == null || (found = this.checkCRLReference(cRef, keyInfoRevocationValues, attachedCRLs))) continue;
            errors.add("xades_complete_revocation_refs_not_in_revocation_values");
            return;
        }
    }

    private boolean checkCRLReference(CRLReference cRef, List<X509CRL> keyInfoRevocationValues, List<SignatureValidationDataAttachment<CRL>> attachedCRLs) {
        if (keyInfoRevocationValues != null) {
            for (CRL cRL : keyInfoRevocationValues) {
                if (!cRef.isReferenced(cRL)) continue;
                return true;
            }
        }
        if (attachedCRLs != null) {
            for (SignatureValidationDataAttachment signatureValidationDataAttachment : attachedCRLs) {
                if (!cRef.isReferenced((CRL)signatureValidationDataAttachment.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private void checkCertificateReferences(List<CompleteCertificateRefsType> certRefs, Set<X509Certificate> certs, List<String> errors, AlgorithmManager algorithmManager) {
        for (X509Certificate cert : certs) {
            boolean found = this.checkCertInReferences(cert, certRefs, algorithmManager);
            if (found) continue;
            errors.add("xades_cert_not_in_complete_cert_refs");
            return;
        }
    }

    private boolean checkCertInReferences(X509Certificate cert, List<CompleteCertificateRefsType> certRefs, AlgorithmManager algorithmManager) {
        for (CompleteCertificateRefsType ref : certRefs) {
            CertIDListType certRefs2 = ref.getCertRefs();
            for (CertIDType s : certRefs2.getCert()) {
                CertificateReference r = XAdESUtil.createCertificateReference(s, algorithmManager);
                if (r == null || !r.isReferenced((Certificate)cert)) continue;
                return true;
            }
        }
        return false;
    }

    private void checkCertificateReferences(List<CompleteCertificateRefsType> certRefs, Set<SignatureValidationDataAttachment<X509Certificate>> set, Set<SignatureValidationDataAttachment<X509Certificate>> keyInfoCerts, List<String> errors, AlgorithmManager algorithmManager) {
        for (CompleteCertificateRefsType ref : certRefs) {
            CertIDListType certRefs2 = ref.getCertRefs();
            for (CertIDType s : certRefs2.getCert()) {
                CertificateReference r = XAdESUtil.createCertificateReference(s, algorithmManager);
                if (r == null) continue;
                boolean found = false;
                if (set != null) {
                    for (SignatureValidationDataAttachment<X509Certificate> cert : set) {
                        if (!r.isReferenced((Certificate)cert.getValue())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                if (keyInfoCerts != null) {
                    for (SignatureValidationDataAttachment<X509Certificate> cert : keyInfoCerts) {
                        if (!r.isReferenced((Certificate)cert.getValue())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                errors.add("xades_complete_certificate_revs_not_in_certificate_values");
                return;
            }
        }
    }

    private void checkSignedProperties(SignedPropertiesType signedProperties, List<ReferenceType> references, XAdESValidationContext context, List<String> errors) {
        String signedPropertiesID = signedProperties.getId();
        ReferenceType reference = this.getReference(references, signedPropertiesID);
        if (reference == null) {
            errors.add("xades_signed_properties_not_protected_by_signature");
        }
        if (context.getFormatDefinitionToCheck().isEN()) {
            boolean empty;
            String type;
            if (reference != null && !"http://uri.etsi.org/01903#SignedProperties".equals(type = reference.getType())) {
                errors.add("xades_signed_properties_protected_with_wrong_type");
            }
            boolean bl = empty = signedProperties.getSignedSignatureProperties() == null && signedProperties.getSignedDataObjectProperties() == null;
            if (empty) {
                errors.add("xades_signed_properties_empty");
            }
        }
    }

    private void checkSigningCertificateIsProtected(XAdESSignature signature, List<ReferenceType> references, X509Certificate signingCertificate, KeyInfoType keyInfo, Set<SignatureValidationDataAttachment<X509Certificate>> keyInfoCerts, XAdESValidationContext context, List<String> errors) {
        List certRefs = signature.getSigningCertificateReferences();
        if (certRefs != null && !certRefs.isEmpty()) {
            if (this.checkSigningCertificateIsReferenced(signingCertificate, context, errors, certRefs)) {
                return;
            }
        } else {
            String keyInfoID;
            boolean referenced;
            if (context.getFormatDefinitionToCheck() == XAdESDefinition.TS_103_171) {
                errors.add("xades_baseline_missing_cert_refs");
            }
            if (referenced = this.isReferenced(references, keyInfoID = keyInfo.getId())) {
                for (SignatureValidationDataAttachment<X509Certificate> keyInfoCert : keyInfoCerts) {
                    if (!((X509Certificate)keyInfoCert.getValue()).equals(signingCertificate)) continue;
                    return;
                }
            }
        }
        errors.add("xades_signing_cert_not_covered_by_sig");
    }

    private boolean checkSigningCertificateIsReferenced(X509Certificate signingCertificate, XAdESValidationContext context, List<String> errors, List<CertificateReference> certRefs) {
        boolean once = true;
        for (CertificateReference ref : certRefs) {
            if (ref.getUri() != null && context.getFormatDefinitionToCheck() == XAdESDefinition.TS_103_171) {
                errors.add("xades_baseline_uri_permitted");
            }
            if (ref.isReferenced((Certificate)signingCertificate)) {
                return true;
            }
            if (!context.getFormatDefinitionToCheck().isEN() || !once) continue;
            errors.add("xades_signing_certificate_not_first_reference");
            once = false;
        }
        if (context.getFormatDefinitionToCheck() != XAdESDefinition.TS_103_171) {
            errors.add("xades_baseline_signing_cert_not_referenced");
        }
        return false;
    }

    private ValidationResult buildResult(List<String> errors) {
        ValidationResult result = SVPFactory.createResultOk();
        if (!errors.isEmpty()) {
            result.setMajor(MajorTotalResult.TOTAL_FAILED);
            result.setMinor(MinorResult.FORMAT_FAILURE);
            List messages = result.getMessages();
            for (String e : errors) {
                messages.add(SVPFactory.createMessageCode((String)e));
            }
        }
        return result;
    }

    private boolean isReferenced(List<ReferenceType> references, String id) {
        ReferenceType reference = this.getReference(references, id);
        return reference != null;
    }

    private ReferenceType getReference(List<ReferenceType> references, String id) {
        String referenceID = "#" + id;
        if (references != null) {
            for (ReferenceType ref : references) {
                String uri = ref.getURI();
                if (uri == null || !uri.equals(referenceID)) continue;
                return ref;
            }
        }
        return null;
    }

    public boolean preconditionsFulfilled(XAdESSignature signature, XAdESSignatureValidationResult result) {
        return result.getSigningCertificateValidationResult() != null;
    }

    public boolean isApplicable(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        if (context.getFormatDefinitionToCheck() == null) {
            this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
            return false;
        }
        return signature.getRawQualifyingProperties() != null && !signature.getRawQualifyingProperties().isEmpty();
    }
}

