/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.xades.XAdESDefinition;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSigningTime
extends AbstractValidationCriterion<XAdESSignature, XAdESSignatureValidationResult, XAdESValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckSigningTime.class);

    public void verify(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        LOGGER.debug("Verifying conformance of xades:SigningTime-element");
        if (context.getFormatDefinitionToCheck() != XAdESDefinition.TS_103_171 && context.getFormatDefinitionToCheck() != XAdESDefinition.EN_319_132_1) {
            return;
        }
        ValidationResult r = null;
        r = signature.getSigningTime() == null ? SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"xades_no_signing_time"}) : SVPFactory.createResultOk();
        result.setSigningTimeCheck(r);
    }

    public boolean isApplicable(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        if (context.getFormatDefinitionToCheck() != XAdESDefinition.TS_103_171 && context.getFormatDefinitionToCheck() != XAdESDefinition.EN_319_132_1) {
            result.setSigningTimeCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
            return false;
        }
        return true;
    }
}

