/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.w3._2000._09.xmldsig.ReferenceType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CheckRefsUnique
extends AbstractValidationCriterion<XAdESSignature, XAdESSignatureValidationResult, XAdESValidationContext> {
    public void verify(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        ArrayList<String> idList;
        ArrayList<String> referenceIDsInSig;
        block4: {
            Document doc = signature.getDocument();
            referenceIDsInSig = new ArrayList<String>();
            idList = new ArrayList<String>();
            List reference = signature.getRawSignedData().getSignedInfo().getReference();
            for (ReferenceType referenceType : reference) {
                String URI = referenceType.getURI();
                if (URI.startsWith("#")) {
                    URI = URI.substring(1);
                }
                referenceIDsInSig.add(URI);
            }
            NodeList childNodes = doc.getDocumentElement().getChildNodes();
            try {
                this.checkReferenceIds(childNodes, referenceIDsInSig, idList);
            }
            catch (DOMException e) {
                if (e.code != 1337) break block4;
                ValidationResult vr = SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"xades_signature_contains_duplicate_ref_ids"});
                result.setSignatureReferencesAmbiguous(vr);
            }
        }
        idList.clear();
        referenceIDsInSig.clear();
    }

    private void checkReferenceIds(NodeList nl, List<String> referenceIDsInSig, List<String> idList) {
        int childNodesCount = nl.getLength();
        for (int i = 0; i < childNodesCount; ++i) {
            Node idNode;
            Node currentNode = nl.item(i);
            if (currentNode == null) continue;
            NamedNodeMap attributes = currentNode.getAttributes();
            if (attributes != null && (idNode = attributes.getNamedItem("Id")) != null) {
                String nodeValue = idNode.getNodeValue();
                if (nodeValue != null && idList.contains(nodeValue) && referenceIDsInSig.contains(nodeValue)) {
                    throw new DOMException(1337, "Reference Ids have to be unique");
                }
                idList.add(idNode.getNodeValue());
            }
            this.checkReferenceIds(currentNode.getChildNodes(), referenceIDsInSig, idList);
        }
    }
}

