/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.criteria;

import de.governikus.csl.core.impl.CumulatedValidationResultImpl;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.utils.SignalAggregateUtil;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.RecursiveValidationCriterion;
import de.governikus.csl.validation.tsp.TSPPlugin;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESTimestamp;
import java.util.List;

public class CheckRefsOnlyTimestamps
extends RecursiveValidationCriterion<XAdESSignature, XAdESSignatureValidationResult, Timestamp, TimestampValidationResult, SignatureValidationContext> {
    public void verify(XAdESSignature signature, XAdESSignatureValidationResult result, SignatureValidationContext context) {
        List<XAdESTimestamp> timestamps = signature.getRefsOnlyTimestamps();
        if (timestamps != null) {
            CumulatedValidationResultImpl vr = new CumulatedValidationResultImpl();
            TSPPlugin plugin = (TSPPlugin)context.getConfiguration().getPlugin(Plugin.PluginID.VALIDATE_TSP.getID());
            List results = result.getRefsOnlyTimestampValidationResults();
            for (WritableTimestamp writableTimestamp : timestamps) {
                SignatureValidationContext tsContext = plugin.createContext((Signature)writableTimestamp, context);
                tsContext.setCertificatePathReferences(null);
                TimestampValidationResult valResult = (TimestampValidationResult)this.recursiveCall((Signature)writableTimestamp, (AbstractDocumentPlugin)plugin, tsContext);
                SignalAggregateUtil.aggregateCumulated((boolean)true, (ResultAggregator[])new ResultAggregator[]{vr, valResult});
                results.add(valResult);
            }
        }
    }
}

