/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.xades.QualifyingPropertiesHolder;
import de.governikus.csl.xades.XAdESDefinition;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESUtil;
import de.governikus.csl.xades.XAdESValidationContext;
import java.util.HashSet;
import java.util.List;
import org.etsi.uri._01903.v1_3.DataObjectFormatType;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesType;
import org.etsi.uri._01903.v1_3.SignedDataObjectPropertiesType;
import org.etsi.uri._01903.v1_3.SignedPropertiesType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.ManifestType;
import org.w3._2000._09.xmldsig.ObjectType;
import org.w3._2000._09.xmldsig.ReferenceType;

public class CheckDataObjectFormat
extends AbstractValidationCriterion<XAdESSignature, XAdESSignatureValidationResult, XAdESValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckDataObjectFormat.class);

    public void verify(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        LOGGER.debug("Verifying conformance of xades:DataObjectFormat-elements");
        List<QualifyingPropertiesHolder> qualifyingPropertiesHolder = signature.getRawQualifyingProperties();
        if (qualifyingPropertiesHolder == null || qualifyingPropertiesHolder.isEmpty()) {
            this.setResult(result, context.getFormatDefinitionToCheck() == XAdESDefinition.TS_103_171, "xades_no_qualifying_properties");
            return;
        }
        for (QualifyingPropertiesHolder qph : qualifyingPropertiesHolder) {
            QualifyingPropertiesType qulifyingProperties = qph.getProperties();
            SignedPropertiesType signedProperties = qulifyingProperties.getSignedProperties();
            if (signedProperties == null) {
                this.setResult(result, context.getFormatDefinitionToCheck() == XAdESDefinition.TS_103_171, "xades_no_signed_properties");
                return;
            }
            SignedDataObjectPropertiesType signedDataObjectProperties = signedProperties.getSignedDataObjectProperties();
            if (signedDataObjectProperties == null) {
                this.setResult(result, context.getFormatDefinitionToCheck() == XAdESDefinition.TS_103_171, "xades_no_signed_data_object_properties");
                return;
            }
            List dataFormats = signedDataObjectProperties.getDataObjectFormat();
            if (dataFormats == null) {
                this.setResult(result, context.getFormatDefinitionToCheck() == XAdESDefinition.TS_103_171, "xades_no_data_object_format");
                return;
            }
            List references = signature.getRawSignedData().getSignedInfo().getReference();
            HashSet<String> referenceIDsFound = new HashSet<String>();
            for (DataObjectFormatType doft : dataFormats) {
                String doftMimeType = doft.getMimeType();
                String doftEncoding = doft.getEncoding();
                String ref = doft.getObjectReference();
                if (ref.startsWith("#")) {
                    ref = ref.substring(1);
                }
                boolean refFound = false;
                for (ReferenceType reference : references) {
                    ObjectType s;
                    if ((reference = this.getMatchingReference(reference, ref, signature)) == null) continue;
                    String uri = reference.getURI();
                    if (uri != null && uri.startsWith("#")) {
                        uri = uri.substring(1);
                    }
                    referenceIDsFound.add(reference.getId());
                    refFound = true;
                    if (doftEncoding == null && doftMimeType == null || (s = this.getObject(signature, uri)) == null) break;
                    String refMimeType = s.getMimeType();
                    String refEncoding = s.getEncoding();
                    if (!this.checkString(doftMimeType, refMimeType)) {
                        this.setErrorResult(result, "xades_data_object_format_wrong_mime_type");
                        return;
                    }
                    if (this.checkString(doftEncoding, refEncoding)) break;
                    this.setErrorResult(result, "xades_data_object_format_wrong_encoding");
                    return;
                }
                if (refFound) continue;
                this.setErrorResult(result, "xades_data_object_format_no_reference");
                return;
            }
            if (context.getFormatDefinitionToCheck() == XAdESDefinition.TS_103_171 && references.size() - 1 > referenceIDsFound.size()) {
                this.setErrorResult(result, "xades_baseline_references_not_covered_by_dataobjectformat");
                return;
            }
            result.setDataFormatCheck(SVPFactory.createResultOk());
        }
    }

    private ReferenceType getMatchingReference(ReferenceType reference, String ref, XAdESSignature signature) {
        String id;
        String uri = reference.getURI();
        if (uri != null && uri.startsWith("#")) {
            uri = uri.substring(1);
        }
        if ((id = reference.getId()) != null && ref.equals(id)) {
            return reference;
        }
        if (reference.getType() != null && reference.getType().equals("http://www.w3.org/2000/09/xmldsig#Manifest")) {
            List objects = signature.getRawSignedData().getObject();
            for (ObjectType ot : objects) {
                List content = ot.getContent();
                for (Object o : content) {
                    ManifestType manifest = XAdESUtil.getInstanceOf(o, ManifestType.class, "Manifest");
                    if (manifest == null || !manifest.getId().equals(uri)) continue;
                    List manifestReferences = manifest.getReference();
                    for (ReferenceType rt : manifestReferences) {
                        if ((rt = this.getMatchingReference(rt, ref, signature)) == null) continue;
                        return rt;
                    }
                }
            }
        }
        return null;
    }

    private ObjectType getObject(XAdESSignature signature, String uri) {
        for (ObjectType s : signature.getRawSignedData().getObject()) {
            if (s.getId() == null || !s.getId().equals(uri)) continue;
            return s;
        }
        return null;
    }

    private void setResult(XAdESSignatureValidationResult result, boolean error, String errorMessage) {
        if (error) {
            this.setErrorResult(result, errorMessage);
        } else {
            result.setDataFormatCheck(SVPFactory.createResultOk());
        }
    }

    private void setErrorResult(XAdESSignatureValidationResult result, String message) {
        result.setDataFormatCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{message}));
    }

    private boolean checkString(String s1, String s2) {
        return s1 == null || s2 == null || s1.equals(s2);
    }
}

