/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.criteria;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import de.governikus.csl.xades.QualifyingPropertiesHolder;
import de.governikus.csl.xades.XAdESDefinition;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESValidationContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesType;
import org.etsi.uri._01903.v1_3.UnsignedPropertiesType;
import org.etsi.uri._01903.v1_3.UnsignedSignaturePropertiesType;

public class CheckBannedElements
extends AbstractValidationCriterion<XAdESSignature, XAdESSignatureValidationResult, XAdESValidationContext> {
    public void verify(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        List<QualifyingPropertiesHolder> qualifyingPropertiesHolder = signature.getRawQualifyingProperties();
        if (qualifyingPropertiesHolder == null || qualifyingPropertiesHolder.isEmpty()) {
            this.setResult(result, SVPFactory.createResultOk());
            return;
        }
        for (QualifyingPropertiesHolder qph : qualifyingPropertiesHolder) {
            QualifyingPropertiesType qualifyingProperties = qph.getProperties();
            UnsignedPropertiesType unsignedProperties = qualifyingProperties.getUnsignedProperties();
            if (unsignedProperties == null) {
                this.setResult(result, SVPFactory.createResultOk());
                return;
            }
            UnsignedSignaturePropertiesType unsignedSignatureProperties = unsignedProperties.getUnsignedSignatureProperties();
            if (unsignedSignatureProperties == null) {
                this.setResult(result, SVPFactory.createResultOk());
                return;
            }
            List refs = unsignedSignatureProperties.getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs();
            if (refs == null) {
                this.setResult(result, SVPFactory.createResultOk());
                return;
            }
            ArrayList<String> errorCodes = new ArrayList<String>();
            for (Object ref : refs) {
                if (!(ref instanceof JAXBElement)) continue;
                JAXBElement elem = (JAXBElement)ref;
                String name = elem.getName().getLocalPart();
                switch (name.toLowerCase()) {
                    case "completecertificaterefs": {
                        errorCodes.add("xades_baseline_contains_cert_refs");
                        break;
                    }
                    case "completerevocationrefs": {
                        errorCodes.add("xades_baseline_contains_revocation_refs");
                        break;
                    }
                    case "attributecertificaterefs": {
                        errorCodes.add("xades_baseline_contains_attr_cert_refs");
                        break;
                    }
                    case "attributerevocationrefs": {
                        errorCodes.add("xades_baseline_contains_attr_revocation_refs");
                        break;
                    }
                    case "sigandrefstimestamp": {
                        errorCodes.add("xades_baseline_contains_sig_refs_ts");
                        break;
                    }
                    case "refsonlytimestamp": {
                        errorCodes.add("xades_baseline_contains_refs_only_ts");
                    }
                }
            }
            if (errorCodes.isEmpty()) {
                this.setResult(result, SVPFactory.createResultOk());
                continue;
            }
            this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, errorCodes));
        }
    }

    public boolean isApplicable(XAdESSignature signature, XAdESSignatureValidationResult result, XAdESValidationContext context) {
        if (context.getFormatDefinitionToCheck() != XAdESDefinition.TS_103_171) {
            this.setResult(result, SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (String)"not_validated_because_of_policy"));
            return false;
        }
        return true;
    }

    protected void setResult(XAdESSignatureValidationResult result, ValidationResult vr) {
        result.setBaselineProhibitedElementsCheck(vr);
    }
}

