/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.CRLReference;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.OCSPReference;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validation.CRLReferenceImpl;
import de.governikus.csl.validation.CertificateReferenceImpl;
import de.governikus.csl.validation.OCSPReferenceImpl;
import de.governikus.csl.xades.XAdESValidationData;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.bouncycastle.asn1.x500.X500Name;
import org.etsi.uri._01903.v1_3.CRLIdentifierType;
import org.etsi.uri._01903.v1_3.CRLRefType;
import org.etsi.uri._01903.v1_3.CertIDType;
import org.etsi.uri._01903.v1_3.CertIDTypeV2;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._01903.v1_3.OCSPIdentifierType;
import org.etsi.uri._01903.v1_3.OCSPRefType;
import org.etsi.uri._01903.v1_3.ResponderIDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.KeyInfoType;
import org.w3._2000._09.xmldsig.X509DataType;
import org.w3._2000._09.xmldsig.X509IssuerSerialType;

public class XAdESUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAdESUtil.class);

    public static <T> T getInstanceOf(Object o, Class<T> c, String name) {
        Object instance = o;
        if (instance instanceof JAXBElement) {
            JAXBElement elem = (JAXBElement)instance;
            if (elem.getName().getLocalPart().equals(name)) {
                instance = elem.getValue();
            } else {
                return null;
            }
        }
        if (c.isInstance(instance)) {
            return c.cast(instance);
        }
        return null;
    }

    public static Set<SignatureValidationDataAttachment<X509Certificate>> extractCertificatesFromKeyInfo(KeyInfoType keyInfo) {
        CertificateFactory certFactory = null;
        try {
            certFactory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
        }
        catch (NoSuchProviderException | CertificateException e) {
            LogHelper.fatal((String)"Can't instantiate certificate factory.", (Exception)e, (Logger)LOGGER);
            return new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
        }
        return XAdESUtil.extractCertificatesFromKeyInfo(keyInfo, certFactory);
    }

    public static Set<SignatureValidationDataAttachment<X509Certificate>> extractCertificatesFromKeyInfo(KeyInfoType keyInfo, CertificateFactory certFactory) {
        HashSet<SignatureValidationDataAttachment<X509Certificate>> values = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
        if (keyInfo == null || certFactory == null) {
            return values;
        }
        List content = keyInfo.getContent();
        if (content == null) {
            return values;
        }
        for (Object c : content) {
            X509DataType data = XAdESUtil.getInstanceOf(c, X509DataType.class, "X509Data");
            if (data == null) continue;
            for (Object o : data.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                byte[] bytes = XAdESUtil.getInstanceOf(o, byte[].class, "X509Certificate");
                if (bytes == null) continue;
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                    Throwable throwable = null;
                    try {
                        values.add((SignatureValidationDataAttachment<X509Certificate>)new XAdESValidationData<X509Certificate>((X509Certificate)certFactory.generateCertificate(in), true));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can't extract certificate.", (Throwable)e);
                }
            }
        }
        return values;
    }

    public static List<X509CRL> getRevocationValuesFromKeyInfo(KeyInfoType keyInfo) {
        CertificateFactory certFactory = null;
        try {
            certFactory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
        }
        catch (NoSuchProviderException | CertificateException e) {
            LOGGER.error("Can't instantiate certificate factory.", (Throwable)e);
            return new ArrayList<X509CRL>();
        }
        return XAdESUtil.getRevocationValuesFromKeyInfo(keyInfo, certFactory);
    }

    public static List<X509CRL> getRevocationValuesFromKeyInfo(KeyInfoType keyInfo, CertificateFactory certFactory) {
        ArrayList<X509CRL> values = new ArrayList<X509CRL>();
        if (keyInfo == null) {
            return values;
        }
        List content = keyInfo.getContent();
        if (content == null) {
            return values;
        }
        for (Object c : content) {
            X509DataType data = XAdESUtil.getInstanceOf(c, X509DataType.class, "X509Data");
            if (data == null) continue;
            for (Object o : data.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                byte[] bytes = XAdESUtil.getInstanceOf(o, byte[].class, "X509CRL");
                if (bytes == null) continue;
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                    Throwable throwable = null;
                    try {
                        values.add((X509CRL)certFactory.generateCRL(in));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Can't extract revocation value.", (Throwable)e);
                }
            }
        }
        return values;
    }

    public static CertificateReference createCertificateReference(CertIDType cert, AlgorithmManager algorithmManager) {
        DigestAlgAndValueType digest = cert.getCertDigest();
        X509IssuerSerialType type = cert.getIssuerSerial();
        if (digest == null || type == null) {
            return null;
        }
        DigestAlgorithm digestAlgorithm = algorithmManager.getDigestAlgorithmByURL(digest.getDigestMethod().getAlgorithm());
        return new CertificateReferenceImpl(digestAlgorithm, digest.getDigestValue(), type.getX509IssuerName(), type.getX509SerialNumber(), cert.getURI());
    }

    public static CertificateReference createCertificateReference(CertIDTypeV2 cert, AlgorithmManager algorithmManager) {
        DigestAlgAndValueType digest = cert.getCertDigest();
        if (digest == null) {
            return null;
        }
        DigestAlgorithm digestAlgorithm = algorithmManager.getDigestAlgorithmByURL(digest.getDigestMethod().getAlgorithm());
        return new CertificateReferenceImpl(digestAlgorithm, digest.getDigestValue(), null, null, cert.getURI());
    }

    public static CRLReference createCRLReference(CRLRefType ref, AlgorithmManager algorithmManager) {
        DigestAlgAndValueType digest = ref.getDigestAlgAndValue();
        CRLIdentifierType type = ref.getCRLIdentifier();
        if (digest == null || type == null) {
            return null;
        }
        DigestAlgorithm digestAlgorithm = algorithmManager.getDigestAlgorithmByURL(digest.getDigestMethod().getAlgorithm());
        return new CRLReferenceImpl(digestAlgorithm, digest.getDigestValue());
    }

    public static OCSPReference createOCSPReference(OCSPRefType ref, AlgorithmManager algorithmManager) {
        DigestAlgAndValueType digest = ref.getDigestAlgAndValue();
        OCSPIdentifierType type = ref.getOCSPIdentifier();
        if (digest == null || type == null) {
            return null;
        }
        DigestAlgorithm digestAlgorithm = algorithmManager.getDigestAlgorithmByURL(digest.getDigestMethod().getAlgorithm());
        return new OCSPReferenceImpl(digestAlgorithm, digest.getDigestValue(), XAdESUtil.getLdapName(type), XAdESUtil.getProductionDate(type));
    }

    private static X500Name getLdapName(OCSPIdentifierType type) {
        String name;
        X500Name ldapName = null;
        ResponderIDType responderID = type.getResponderID();
        if (responderID != null && (name = responderID.getByName()) != null) {
            ldapName = new X500Name(name);
        }
        return ldapName;
    }

    private static Date getProductionDate(OCSPIdentifierType type) {
        Date productionDate = null;
        XMLGregorianCalendar producedAt = type.getProducedAt();
        if (producedAt != null) {
            productionDate = producedAt.toGregorianCalendar().getTime();
        }
        return productionDate;
    }
}

