/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades;

import de.governikus.csl.ades.AdESDataExtractor;
import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.validate.svp.AdESSignatureValidationResult;
import de.governikus.csl.validate.svp.ContentSignatureValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.dataExtractor.DefaultContentSignatureDataExtractor;
import de.governikus.csl.xades.QualifyingPropertiesHolder;
import de.governikus.csl.xades.XAdESSignature;
import java.util.List;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesType;

public class XAdESSignatureDataExtractor
extends DefaultContentSignatureDataExtractor<XAdESSignature, XAdESSignatureValidationResult> {
    public void extractData(XAdESSignature source, XAdESSignatureValidationResult destination) {
        super.extractData((Signature)source, (ContentSignatureValidationResult)destination);
        AdESDataExtractor.extractAdESData((AdESSignature)source, (AdESSignatureValidationResult)destination);
        destination.setSignatureType(source.getSignatureType());
        List<QualifyingPropertiesHolder> qphl = source.getRawQualifyingProperties();
        if (qphl != null) {
            QualifyingPropertiesType qualifyingProperties = null;
            for (QualifyingPropertiesHolder qph : qphl) {
                QualifyingPropertiesType properties = qph.getProperties();
                if (qualifyingProperties == null) {
                    qualifyingProperties = properties;
                }
                if (properties.getSignedProperties() == null) continue;
                qualifyingProperties = properties;
                break;
            }
            if (qualifyingProperties != null) {
                destination.setQualifyingPropertiesID(qualifyingProperties.getId());
            }
        }
    }
}

