/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.jce.XMLSecSignatureAlgorithmSpi;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.ObjectValidationResult;
import de.governikus.csl.validate.svp.XAdESSignatureValidationResult;
import de.governikus.csl.validation.AbstractDocumentPlugin;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.criteria.CheckCounterSignatures;
import de.governikus.csl.validation.criteria.CheckSigningCertificateReferences;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import de.governikus.csl.xades.XAdESDefinition;
import de.governikus.csl.xades.XAdESDocument;
import de.governikus.csl.xades.XAdESParser2;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESSignatureDataExtractor;
import de.governikus.csl.xades.XAdESValidationContext;
import de.governikus.csl.xades.criteria.CheckBannedElements;
import de.governikus.csl.xades.criteria.CheckDataObjectFormat;
import de.governikus.csl.xades.criteria.CheckRefsOnlyTimestamps;
import de.governikus.csl.xades.criteria.CheckRefsUnique;
import de.governikus.csl.xades.criteria.CheckSigAndRefsTimestamps;
import de.governikus.csl.xades.criteria.CheckSigningTime;
import de.governikus.csl.xades.criteria.CheckSpecConformity;
import de.governikus.csl.xades.criteria.CheckTimestampDates;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.signature.XMLSignatureException;

@PluginType(id=Plugin.PluginID.VALIDATE_XADES, type=ValidatePlugin.class)
public class XAdESPlugin
extends AbstractDocumentPlugin<XAdESDocument, XAdESSignature, ObjectValidationResult, XAdESSignatureValidationResult, XAdESValidationContext> {
    public XAdESPlugin() {
        super(XAdESSignature.class, XAdESValidationContext.class);
        try {
            SignatureAlgorithm.register((String)"http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", XMLSecSignatureAlgorithmSpi.XML_SHA3_256withRSAandMGF1.class);
        }
        catch (ClassNotFoundException | AlgorithmAlreadyRegisteredException | XMLSignatureException e1) {
            this.logger.debug("Can't register XML_SHA3_256withRSAandMGF1 to XML-Security");
        }
    }

    public XAdESDocument parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        try {
            XAdESParser2 dl = new XAdESParser2(this.configuration.getAlgorithmManager());
            return dl.loadDocument(doc);
        }
        catch (Exception e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document", (Throwable)e);
        }
    }

    protected ObjectValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        return SVPFactory.createObjectValidationResult((String)this.getID());
    }

    protected XAdESSignatureValidationResult createSignatureValidationResultStructure() {
        return new XAdESSignatureValidationResult();
    }

    public XAdESValidationContext createContext(XAdESSignature signature, ValidationPolicyType policy) {
        XAdESValidationContext context = new XAdESValidationContext(policy);
        context.setCertificatePathReferences(signature.getSigningCertificateReferences());
        if (policy != null) {
            boolean enConformity = policy.isENConformity();
            boolean baseLineRequired = policy.isAdesBaselineConformityRequired();
            if (enConformity) {
                if (baseLineRequired) {
                    context.setFormatDefinitionToCheck(XAdESDefinition.EN_319_132_1);
                } else {
                    context.setFormatDefinitionToCheck(XAdESDefinition.EN_319_132_2);
                }
            } else if (baseLineRequired) {
                context.setFormatDefinitionToCheck(XAdESDefinition.TS_103_171);
            } else {
                context.setFormatDefinitionToCheck(XAdESDefinition.TS_101_903);
            }
        }
        return context;
    }

    public MagicBytes getMagicBytesOfDocumentFormat() {
        return MagicBytes.MAGIC_BYTES_XML;
    }

    public static List<ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>> result = new ArrayList<ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>>();
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckSigningTime());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckDataObjectFormat());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckBannedElements());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckSpecConformity());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckTimestampDates());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckSigAndRefsTimestamps());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckRefsOnlyTimestamps());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckCounterSignatures());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckRefsUnique());
        result.add((ValidationCriterion<? super XAdESSignature, ? super XAdESSignatureValidationResult, ? super XAdESValidationContext>)new CheckSigningCertificateReferences());
        return result;
    }

    public DataExtractor<? super XAdESSignature, ? super XAdESSignatureValidationResult> getSignatureDataExtractor() {
        return new XAdESSignatureDataExtractor();
    }
}

