/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.ChangeableDocument;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.docs.StreamProviderDocument;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.CertificateReference;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.WritableSignature;
import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.CRLIDType;
import de.governikus.csl.validate.svp.CommitmentType;
import de.governikus.csl.validate.svp.OCSPIDType;
import de.governikus.csl.validate.svp.RecomputedDigestValueType;
import de.governikus.csl.validate.svp.RecomputedDigestValueV2Type;
import de.governikus.csl.validate.svp.RevIDListType;
import de.governikus.csl.validate.svp.SigPolicyIdentifierType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.SignerLocationType;
import de.governikus.csl.validate.svp.TimeAttributeType;
import de.governikus.csl.validation.tsp.TSPParser;
import de.governikus.csl.validation.tsp.TimestampFactory;
import de.governikus.csl.validation.tsp.TimestampedObject;
import de.governikus.csl.xades.CSLX509CertificateResolver;
import de.governikus.csl.xades.DocumentParser;
import de.governikus.csl.xades.QualifyingPropertiesHolder;
import de.governikus.csl.xades.XAdESDocument;
import de.governikus.csl.xades.XAdESReference;
import de.governikus.csl.xades.XAdESSignature;
import de.governikus.csl.xades.XAdESTimestamp;
import de.governikus.csl.xades.XAdESUtil;
import de.governikus.csl.xades.XAdESValidationData;
import de.governikus.csl.xades.ats.ArchiveTimestampMessageDigestProvider;
import de.governikus.csl.xades.ats.XAdESArchiveTimestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.io.IOUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverFragment;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.x509.util.StreamParsingException;
import org.etsi.uri._01903.v1_3.CRLRefType;
import org.etsi.uri._01903.v1_3.CRLRefsType;
import org.etsi.uri._01903.v1_3.CRLValuesType;
import org.etsi.uri._01903.v1_3.CertIDListType;
import org.etsi.uri._01903.v1_3.CertIDListV2Type;
import org.etsi.uri._01903.v1_3.CertIDType;
import org.etsi.uri._01903.v1_3.CertIDTypeV2;
import org.etsi.uri._01903.v1_3.CertificateValuesType;
import org.etsi.uri._01903.v1_3.CertifiedRoleTypeV2;
import org.etsi.uri._01903.v1_3.CertifiedRolesListType;
import org.etsi.uri._01903.v1_3.CertifiedRolesListTypeV2;
import org.etsi.uri._01903.v1_3.CommitmentTypeIndicationType;
import org.etsi.uri._01903.v1_3.CompleteCertificateRefsType;
import org.etsi.uri._01903.v1_3.CompleteRevocationRefsType;
import org.etsi.uri._01903.v1_3.CounterSignatureType;
import org.etsi.uri._01903.v1_3.DataObjectFormatType;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.IdentifierType;
import org.etsi.uri._01903.v1_3.OCSPIdentifierType;
import org.etsi.uri._01903.v1_3.OCSPRefType;
import org.etsi.uri._01903.v1_3.OCSPRefsType;
import org.etsi.uri._01903.v1_3.OCSPValuesType;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.etsi.uri._01903.v1_3.ObjectIdentifierType;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesReferenceType;
import org.etsi.uri._01903.v1_3.QualifyingPropertiesType;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.etsi.uri._01903.v1_3.SignaturePolicyIdType;
import org.etsi.uri._01903.v1_3.SignaturePolicyIdentifierType;
import org.etsi.uri._01903.v1_3.SignatureProductionPlaceType;
import org.etsi.uri._01903.v1_3.SignatureProductionPlaceV2Type;
import org.etsi.uri._01903.v1_3.SignedDataObjectPropertiesType;
import org.etsi.uri._01903.v1_3.SignedPropertiesType;
import org.etsi.uri._01903.v1_3.SignedSignaturePropertiesType;
import org.etsi.uri._01903.v1_3.SignerRoleType;
import org.etsi.uri._01903.v1_3.SignerRoleV2Type;
import org.etsi.uri._01903.v1_3.UnsignedDataObjectPropertiesType;
import org.etsi.uri._01903.v1_3.UnsignedPropertiesType;
import org.etsi.uri._01903.v1_3.UnsignedSignaturePropertiesType;
import org.etsi.uri._01903.v1_3.XAdESTimeStampType;
import org.etsi.uri._01903.v1_4.RenewedDigestsType;
import org.etsi.uri._01903.v1_4.RenewedDigestsV2Type;
import org.etsi.uri._01903.v1_4.ValidationDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._2000._09.xmldsig.CanonicalizationMethodType;
import org.w3._2000._09.xmldsig.DigestMethodType;
import org.w3._2000._09.xmldsig.KeyInfoType;
import org.w3._2000._09.xmldsig.ObjectType;
import org.w3._2000._09.xmldsig.SignatureType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESParser2
extends AbstractDocumentParser<XAdESDocument> {
    private static final String URI_ETSI_01903_SIGNED_PROPERTIES = "http://uri.etsi.org/01903#SignedProperties";
    private static final Logger LOGGER = LoggerFactory.getLogger(XAdESParser2.class);
    private static final String ENVELOPED_ALGO_URI = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    private final de.governikus.csl.validate.svp.ObjectFactory svpFactory = new de.governikus.csl.validate.svp.ObjectFactory();
    private CertificateFactory certFactory;
    private Binder<Node> binder;
    private AlgorithmManager algorithmManager;
    private SignedData signedData;
    private List<Document> includedData;
    private List<XAdESReference> references;
    private SignedPropertiesType signedProperties;
    private KeyInfoType keyInfo;

    public XAdESParser2(AlgorithmManager algorithmManager) throws JAXBException, CertificateException, NoSuchProviderException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{org.w3._2000._09.xmldsig.ObjectFactory.class, ObjectFactory.class, org.etsi.uri._01903.v1_4.ObjectFactory.class});
        this.binder = context.createBinder();
        this.certFactory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
        this.algorithmManager = algorithmManager;
    }

    public XAdESDocument loadDocument(SignedData sda) throws Exception {
        this.signedData = sda;
        DocumentParser docParser = new DocumentParser();
        Document signature = sda.getSignature();
        org.w3c.dom.Document doc = docParser.parse(signature);
        ReferenceResolver refResolver = sda.getSignature().getReferenceResolver();
        XAdESDocument result = new XAdESDocument();
        result.setName(signature.getName());
        this.loadDocument(doc, result, refResolver);
        return result;
    }

    public void loadDocument(org.w3c.dom.Document doc, XAdESDocument result, ReferenceResolver refResolver) throws Exception {
        result.setDocument(doc);
        List<Element> nodes = this.getSignatureNodes(doc);
        ArrayList<XAdESSignature> signatures = new ArrayList<XAdESSignature>();
        for (Element node : nodes) {
            signatures.add(this.parseSignature(node, doc, refResolver));
        }
        this.selectIncludedData(refResolver);
        result.setIncludedFilesToValidate(this.includedData);
        result.setSignatures(signatures);
    }

    private void selectIncludedData(ReferenceResolver refResolver) {
        if (this.references == null) {
            return;
        }
        for (XAdESReference ref : this.references) {
            if (!ref.isReferencingPossibleIncludedData()) continue;
            this.addReferenceToIncludedFiles(ref, refResolver);
        }
    }

    private XAdESSignature parseSignature(Element e, org.w3c.dom.Document doc, ReferenceResolver refResolver) throws JAXBException, XMLSecurityException, CertificateException, NoSuchProviderException {
        String id = e.getAttribute("id");
        if (id.isEmpty()) {
            id = null;
        }
        XMLSignature aSig = new XMLSignature(e, "");
        if (refResolver != null) {
            this.addResourceResolverToSignature(refResolver, aSig);
        }
        XAdESSignature signature = this.processSignature(aSig, refResolver);
        signature.setID(id);
        SignatureType signatureType = this.parse(e);
        signature.setRawSignedData(signatureType);
        this.keyInfo = signatureType.getKeyInfo();
        Set<SignatureValidationDataAttachment<X509Certificate>> keyInfoCerts = XAdESUtil.extractCertificatesFromKeyInfo(this.keyInfo, this.certFactory);
        if (keyInfoCerts != null && !keyInfoCerts.isEmpty()) {
            signature.setAttachedCertificates(keyInfoCerts);
        }
        List<QualifyingPropertiesHolder> qphl = this.tryToFindQualifyingProperties(signatureType, doc);
        signature.setRawQualifyingProperties(qphl);
        for (QualifyingPropertiesHolder qph : qphl) {
            UnsignedPropertiesType unsignedProperties;
            QualifyingPropertiesType qp = qph.getProperties();
            this.signedProperties = qp.getSignedProperties();
            if (this.signedProperties != null) {
                this.processSignedProperties(this.signedProperties, signature, aSig, keyInfoCerts);
            }
            if ((unsignedProperties = qp.getUnsignedProperties()) == null) continue;
            this.processUnsignedProperties(unsignedProperties, signature, aSig, doc, refResolver);
        }
        signature.setDocument(doc);
        return signature;
    }

    private void addResourceResolverToSignature(final ReferenceResolver refResolver, XMLSignature aSig) {
        aSig.addResourceResolver(new ResourceResolverSpi(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
                try (InputStream fis = refResolver.getReference(context.uriToResolve);){
                    if (fis == null) {
                        XMLSignatureInput xMLSignatureInput2 = null;
                        return xMLSignatureInput2;
                    }
                    byte[] data = IOUtils.toByteArray((InputStream)fis);
                    XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(data);
                    return xMLSignatureInput;
                }
                catch (IOException e) {
                    LOGGER.error("Error while resolving URI.", (Throwable)e);
                    return null;
                }
            }

            public boolean engineCanResolveURI(ResourceResolverContext context) {
                return refResolver.canResolve(context.uriToResolve);
            }
        });
    }

    private void processSignedProperties(SignedPropertiesType spt, XAdESSignature signature, XMLSignature aSig, Set<SignatureValidationDataAttachment<X509Certificate>> keyInfoCerts) {
        SignedDataObjectPropertiesType sdopt;
        SignedSignaturePropertiesType sspt = spt.getSignedSignatureProperties();
        if (sspt != null) {
            this.processSignedSignatureProperties(sspt, signature, keyInfoCerts);
        }
        if ((sdopt = spt.getSignedDataObjectProperties()) != null) {
            this.processSignedDataObjectProperties(signature, aSig, sspt, sdopt);
        }
    }

    private void processSignedDataObjectProperties(XAdESSignature signature, XMLSignature aSig, SignedSignaturePropertiesType sspt, SignedDataObjectPropertiesType sdopt) {
        SignatureAttributesType signatureAttributes;
        if (signature.getSignatureAttributes() == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            signature.setSignatureAttributes(signatureAttributes);
        } else {
            signatureAttributes = signature.getSignatureAttributes();
        }
        this.processDataObjectFormat(sdopt, signatureAttributes);
        this.processCommitmentTypeIndication(sdopt, signatureAttributes);
        this.processAllDataObjectsTimestamp(sdopt, signature, aSig);
        this.processIndividualDataObjectsTimeStamp(sdopt, signatureAttributes);
        this.processAttributeCertificates(signature, sspt);
    }

    private void processDataObjectFormat(SignedDataObjectPropertiesType sdopt, SignatureAttributesType signatureAttributes) {
        List dataObjectFormatTypeList = sdopt.getDataObjectFormat();
        if (dataObjectFormatTypeList != null) {
            for (DataObjectFormatType dataObjectFormatType : dataObjectFormatTypeList) {
                de.governikus.csl.validate.svp.DataObjectFormatType doft = this.svpFactory.createDataObjectFormatType();
                Optional.ofNullable(dataObjectFormatType.getDescription()).ifPresent(arg_0 -> ((de.governikus.csl.validate.svp.DataObjectFormatType)doft).setDescription(arg_0));
                Optional.ofNullable(dataObjectFormatType.getObjectIdentifier()).map(ObjectIdentifierType::getIdentifier).map(IdentifierType::getValue).ifPresent(arg_0 -> ((de.governikus.csl.validate.svp.DataObjectFormatType)doft).setContentType(arg_0));
                Optional.ofNullable(dataObjectFormatType.getMimeType()).ifPresent(arg_0 -> ((de.governikus.csl.validate.svp.DataObjectFormatType)doft).setMimeType(arg_0));
                Optional.ofNullable(dataObjectFormatType.getObjectReference()).ifPresent(arg_0 -> ((de.governikus.csl.validate.svp.DataObjectFormatType)doft).setObjectReference(arg_0));
                doft.setSigned(Boolean.TRUE);
                JAXBElement signatureAttributesTypeDataObjectFormat = this.svpFactory.createSignatureAttributesTypeDataObjectFormat(doft);
                signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(signatureAttributesTypeDataObjectFormat);
            }
        }
    }

    private void processCommitmentTypeIndication(SignedDataObjectPropertiesType sdopt, SignatureAttributesType signatureAttributes) {
        List commitmentTypeIndication = sdopt.getCommitmentTypeIndication();
        if (commitmentTypeIndication != null && !commitmentTypeIndication.isEmpty()) {
            ArrayList<de.governikus.csl.validate.svp.CommitmentTypeIndicationType> commitmentTypes = new ArrayList<de.governikus.csl.validate.svp.CommitmentTypeIndicationType>();
            for (CommitmentTypeIndicationType c : commitmentTypeIndication) {
                String value;
                de.governikus.csl.validate.svp.CommitmentTypeIndicationType ct;
                IdentifierType identifier;
                ObjectIdentifierType commitmentTypeId = c.getCommitmentTypeId();
                if (commitmentTypeId == null || (identifier = commitmentTypeId.getIdentifier()) == null || (ct = this.getCommitmentType(value = identifier.getValue())) == null) continue;
                commitmentTypes.add(ct);
            }
            for (de.governikus.csl.validate.svp.CommitmentTypeIndicationType commitment : commitmentTypes) {
                JAXBElement commitmentElem = this.svpFactory.createSignatureAttributesTypeCommitmentTypeIndication(commitment);
                signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(commitmentElem);
            }
        }
    }

    private void processAllDataObjectsTimestamp(SignedDataObjectPropertiesType sdopt, XAdESSignature signature, XMLSignature aSig) {
        List allDataTimestamps = sdopt.getAllDataObjectsTimeStamp();
        if (allDataTimestamps != null) {
            byte[] concatenatedBytes = this.concatenateReferencedSignerInfoBytes(aSig);
            ByteArrayStreamProvider bais = new ByteArrayStreamProvider(concatenatedBytes);
            ArrayList<XAdESTimestamp> ts2 = new ArrayList<XAdESTimestamp>();
            for (XAdESTimeStampType ts : allDataTimestamps) {
                List<XAdESTimestamp> timestamps = this.parseTimestamp(ts);
                for (TimestampedObject timestampedObject : timestamps) {
                    timestampedObject.setTimestampedContent((StreamProvider)bais);
                }
                ts2.addAll(timestamps);
            }
            signature.setSignedDataTimestamps(ts2);
        }
    }

    private void processIndividualDataObjectsTimeStamp(SignedDataObjectPropertiesType sdopt, SignatureAttributesType signatureAttributes) {
        List individualDataObjectsTimeStamp = sdopt.getIndividualDataObjectsTimeStamp();
        if (individualDataObjectsTimeStamp != null) {
            for (XAdESTimeStampType xAdESTimeStampType : individualDataObjectsTimeStamp) {
                List<XAdESTimestamp> parsedTimestampList = this.parseTimestamp(xAdESTimeStampType);
                for (TimestampedObject timestampedObject : parsedTimestampList) {
                    Date generationTime = timestampedObject.getGenerationTime();
                    if (generationTime == null) continue;
                    TimeAttributeType timeAttributeType = this.svpFactory.createTimeAttributeType();
                    timeAttributeType.setTime(generationTime);
                    timeAttributeType.setSigned(Boolean.TRUE);
                    JAXBElement createSignatureAttributesTypeIndividualDataObjectsTimeStamp = this.svpFactory.createSignatureAttributesTypeIndividualDataObjectsTimeStamp(timeAttributeType);
                    signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(createSignatureAttributesTypeIndividualDataObjectsTimeStamp);
                }
            }
        }
    }

    private byte[] concatenateReferencedSignerInfoBytes(XMLSignature aSig) {
        SignedInfo si = aSig.getSignedInfo();
        int length = si.getLength();
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (int i = 0; i < length; ++i) {
            try {
                Reference r = si.item(i);
                if (URI_ETSI_01903_SIGNED_PROPERTIES.equals(r.getType())) continue;
                byte[] b = r.getReferencedBytes();
                data.add(b);
                continue;
            }
            catch (Exception e) {
                LOGGER.info("Can't get referenced data: {}", (Object)e.getMessage());
            }
        }
        int size = 0;
        for (byte[] d : data) {
            size += d.length;
        }
        byte[] ba = new byte[size];
        int ctr = 0;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            byte[] d;
            byte[] byArray = d = (byte[])iterator.next();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte b;
                ba[ctr] = b = byArray[i];
                ++ctr;
            }
        }
        return ba;
    }

    private void processSignedSignatureProperties(SignedSignaturePropertiesType signatureProperties, XAdESSignature signature, Set<SignatureValidationDataAttachment<X509Certificate>> keyInfoCerts) {
        SignatureAttributesType signatureAttributes;
        if (signature.getSignatureAttributes() == null) {
            signatureAttributes = this.svpFactory.createSignatureAttributesType();
            signature.setSignatureAttributes(signatureAttributes);
        } else {
            signatureAttributes = signature.getSignatureAttributes();
        }
        this.processSigningTime(signatureProperties, signature);
        this.processSigningCertificate(signatureProperties, signature, keyInfoCerts);
        this.processSignaturePolicyIdentifier(signatureProperties, signatureAttributes);
        this.processSignatureProductionPlace(signatureProperties, signatureAttributes);
    }

    private void processSignatureProductionPlace(SignedSignaturePropertiesType signatureProperties, SignatureAttributesType signatureAttributes) {
        SignatureProductionPlaceV2Type signatureProductionPlaceV2;
        SignatureProductionPlaceType signatureProductionPlace = signatureProperties.getSignatureProductionPlace();
        if (signatureProductionPlace != null) {
            SignerLocationType location = this.createSignerLocation(null, signatureProductionPlace.getPostalCode(), signatureProductionPlace.getCity(), signatureProductionPlace.getStateOrProvince(), signatureProductionPlace.getCountryName());
            JAXBElement locationElem = this.svpFactory.createSignatureAttributesTypeSignerLocation(location);
            signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(locationElem);
        }
        if ((signatureProductionPlaceV2 = signatureProperties.getSignatureProductionPlaceV2()) != null) {
            SignerLocationType location = this.createSignerLocation(signatureProductionPlaceV2.getStreetAddress(), signatureProductionPlaceV2.getPostalCode(), signatureProductionPlaceV2.getCity(), signatureProductionPlaceV2.getStateOrProvince(), signatureProductionPlaceV2.getCountryName());
            JAXBElement locationElem = this.svpFactory.createSignatureAttributesTypeSignerLocation(location);
            signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(locationElem);
        }
    }

    private void processSignaturePolicyIdentifier(SignedSignaturePropertiesType signatureProperties, SignatureAttributesType signatureAttributes) {
        SignaturePolicyIdentifierType sigPolicyType;
        SignaturePolicyIdType signaturePolicyId;
        if (signatureProperties.getSignaturePolicyIdentifier() != null && (signaturePolicyId = (sigPolicyType = signatureProperties.getSignaturePolicyIdentifier()).getSignaturePolicyId()) != null) {
            ObjectIdentifierType sigPolicyId = signaturePolicyId.getSigPolicyId();
            IdentifierType identifier = sigPolicyId.getIdentifier();
            SigPolicyIdentifierType sigPolicyIdentifier = this.svpFactory.createSigPolicyIdentifierType();
            sigPolicyIdentifier.setSigned(Boolean.TRUE);
            sigPolicyIdentifier.setSigPolicyId(identifier.getValue());
            JAXBElement sigPolicyElem = this.svpFactory.createSignatureAttributesTypeSignaturePolicyIdentifier(sigPolicyIdentifier);
            signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(sigPolicyElem);
        }
    }

    private void processSigningCertificate(SignedSignaturePropertiesType signatureProperties, XAdESSignature signature, Set<SignatureValidationDataAttachment<X509Certificate>> keyInfoCerts) {
        Certificate cert;
        CertificateReference reference;
        List<CertificateReference> certReferences = this.getCertReferences(signatureProperties);
        X509CertificateImpl signingCertificate = signature.getSigningCertificate();
        if (!certReferences.isEmpty() && signingCertificate != null && !(reference = certReferences.get(0)).isReferenced(cert = (Certificate)signingCertificate.getWrappedCertificate())) {
            for (SignatureValidationDataAttachment<X509Certificate> possibleSigningCertificate : keyInfoCerts) {
                X509Certificate value = (X509Certificate)possibleSigningCertificate.getValue();
                if (!reference.isReferenced((Certificate)value)) continue;
                signature.setSigningCertificate(new X509CertificateImpl(value));
                break;
            }
        }
        signature.setSigningCertificateReferences(certReferences);
    }

    private void processSigningTime(SignedSignaturePropertiesType signatureProperties, XAdESSignature signature) {
        XMLGregorianCalendar signingTime = signatureProperties.getSigningTime();
        if (signingTime != null) {
            signature.setSigningTime(SVPFactory.createTypedDate((Date)signingTime.toGregorianCalendar().getTime(), (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
    }

    private List<CertificateReference> getCertReferences(SignedSignaturePropertiesType signatureProperties) {
        CertIDListV2Type certificatesV2;
        ArrayList<CertificateReference> certReferences = new ArrayList<CertificateReference>();
        CertIDListType certificates = signatureProperties.getSigningCertificate();
        if (certificates != null) {
            for (CertIDType cert : certificates.getCert()) {
                CertificateReference reference = XAdESUtil.createCertificateReference(cert, this.algorithmManager);
                if (reference == null) continue;
                certReferences.add(reference);
            }
        }
        if ((certificatesV2 = signatureProperties.getSigningCertificateV2()) != null) {
            for (CertIDTypeV2 cert : certificatesV2.getCert()) {
                CertificateReference reference = XAdESUtil.createCertificateReference(cert, this.algorithmManager);
                if (reference == null) continue;
                certReferences.add(reference);
            }
        }
        return certReferences;
    }

    private de.governikus.csl.validate.svp.CommitmentTypeIndicationType getCommitmentType(String commitmentTypeURI) {
        de.governikus.csl.validate.svp.CommitmentTypeIndicationType commitment = this.svpFactory.createCommitmentTypeIndicationType();
        commitment.setSigned(Boolean.TRUE);
        switch (commitmentTypeURI) {
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfOrigin": {
                commitment.setCommitment(CommitmentType.PROOF_OF_ORIGIN);
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfReceipt": {
                commitment.setCommitment(CommitmentType.PROOF_OF_RECEIPT);
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfDelivery": {
                commitment.setCommitment(CommitmentType.PROOF_OF_DELIVERY);
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfSender": {
                commitment.setCommitment(CommitmentType.PROOF_OF_SENDER);
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfApproval": {
                commitment.setCommitment(CommitmentType.PROOF_OF_APPROVAL);
                break;
            }
            case "http://uri.etsi.org/01903/v1.2.2#ProofOfCreation": {
                commitment.setCommitment(CommitmentType.PROOF_OF_CREATION);
                break;
            }
            default: {
                LOGGER.warn("Unknown CommitmentType URI found. Creation of internal representation is skipped. [commitmentTypeURI={}]", (Object)commitmentTypeURI);
                return null;
            }
        }
        return commitment;
    }

    private SignerLocationType createSignerLocation(String streetAddress, String postalCode, String city, String stateOrProvince, String countryName) {
        SignerLocationType location = new SignerLocationType();
        location.setCountryName(countryName);
        location.setLocalityName(city);
        if (streetAddress == null && postalCode == null && stateOrProvince == null) {
            return location;
        }
        List address = location.getAddress();
        if (streetAddress != null) {
            address.add(streetAddress);
        }
        if (postalCode != null && city != null) {
            address.add(postalCode + " " + city);
        } else {
            if (postalCode != null) {
                address.add(postalCode);
            }
            if (city != null) {
                address.add(city);
            }
        }
        if (stateOrProvince != null) {
            address.add(stateOrProvince);
        }
        if (countryName != null) {
            address.add(countryName);
        }
        location.setSigned(Boolean.TRUE);
        return location;
    }

    private void processAttributeCertificates(XAdESSignature signature, SignedSignaturePropertiesType sspt) {
        LinkedHashSet<AttributeCertificate> attributeCertificates = new LinkedHashSet<AttributeCertificate>();
        this.addAttributeCertificatesFromSignerRole(sspt, attributeCertificates);
        this.addAttributeCertificatesFromSignerRoleV2(sspt, attributeCertificates);
        if (!attributeCertificates.isEmpty()) {
            signature.setAttributeCertificates(attributeCertificates);
        }
    }

    private void addAttributeCertificatesFromSignerRole(SignedSignaturePropertiesType sspt, Set<AttributeCertificate> attributeCertificates) {
        SignerRoleType signerRole = sspt.getSignerRole();
        Optional.ofNullable(signerRole).map(SignerRoleType::getCertifiedRoles).map(CertifiedRolesListType::getCertifiedRole).ifPresent(x -> x.forEach(c -> this.addAttributeCertificate(attributeCertificates, (EncapsulatedPKIDataType)c)));
    }

    private void addAttributeCertificatesFromSignerRoleV2(SignedSignaturePropertiesType sspt, Set<AttributeCertificate> attributeCertificates) {
        SignerRoleV2Type signerRole = sspt.getSignerRoleV2();
        Optional.ofNullable(signerRole).map(SignerRoleV2Type::getCertifiedRolesV2).map(CertifiedRolesListTypeV2::getCertifiedRole).ifPresent(l -> l.forEach(x -> this.addAttributeCertificate(attributeCertificates, (CertifiedRoleTypeV2)x)));
    }

    private void addAttributeCertificate(Set<AttributeCertificate> attributeCertificates, EncapsulatedPKIDataType attributeCert) {
        if (attributeCert != null) {
            attributeCertificates.add(AttributeCertificate.getInstance((Object)attributeCert.getValue()));
        }
    }

    private void addAttributeCertificate(Set<AttributeCertificate> attributeCertificates, CertifiedRoleTypeV2 certifiedRole) {
        if (certifiedRole != null) {
            EncapsulatedPKIDataType x509AttributeCertificate = certifiedRole.getX509AttributeCertificate();
            this.addAttributeCertificate(attributeCertificates, x509AttributeCertificate);
        }
    }

    private void processUnsignedProperties(UnsignedPropertiesType unsignedProperties, XAdESSignature signature, XMLSignature aSig, org.w3c.dom.Document d, ReferenceResolver f) throws CertificateException, NoSuchProviderException {
        UnsignedDataObjectPropertiesType unsignedDataObjectProperties;
        UnsignedSignaturePropertiesType unsignedSignatureProperties;
        if (signature.getSignatureAttributes() == null) {
            SignatureAttributesType signatureAttributes = this.svpFactory.createSignatureAttributesType();
            signature.setSignatureAttributes(signatureAttributes);
        }
        if ((unsignedSignatureProperties = unsignedProperties.getUnsignedSignatureProperties()) != null) {
            this.processUnsignedSignatureProperties(signature, aSig, d, f, unsignedSignatureProperties);
        }
        if ((unsignedDataObjectProperties = unsignedProperties.getUnsignedDataObjectProperties()) != null) {
            this.processUnsignedDataObjectProperties(unsignedDataObjectProperties);
        }
    }

    private void processUnsignedDataObjectProperties(UnsignedDataObjectPropertiesType unsignedDataObjectProperties) {
    }

    private void processUnsignedSignatureProperties(XAdESSignature signature, XMLSignature aSig, org.w3c.dom.Document d, ReferenceResolver f, UnsignedSignaturePropertiesType unsignedSignatureProperties) throws CertificateException, NoSuchProviderException {
        List counterSignatureOrSignatureTimeStampOrCompleteCertificateRefs = unsignedSignatureProperties.getCounterSignatureOrSignatureTimeStampOrCompleteCertificateRefs();
        HashSet<SignatureValidationDataAttachment<X509Certificate>> timestampValidationCertificates = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
        ArrayList<SignatureValidationDataAttachment<OCSPResp>> timestampValidationOCSPs = new ArrayList<SignatureValidationDataAttachment<OCSPResp>>();
        ArrayList<SignatureValidationDataAttachment<CRL>> timestampValidationCRLs = new ArrayList<SignatureValidationDataAttachment<CRL>>();
        ArrayList<TimestampedObject> signatureTimestamps = new ArrayList<TimestampedObject>();
        ArrayList<XAdESArchiveTimestamp> archiveTimestamps = new ArrayList<XAdESArchiveTimestamp>();
        int archiveTimestampPos = 0;
        int unsignedPropsPos = 0;
        for (Object o : counterSignatureOrSignatureTimeStampOrCompleteCertificateRefs) {
            RenewedDigestsType rdt;
            int pos = ++unsignedPropsPos;
            String name = null;
            if (o instanceof JAXBElement) {
                JAXBElement jaxB = (JAXBElement)o;
                o = jaxB.getValue();
                name = jaxB.getName().getLocalPart();
            }
            if (o instanceof XAdESTimeStampType) {
                XAdESTimeStampType tst = (XAdESTimeStampType)o;
                this.processUnsignedXAdESTimeStampProperties(signature, aSig, unsignedSignatureProperties, signatureTimestamps, archiveTimestamps, archiveTimestampPos, pos, name, tst);
                continue;
            }
            if (o instanceof CertificateValuesType) {
                CertificateValuesType cvt = (CertificateValuesType)o;
                this.processCertificateValues(signature, pos, name, cvt);
                continue;
            }
            if (o instanceof RevocationValuesType) {
                RevocationValuesType rvt = (RevocationValuesType)o;
                this.processRevocationValues(signature, pos, rvt);
                continue;
            }
            if (o instanceof CounterSignatureType) {
                CounterSignatureType counterSignatureType = (CounterSignatureType)o;
                this.processCounterSignature(signature, d, f, counterSignatureType);
                continue;
            }
            if (o instanceof ValidationDataType) {
                ValidationDataType validationData = (ValidationDataType)o;
                if (!"TimeStampValidationData".equals(name)) continue;
                CertificateValuesType cvt = validationData.getCertificateValues();
                this.processTimeStampValidationData(timestampValidationCertificates, timestampValidationOCSPs, timestampValidationCRLs, pos, validationData, cvt);
                continue;
            }
            if (o instanceof CompleteCertificateRefsType) {
                CompleteCertificateRefsType ccrt = (CompleteCertificateRefsType)o;
                this.processCompleteCertificateRefs(signature, ccrt);
                continue;
            }
            if (o instanceof CompleteRevocationRefsType) {
                CompleteRevocationRefsType crrt = (CompleteRevocationRefsType)o;
                this.processCompleteRevocationRefs(signature, crrt);
                continue;
            }
            if (o instanceof RenewedDigestsType) {
                rdt = (RenewedDigestsType)o;
                this.processRenewedDigests(signature, rdt);
                continue;
            }
            if (!(o instanceof RenewedDigestsV2Type)) continue;
            rdt = (RenewedDigestsV2Type)o;
            this.processRenewedDigestsV2(signature, (RenewedDigestsV2Type)rdt);
        }
        if (!archiveTimestamps.isEmpty()) {
            signature.setArchiveTimestamps(archiveTimestamps);
        }
        if (!signatureTimestamps.isEmpty()) {
            signature.setSignatureTimestamps(signatureTimestamps);
            for (TimestampedObject to : signatureTimestamps) {
                if (!timestampValidationCertificates.isEmpty()) {
                    HashSet<SignatureValidationDataAttachment<X509Certificate>> timestampCerts = to.getAttachedCertificates();
                    if (timestampCerts == null) {
                        timestampCerts = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
                        to.setAttachedCertificates(timestampCerts);
                    }
                    timestampCerts.addAll(timestampValidationCertificates);
                }
                if (!timestampValidationCRLs.isEmpty()) {
                    List timestampCRLs = to.getAttachedCRLs();
                    if (timestampCRLs == null) {
                        to.setAttachedCRLs(timestampValidationCRLs);
                    } else {
                        timestampCRLs.addAll(timestampValidationCRLs);
                    }
                }
                if (timestampValidationOCSPs.isEmpty()) continue;
                List timestampOCSPs = to.getAttachedOCSPValues();
                if (timestampOCSPs == null) {
                    to.setAttachedOCSPValues(timestampValidationOCSPs);
                    continue;
                }
                timestampOCSPs.addAll(timestampValidationOCSPs);
            }
        }
    }

    private void processRenewedDigests(XAdESSignature signature, RenewedDigestsType rdt) {
        de.governikus.csl.validate.svp.RenewedDigestsType renewedDigestsType = this.svpFactory.createRenewedDigestsType();
        DigestMethodType digestMethod = rdt.getDigestMethod();
        String algorithm = digestMethod.getAlgorithm();
        DigestAlgorithm digestAlgorithmByJcaOidOrUrl = this.algorithmManager.getDigestAlgorithmByJcaOidOrUrl(algorithm, algorithm, algorithm);
        de.governikus.csl.validate.svp.DigestAlgorithm digestAlgorithm = SVPFactory.createDigestAlgorithm((DigestAlgorithm)digestAlgorithmByJcaOidOrUrl);
        renewedDigestsType.setDigestMethod(digestAlgorithm);
        List recomputedDigestValues = rdt.getRecomputedDigestValue();
        for (org.etsi.uri._01903.v1_4.RecomputedDigestValueType reComDigVal : recomputedDigestValues) {
            BigInteger order = reComDigVal.getOrder();
            if (order == null) continue;
            RecomputedDigestValueType recomputedDigestValueType = this.svpFactory.createRecomputedDigestValueType();
            recomputedDigestValueType.setOrder(order);
            recomputedDigestValueType.setValue(reComDigVal.getValue());
            renewedDigestsType.getRecomputedDigestValue().add(recomputedDigestValueType);
        }
        JAXBElement signatureAttributesTypeRenewedDigest = this.svpFactory.createSignatureAttributesTypeRenewedDigests(renewedDigestsType);
        signature.getSignatureAttributes().getSigningTimeOrSigningCertificateOrDataObjectFormat().add(signatureAttributesTypeRenewedDigest);
    }

    private void processRenewedDigestsV2(XAdESSignature signature, RenewedDigestsV2Type rdt) {
        DigestMethodType digestMethodType;
        de.governikus.csl.validate.svp.RenewedDigestsV2Type renewedDigestsV2Type = this.svpFactory.createRenewedDigestsV2Type();
        CanonicalizationMethodType canonicalizationMethodType = rdt.getCanonicalizationMethod();
        if (canonicalizationMethodType != null) {
            renewedDigestsV2Type.setCanonicalizationMethod(canonicalizationMethodType.getAlgorithm());
        }
        if ((digestMethodType = rdt.getDigestMethod()) != null) {
            String algorithm = digestMethodType.getAlgorithm();
            DigestAlgorithm digestAlgorithmByJcaOidOrUrl = this.algorithmManager.getDigestAlgorithmByJcaOidOrUrl(algorithm, algorithm, algorithm);
            de.governikus.csl.validate.svp.DigestAlgorithm digestAlgorithm = SVPFactory.createDigestAlgorithm((DigestAlgorithm)digestAlgorithmByJcaOidOrUrl);
            renewedDigestsV2Type.setDigestMethod(digestAlgorithm);
        }
        List recomputedDigestValues = rdt.getRecomputedDigestValue();
        for (org.etsi.uri._01903.v1_4.RecomputedDigestValueV2Type reComDigVal : recomputedDigestValues) {
            byte[] originalRefDigest;
            RecomputedDigestValueV2Type recomputedDigestValueV2Type = this.svpFactory.createRecomputedDigestValueV2Type();
            byte[] newSDODigestValue = reComDigVal.getNewSDODigestValue();
            if (newSDODigestValue != null) {
                recomputedDigestValueV2Type.setNewSDODigestValue(newSDODigestValue);
            }
            if ((originalRefDigest = reComDigVal.getOriginalRefDigest()) != null) {
                recomputedDigestValueV2Type.setOriginalRefDigest(originalRefDigest);
            }
            renewedDigestsV2Type.getRecomputedDigestValue().add(recomputedDigestValueV2Type);
        }
        JAXBElement signatureAttributesTypeRenewedDigestsV2 = this.svpFactory.createSignatureAttributesTypeRenewedDigestsV2(renewedDigestsV2Type);
        signature.getSignatureAttributes().getSigningTimeOrSigningCertificateOrDataObjectFormat().add(signatureAttributesTypeRenewedDigestsV2);
    }

    private void processCompleteRevocationRefs(XAdESSignature signature, CompleteRevocationRefsType crrt) {
        RevIDListType revIDListType = this.svpFactory.createRevIDListType();
        this.processCRLRefs(crrt, revIDListType);
        this.processOCSPRefs(crrt, revIDListType);
        if (!revIDListType.getCRLIDOrOCSPID().isEmpty()) {
            JAXBElement signatureAttributesTypeCompleteRevocationRefs = this.svpFactory.createSignatureAttributesTypeCompleteRevocationRefs(revIDListType);
            signature.getSignatureAttributes().getSigningTimeOrSigningCertificateOrDataObjectFormat().add(signatureAttributesTypeCompleteRevocationRefs);
        }
    }

    private void processCRLRefs(CompleteRevocationRefsType crrt, RevIDListType createRevIDListType) {
        CRLRefsType crlRefsType = crrt.getCRLRefs();
        List crlRefs = crlRefsType.getCRLRef();
        for (CRLRefType crlRef : crlRefs) {
            DigestMethodType digestMethod;
            DigestAlgAndValueType digestAlgAndValue = crlRef.getDigestAlgAndValue();
            if (digestAlgAndValue == null || (digestMethod = digestAlgAndValue.getDigestMethod()) == null) continue;
            String algorithm = digestMethod.getAlgorithm();
            CRLIDType createCRLIDType = this.svpFactory.createCRLIDType();
            DigestAlgorithm digestAlgorithmByJcaOidOrUrl = this.algorithmManager.getDigestAlgorithmByJcaOidOrUrl(algorithm, algorithm, algorithm);
            de.governikus.csl.validate.svp.DigestAlgorithm createDigestAlgorithm = this.svpFactory.createDigestAlgorithm();
            createDigestAlgorithm.setDigestSize(digestAlgorithmByJcaOidOrUrl.getDigestSize());
            createDigestAlgorithm.setJCAName(digestAlgorithmByJcaOidOrUrl.getJCAName());
            createDigestAlgorithm.setName(digestAlgorithmByJcaOidOrUrl.getName());
            createDigestAlgorithm.setOID(digestAlgorithmByJcaOidOrUrl.getOID());
            createDigestAlgorithm.setURI(digestAlgorithmByJcaOidOrUrl.getURI());
            createCRLIDType.setDigestMethod(createDigestAlgorithm);
            createCRLIDType.setDigestValue(digestAlgAndValue.getDigestValue());
            createRevIDListType.getCRLIDOrOCSPID().add(createCRLIDType);
        }
    }

    private void processOCSPRefs(CompleteRevocationRefsType crrt, RevIDListType createRevIDListType) {
        OCSPRefsType ocspRefsType = crrt.getOCSPRefs();
        List ocspRefs = ocspRefsType.getOCSPRef();
        for (OCSPRefType ocspRef : ocspRefs) {
            DigestMethodType digestMethod;
            DigestAlgAndValueType digestAlgAndValue = ocspRef.getDigestAlgAndValue();
            if (digestAlgAndValue == null || (digestMethod = digestAlgAndValue.getDigestMethod()) == null) continue;
            OCSPIDType createOCSPIDType = this.svpFactory.createOCSPIDType();
            OCSPIdentifierType ocspIdentifier = ocspRef.getOCSPIdentifier();
            Optional.ofNullable(ocspIdentifier).map(OCSPIdentifierType::getProducedAt).map(XMLGregorianCalendar::toGregorianCalendar).map(Calendar::getTime).ifPresent(arg_0 -> ((OCSPIDType)createOCSPIDType).setProducedAt(arg_0));
            Optional.ofNullable(ocspIdentifier).map(OCSPIdentifierType::getResponderID).ifPresent(y -> createOCSPIDType.setResponderIDByKey(y.getByKey()));
            Optional.ofNullable(ocspIdentifier).map(OCSPIdentifierType::getResponderID).ifPresent(y -> createOCSPIDType.setResponderIDByName(y.getByName()));
            createRevIDListType.getCRLIDOrOCSPID().add(createOCSPIDType);
        }
    }

    private void processCompleteCertificateRefs(XAdESSignature signature, CompleteCertificateRefsType ccrt) {
        ArrayList<CertificateReference> certReferences = signature.getCompleteCertificateReferences();
        if (certReferences == null) {
            certReferences = new ArrayList<CertificateReference>();
        }
        CertIDListType certRefs = ccrt.getCertRefs();
        List certList = certRefs.getCert();
        for (CertIDType cert : certList) {
            CertificateReference certRef = XAdESUtil.createCertificateReference(cert, this.algorithmManager);
            certReferences.add(certRef);
        }
        signature.setCompleteCertificateReferences(certReferences);
    }

    private void processTimeStampValidationData(Set<SignatureValidationDataAttachment<X509Certificate>> timestampValidationCertificates, List<SignatureValidationDataAttachment<OCSPResp>> timestampValidationOCSPs, List<SignatureValidationDataAttachment<CRL>> timestampValidationCRLs, int pos, ValidationDataType validationData, CertificateValuesType cvt) throws CertificateException {
        RevocationValuesType revocationValues;
        Set<SignatureValidationDataAttachment<X509Certificate>> certs;
        if (cvt != null && !(certs = this.parseCertificateValue(cvt, pos)).isEmpty()) {
            timestampValidationCertificates.addAll(certs);
        }
        if ((revocationValues = validationData.getRevocationValues()) != null) {
            RevocationValuesBundle revocs = this.parseRevocationValue(revocationValues);
            if (revocs.crls != null) {
                timestampValidationCRLs.addAll(revocs.crls.stream().map(x -> new XAdESValidationData<CRL>((CRL)x, pos)).collect(Collectors.toList()));
            }
            if (revocs.ocsp != null) {
                timestampValidationOCSPs.addAll(revocs.ocsp.stream().map(x -> new XAdESValidationData<OCSPResp>((OCSPResp)x, pos)).collect(Collectors.toList()));
            }
        }
    }

    private void processCounterSignature(XAdESSignature signature, org.w3c.dom.Document d, ReferenceResolver f, CounterSignatureType counterSignatureType) throws CertificateException, NoSuchProviderException {
        SignatureType sig = counterSignatureType.getSignature();
        String id = sig.getId();
        if (id != null && !id.isEmpty()) {
            Element counterSig = d.getElementById(id);
            try {
                XAdESSignature counterSignature = this.parseSignature(counterSig, d, f);
                ArrayList<XAdESSignature> childs = signature.getCounterSignatures();
                if (childs == null) {
                    childs = new ArrayList<XAdESSignature>();
                    signature.setCounterSignatures(childs);
                }
                childs.add(counterSignature);
            }
            catch (JAXBException | XMLSecurityException e) {
                LOGGER.warn("Can't parse counter signature.", e);
            }
        }
    }

    private void processRevocationValues(XAdESSignature signature, int unsignedPropertiesPosition, RevocationValuesType rvt) {
        RevocationValuesBundle revocs = this.parseRevocationValue(rvt);
        if (revocs.crls != null) {
            signature.setAttachedCRLs(revocs.crls.stream().map(x -> new XAdESValidationData<CRL>((CRL)x, unsignedPropertiesPosition)).collect(Collectors.toList()));
        }
        if (revocs.ocsp != null) {
            signature.setAttachedOCSPValues(revocs.ocsp.stream().map(x -> new XAdESValidationData<OCSPResp>((OCSPResp)x, unsignedPropertiesPosition)).collect(Collectors.toList()));
        }
    }

    private void processCertificateValues(XAdESSignature signature, int pos, String name, CertificateValuesType cvt) throws CertificateException {
        Set<SignatureValidationDataAttachment<X509Certificate>> certs = this.parseCertificateValue(cvt, pos);
        if ("CertificateValues".equalsIgnoreCase(name) && !certs.isEmpty()) {
            Set attachedCerts = signature.getAttachedCertificates();
            if (attachedCerts != null) {
                attachedCerts.addAll(certs);
            } else {
                signature.setAttachedCertificates(certs);
            }
        }
    }

    private void processUnsignedXAdESTimeStampProperties(XAdESSignature signature, XMLSignature aSig, UnsignedSignaturePropertiesType sigProps, List<TimestampedObject> signatureTimestamps, List<XAdESArchiveTimestamp> archiveTimestamps, int archiveTimestampPos, int unsignedPropertiesPosition, String name, XAdESTimeStampType tst) {
        if ("SignatureTimeStamp".equals(name)) {
            List<XAdESTimestamp> parseSignatureTimestamp = this.parseSignatureTimestamp(tst, aSig);
            if (!parseSignatureTimestamp.isEmpty()) {
                parseSignatureTimestamp.forEach(x -> x.setUnsignedPropertiesPosition(unsignedPropertiesPosition));
                signatureTimestamps.addAll(parseSignatureTimestamp);
            }
        } else if ("SigAndRefsTimeStamp".equals(name)) {
            this.processSigAndRefsTimestamp(tst, signature, aSig);
        } else if ("RefsOnlyTimeStamp".equals(name)) {
            this.processRefsOnlyTimestamp(tst, signature, sigProps);
        } else if ("ArchiveTimeStamp".equals(name)) {
            List<XAdESArchiveTimestamp> parseArchiveTimestamp = this.parseArchiveTimestamp(tst, aSig, archiveTimestampPos++);
            parseArchiveTimestamp.forEach(x -> x.setUnsignedPropertiesPosition(unsignedPropertiesPosition));
            archiveTimestamps.addAll(parseArchiveTimestamp);
        }
    }

    private void processRefsOnlyTimestamp(XAdESTimeStampType tst, XAdESSignature signature, UnsignedSignaturePropertiesType sigProps) {
        List<XAdESTimestamp> timestamps = this.parseTimestamp(tst);
        Node unsignedSignaturePropertiesElement = (Node)this.binder.getXMLNode((Object)sigProps);
        if (!timestamps.isEmpty()) {
            signature.setRefsOnlyTimestamps(timestamps);
            String canonicalizerAlgorithm = "http://www.w3.org/2006/12/xml-c14n11";
            CanonicalizationMethodType cmt = tst.getCanonicalizationMethod();
            if (cmt != null) {
                canonicalizerAlgorithm = cmt.getAlgorithm();
            }
            try {
                ArrayList<byte[]> datas = new ArrayList<byte[]>();
                byte[] signedContent = null;
                int length = 0;
                NodeList childs = unsignedSignaturePropertiesElement.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node child = childs.item(i);
                    String string = child.getNodeName();
                    if (!string.endsWith("CompleteCertificateRefs") && !string.endsWith("CompleteRevocationRefs") && !string.endsWith("AttributeCertificateRefs") && !string.endsWith("AttributeRevocationRefs")) continue;
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        Canonicalizer canon = Canonicalizer.getInstance((String)canonicalizerAlgorithm);
                        canon.canonicalizeSubtree(child, (OutputStream)baos);
                        signedContent = baos.toByteArray();
                        datas.add(signedContent);
                        length += signedContent.length;
                        continue;
                    }
                }
                signedContent = new byte[length];
                int pos = 0;
                for (byte[] byArray : datas) {
                    System.arraycopy(byArray, 0, signedContent, pos, byArray.length);
                    pos += byArray.length;
                }
                for (WritableTimestamp writableTimestamp : timestamps) {
                    writableTimestamp.setTimestampedContent((StreamProvider)new ByteArrayStreamProvider(signedContent));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while parsing refs only timestamp.", (Throwable)e);
            }
        }
    }

    private void processSigAndRefsTimestamp(XAdESTimeStampType tst, XAdESSignature signature, XMLSignature aSig) {
        List<XAdESTimestamp> timestamps = this.parseTimestamp(tst);
        if (!timestamps.isEmpty()) {
            signature.setSigAndRefsTimestamps(timestamps);
            String canonicalizerAlgorithm = "http://www.w3.org/2006/12/xml-c14n11";
            CanonicalizationMethodType cmt = tst.getCanonicalizationMethod();
            if (cmt != null) {
                canonicalizerAlgorithm = cmt.getAlgorithm();
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Canonicalizer canon = Canonicalizer.getInstance((String)canonicalizerAlgorithm);
                Element elem = aSig.getElement();
                NodeList nl1 = elem.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "UnsignedSignatureProperties");
                Node unsignedSignaturePropertiesElement = nl1.item(0);
                NodeList sigValue = elem.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
                ArrayList<byte[]> datas = new ArrayList<byte[]>();
                canon.canonicalizeSubtree(sigValue.item(0), (OutputStream)baos);
                byte[] signedContent = baos.toByteArray();
                baos.reset();
                int length = signedContent.length;
                datas.add(signedContent);
                NodeList childs = unsignedSignaturePropertiesElement.getChildNodes();
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node child = childs.item(i);
                    String string = child.getNodeName();
                    if (!string.endsWith("SignatureTimeStamp") && !string.endsWith("CompleteCertificateRefs") && !string.endsWith("CompleteRevocationRefs") && !string.endsWith("AttributeCertificateRefs") && !string.endsWith("AttributeRevocationRefs")) continue;
                    canon = Canonicalizer.getInstance((String)canonicalizerAlgorithm);
                    canon.canonicalizeSubtree(child, (OutputStream)baos);
                    signedContent = baos.toByteArray();
                    baos.reset();
                    datas.add(signedContent);
                    length += signedContent.length;
                }
                ByteBuffer bb = ByteBuffer.allocate(length);
                for (byte[] byArray : datas) {
                    bb.put(byArray);
                }
                signedContent = bb.array();
                for (WritableTimestamp writableTimestamp : timestamps) {
                    writableTimestamp.setTimestampedContent((StreamProvider)new ByteArrayStreamProvider(signedContent));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while parsing sig and refs timestamp.", (Throwable)e);
            }
        }
    }

    private RevocationValuesBundle parseRevocationValue(RevocationValuesType rvt) {
        OCSPValuesType ocspValues;
        X509CRLParser parser = new X509CRLParser();
        CRLValuesType cvt = rvt.getCRLValues();
        RevocationValuesBundle result = new RevocationValuesBundle();
        if (cvt != null) {
            ArrayList<CRL> crlValues = new ArrayList<CRL>();
            for (EncapsulatedPKIDataType epdt : cvt.getEncapsulatedCRLValue()) {
                byte[] bytes = epdt.getValue();
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    Throwable throwable = null;
                    try {
                        parser.engineInit((InputStream)bais);
                        Collection c = parser.engineReadAll();
                        for (Object o : c) {
                            CRL crl = (CRL)o;
                            crlValues.add(crl);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bais == null) continue;
                        if (throwable != null) {
                            try {
                                bais.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        bais.close();
                    }
                }
                catch (IOException | StreamParsingException e) {
                    LOGGER.error("Error while processing revocation value.", e);
                }
            }
            result.crls = crlValues;
        }
        if ((ocspValues = rvt.getOCSPValues()) != null) {
            ArrayList<OCSPResp> ocspResponses = new ArrayList<OCSPResp>();
            for (EncapsulatedPKIDataType epdt : ocspValues.getEncapsulatedOCSPValue()) {
                byte[] bytes = epdt.getValue();
                try {
                    OCSPResp ocsp = new OCSPResp(bytes);
                    ocspResponses.add(ocsp);
                }
                catch (IOException e) {
                    LOGGER.error("Error while processing revocation value.", (Throwable)e);
                }
            }
            result.ocsp = ocspResponses;
        }
        return result;
    }

    private Set<SignatureValidationDataAttachment<X509Certificate>> parseCertificateValue(CertificateValuesType cvt, int unsignedPropertyPosition) throws CertificateException {
        HashSet<SignatureValidationDataAttachment<X509Certificate>> certs = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
        for (Object o : cvt.getEncapsulatedX509CertificateOrOtherCertificate()) {
            if (!(o instanceof EncapsulatedPKIDataType)) continue;
            EncapsulatedPKIDataType pki = (EncapsulatedPKIDataType)o;
            byte[] bytes = pki.getValue();
            try {
                X509Certificate cert = (X509Certificate)this.certFactory.generateCertificate(new ByteArrayInputStream(bytes));
                certs.add((SignatureValidationDataAttachment<X509Certificate>)new XAdESValidationData<X509Certificate>(cert, unsignedPropertyPosition));
            }
            catch (CertificateException e) {
                LOGGER.error("Error while parsing certificate.", (Throwable)e);
            }
        }
        return certs;
    }

    private List<XAdESTimestamp> parseTimestamp(XAdESTimeStampType tst) {
        return this.parseTimestamp(tst, XAdESTimestamp::new);
    }

    private <T extends WritableTimestamp<S>, S extends WritableSignature> List<T> parseTimestamp(XAdESTimeStampType tst, TimestampFactory<T, S> factory) {
        ArrayList timestamps = new ArrayList();
        for (Object o : tst.getEncapsulatedTimeStampOrXMLTimeStamp()) {
            if (!(o instanceof EncapsulatedPKIDataType)) continue;
            EncapsulatedPKIDataType pki = (EncapsulatedPKIDataType)o;
            byte[] bytes = pki.getValue();
            SignatureTimeStampToken stst = null;
            try {
                stst = new SignatureTimeStampToken((Source)new BSource(bytes));
                TSPParser tspParser = new TSPParser(this.algorithmManager);
                timestamps.addAll(tspParser.parse(stst.getSignedData(), null, factory));
            }
            catch (ParseException e) {
                LOGGER.error("Error while parsing timestamp.", (Throwable)e);
            }
        }
        return timestamps;
    }

    private List<XAdESTimestamp> parseSignatureTimestamp(XAdESTimeStampType tst, XMLSignature aSig) {
        List<XAdESTimestamp> timestamps = this.parseTimestamp(tst);
        if (!timestamps.isEmpty()) {
            String canonicalizerAlgorithm = "http://www.w3.org/2006/12/xml-c14n11";
            CanonicalizationMethodType cmt = tst.getCanonicalizationMethod();
            if (cmt != null) {
                canonicalizerAlgorithm = cmt.getAlgorithm();
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Canonicalizer canon = Canonicalizer.getInstance((String)canonicalizerAlgorithm);
                Element elem = aSig.getElement();
                NodeList sigValue = elem.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
                canon.canonicalizeSubtree(sigValue.item(0), (OutputStream)baos);
                byte[] signedContent = baos.toByteArray();
                for (WritableTimestamp writableTimestamp : timestamps) {
                    writableTimestamp.setTimestampedContent((StreamProvider)new ByteArrayStreamProvider(signedContent));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while parsing signature timestamp.", (Throwable)e);
            }
        }
        return timestamps;
    }

    private List<XAdESArchiveTimestamp> parseArchiveTimestamp(XAdESTimeStampType tst, XMLSignature aSig, int archiveTimestampPos) {
        List<XAdESArchiveTimestamp> timestamps = this.parseTimestamp(tst, new XAdESArchiveTimestampFactory());
        if (!timestamps.isEmpty()) {
            try {
                String canonicalizationMethod = aSig.getSignedInfo().getCanonicalizationMethodURI();
                CanonicalizationMethodType canonicalizationMethodTst = tst.getCanonicalizationMethod();
                if (canonicalizationMethodTst != null && !canonicalizationMethodTst.getAlgorithm().isEmpty()) {
                    canonicalizationMethod = canonicalizationMethodTst.getAlgorithm();
                } else {
                    LOGGER.warn("ArchiveTimestamp misses the canonicalization method. Using canonicalization method of SignedInfo in the Signature object. [archiveTimestampId={}, canonicalizationMethodSignedInfo={}]", (Object)tst.getId(), (Object)canonicalizationMethod);
                }
                for (WritableTimestamp writableTimestamp : timestamps) {
                    writableTimestamp.setTimestampedContent((StreamProvider)new ArchiveTimestampMessageDigestProvider(aSig, canonicalizationMethod, archiveTimestampPos, this.signedData.getContents()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while parsing signature timestamp.", (Throwable)e);
            }
        }
        return timestamps;
    }

    private SignatureType parse(Element e) throws JAXBException {
        JAXBElement jaxbSig = this.binder.unmarshal((Object)e, SignatureType.class);
        return (SignatureType)jaxbSig.getValue();
    }

    private List<QualifyingPropertiesHolder> tryToFindQualifyingProperties(SignatureType signature, org.w3c.dom.Document d) {
        ArrayList<QualifyingPropertiesHolder> result = new ArrayList<QualifyingPropertiesHolder>();
        List objectTypes = signature.getObject();
        for (ObjectType objectType : objectTypes) {
            List objects = objectType.getContent();
            for (Object o : objects) {
                if (o instanceof JAXBElement) {
                    JAXBElement jaxB = (JAXBElement)o;
                    o = jaxB.getValue();
                }
                if (o instanceof QualifyingPropertiesType) {
                    QualifyingPropertiesType e = (QualifyingPropertiesType)o;
                    result.add(new QualifyingPropertiesHolder(e, objectType));
                    continue;
                }
                if (!(o instanceof QualifyingPropertiesReferenceType)) continue;
                QualifyingPropertiesReferenceType reference = (QualifyingPropertiesReferenceType)o;
                String uri = reference.getURI();
                Element elementById = d.getElementById(uri);
                if (elementById != null) {
                    QualifyingPropertiesType properties = this.parseQualifyingProperties(elementById);
                    if (properties == null) {
                        LOGGER.info("Can't parse resolved qualifying properties reference");
                        continue;
                    }
                    result.add(new QualifyingPropertiesHolder(properties, objectType, reference));
                    continue;
                }
                LOGGER.info("Can't resolve qualifying properties reference");
            }
        }
        return result;
    }

    private QualifyingPropertiesType parseQualifyingProperties(Element e) {
        try {
            JAXBElement jaxbSig = this.binder.unmarshal((Object)e, QualifyingPropertiesType.class);
            return (QualifyingPropertiesType)jaxbSig.getValue();
        }
        catch (JAXBException e1) {
            return null;
        }
    }

    private XAdESSignature processSignature(XMLSignature aSig, ReferenceResolver refResolver) {
        XAdESSignature result = new XAdESSignature();
        try {
            result.setSignatureValue(aSig.getSignatureValue());
        }
        catch (XMLSignatureException e2) {
            LOGGER.warn("Can't get signature value.", (Throwable)e2);
        }
        KeyInfo key = aSig.getKeyInfo();
        key.registerInternalKeyResolver((KeyResolverSpi)new CSLX509CertificateResolver());
        try {
            result.setSigningCertificate(new X509CertificateImpl(key.getX509Certificate()));
        }
        catch (KeyResolverException e1) {
            LOGGER.warn("Can't get signing certificate.", (Throwable)e1);
        }
        SignedInfo si = aSig.getSignedInfo();
        SignatureAlgorithm signatureAlgorithm = this.algorithmManager.getSignatureAlgorithmByURI(si.getSignatureAlgorithm().getAlgorithmURI());
        result.setSignatureAlgorithm(signatureAlgorithm);
        try {
            result.setSignedContent((Document)new ByteArrayDocument(si.getCanonicalizedOctetStream()));
        }
        catch (IOException | XMLSecurityException e1) {
            LOGGER.warn("Can't get signed content.", e1);
        }
        this.references = new ArrayList<XAdESReference>();
        result.setSignedContentParts(this.references);
        int length = si.getLength();
        int detCtr = 0;
        for (int i = 0; i < length; ++i) {
            Reference ref = null;
            try {
                de.governikus.csl.uom.sign.SignatureType type;
                ref = si.item(i);
                String uri = ref.getURI();
                if (result.getSignatureType() == null && (type = this.getType(uri, refResolver, ref)) != null) {
                    result.setSignatureType(type);
                }
                ref.verify();
                byte[] digest2 = ref.getDigestValue();
                byte[] content = ref.getReferencedBytes();
                DigestAlgorithm digestAlgorithm = this.algorithmManager.getDigestAlgorithmByJCAName(ref.getMessageDigestAlgorithm().getJCEAlgorithmString());
                ByteArrayDocument bad = new ByteArrayDocument(content, uri);
                bad.setName(uri);
                XAdESReference xadesRef = new XAdESReference((Document)bad, digest2, digestAlgorithm, ref);
                if (this.isExternalReferenceUri(uri)) {
                    xadesRef.setContentName(uri);
                }
                this.references.add(xadesRef);
                continue;
            }
            catch (XMLSecurityException e) {
                List contents = this.signedData.getContents();
                List hashValues = this.signedData.getHashValues();
                boolean createErrorCondition = true;
                if (contents != null && !contents.isEmpty() || hashValues != null && !hashValues.isEmpty() && ref != null) {
                    try {
                        byte[] digest2 = ref.getDigestValue();
                        DigestAlgorithm digestAlgorithm = this.algorithmManager.getDigestAlgorithmByJCAName(ref.getMessageDigestAlgorithm().getJCEAlgorithmString());
                        Document content = null;
                        if (contents != null && contents.size() > detCtr) {
                            content = (Document)contents.get(detCtr++);
                            createErrorCondition = false;
                            StreamProviderDocument tmp = this.getTransformedContent(content, ref);
                            if (tmp != null) {
                                content = tmp;
                            }
                        }
                        XAdESReference contentPart = new XAdESReference(content, digest2, digestAlgorithm, ref);
                        if (content != null) {
                            contentPart.setContentName(content.getName());
                        }
                        if (hashValues != null && hashValues.size() > detCtr) {
                            byte[] hashValue = (byte[])hashValues.get(detCtr++);
                            createErrorCondition = false;
                            contentPart.setCalculatedDigest(hashValue);
                        }
                        if (!createErrorCondition) {
                            this.references.add(contentPart);
                        }
                    }
                    catch (Exception e1) {
                        LOGGER.info("Can't attach detached document/hash value to signature", (Throwable)e);
                    }
                }
                if (!createErrorCondition) continue;
                XAdESReference xadesRef = new XAdESReference(null, null, this.algorithmManager.getDigestAlgorithmByJCAName("SHA-1"), ref);
                xadesRef.setReferencingPossibleIncludedData(false);
                xadesRef.setReference(ref);
                this.references.add(xadesRef);
                LOGGER.info("Generating invalid signed content parts due to the following exception: {} ", (Object)e.getMessage());
            }
        }
        if (result.getSignatureType() == null) {
            result.setSignatureType(de.governikus.csl.uom.sign.SignatureType.ENVELOPING);
        }
        return result;
    }

    private StreamProviderDocument getTransformedContent(Document content, Reference ref) {
        Transforms transforms;
        try {
            transforms = ref.getTransforms();
        }
        catch (XMLSecurityException e1) {
            return null;
        }
        if (transforms != null) {
            try {
                InputStream transformedStream = transforms.performTransforms(new XMLSignatureInput(content.getInputStream())).getOctetStream();
                return new StreamProviderDocument(() -> transformedStream);
            }
            catch (TransformationException e) {
                String contentName = content.getName();
                if (contentName == null || contentName.isEmpty()) {
                    contentName = "unknown";
                }
                List<String> transformAlgos = this.getTransformAlgos(transforms);
                LOGGER.debug("Can't apply the following transform(s) to signed content {}: {}", new Object[]{contentName, transformAlgos, e});
            }
            catch (IOException e) {
                LOGGER.debug("Cannot read signed content");
            }
        }
        return null;
    }

    private List<String> getTransformAlgos(Transforms transforms) {
        ArrayList<String> transformAlgos = new ArrayList<String>();
        Element element = transforms.getElement();
        NodeList childNodes = element.getChildNodes();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            String textContent;
            Node namedItem;
            Node item = childNodes.item(i);
            NamedNodeMap attributes = item.getAttributes();
            if (attributes == null || (namedItem = attributes.getNamedItem("Algorithm")) == null || (textContent = namedItem.getTextContent()) == null || textContent.isEmpty()) continue;
            transformAlgos.add(textContent);
        }
        return transformAlgos;
    }

    private de.governikus.csl.uom.sign.SignatureType getType(String uri, ReferenceResolver refResolver, Reference ref) {
        if (!(refResolver == null || uri == null || uri.isEmpty() || !refResolver.canResolve(uri) && uri.startsWith("#"))) {
            return de.governikus.csl.uom.sign.SignatureType.DETACHED;
        }
        try {
            Transforms transforms = ref.getTransforms();
            int len = 0;
            while (len <= transforms.getLength()) {
                Transform transform;
                String algoUri;
                if ((algoUri = (transform = transforms.item(len++)).getURI()) == null || algoUri.isEmpty() || !ENVELOPED_ALGO_URI.equals(algoUri)) continue;
                return de.governikus.csl.uom.sign.SignatureType.ENVELOPED;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private boolean isExternalReferenceUri(String referenceUri) {
        return referenceUri != null && !referenceUri.isEmpty() && referenceUri.trim().charAt(0) != '#';
    }

    private void addReferenceToIncludedFiles(XAdESReference reference, ReferenceResolver refResolver) {
        Document referencedContent;
        Reference ref = reference.getReference();
        String type = ref.getType();
        if (URI_ETSI_01903_SIGNED_PROPERTIES.equals(type)) {
            return;
        }
        String uri = ref.getURI();
        if (uri != null && uri.startsWith("#")) {
            String id;
            uri = uri.substring(1);
            if (this.signedProperties != null && (id = this.signedProperties.getId()) != null && id.equals(uri)) {
                return;
            }
            if (this.keyInfo != null && (id = this.keyInfo.getId()) != null && id.equals(uri)) {
                return;
            }
        }
        if (this.includedData == null) {
            this.includedData = new ArrayList<Document>();
        }
        if ((referencedContent = reference.getReferencedContent()) instanceof ChangeableDocument && refResolver != null) {
            ChangeableDocument document = (ChangeableDocument)referencedContent;
            document.setReferenceResolver(refResolver);
        }
        this.includedData.add(referencedContent);
    }

    private List<Element> getSignatureNodes(org.w3c.dom.Document document) throws Exception {
        ArrayList<Element> signatureElements = new ArrayList<Element>();
        NodeList signatureNodes = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (signatureNodes.getLength() == 0) {
            return signatureElements;
        }
        for (int i = 0; i < signatureNodes.getLength(); ++i) {
            Node item = signatureNodes.item(i);
            if (!(item instanceof Element)) {
                throw new RuntimeException("Signature is not an Element");
            }
            signatureElements.add((Element)item);
        }
        return signatureElements;
    }

    static {
        Init.init();
        ResourceResolver.register((ResourceResolverSpi)new ResolverFragment(), (boolean)true);
        ResourceResolver.register((ResourceResolverSpi)new ResourceResolverSpi(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
                try (FileInputStream fis = new FileInputStream(new File(context.uriToResolve));){
                    byte[] data = IOUtils.toByteArray((InputStream)fis);
                    XMLSignatureInput xMLSignatureInput = new XMLSignatureInput(data);
                    return xMLSignatureInput;
                }
                catch (IOException e) {
                    LOGGER.error("Error while resolving URI.", (Throwable)e);
                    return null;
                }
            }

            public boolean engineCanResolveURI(ResourceResolverContext context) {
                if (context.uriToResolve == null) {
                    return false;
                }
                return new File(context.uriToResolve).exists();
            }
        }, (boolean)true);
    }

    private static class XAdESArchiveTimestampFactory
    implements TimestampFactory<XAdESArchiveTimestamp, BaseSignature> {
        private XAdESArchiveTimestampFactory() {
        }

        public XAdESArchiveTimestamp createNewTimestamp() {
            return new XAdESArchiveTimestamp();
        }
    }

    private static class RevocationValuesBundle {
        private List<OCSPResp> ocsp;
        private List<CRL> crls;

        private RevocationValuesBundle() {
        }
    }
}

