/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades;

import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.w3c.dom.Element;

public class CSLXML509Certificate
extends XMLX509Certificate {
    public CSLXML509Certificate(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    public X509Certificate getX509Certificate() throws XMLSecurityException {
        try {
            byte[] certbytes = this.getCertificateBytes();
            CertificateFactory certFact = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
            X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(certbytes));
            if (cert != null) {
                return cert;
            }
            return null;
        }
        catch (NoSuchProviderException | CertificateException ex) {
            throw new XMLSecurityException((Exception)ex);
        }
    }
}

