/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades;

import de.governikus.csl.xades.CSLXML509Certificate;
import java.security.cert.X509Certificate;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.implementations.X509CertificateResolver;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CSLX509CertificateResolver
extends X509CertificateResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSLX509CertificateResolver.class);

    public X509Certificate engineLookupResolveX509Certificate(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        try {
            Element[] els = XMLUtils.selectDsNodes((Node)element.getFirstChild(), (String)"X509Certificate");
            if (els == null || els.length == 0) {
                Element el = XMLUtils.selectDsNode((Node)element.getFirstChild(), (String)"X509Data", (int)0);
                if (el != null) {
                    return this.engineLookupResolveX509Certificate(el, baseURI, storage);
                }
                return null;
            }
            for (int i = 0; i < els.length; ++i) {
                CSLXML509Certificate xmlCert = new CSLXML509Certificate(els[i], baseURI);
                X509Certificate cert = xmlCert.getX509Certificate();
                if (cert == null) continue;
                return cert;
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("XMLSecurityException", (Throwable)ex);
            }
            throw new KeyResolverException((Exception)((Object)ex));
        }
    }
}

