/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.visual;

import de.governikus.csl.pdf.sign.PDFSignMessageCode;
import de.governikus.csl.pdf.sign.PDFSigningPrepareException;
import de.governikus.csl.pdf.sign.TextFormatting;
import de.governikus.csl.sign.CSLSignatureException;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TextFormatter.class.getName());
    String[] lines;
    float width;
    float height;
    float textHeight;
    float textWidth;
    float fontSize;
    int longestLine;
    boolean scaleFont;
    boolean succLineBreak;
    PDFont font;
    float[] x_offsets_lines;
    public static final float ZEILENABSTAND = 1.5f;
    public static final float PADDING = 3.0f;
    public static final float MIN_FONT_SIZE = 6.0f;
    TextFormatting align;

    public TextFormatter(String[] lines, PDFont font, float initialFontSize, float width, float height, TextFormatting align, boolean scaleFont) {
        this.lines = lines;
        this.font = font;
        this.fontSize = initialFontSize;
        this.width = width;
        this.height = height;
        this.align = align == null ? TextFormatting.center : align;
        this.scaleFont = scaleFont;
    }

    public String[] format() throws IOException, CSLSignatureException {
        this.updateParams();
        this.succLineBreak = true;
        while (this.height <= this.textHeight || this.width <= this.textWidth) {
            if (this.textHeight < this.height - this.fontSize * 1.5f && this.succLineBreak) {
                this.succLineBreak = this.breakLongestLine();
            } else if (this.scaleFont && this.fontSize >= 6.0f) {
                this.fontSize -= 1.0f;
            } else {
                LOGGER.warn("Faild to format text to {} 'x' {}; Min. font size is {}", new Object[]{Float.valueOf(this.width), Float.valueOf(this.height), Float.valueOf(6.0f)});
                throw new PDFSigningPrepareException(PDFSignMessageCode.PDF_NOT_ENOUGH_SPACE_FOR_VIS_SIG);
            }
            this.updateParams();
        }
        return this.lines;
    }

    public float getTextHeight() {
        return this.textHeight;
    }

    public float getTextWidth() {
        return this.textWidth;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public float[] getLineXOffsets() {
        return this.x_offsets_lines;
    }

    void updateParams() throws IOException {
        float txt_width = 0.0f;
        float line_width = 0.0f;
        float lastLineWidth = 0.0f;
        this.x_offsets_lines = new float[this.lines.length];
        for (int i = 0; i < this.lines.length; ++i) {
            line_width = this.font.getStringWidth(this.lines[i]) / 1000.0f * this.fontSize;
            switch (this.align) {
                case left: {
                    this.x_offsets_lines[i] = 0.0f;
                    break;
                }
                case center: {
                    this.x_offsets_lines[i] = (lastLineWidth - line_width) / 2.0f;
                    break;
                }
                case right: {
                    this.x_offsets_lines[i] = lastLineWidth - line_width;
                }
            }
            if (line_width > txt_width) {
                txt_width = line_width;
                this.longestLine = i;
            }
            lastLineWidth = line_width;
        }
        this.textWidth = txt_width;
        this.textHeight = (float)this.lines.length * this.fontSize * 1.5f;
    }

    boolean breakLongestLine() throws IOException {
        String line2break = this.lines[this.longestLine].trim();
        if (line2break.length() < 3) {
            return false;
        }
        int spaceIndex = 0;
        while ((spaceIndex = line2break.indexOf(32, spaceIndex + 1)) > -1 && !(this.font.getStringWidth(line2break.substring(0, spaceIndex)) > this.font.getStringWidth(line2break.substring(spaceIndex)))) {
        }
        if (spaceIndex > -1) {
            String[] newLines = new String[this.lines.length + 1];
            System.arraycopy(this.lines, 0, newLines, 0, this.longestLine);
            newLines[this.longestLine] = line2break.substring(0, spaceIndex);
            newLines[this.longestLine + 1] = line2break.substring(spaceIndex + 1);
            System.arraycopy(this.lines, this.longestLine + 1, newLines, this.longestLine + 2, this.lines.length - this.longestLine - 1);
            this.lines = newLines;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws CSLSignatureException, IOException {
        int i;
        PDType1Font fnt = PDType1Font.HELVETICA;
        TextFormatter tf = new TextFormatter(new String[]{"eins", "zwei und drei", "vier"}, (PDFont)fnt, 14.0f, 100.0f, 100.0f, TextFormatting.center, true);
        String[] ret = tf.format();
        for (i = 0; i < ret.length; ++i) {
            LOGGER.info("LINE {}", (Object)ret[i]);
        }
        LOGGER.info("FONTSIZE {}", (Object)Float.valueOf(tf.fontSize));
        for (i = 0; i < tf.x_offsets_lines.length; ++i) {
            LOGGER.info("OFF {}", (Object)Float.valueOf(tf.x_offsets_lines[i]));
        }
    }
}

