/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.visual;

import de.governikus.csl.pdf.sign.PDFSignMessageCode;
import de.governikus.csl.pdf.sign.PDFSignOptions;
import de.governikus.csl.pdf.sign.PDFSignatureInfo;
import de.governikus.csl.pdf.sign.PDFSigningPrepareException;
import de.governikus.csl.pdf.sign.PDFVisualSignatureDetails;
import de.governikus.csl.pdf.sign.TextColor;
import de.governikus.csl.pdf.sign.TextFormatting;
import de.governikus.csl.pdf.sign.VisibleSignatureLayout;
import de.governikus.csl.pdf.sign.impl.pdfbox.visual.TextFormatter;
import de.governikus.csl.pdf.sign.impl.visual.FontEnum;
import de.governikus.csl.pdf.sign.impl.visual.PDFTablePositioner;
import de.governikus.csl.pdf.sign.impl.visual.ParamValidator;
import de.governikus.csl.pdf.sign.impl.visual.VisualSignatureHelper;
import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.uom.CoreException;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFBoxVisualSignatureHelperImpl
implements VisualSignatureHelper<PDDocument> {
    private static final String METHOD_NAME_GET_FONT = "getFont";
    private static final String NO_SIGNATURE_OPTION = "no SignatureOption";
    private static final String SET_VISUAL_SIGN = "setVisualSign";
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFBoxVisualSignatureHelperImpl.class);
    private ResourceBundle resourceBundle = PDFBoxVisualSignatureHelperImpl.getResourceBundle();
    private File tempDir;

    public static ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(PDFBoxVisualSignatureHelperImpl.class.getName());
    }

    @Override
    public void setTempFile(File tempFile) {
        this.tempDir = tempFile;
    }

    public static String adjustAlternateTextWithImagePresentHint(String alternateText, PDFVisualSignatureDetails visualSignatureDetails) {
        Object result;
        Object object = result = alternateText == null ? "" : alternateText;
        if (visualSignatureDetails != null && visualSignatureDetails.getImage() != null) {
            ResourceBundle resourceBundle = PDFBoxVisualSignatureHelperImpl.getResourceBundle();
            VisibleSignatureLayout signatureLayout = visualSignatureDetails.getSignatureLayout();
            if (signatureLayout == null) {
                signatureLayout = VisibleSignatureLayout.ImageLeft;
            }
            result = (String)result + "\n" + resourceBundle.getString("VisSig.Descriptions." + signatureLayout.name() + "Hint");
        }
        return result;
    }

    @Override
    public File handleVisibleSignature(PDFSignOptions pdfSignOptions, String signerCommonName, Calendar cal, PDDocument doc) throws IOException, CoreException {
        if (pdfSignOptions == null || pdfSignOptions.getVisualSignatureDetails() == null) {
            throw new IllegalArgumentException("Parameter shouldn't be null");
        }
        PDFVisualSignatureDetails pdfVisualSignatureDetails = this.validateVisualSignatureDetails(pdfSignOptions.getVisualSignatureDetails());
        pdfSignOptions.setVisualSignatureDetails(pdfVisualSignatureDetails);
        int pageNumToSign = this.getPageNumToSign(doc, pdfVisualSignatureDetails);
        PDPage page = doc.getDocumentCatalog().getPages().get(pageNumToSign);
        PDRectangle mediaBox = page.getMediaBox();
        int rotation = page.getRotation();
        File visibleSignature = null;
        while (visibleSignature == null) {
            visibleSignature = this.tryVisualSignatureWithFontSize(pdfSignOptions, signerCommonName, cal, mediaBox, rotation);
        }
        return visibleSignature;
    }

    @Override
    public String getAlternativeText(PDFSignOptions pdfOptions, String signerCommonName, Calendar cal) throws CoreException {
        String visualSignatureAltText;
        StringBuilder phraseBuilder = new StringBuilder("");
        PDFVisualSignatureDetails visualSignatureDetails = pdfOptions.getVisualSignatureDetails();
        if (visualSignatureDetails != null) {
            String[] text = this.getTextForTable(pdfOptions, signerCommonName, cal, true);
            for (int i = 0; i < text.length; ++i) {
                if (text[i] == null || text[i].isEmpty()) continue;
                phraseBuilder.append(text[i] + "\n");
            }
            if (text.length == 0 && visualSignatureDetails.getAlternateName() != null && !visualSignatureDetails.getAlternateName().isEmpty()) {
                phraseBuilder.append(visualSignatureDetails.getAlternateName());
            }
        }
        visualSignatureAltText = (visualSignatureAltText = phraseBuilder.toString()).isEmpty() ? "alternative signer description not provided" : visualSignatureAltText.trim();
        return visualSignatureAltText;
    }

    private File tryVisualSignatureWithFontSize(PDFSignOptions pdfSignOptions, String signerCommonName, Calendar cal, PDRectangle mediaBox, int rotation) throws IOException, CoreException {
        try {
            return this.handleVisibleSignatureInt(pdfSignOptions, signerCommonName, cal, mediaBox.getWidth(), mediaBox.getHeight(), rotation);
        }
        catch (CoreException e) {
            Integer fontSize;
            PDFVisualSignatureDetails visualSignatureDetails = pdfSignOptions.getVisualSignatureDetails();
            if (Boolean.TRUE.equals(visualSignatureDetails.getDynamicTextSize()) && "PDF_NOT_ENOUGH_SPACE_FOR_VIS_SIG".equals(e.getMessage()) && (fontSize = Integer.valueOf(visualSignatureDetails.getFontSize() - 2)) >= 6) {
                visualSignatureDetails.setFontSize(fontSize);
                return null;
            }
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((Throwable)e);
        }
    }

    private int getPageNumToSign(PDDocument doc, PDFVisualSignatureDetails pdfVisualSignatureDetails) throws CSLSignatureException {
        int pageNumToSign = doc.getNumberOfPages() - 1;
        if (pageNumToSign < pdfVisualSignatureDetails.getPage() - 1) {
            throw new PDFSigningPrepareException("PDF_WRONG_PAGE_FOR_VIS_SIGNATURE", PDFSignMessageCode.PDF_WRONG_PAGE_FOR_VIS_SIGNATURE);
        }
        if (pdfVisualSignatureDetails.getPage() > 0) {
            pageNumToSign = pdfVisualSignatureDetails.getPage() - 1;
        }
        return pageNumToSign;
    }

    private File handleVisibleSignatureInt(PDFSignOptions pdfSignOptions, String signerCommonName, Calendar cal, double pageWidth, double pageHeight, int rotation) throws IOException, CoreException {
        PDFVisualSignatureDetails pdfVisualSignatureDetails = pdfSignOptions.getVisualSignatureDetails();
        if (pdfVisualSignatureDetails != null) {
            float tableWidth = 0.0f;
            float tableHeight = 0.0f;
            this.checkVisualSignatureWithoutTextRequiresImage(pdfVisualSignatureDetails);
            tableWidth = this.getTableWidth(pdfVisualSignatureDetails).floatValue();
            tableHeight = this.getTableHeight(pdfVisualSignatureDetails).floatValue();
            Point2D.Double p = null;
            this.checkNoMixedRelativeAbsolutePositions(pdfVisualSignatureDetails);
            if (pdfVisualSignatureDetails.getPositionX() != null || pdfVisualSignatureDetails.getPositionY() != null) {
                p = PDFTablePositioner.getPosition(pdfVisualSignatureDetails.getPositionX(), pdfVisualSignatureDetails.getPositionY(), tableWidth, tableHeight, pageWidth, pageHeight);
            }
            if (pdfVisualSignatureDetails.getAbsolutePositionX() != null || pdfVisualSignatureDetails.getAbsolutePositionY() != null) {
                p = new Point2D.Double(pdfVisualSignatureDetails.getAbsolutePositionX(), pdfVisualSignatureDetails.getAbsolutePositionY());
            }
            if (p == null) {
                throw new IllegalStateException("position of visible signature can not be calculated");
            }
            File result = this.createTempFileForVisSig();
            PDDocument doc = new PDDocument();
            PDPage page = new PDPage(new PDRectangle((float)p.x, (float)p.y, (float)p.x + tableWidth, (float)p.y + tableHeight));
            doc.addPage(page);
            PDRectangle rect = new PDRectangle((float)p.x, (float)p.y, tableWidth, tableHeight);
            this.writeVisibleSigToLayer(doc, pdfSignOptions, signerCommonName, cal, rect, rotation);
            doc.save(result);
            doc.close();
            return result;
        }
        throw new IllegalStateException(NO_SIGNATURE_OPTION);
    }

    private void checkVisualSignatureWithoutTextRequiresImage(PDFVisualSignatureDetails pdfVisualSignatureDetails) {
        if (Boolean.TRUE.equals(pdfVisualSignatureDetails.getNoText()) && pdfVisualSignatureDetails.getImage() == null) {
            throw new IllegalStateException("Visual Signature with no Text and no Image");
        }
    }

    private void checkNoMixedRelativeAbsolutePositions(PDFVisualSignatureDetails pdfVisualSignatureDetails) {
        if (!(pdfVisualSignatureDetails.getPositionX() == null && pdfVisualSignatureDetails.getPositionY() == null || pdfVisualSignatureDetails.getAbsolutePositionX() == null && pdfVisualSignatureDetails.getAbsolutePositionY() == null)) {
            throw new IllegalStateException("Found relative and absolute position mixed together. Please use only absolute or relative position.");
        }
    }

    private File createTempFileForVisSig() throws IOException {
        File result = this.tempDir == null ? File.createTempFile("VisSig", ".pdf") : new File(this.tempDir, "VisSig" + UUID.randomUUID().toString() + ".pdf");
        result.deleteOnExit();
        return result;
    }

    private void writeVisibleSigToLayer(PDDocument doc, PDFSignOptions pdfSignOptions, String signerCommonName, Calendar cal, PDRectangle rect, int rotation) throws CoreException, IOException {
        PDFVisualSignatureDetails visualSignatureOptions = pdfSignOptions.getVisualSignatureDetails();
        PDAnnotationWidget widget = this.prepareVisibleSignatureWidgetAcroForm(doc, rect);
        WriteVisibleSigDto writeVisibleSigDto = new WriteVisibleSigDto();
        PDFormXObject form = this.prepareVisibleSignatureStreamXForm(doc);
        PDRectangle bbox = new PDRectangle(rect.getWidth(), rect.getHeight());
        writeVisibleSigDto.height = bbox.getHeight();
        writeVisibleSigDto.width = bbox.getWidth();
        Matrix initialScale = null;
        initialScale = this.prepareWriteVisibleSignatureRotation(rotation, writeVisibleSigDto, form, bbox, initialScale);
        form.setBBox(bbox);
        PDAppearanceStream appearanceStream = this.prepareWriteVisibleSignatureDictAppearance(widget, form);
        try (PDPageContentStream cs = new PDPageContentStream(doc, appearanceStream);){
            this.prepareWriteVisibleSignaturePDStream(visualSignatureOptions, writeVisibleSigDto.height, writeVisibleSigDto.width, initialScale, cs);
            writeVisibleSigDto.fontSize = this.prepareWriteVisibleSignatureInitialFontSize(visualSignatureOptions);
            PDFont font = this.getFont(visualSignatureOptions, doc);
            if (visualSignatureOptions.getImage() == null) {
                writeVisibleSigDto.txtY = 0.0f;
                writeVisibleSigDto.txtX = 0.0f;
                writeVisibleSigDto.txtWidth = writeVisibleSigDto.width;
                writeVisibleSigDto.txtHeight = writeVisibleSigDto.height;
            } else {
                PDImageXObject img = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])visualSignatureOptions.getImage(), (String)"icon");
                this.prepareWriteVisibleSignatureLayout(visualSignatureOptions, writeVisibleSigDto, img);
                cs.saveGraphicsState();
                cs.transform(Matrix.getScaleInstance((float)writeVisibleSigDto.imgScale, (float)writeVisibleSigDto.imgScale));
                cs.drawImage(img, (writeVisibleSigDto.imgX + 3.0f) / writeVisibleSigDto.imgScale, (writeVisibleSigDto.imgY + 3.0f) / writeVisibleSigDto.imgScale);
                cs.restoreGraphicsState();
                writeVisibleSigDto.realSigContentHeight += writeVisibleSigDto.imgHeight;
                writeVisibleSigDto.realSigContentWidth = writeVisibleSigDto.imgWidth > writeVisibleSigDto.realSigContentWidth ? writeVisibleSigDto.imgWidth : writeVisibleSigDto.realSigContentWidth;
            }
            this.writeVisibleSignatureAddText(pdfSignOptions, signerCommonName, cal, visualSignatureOptions, cs, writeVisibleSigDto, font);
        }
    }

    private Matrix prepareWriteVisibleSignatureRotation(int rotation, WriteVisibleSigDto writeVisibleSigDto, PDFormXObject form, PDRectangle bbox, Matrix initialScale) {
        switch (rotation) {
            case 90: {
                form.setMatrix(AffineTransform.getQuadrantRotateInstance(1));
                initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                writeVisibleSigDto.height = bbox.getWidth();
                writeVisibleSigDto.width = bbox.getHeight();
                break;
            }
            case 180: {
                form.setMatrix(AffineTransform.getQuadrantRotateInstance(2));
                break;
            }
            case 270: {
                form.setMatrix(AffineTransform.getQuadrantRotateInstance(3));
                initialScale = Matrix.getScaleInstance((float)(bbox.getWidth() / bbox.getHeight()), (float)(bbox.getHeight() / bbox.getWidth()));
                writeVisibleSigDto.height = bbox.getWidth();
                writeVisibleSigDto.width = bbox.getHeight();
                break;
            }
        }
        return initialScale;
    }

    private void prepareWriteVisibleSignatureLayout(PDFVisualSignatureDetails visualSignatureOptions, WriteVisibleSigDto writeVisibleSigDto, PDImageXObject img) {
        if (Boolean.TRUE.equals(visualSignatureOptions.getNoText())) {
            writeVisibleSigDto.imgY = 0.0f;
            writeVisibleSigDto.imgX = 0.0f;
            writeVisibleSigDto.imgWidth = writeVisibleSigDto.width;
            writeVisibleSigDto.imgHeight = writeVisibleSigDto.height;
            writeVisibleSigDto.txtX = 0.0f;
            writeVisibleSigDto.txtY = 0.0f;
            writeVisibleSigDto.txtWidth = 0.0f;
            writeVisibleSigDto.txtHeight = 0.0f;
        } else if (visualSignatureOptions.getSignatureLayout() == VisibleSignatureLayout.ImageLeft || visualSignatureOptions.getSignatureLayout() == VisibleSignatureLayout.ImageRight) {
            this.prepareWriteVisibleSignatureLayoutImageLeftRight(visualSignatureOptions, writeVisibleSigDto);
        } else {
            this.prepareWriteVisibleSignatureLayoutImageDefault(visualSignatureOptions, writeVisibleSigDto);
        }
        if (writeVisibleSigDto.imgWidth / (float)img.getWidth() < writeVisibleSigDto.imgHeight / (float)img.getHeight()) {
            writeVisibleSigDto.imgScale = (writeVisibleSigDto.imgWidth - 6.0f) / (float)img.getWidth();
            writeVisibleSigDto.imgY += (writeVisibleSigDto.imgHeight - (float)img.getHeight() * writeVisibleSigDto.imgScale) / 2.0f;
        } else {
            writeVisibleSigDto.imgScale = (writeVisibleSigDto.imgHeight - 6.0f) / (float)img.getHeight();
            writeVisibleSigDto.imgX += (writeVisibleSigDto.imgWidth - (float)img.getWidth() * writeVisibleSigDto.imgScale) / 2.0f;
        }
    }

    private void prepareWriteVisibleSignatureLayoutImageDefault(PDFVisualSignatureDetails visualSignatureOptions, WriteVisibleSigDto writeVisibleSigDto) {
        writeVisibleSigDto.imgWidth = writeVisibleSigDto.width;
        writeVisibleSigDto.imgHeight = (float)((double)writeVisibleSigDto.height * visualSignatureOptions.getImageToTextRatio());
        writeVisibleSigDto.txtWidth = writeVisibleSigDto.width;
        writeVisibleSigDto.txtHeight = writeVisibleSigDto.height - writeVisibleSigDto.imgHeight;
        writeVisibleSigDto.imgX = 0.0f;
        writeVisibleSigDto.txtX = 0.0f;
        if (visualSignatureOptions.getSignatureLayout() == VisibleSignatureLayout.ImageTop) {
            writeVisibleSigDto.imgY = writeVisibleSigDto.txtHeight;
            writeVisibleSigDto.txtY = 0.0f;
        } else {
            writeVisibleSigDto.imgY = 0.0f;
            writeVisibleSigDto.txtY = writeVisibleSigDto.imgHeight;
        }
    }

    private void prepareWriteVisibleSignatureLayoutImageLeftRight(PDFVisualSignatureDetails visualSignatureOptions, WriteVisibleSigDto writeVisibleSigDto) {
        writeVisibleSigDto.imgWidth = (float)((double)writeVisibleSigDto.width * visualSignatureOptions.getImageToTextRatio());
        writeVisibleSigDto.imgHeight = writeVisibleSigDto.height;
        writeVisibleSigDto.txtWidth = writeVisibleSigDto.width - writeVisibleSigDto.imgWidth;
        writeVisibleSigDto.txtHeight = writeVisibleSigDto.height;
        writeVisibleSigDto.imgY = 0.0f;
        writeVisibleSigDto.txtY = 0.0f;
        if (visualSignatureOptions.getSignatureLayout() == VisibleSignatureLayout.ImageLeft) {
            writeVisibleSigDto.imgX = 0.0f;
            writeVisibleSigDto.txtX = writeVisibleSigDto.imgWidth;
        } else {
            writeVisibleSigDto.imgX = writeVisibleSigDto.txtWidth;
            writeVisibleSigDto.txtX = 0.0f;
        }
    }

    private void writeVisibleSignatureAddText(PDFSignOptions pdfSignOptions, String signerCommonName, Calendar cal, PDFVisualSignatureDetails visualSignatureOptions, PDPageContentStream cs, WriteVisibleSigDto writeVisibleSigDto, PDFont font) throws CoreException, IOException {
        String[] text;
        if (Boolean.FALSE.equals(visualSignatureOptions.getNoText()) && (text = this.getTextForTable(pdfSignOptions, signerCommonName, cal, false)).length > 0) {
            TextFormatter tf = new TextFormatter(text, font, writeVisibleSigDto.fontSize, writeVisibleSigDto.txtWidth - 6.0f, writeVisibleSigDto.txtHeight - 6.0f, visualSignatureOptions.getTextFormatting(), visualSignatureOptions.getDynamicTextSize());
            text = tf.format();
            writeVisibleSigDto.fontSize = tf.getFontSize();
            writeVisibleSigDto.realSigContentHeight += tf.getTextHeight();
            writeVisibleSigDto.realSigContentWidth = tf.getTextWidth() > writeVisibleSigDto.realSigContentWidth ? tf.getTextWidth() : writeVisibleSigDto.realSigContentWidth;
            float[] xOffsets = tf.getLineXOffsets();
            float leading = writeVisibleSigDto.fontSize * 1.5f;
            cs.setFont(font, writeVisibleSigDto.fontSize);
            cs.beginText();
            this.prepareWriteVisibleSignatureStrokingColor(visualSignatureOptions, cs);
            float startTxtX = this.prepareWriteVisibleSignatureCalcTextStartX(visualSignatureOptions, writeVisibleSigDto);
            cs.newLineAtOffset(startTxtX + xOffsets[0], writeVisibleSigDto.txtY + leading * (float)(text.length - 1) + (writeVisibleSigDto.txtHeight - tf.getTextHeight()) / 2.0f + 3.0f);
            for (int i = 0; i < text.length; ++i) {
                cs.showText(text[i]);
                if (i >= text.length - 1) continue;
                cs.newLineAtOffset(xOffsets[i + 1], -leading);
            }
            cs.endText();
        }
    }

    private float prepareWriteVisibleSignatureCalcTextStartX(PDFVisualSignatureDetails visualSignatureOptions, WriteVisibleSigDto writeVisibleSigDto) {
        float startTxtX = writeVisibleSigDto.txtX;
        switch (visualSignatureOptions.getTextFormatting() == null ? TextFormatting.center : visualSignatureOptions.getTextFormatting()) {
            case left: {
                startTxtX = writeVisibleSigDto.txtX + 3.0f;
                break;
            }
            case center: {
                startTxtX = writeVisibleSigDto.txtX + writeVisibleSigDto.txtWidth / 2.0f + 3.0f;
                break;
            }
            case right: {
                startTxtX = writeVisibleSigDto.txtX + writeVisibleSigDto.txtWidth - 3.0f;
                break;
            }
        }
        return startTxtX;
    }

    private void prepareWriteVisibleSignatureStrokingColor(PDFVisualSignatureDetails visualSignatureOptions, PDPageContentStream cs) throws IOException, CSLSignatureException {
        if (Boolean.TRUE.equals(visualSignatureOptions.getPDFASignatureAppearance())) {
            cs.setNonStrokingColor(Color.black);
        } else {
            cs.setNonStrokingColor(this.getFontColor(visualSignatureOptions.getTextColor()));
        }
    }

    private float prepareWriteVisibleSignatureInitialFontSize(PDFVisualSignatureDetails visualSignatureOptions) {
        float fontSize = 0.0f;
        if (visualSignatureOptions.getFontSize() != null) {
            fontSize = visualSignatureOptions.getFontSize().intValue();
        }
        return fontSize;
    }

    private PDFormXObject prepareVisibleSignatureStreamXForm(PDDocument doc) {
        PDStream stream = new PDStream(doc);
        PDFormXObject form = new PDFormXObject(stream);
        PDResources res = new PDResources();
        form.setResources(res);
        form.setFormType(1);
        return form;
    }

    private PDAnnotationWidget prepareVisibleSignatureWidgetAcroForm(PDDocument doc, PDRectangle rect) throws IOException {
        PDAcroForm acroForm = new PDAcroForm(doc);
        doc.getDocumentCatalog().setAcroForm(acroForm);
        PDSignatureField signatureField = new PDSignatureField(acroForm);
        PDAnnotationWidget widget = (PDAnnotationWidget)signatureField.getWidgets().get(0);
        List acroFormFields = acroForm.getFields();
        acroForm.setSignaturesExist(true);
        acroForm.setAppendOnly(true);
        acroForm.getCOSObject().setDirect(true);
        acroFormFields.add(signatureField);
        widget.setRectangle(rect);
        return widget;
    }

    private PDAppearanceStream prepareWriteVisibleSignatureDictAppearance(PDAnnotationWidget widget, PDFormXObject form) {
        PDAppearanceDictionary appearance = new PDAppearanceDictionary();
        appearance.getCOSObject().setDirect(true);
        PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
        appearance.setNormalAppearance(appearanceStream);
        widget.setAppearance(appearance);
        return appearanceStream;
    }

    private void prepareWriteVisibleSignaturePDStream(PDFVisualSignatureDetails visualSignatureOptions, float height, float width, Matrix initialScale, PDPageContentStream cs) throws IOException {
        if (initialScale != null) {
            cs.transform(initialScale);
        }
        if (Boolean.TRUE.equals(visualSignatureOptions.getTransparent())) {
            PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
            graphicsState.setNonStrokingAlphaConstant(Float.valueOf(0.3f));
            graphicsState.setNonStrokingOverprintControl(false);
            cs.setGraphicsStateParameters(graphicsState);
        } else {
            cs.setNonStrokingColor(Color.white);
            cs.addRect(0.0f, 0.0f, width, height);
            cs.fill();
        }
    }

    public String[] getTextForTable(PDFSignOptions pdfOptions, String signerCommonName, Calendar cal, boolean forceVisibleDescriptions) throws CoreException {
        PDFVisualSignatureDetails pdfSignatureDetails = pdfOptions.getVisualSignatureDetails();
        if (pdfSignatureDetails instanceof PDFVisualSignatureDetails) {
            ArrayList ret = new ArrayList();
            pdfSignatureDetails.getInfoSettings().forEach(i -> {
                boolean visible = this.isDescriptionVisible(forceVisibleDescriptions, (PDFSignatureInfo)((Object)i));
                switch (i.getInfoType()) {
                    case TYPE_SIGNER: {
                        this.addSignerInformation(signerCommonName, pdfSignatureDetails, ret, visible);
                        break;
                    }
                    case TYPE_DATE: {
                        this.addDateInformation(cal, pdfSignatureDetails, ret, visible);
                        break;
                    }
                    case TYPE_LOCATION: {
                        this.addLocationInformation(pdfOptions, ret, visible);
                        break;
                    }
                    case TYPE_REASON: {
                        this.addReasonInformation(pdfOptions, ret, visible);
                    }
                }
            });
            return ret.toArray(new String[ret.size()]);
        }
        throw new UnsupportedOperationException("Unsupported SignatureOption -> " + pdfSignatureDetails.getClass().getName());
    }

    private void addReasonInformation(PDFSignOptions pdfOptions, ArrayList<String> ret, boolean visible) {
        if (pdfOptions.getSignerReason() != null && !pdfOptions.getSignerReason().isEmpty()) {
            ret.add(this.getDesc(visible, "VisSig.Reason") + pdfOptions.getSignerReason());
        }
    }

    private void addLocationInformation(PDFSignOptions pdfOptions, ArrayList<String> ret, boolean visible) {
        if (pdfOptions.getSignerLocation() != null && !pdfOptions.getSignerLocation().isEmpty()) {
            ret.add(this.getDesc(visible, "VisSig.Location") + pdfOptions.getSignerLocation());
        }
    }

    private void addDateInformation(Calendar cal, PDFVisualSignatureDetails pdfSignatureDetails, ArrayList<String> ret, boolean visible) {
        if (Boolean.FALSE.equals(pdfSignatureDetails.getNoDate())) {
            SimpleDateFormat sdf = new SimpleDateFormat(pdfSignatureDetails.getDateFormat());
            ret.add(this.getDesc(visible, "VisSig.Date") + sdf.format(cal.getTime()));
        }
    }

    private void addSignerInformation(String signerCommonName, PDFVisualSignatureDetails pdfSignatureDetails, ArrayList<String> ret, boolean visible) {
        if (Boolean.TRUE.equals(pdfSignatureDetails.getUseSignerCommonName())) {
            if (Boolean.FALSE.equals(pdfSignatureDetails.getNoName())) {
                ret.add(this.getDesc(visible, "VisSig.SignerName") + signerCommonName);
            }
        } else if (pdfSignatureDetails.getSignerName() != null && !pdfSignatureDetails.getSignerName().isEmpty()) {
            ret.add(this.getDesc(visible, "VisSig.SignerName") + pdfSignatureDetails.getSignerName());
        }
    }

    private String getDesc(boolean visible, String visSigKey) {
        Object result = visible ? this.resourceBundle.getString(visSigKey) + ": " : "";
        return result;
    }

    private boolean isDescriptionVisible(boolean forceVisibleDescriptions, PDFSignatureInfo i) {
        boolean visible = forceVisibleDescriptions;
        if (!visible) {
            visible = i.isVisible();
        }
        return visible;
    }

    private PDFVisualSignatureDetails validateVisualSignatureDetails(PDFVisualSignatureDetails visualSignatureDetails) {
        if (ParamValidator.isNull((Object)visualSignatureDetails.getSignatureLayout(), this.getClass(), SET_VISUAL_SIGN, "getSignatureLayout()", Level.WARNING)) {
            visualSignatureDetails.setSignatureLayout(VisibleSignatureLayout.ImageLeft);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getSignatureWidth(), this.getClass(), SET_VISUAL_SIGN, "getsignatureWidth()", Level.WARNING)) {
            visualSignatureDetails.setSignatureWidth(7.0);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getSignatureHeight(), this.getClass(), SET_VISUAL_SIGN, "getsignatureHeight()", Level.WARNING)) {
            visualSignatureDetails.setSignatureHeight(3.5);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getUseSignerCommonName(), this.getClass(), SET_VISUAL_SIGN, "getUseSignerCommonName()", Level.WARNING)) {
            visualSignatureDetails.setUseSignerCommonName(true);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getNoText(), this.getClass(), SET_VISUAL_SIGN, "getnoText()", Level.WARNING)) {
            visualSignatureDetails.setNoText(true);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getPage(), this.getClass(), SET_VISUAL_SIGN, "getPage()", Level.WARNING)) {
            visualSignatureDetails.setPage(1);
        }
        this.validateSignatureDetailsDefaultPosition(visualSignatureDetails);
        if (ParamValidator.isNull(visualSignatureDetails.getImageToTextRatio(), this.getClass(), SET_VISUAL_SIGN, "getImgageToTextRatio()", Level.WARNING)) {
            visualSignatureDetails.setImageToTextRatio(0.2);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getDynamicTextSize(), this.getClass(), SET_VISUAL_SIGN, "getDynamicTextSize()", Level.WARNING)) {
            visualSignatureDetails.setDynamicTextSize(false);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getDateFormat(), this.getClass(), SET_VISUAL_SIGN, "getDateFormat()", Level.WARNING)) {
            visualSignatureDetails.setDateFormat("yyyy.MM.dd '/' HH:mm:ss z");
        }
        if (ParamValidator.isNull(visualSignatureDetails.getNoName(), this.getClass(), SET_VISUAL_SIGN, "getNoName()", Level.WARNING)) {
            visualSignatureDetails.setNoName(Boolean.FALSE);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getNoDate(), this.getClass(), SET_VISUAL_SIGN, "getNoDate()", Level.WARNING)) {
            visualSignatureDetails.setNoDate(Boolean.FALSE);
        }
        if (ParamValidator.isNull(visualSignatureDetails.getPDFASignatureAppearance(), this.getClass(), SET_VISUAL_SIGN, "getPDFASignatureAppearance()", Level.WARNING)) {
            visualSignatureDetails.setPDFASignatureAppearance(Boolean.FALSE);
        }
        return visualSignatureDetails;
    }

    private void validateSignatureDetailsDefaultPosition(PDFVisualSignatureDetails visualSignatureDetails) {
        if (visualSignatureDetails.getAbsolutePositionX() == null && visualSignatureDetails.getAbsolutePositionY() == null) {
            if (ParamValidator.isNull(visualSignatureDetails.getPositionX(), this.getClass(), SET_VISUAL_SIGN, "getPositionX()", Level.WARNING)) {
                visualSignatureDetails.setPositionX(0.2);
            }
            if (ParamValidator.isNull(visualSignatureDetails.getPositionY(), this.getClass(), SET_VISUAL_SIGN, "getPositionY()", Level.WARNING)) {
                visualSignatureDetails.setPositionY(0.5);
            }
        }
    }

    private Double getTableWidth(PDFVisualSignatureDetails pdfVisualSignatureDetails) {
        return pdfVisualSignatureDetails.getSignatureWidth() * 72.0 / 2.54;
    }

    private Double getTableHeight(PDFVisualSignatureDetails pdfVisualSignatureDetails) {
        return pdfVisualSignatureDetails.getSignatureHeight() * 72.0 / 2.54;
    }

    private PDFont getFont(PDFVisualSignatureDetails visualSignatureOptions, PDDocument doc) throws CSLSignatureException {
        LOGGER.debug("Start 'getFont()'");
        PDFont currentFont = null;
        ParamValidator.isNull(visualSignatureOptions, this.getClass(), METHOD_NAME_GET_FONT, "visualSignatureOptions", Level.SEVERE);
        if (ParamValidator.isNull(visualSignatureOptions.getFontName(), this.getClass(), METHOD_NAME_GET_FONT, "getFont()", Level.WARNING)) {
            visualSignatureOptions.setFontName(FontEnum.HELVETICA.name());
        }
        if (ParamValidator.isNull(visualSignatureOptions.getFontSize(), this.getClass(), METHOD_NAME_GET_FONT, "getFontSize()", Level.WARNING)) {
            visualSignatureOptions.setFontSize(12);
        }
        if (ParamValidator.isNull((Object)visualSignatureOptions.getTextColor(), this.getClass(), METHOD_NAME_GET_FONT, "getTextColor()", Level.WARNING)) {
            visualSignatureOptions.setTextColor(TextColor.Black);
        }
        String font = visualSignatureOptions.getFontName();
        int fontSize = visualSignatureOptions.getFontSize();
        Boolean bPDFAMode = visualSignatureOptions.getPDFASignatureAppearance();
        currentFont = this.setFont(doc, font, currentFont, bPDFAMode);
        this.checkFontSize(fontSize);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("End 'getFont()'");
        }
        return currentFont;
    }

    private PDFont setFont(PDDocument doc, String font, PDFont currentFont, boolean bPDFAMode) throws CSLSignatureException {
        if (font.equals(FontEnum.TIMES.name()) || font.equals(FontEnum.HELVETICA.name()) || font.equals(FontEnum.COURIER.name())) {
            try {
                if (bPDFAMode) {
                    currentFont = PDType0Font.load((PDDocument)doc, (InputStream)this.getClass().getResourceAsStream("/pdf/LiberationSans-Regular.ttf"));
                }
                currentFont = this.setStandardFont(font, currentFont);
            }
            catch (Exception e) {
                LOGGER.debug(e.getLocalizedMessage(), (Throwable)e);
                throw new PDFSigningPrepareException("PDF_COULD_NOT_CREATE_USED_FONT", e, PDFSignMessageCode.PDF_COULD_NOT_CREATE_USED_FONT);
            }
        } else {
            throw new PDFSigningPrepareException("PDF_INVALID_VALUE_GETFONT", PDFSignMessageCode.PDF_INVALID_VALUE_GETFONT);
        }
        return currentFont;
    }

    private PDFont setStandardFont(String font, PDFont currentFont) {
        if (font.equals(FontEnum.HELVETICA.name())) {
            currentFont = PDType1Font.HELVETICA;
        }
        if (font.equals(FontEnum.TIMES.name())) {
            currentFont = PDType1Font.TIMES_ROMAN;
        }
        if (font.equals(FontEnum.COURIER.name())) {
            currentFont = PDType1Font.COURIER;
        }
        return currentFont;
    }

    private void checkFontSize(int fontSize) throws CSLSignatureException {
        if (fontSize < 6 || fontSize > 36 || fontSize % 2 != 0) {
            throw new PDFSigningPrepareException("PDF_USED_FONT_INVALID", PDFSignMessageCode.PDF_USED_FONT_INVALID);
        }
    }

    private Color getFontColor(TextColor textcolor) throws CSLSignatureException {
        switch (textcolor) {
            case Black: {
                return Color.BLACK;
            }
            case Blue: {
                return Color.BLUE;
            }
            case Gray: {
                return Color.GRAY;
            }
            case Green: {
                return Color.GREEN;
            }
            case Red: {
                return Color.RED;
            }
            case Yellow: {
                return Color.YELLOW;
            }
        }
        throw new PDFSigningPrepareException("PDF_INVALID_TEXTCOLOR", PDFSignMessageCode.PDF_INVALID_TEXTCOLOR);
    }

    private class WriteVisibleSigDto {
        float height;
        float width;
        float imgWidth;
        float imgHeight;
        float imgX;
        float imgY;
        float imgScale;
        float txtX;
        float txtY;
        float txtWidth;
        float txtHeight;
        float realSigContentHeight = 0.0f;
        float realSigContentWidth = 0.0f;
        float fontSize;

        private WriteVisibleSigDto() {
        }
    }
}

