/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.utils;

import de.governikus.csl.pdf.sign.PDFSignOptions;
import de.governikus.csl.pdf.sign.PDFVisualSignatureDetails;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDFUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFUtils.class);
    public static final String DICTIONARY_ITEM_KEY_CERT = "Cert";
    public static final String DICTIONARY_ITEM_KEY_JSIGN_CERT = "Zertifikat";
    public static final String OID_PKCS9_ID_AA_ETS_SIGNER_LOCATION = "1.2.840.113549.1.9.16.2.17";
    public static final String OID_PKCS9_ID_AA_CONTENT_IDENTIFIER = "1.2.840.113549.1.9.16.2.7";
    public static final String OID_PKCS9_ID_AA_CONTENT_HINT = "1.2.840.113549.1.9.16.2.4";
    public static final String OID_PKCS9_ID_SIGNING_TIME = "1.2.840.113549.1.9.5";
    private static int[] pdfHeader = new int[]{37, 80, 68, 70, 45, 49};

    private PDFUtils() {
    }

    public static boolean canHandle(File file) throws IOException {
        boolean bl;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            bl = PDFUtils.canFind(pdfHeader, 0, fis);
        }
        catch (Throwable throwable) {
            PDFUtils.closeStream(fis);
            throw throwable;
        }
        PDFUtils.closeStream(fis);
        return bl;
    }

    public static boolean canFind(int[] search, int failureAllowed, InputStream is) throws IOException {
        int count = 0;
        int failureCount = 0;
        while (count < search.length) {
            int b = is.read();
            if (search[count] == b) {
                ++count;
                continue;
            }
            if (++failureCount > failureAllowed) {
                return false;
            }
            count = 0;
        }
        return true;
    }

    public static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close stream. " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static void closeStream(PDDocument stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close stream. " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toOutputStream(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesReaded;
            byte[] buffer = new byte[8192];
            while ((bytesReaded = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesReaded);
            }
            os.flush();
        }
        finally {
            PDFUtils.closeStream(is);
        }
    }

    public static void removeOldSignatures(PDDocument doc) throws IOException {
        try {
            COSBase dictionaryObject;
            COSDictionary acroForm;
            COSDocument document = doc.getDocument();
            COSObject documentCatalog = document.getCatalog();
            if (documentCatalog != null && (acroForm = (COSDictionary)documentCatalog.getDictionaryObject(COSName.getPDFName((String)"AcroForm"))) != null && (dictionaryObject = acroForm.getDictionaryObject("Fields")) instanceof COSArray) {
                COSArray acroFormFields = (COSArray)dictionaryObject;
                Iterator iter = acroFormFields.iterator();
                while (iter.hasNext()) {
                    COSBase signatureDict;
                    COSDictionary dict;
                    COSBase cosBase = (COSBase)iter.next();
                    if (!(cosBase instanceof COSObject) || !"Sig".equals((dict = (COSDictionary)((COSObject)cosBase).getObject()).getNameAsString(COSName.getPDFName((String)"FT"))) || (signatureDict = dict.getDictionaryObject(COSName.V)) == null) continue;
                    COSDictionary page = (COSDictionary)dict.getDictionaryObject(COSName.P);
                    if (page == null) {
                        PDPage pdPage;
                        COSDictionary pageDic;
                        COSArray annots;
                        PDPageTree allPages = doc.getDocumentCatalog().getPages();
                        Iterator iterator = allPages.iterator();
                        while (iterator.hasNext() && ((annots = (COSArray)(pageDic = (pdPage = (PDPage)iterator.next()).getCOSObject()).getDictionaryObject("Annots")) == null || !annots.remove(cosBase))) {
                        }
                    } else {
                        COSArray annots = (COSArray)page.getDictionaryObject("Annots");
                        if (annots != null && acroFormFields != annots) {
                            annots.remove(cosBase);
                        }
                    }
                    iter.remove();
                }
            }
        }
        catch (NullPointerException e) {
            throw new IOException(e);
        }
    }

    public static XMLGregorianCalendar toXMLGregCalendar(Calendar cal) {
        if (cal == null) {
            return null;
        }
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)cal);
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }

    public static String printCOSDictionary(COSDictionary dict) {
        StringBuilder sb = new StringBuilder();
        if (dict.getItem(COSName.TYPE) != null) {
            sb.append(dict.getNameAsString(COSName.TYPE) + " ");
        }
        sb.append("{\n");
        Set entrySet = dict.entrySet();
        for (Map.Entry entry : entrySet) {
            sb.append("\t");
            sb.append(entry.getKey());
            sb.append(" : ");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static PDVisibleSigProperties convert(PDFSignOptions pdfSignOptions, PDFVisualSignatureDetails visualSignatureDetails) throws IOException {
        PDVisibleSigProperties result = new PDVisibleSigProperties();
        if (visualSignatureDetails != null) {
            result.visualSignEnabled(true).page(visualSignatureDetails.getPage().intValue()).signatureReason(pdfSignOptions.getSignerReason()).signerName(visualSignatureDetails.getSignerName()).signerLocation(pdfSignOptions.getSignerLocation());
            byte[] imageBytes = visualSignatureDetails.getImage();
            if (imageBytes != null) {
                result.setVisibleSignature((InputStream)new ByteArrayInputStream(imageBytes));
            }
        }
        return result;
    }
}

