/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.utils;

import de.governikus.csl.pdf.sign.impl.pdfbox.visual.PDFBoxVisualSignatureHelperImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDAttributeObject;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkedContentReference;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDObjectReference;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.documentinterchange.taggedpdf.PDLayoutAttributeObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTree;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public class PDFUAUtil {
    public static final String ICC_RESOURCE_PDFBOX = "/org/apache/pdfbox/resources/icc/ISOcoated_v2_300_bas.icc";
    public static final String ICC_RESOURCE_GOVERNIKUS = "/de/governikus/csl/pdf/sign/impl/pdfbox/visual/sRGB_IEC61966-2.icc";
    public static final String RGB_IEC61966_2_1 = "sRGB IEC61966-2.1";
    private static final ResourceBundle RESOURCE_BUNDLE = PDFBoxVisualSignatureHelperImpl.getResourceBundle();
    private static final COSName TABS = COSName.getPDFName((String)"Tabs");

    private PDFUAUtil() {
    }

    public static List<COSDictionary> getSignatureWidgets(PDDocument document) {
        LinkedList<COSDictionary> result = new LinkedList<COSDictionary>();
        PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
        PDAcroForm acroForm = documentCatalog.getAcroForm();
        if (acroForm != null && acroForm.isSignaturesExist()) {
            PDFieldTree fieldTree = acroForm.getFieldTree();
            for (PDField field : fieldTree) {
                if (!(field instanceof PDSignatureField) || ((PDSignatureField)field).getSignature() == null || ((PDSignatureField)field).getSignature().getContents().length <= 0) continue;
                PDSignatureField sigField = (PDSignatureField)field;
                result.add(sigField.getCOSObject());
            }
        }
        return result;
    }

    public static void fixPDFUAFeatures(PDDocument document, List<COSDictionary> previousSignatures, List<COSDictionary> currentSignatures, String visibleSignatureAlternateText) throws IOException {
        currentSignatures.removeAll(previousSignatures);
        if (currentSignatures.isEmpty()) {
            return;
        }
        if (currentSignatures.size() > 1) {
            throw new IOException("more then one signature added?");
        }
        COSDictionary cosSignatureField = currentSignatures.get(0);
        PDFUAUtil.fixLogicalStructure(document, visibleSignatureAlternateText, cosSignatureField);
        PDFUAUtil.fixTabOrderForPDFUA(document);
        PDFUAUtil.addOutputIntendForPDFA(document);
    }

    private static void fixLogicalStructure(PDDocument document, String visibleSignatureAlternateText, COSDictionary cosSignatureField) throws IOException {
        PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
        PDStructureTreeRoot structureTreeRoot = documentCatalog.getStructureTreeRoot();
        if (structureTreeRoot != null && structureTreeRoot.getParentTree() != null) {
            PDNumberTreeNode parentTree = structureTreeRoot.getParentTree();
            int parentTreeNextKey = PDFUAUtil.getParentTreeNextKey(structureTreeRoot, parentTree);
            PDAnnotationWidget pdAnnotationWidget = PDFUAUtil.updateAnnotationWidget(visibleSignatureAlternateText, cosSignatureField, parentTreeNextKey);
            COSDictionary structTreeRootAsCOSDict = structureTreeRoot.getCOSObject();
            COSBase cosTopLevelStructureElement = structTreeRootAsCOSDict.getDictionaryObject(COSName.K);
            if (cosTopLevelStructureElement instanceof COSDictionary) {
                COSDictionary topLevelElementAsDictionary = (COSDictionary)cosTopLevelStructureElement;
                topLevelElementAsDictionary.setNeedToBeUpdated(true);
                PDStructureElement topLevelStructElement = new PDStructureElement(topLevelElementAsDictionary);
                PDObjectReference objectReference = new PDObjectReference();
                objectReference.setReferencedObject((PDAnnotation)pdAnnotationWidget);
                objectReference.getCOSObject().setNeedToBeUpdated(true);
                if (pdAnnotationWidget.getNormalAppearanceStream() != null) {
                    PDFUAUtil.createMarkedContentReference(document, pdAnnotationWidget);
                    PDStructureElement formStructureElement = PDFUAUtil.createFormStructureElement(pdAnnotationWidget, topLevelStructElement, objectReference);
                    PDFUAUtil.updateParentTree(structureTreeRoot, parentTree, parentTreeNextKey, formStructureElement);
                    COSArray kArray = structureTreeRoot.getKArray();
                    if (kArray != null) {
                        kArray.setNeedToBeUpdated(true);
                        kArray.add((COSBase)formStructureElement.getCOSObject());
                    } else {
                        topLevelStructElement.appendKid(formStructureElement);
                    }
                }
                parentTree.getCOSObject().setNeedToBeUpdated(true);
                structureTreeRoot.getCOSObject().setNeedToBeUpdated(true);
            }
        }
    }

    private static void updateParentTree(PDStructureTreeRoot structureTreeRoot, PDNumberTreeNode parentTree, int parentTreeNextKey, PDStructureElement formStructureElement) throws IOException {
        COSDictionary parentTreeCOSObject = parentTree.getCOSObject();
        COSArray numbersArray = PDFUAUtil.getNumsArray(parentTreeCOSObject);
        numbersArray.add((COSBase)COSInteger.get((long)parentTreeNextKey));
        numbersArray.add((COSObjectable)formStructureElement);
        numbersArray.setNeedToBeUpdated(true);
        PDFUAUtil.updateLimits(parentTreeCOSObject);
        structureTreeRoot.setParentTreeNextKey(parentTreeNextKey + 1);
    }

    static PDAnnotationWidget updateAnnotationWidget(String visibleSignatureAlternateText, COSDictionary cosSignatureField, int parentTreeNextKey) {
        PDAnnotationWidget pdAnnotationWidget = new PDAnnotationWidget(cosSignatureField);
        pdAnnotationWidget.setStructParent(parentTreeNextKey);
        pdAnnotationWidget.setContents(RESOURCE_BUNDLE.getString("VisSig.templates.defaultAnnotationWidgetContentText"));
        pdAnnotationWidget.getCOSObject().setString(COSName.TU, PDFUAUtil.createAlternativeText(visibleSignatureAlternateText, pdAnnotationWidget.getCOSObject().getDictionaryObject(COSName.V)));
        return pdAnnotationWidget;
    }

    private static PDStructureElement createFormStructureElement(PDAnnotationWidget pdAnnotationWidget, PDStructureElement topLevelStructElement, PDObjectReference objectReference) {
        PDStructureElement formMCElement = new PDStructureElement("Form", (PDStructureNode)topLevelStructElement);
        formMCElement.appendKid(objectReference);
        PDLayoutAttributeObject attributeObject = new PDLayoutAttributeObject();
        attributeObject.setPlacement("Block");
        formMCElement.addAttribute((PDAttributeObject)attributeObject);
        formMCElement.setPage(pdAnnotationWidget.getPage());
        return formMCElement;
    }

    private static PDMarkedContentReference createMarkedContentReference(PDDocument document, PDAnnotationWidget pdAnnotationWidget) throws IOException {
        int newMCID = 0;
        PDFUAUtil.updateTaggedContentInVisibleSignature(document, pdAnnotationWidget, newMCID);
        PDMarkedContentReference markedContentReference = new PDMarkedContentReference();
        markedContentReference.setMCID(newMCID);
        markedContentReference.getCOSObject().setItem(COSName.getPDFName((String)"STM"), (COSBase)pdAnnotationWidget.getNormalAppearanceStream().getContentStream().getCOSObject());
        markedContentReference.getCOSObject().setNeedToBeUpdated(true);
        return markedContentReference;
    }

    static String createAlternativeText(String visibleSignatureAlternateText, COSBase signatureDictionary) {
        if (visibleSignatureAlternateText == null || visibleSignatureAlternateText.trim().isEmpty()) {
            if (signatureDictionary instanceof COSDictionary) {
                COSDictionary asDict = (COSDictionary)signatureDictionary;
                String reason = asDict.getString(COSName.REASON, "");
                String location = asDict.getString(COSName.LOCATION, "");
                String date = asDict.getString(COSName.M, "");
                Object sigDictContent = reason + " " + location + " " + date;
                if (((String)(sigDictContent = ((String)sigDictContent).trim())).length() != 0) {
                    return sigDictContent;
                }
            }
            return RESOURCE_BUNDLE.getString("VisSig.templates.fallbackAlternateSignatureDictionaryText");
        }
        return visibleSignatureAlternateText;
    }

    private static int getParentTreeNextKey(PDStructureTreeRoot structureTreeRoot, PDNumberTreeNode parentTree) throws IOException {
        int parentTreeNextKey = structureTreeRoot.getParentTreeNextKey();
        if (parentTreeNextKey < 0) {
            COSDictionary parentTreeCOSObject = parentTree.getCOSObject();
            COSArray numbersArray = PDFUAUtil.getNumsArray(parentTreeCOSObject);
            parentTreeNextKey = numbersArray.size() / 2;
        }
        return parentTreeNextKey;
    }

    private static COSArray getNumsArray(COSDictionary parentTreeCOSObject) throws IOException {
        COSArray nums = (COSArray)parentTreeCOSObject.getDictionaryObject(COSName.NUMS);
        if (nums != null) {
            return nums;
        }
        COSDictionary lastKidAsDict = PDFUAUtil.extractLastKidAsDictionary(parentTreeCOSObject);
        return PDFUAUtil.getNumsArray(lastKidAsDict);
    }

    private static COSDictionary extractLastKidAsDictionary(COSDictionary parentTreeCOSObject) {
        COSBase lastKidObject;
        COSArray kids = (COSArray)parentTreeCOSObject.getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            throw new IllegalArgumentException("Kids element not found in struct tree");
        }
        COSBase lastKid = kids.get(kids.size() - 1);
        COSBase cOSBase = lastKidObject = lastKid instanceof COSDictionary ? lastKid : ((COSObject)lastKid).getObject();
        if (!(lastKidObject instanceof COSDictionary)) {
            throw new IllegalArgumentException("Kids element not a dictionary");
        }
        return (COSDictionary)lastKidObject;
    }

    private static void updateLimits(COSDictionary parentTreeCOSObject) throws IOException {
        COSBase lastKidObject;
        COSArray nums = (COSArray)parentTreeCOSObject.getDictionaryObject(COSName.NUMS);
        if (nums != null) {
            return;
        }
        COSArray kids = (COSArray)parentTreeCOSObject.getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            throw new IOException("Nums element not found in struct tree");
        }
        COSBase lastKid = kids.get(kids.size() - 1);
        COSBase cOSBase = lastKidObject = lastKid instanceof COSDictionary ? lastKid : ((COSObject)lastKid).getObject();
        if (!(lastKidObject instanceof COSDictionary)) {
            throw new IllegalArgumentException("Kids element not a dictionary");
        }
        COSDictionary lastKidAsDict = (COSDictionary)lastKidObject;
        COSArray limits = (COSArray)lastKidAsDict.getDictionaryObject(COSName.LIMITS);
        if (limits != null) {
            int lastLimit = limits.getInt(limits.size() - 1);
            limits.set(limits.size() - 1, lastLimit + 1);
            limits.setNeedToBeUpdated(true);
            parentTreeCOSObject.setNeedToBeUpdated(true);
        }
        PDFUAUtil.updateLimits(lastKidAsDict);
    }

    private static void updateTaggedContentInVisibleSignature(PDDocument document, PDAnnotationWidget annotationWidget, int nextMarkedContentID) throws IOException {
        PDAppearanceStream contentStream = annotationWidget.getNormalAppearanceStream();
        if (contentStream != null) {
            InputStream contents = contentStream.getContents();
            PDAppearanceDictionary appearance = new PDAppearanceDictionary();
            PDAppearanceStream appearanceStream = new PDAppearanceStream(document);
            appearanceStream.setResources(contentStream.getResources());
            appearanceStream.setBBox(contentStream.getBBox());
            appearanceStream.setMatrix(contentStream.getMatrix().createAffineTransform());
            appearance.setNormalAppearance(appearanceStream);
            try (OutputStream os = appearanceStream.getStream().createOutputStream(COSName.FLATE_DECODE);){
                os.write(("/Form << /MCID " + nextMarkedContentID + ">> BDC\n").getBytes());
                IOUtils.copy((InputStream)contents, (OutputStream)os);
                os.write("EMC\n".getBytes());
            }
            annotationWidget.setAppearance(appearance);
        }
    }

    private static void addOutputIntendForPDFA(PDDocument doc) throws IOException {
        PDDocumentCatalog documentCatalog = doc.getDocumentCatalog();
        if (documentCatalog.getOutputIntents().isEmpty()) {
            try (InputStream colorProfile = PDFUAUtil.class.getResourceAsStream(ICC_RESOURCE_GOVERNIKUS);){
                PDOutputIntent oi = new PDOutputIntent(doc, colorProfile);
                oi.setInfo(RGB_IEC61966_2_1);
                oi.setOutputCondition(RGB_IEC61966_2_1);
                oi.setOutputConditionIdentifier(RGB_IEC61966_2_1);
                oi.setRegistryName("http://www.color.org");
                documentCatalog.addOutputIntent(oi);
            }
        }
    }

    private static void fixTabOrderForPDFUA(PDDocument doc) {
        for (int i = 0; i < doc.getNumberOfPages(); ++i) {
            PDPage p = doc.getDocumentCatalog().getPages().get(i);
            COSDictionary cosObject = p.getCOSObject();
            if (cosObject.containsKey(TABS)) continue;
            cosObject.setItem(TABS, (COSBase)COSName.S);
            cosObject.setNeedToBeUpdated(true);
            while (cosObject.containsKey(COSName.PARENT)) {
                COSBase cosBase = cosObject.getDictionaryObject(COSName.PARENT);
                if (!(cosBase instanceof COSDictionary)) continue;
                cosObject = (COSDictionary)cosBase;
                cosObject.setNeedToBeUpdated(true);
            }
        }
    }
}

