/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.utils;

import de.governikus.csl.cms.sign.doc.CMSSignedDocument;
import de.governikus.csl.cms.sign.props.CMSContentType;
import de.governikus.csl.pdf.sign.impl.PDFSigningContext;
import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.sign.impl.AbstractSignPlugin;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.core.SignatureRequest;
import de.governikus.csl.uom.core.impl.DataToBeSignedImpl;
import de.governikus.csl.uom.docs.StreamDocument;
import de.governikus.csl.uom.impl.UnparsedDocument;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPlugin;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.impl.SignOptionsBuilder;
import de.governikus.csl.uom.sign.impl.SignerInfoBuilder;
import de.governikus.csl.uom.sign.props.PropertiesUtil;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import de.governikus.csl.uom.sign.props.SigningTime;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;

public class PDFCMSPluginSigner
implements SignatureInterface {
    private final PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context;
    private final SignPlugin cmsSignPlugin;

    public PDFCMSPluginSigner(SignPlugin cmsSignPlugin, PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws CSLSignatureException {
        this.cmsSignPlugin = AbstractSignPlugin.assertSignPlugin((SignPlugin)cmsSignPlugin, (Plugin.PluginID)Plugin.PluginID.SIGN_CMS);
        if (this.cmsSignPlugin == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "missing required CMSSignPlugin instance");
        }
        this.context = context;
    }

    public byte[] sign(InputStream content) throws IOException {
        LinkedHashSet<Class<UnparsedDocument>> inputDocumentClasses = new LinkedHashSet<Class<UnparsedDocument>>();
        inputDocumentClasses.add(UnparsedDocument.class);
        SignerInfo signerInfo = new SignerInfoBuilder().setSignatureAlgorithmURI(this.context.algoIdSignature).setKey(this.context.signerInfo.getKey()).build();
        SignPolicy signPolicy = (SignPolicy)this.context.getSignOptions().getPolicy();
        SignOptions options = new SignOptionsBuilder().setSignerInfos(Collections.singleton(signerInfo)).setSignatureType(SignatureType.DETACHED).setPluginID(Plugin.PluginID.SIGN_CMS.getID()).setInputDocumentFormatClasses(inputDocumentClasses).setPolicy(signPolicy).setDefaultTrustedAnchorService(((SignOptions)this.context.getSignRequest().getOptions()).getDefaultTrustedAnchorService()).setDefaultTimestampService(((SignOptions)this.context.getSignRequest().getOptions()).getDefaultTimestampService()).setDefaultCertificateValidationService(((SignOptions)this.context.getSignRequest().getOptions()).getDefaultCertificateValidationService()).build();
        SigningCertificate signingCertificate = (SigningCertificate)PropertiesUtil.getSignedProperty(SigningCertificate.class, (SignedProperties)this.context.signedProperties, (boolean)false);
        if (signingCertificate == null) {
            SignOptions optionsEntry = (SignOptions)this.context.getSignRequest().getOptions();
            if (!(optionsEntry instanceof ConstraintSignPolicy)) {
                throw new IOException("creation of signing certificate not possible, no encoding selectable, use ConstraintSignPolicy: " + optionsEntry);
            }
            if (signerInfo.getKey() == null || signerInfo.getKey().getCertificate() == null) {
                throw new IOException("creation of signing certificate not possible, no key with certificate");
            }
            ConstraintSignPolicy csp = (ConstraintSignPolicy)optionsEntry;
            if (csp.getEncodingConstraints().size() != 1) {
                throw new IOException("creation of signing certificate not possible, more than one encoding: " + csp.getEncodingConstraints());
            }
            String digestAlgorithmURI = "http://www.w3.org/2000/09/xmldsig#sha1";
            if (csp.getEncodingConstraints().contains(ConstraintSignPolicy.EncodingConstraint.ETSI_EN)) {
                digestAlgorithmURI = "http://www.w3.org/2001/04/xmlenc#sha256";
            }
            SigningCertificate created = new SigningCertificate(csp.getEncodingConstraints());
            created.setDigestAlgorithmURI(digestAlgorithmURI);
            created.addCertificate(signerInfo.getKey().getCertificate().certificate());
            this.context.signedProperties.add((Object)created);
        }
        this.context.signedProperties.add((Object)new CMSContentType(this.context.contentType.getId(), true, ConstraintSignPolicy.EncodingConstraint.DEFAULT));
        if (PropertiesUtil.existsSignedProperties(SigningTime.class, (SignedProperties)this.context.signedProperties)) {
            PropertiesUtil.removeProperties((List)this.context.signedProperties, (Class[])new Class[]{SigningTime.class});
        }
        signerInfo.getSignedProperties().addAll((Collection)this.context.signedProperties);
        signerInfo.getUnsignedProperties().addAll((Collection)this.context.unsignedProperties);
        StreamDocument d = new StreamDocument(UUID.randomUUID().toString(), "pdf-sign-as-cms", content, "text/plain");
        List dataToBeSigned = DataToBeSignedImpl.getList((Document[])new Document[]{d});
        SignatureRequest signRequest = new SignatureRequest(options, dataToBeSigned);
        try {
            SignedDataResponse signResponse = this.cmsSignPlugin.sign((SignRequest)signRequest, this.context.env);
            byte[] cms = ((CMSSignedData)((CMSSignedDocument)((SignedData)signResponse.getDatas().get(0)).getSignature()).getParsed()).getEncoded();
            CMSSignedData cmsSD = new CMSSignedData(cms);
            if (((SignerInformation)cmsSD.getSignerInfos().getSigners().iterator().next()).getSignedAttributes().get(PKCSObjectIdentifiers.pkcs_9_at_signingTime) != null) {
                throw new IOException("failed to sign: signing time not allowed at CMS of PDF signature");
            }
            return cms;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("failed to sign", e);
        }
    }
}

