/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.metadata;

import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.CalculateHelper;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.Rectangle;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.SignatureField;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class Page {
    private List<SignatureField> signatureFields = new ArrayList<SignatureField>();
    private List<SignatureField> signableSignatureFields = new ArrayList<SignatureField>();
    private PDPage page;
    private int pageNo;
    private PDDocument document;

    public Page(PDDocument document, PDPage page, int pageNo) {
        this.document = document;
        this.page = page;
        this.pageNo = pageNo;
    }

    public BufferedImage generatePage() throws IOException {
        return this.generatePage(ImageType.RGB, 300);
    }

    public BufferedImage generatePage(int imageType, int resolution) throws IOException {
        ImageType pdfBoxImageType = null;
        switch (imageType) {
            case 12: {
                pdfBoxImageType = ImageType.BINARY;
                break;
            }
            case 10: {
                pdfBoxImageType = ImageType.GRAY;
                break;
            }
            case 1: {
                pdfBoxImageType = ImageType.RGB;
                break;
            }
            case 2: {
                pdfBoxImageType = ImageType.ARGB;
                break;
            }
            default: {
                throw new IOException("not supported type: " + imageType);
            }
        }
        return new PDFRenderer(this.document).renderImageWithDPI(this.pageNo, (float)resolution, pdfBoxImageType);
    }

    public BufferedImage generatePage(ImageType imageType, int resolution) throws IOException {
        return new PDFRenderer(this.document).renderImageWithDPI(this.pageNo, (float)resolution, imageType);
    }

    public BufferedImage generatePage(ImageType imageType, float scale) throws IOException {
        PDFRenderer pdfRenderer = new PDFRenderer(this.document);
        return pdfRenderer.renderImage(this.pageNo - 1, scale, ImageType.ARGB);
    }

    public Rectangle getMediaBox() {
        return CalculateHelper.convertToRectangle(this.page.getMediaBox());
    }

    public Rectangle getCropBox() {
        return CalculateHelper.convertToRectangle(this.page.getCropBox());
    }

    public int getRotation() {
        return this.page.getRotation();
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void addSignatureField(SignatureField sigField) {
        this.signatureFields.add(sigField);
        this.signableSignatureFields.clear();
    }

    public List<SignatureField> getSignatureFields() {
        return this.signatureFields;
    }

    public synchronized List<SignatureField> getSignableSignatureFields() {
        if (this.signableSignatureFields.isEmpty()) {
            for (SignatureField sigField : this.getSignatureFields()) {
                if (!sigField.isUsableForSigning()) continue;
                this.signableSignatureFields.add(sigField);
            }
        }
        return this.signableSignatureFields;
    }
}

