/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.metadata;

import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.Page;
import de.governikus.csl.pdf.sign.impl.pdfbox.metadata.SignatureField;
import de.governikus.csl.pdf.sign.impl.pdfbox.utils.PDFUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFMetaData
implements Closeable,
SignatureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(PDFMetaData.class);
    private final PDDocument document;
    private List<Page> pages;
    private final boolean encryptedDocument;
    protected List<PDSignatureField> signatureFields = new ArrayList<PDSignatureField>();
    protected List<SignatureField> sigFields = new ArrayList<SignatureField>();
    protected PDSignature signatureDictionary = null;
    protected SignatureOptions signatureOptions = null;

    public PDFMetaData(File pdfDocument) throws IOException {
        this(PDDocument.load((File)pdfDocument));
    }

    public PDFMetaData(InputStream pdfDocument) throws IOException {
        this(PDDocument.load((InputStream)pdfDocument));
    }

    public PDFMetaData(PDDocument pdfDocument) throws IOException {
        this.document = pdfDocument;
        this.encryptedDocument = this.document.isEncrypted();
        if (this.encryptedDocument) {
            throw new IOException("document is encrypted, external decryption required on loading document");
        }
        this.retrieveMetaData();
    }

    public int getNumberOfPages() {
        return this.document.getNumberOfPages();
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public boolean isEncrypted() {
        return this.encryptedDocument;
    }

    private void retrieveMetaData() throws IOException {
        this.pages = new ArrayList<Page>();
        PDPageTree allPages = this.document.getPages();
        int pageNo = 0;
        for (PDPage pdPage : allPages) {
            Page page = new Page(this.document, pdPage, ++pageNo);
            this.pages.add(page);
        }
        List tmpSignatureFields = this.document.getSignatureFields();
        for (PDSignatureField pdSignatureField : tmpSignatureFields) {
            for (PDAnnotationWidget widget : pdSignatureField.getWidgets()) {
                PDPage page = widget.getPage();
                if (page == null) continue;
                PDAnnotationWidget annot = (PDAnnotationWidget)pdSignatureField.getWidgets().get(0);
                SignatureField signatureField = this.calcSignatureField(page, (PDAnnotation)annot);
                int postion = allPages.indexOf(page) + 1;
                signatureField.setFieldName(pdSignatureField.getPartialName());
                signatureField.setPageNo(postion);
                boolean notUsableForSigning = pdSignatureField.getSignature() != null || annot.isNoView() || annot.isHidden();
                signatureField.setUsableForSigning(!notUsableForSigning);
                this.pages.get(postion - 1).addSignatureField(signatureField);
            }
        }
    }

    private SignatureField calcSignatureField(PDPage page, PDAnnotation annot) {
        float sw;
        float y2;
        PDRectangle box = page.getCropBox();
        PDRectangle rect = annot.getRectangle();
        float x1 = rect.getLowerLeftX();
        float x2 = rect.getUpperRightX();
        float y1 = box.getHeight() - rect.getUpperRightY();
        if (y1 > (y2 = box.getHeight() - rect.getLowerLeftY())) {
            sw = y1;
            y1 = y2;
            y2 = sw;
        }
        if (x1 > x2) {
            sw = x1;
            x1 = x2;
            x2 = sw;
        }
        float width = x2 - x1;
        float height = y2 - y1;
        return new SignatureField(x1, y1, width, height);
    }

    @Override
    public void close() throws IOException {
        PDFUtils.closeStream(this.document);
    }

    public List<PDSignatureField> getPDSignatureFields() {
        return this.signatureFields;
    }

    public final void addPDSignatureField(PDSignatureField pdSignatureField) {
        this.signatureFields.add(pdSignatureField);
    }

    public void addSignatureField(SignatureField sigFields) {
        this.sigFields.add(sigFields);
    }

    public PDSignatureField createNewPDSignatureField() throws IOException {
        PDDocumentCatalog documentCatalog = this.document.getDocumentCatalog();
        PDAcroForm acroForm = documentCatalog.getAcroForm();
        if (acroForm == null) {
            acroForm = new PDAcroForm(this.document);
            documentCatalog.setAcroForm(acroForm);
        }
        PDSignatureField pdsf = new PDSignatureField(acroForm);
        acroForm.getFields().add(pdsf);
        return pdsf;
    }

    public final SignatureOptions getSignatureOptions() {
        return this.signatureOptions;
    }

    public final void setSignatureOptions(SignatureOptions signatureOptions) {
        this.signatureOptions = signatureOptions;
    }

    protected void preConfiguration(PDDocument doc) throws IOException {
        PDDocumentCatalog documentCatalog = doc.getDocumentCatalog();
        PDPageTree allPages = documentCatalog.getPages();
        for (SignatureField sigField : this.sigFields) {
            if (sigField.getPageNo() <= 0 || sigField.getPageNo() > allPages.getCount()) {
                throw new IllegalStateException("Page " + sigField.getPageNo() + " not available! Use one between these: 1 and " + allPages.getCount());
            }
            PDPage pdPage = allPages.get(sigField.getPageNo() - 1);
            if (pdPage == null) {
                throw new IllegalStateException("Page " + sigField.getPageNo() + " not available! Use one between these: 1 and " + allPages.getCount());
            }
            if (sigField.getFieldName() == null || sigField.getFieldName().isEmpty()) {
                throw new IllegalStateException("Signature FieldName should not be empty");
            }
            try {
                PDSignatureField pdSignatureField = this.createNewPDSignatureField();
                pdSignatureField.setPartialName(sigField.getFieldName());
                pdSignatureField.setAlternateFieldName(sigField.getAlternateFieldName());
                List widgets = pdSignatureField.getWidgets();
                for (PDAnnotationWidget widget : widgets) {
                    PDRectangle mediaBox = pdPage.getMediaBox();
                    PDRectangle rectangle = new PDRectangle();
                    rectangle.setLowerLeftX(sigField.getX());
                    rectangle.setLowerLeftY(mediaBox.getUpperRightY() - sigField.getY() - sigField.getHeight());
                    rectangle.setUpperRightX(sigField.getX() + sigField.getWidth());
                    rectangle.setUpperRightY(mediaBox.getUpperRightY() - sigField.getY());
                    widget.setRectangle(rectangle);
                    PDAppearanceDictionary pdAppearanceDictionary = new PDAppearanceDictionary();
                    PDAppearanceStream appearanceStream = new PDAppearanceStream(doc);
                    pdAppearanceDictionary.setNormalAppearance(appearanceStream);
                    widget.setAppearance(pdAppearanceDictionary);
                    widget.setPage(pdPage);
                }
                pdPage.getCOSObject().setNeedToBeUpdated(true);
                this.addPDSignatureField(pdSignatureField);
            }
            catch (Exception e) {
                throw new IOException("Error occured while transforming SignatureField.", e);
            }
        }
    }

    public final void saveFile(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Outputstream shouldn't be null");
        }
        this.preConfiguration(this.document);
        try {
            this.document.addSignatureField(this.getPDSignatureFields(), (SignatureInterface)this, this.getSignatureOptions());
            if (!this.getPDSignatureFields().isEmpty()) {
                ((COSArray)this.document.getDocumentCatalog().getAcroForm().getCOSObject().getDictionaryObject("Fields")).setNeedToBeUpdated(true);
            }
            this.document.saveIncremental(outputStream);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        finally {
            this.close();
        }
    }

    public byte[] sign(InputStream arg0) throws IOException {
        throw new IllegalArgumentException("Unsupported call");
    }
}

