/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.doc.impl;

import de.governikus.csl.pdf.sign.PDFSignMessageCode;
import de.governikus.csl.pdf.sign.PDFSigningPrepareException;
import de.governikus.csl.pdf.sign.doc.PDFDocument;
import de.governikus.csl.pdf.sign.impl.pdfbox.doc.impl.PDFDocumentImpl;
import de.governikus.csl.pdf.sign.impl.pdfbox.doc.impl.PDFSignedDocumentImpl;
import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Options;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignatureType;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFSimpleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFSimpleParser.class);

    public Document parseDocument(Options<?> options, Document rawDocument) throws CSLSignatureException, PDFSigningPrepareException, IOException {
        PDDocument pdf;
        if (rawDocument instanceof PDFDocument) {
            return rawDocument;
        }
        if (options instanceof SignOptions) {
            SignatureType signatureType = ((SignOptions)options).getSignatureType();
            switch (signatureType) {
                case ENVELOPED: {
                    break;
                }
                default: {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "not supported signature type: " + signatureType);
                }
            }
        }
        if ((pdf = PDFDocumentImpl.loadPDFDocument(rawDocument)) == null) {
            throw new PDFSigningPrepareException("error: document can not be read. Not pdf?", PDFSignMessageCode.PDF_INVALID_DOCUMENT);
        }
        if (pdf.isEncrypted()) {
            throw new PDFSigningPrepareException("error: document encrypted", PDFSignMessageCode.DOCUMENT_ENCRYPTED);
        }
        String contentType = rawDocument.getContentType();
        if (contentType == null) {
            contentType = "application/pdf";
        }
        if (pdf.getLastSignatureDictionary() == null) {
            return new PDFDocumentImpl(pdf, rawDocument.getId(), rawDocument.getName(), contentType, rawDocument.getReferenceResolver());
        }
        return new PDFSignedDocumentImpl(pdf, rawDocument.getId(), rawDocument.getName(), contentType, rawDocument.getReferenceResolver());
    }
}

