/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox.doc.impl;

import de.governikus.csl.pdf.sign.doc.PDFDocument;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.impl.FileReferenceResolver;
import de.governikus.csl.uom.impl.ParsedDocumentImpl;
import de.governikus.csl.uom.util.CSLDocumentDataHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PDFDocumentImpl
extends ParsedDocumentImpl<PDDocument>
implements PDFDocument<PDDocument>,
Closeable {
    private File pdfFile;

    public PDFDocumentImpl(PDDocument pdf, String id, String name, String contentType) {
        this(pdf, id, name, contentType, null);
    }

    public PDFDocumentImpl(File pdfFile, String id, String name, String contentType) {
        this(pdfFile, id, name, contentType, null);
    }

    public PDFDocumentImpl(PDDocument pdf, String id, String name, String contentType, ReferenceResolver referenceResolver) {
        this(pdf, null, id, name, (DataHandler)PDFDocumentImpl.createPDFDocumentDataHandler(pdf), contentType, referenceResolver);
    }

    public PDFDocumentImpl(File pdfFile, String id, String name, String contentType, ReferenceResolver referenceResolver) {
        this(null, pdfFile, id, name, new DataHandler((Object)new FileDataSource(pdfFile), contentType), contentType, referenceResolver);
    }

    public PDFDocumentImpl(String id, String name, DataHandler dataHandler, String contentType) {
        this(null, null, id, name, dataHandler, contentType, null);
    }

    public PDFDocumentImpl(String id, String name, DataHandler dataHandler, String contentType, ReferenceResolver referenceResolver) {
        this(null, null, id, name, dataHandler, contentType, referenceResolver);
    }

    PDFDocumentImpl(PDDocument pdf, File pdfFile, String id, String name, DataHandler dataHandler, String contentType, ReferenceResolver referenceResolver) {
        super(id, name, dataHandler, contentType, referenceResolver);
        this.parsedDocumentType = pdf;
        this.pdfFile = pdfFile;
    }

    public final synchronized PDDocument getParsed() {
        if (this.parsedDocumentType == null) {
            this.parsedDocumentType = this.getNewParsed();
        }
        return (PDDocument)this.parsedDocumentType;
    }

    public synchronized PDDocument getNewParsed() {
        return PDFDocumentImpl.loadPDFDocument(this);
    }

    public InputStream getInputStream() throws IOException {
        if (this.pdfFile != null) {
            return new FileInputStream(this.pdfFile);
        }
        ReferenceResolver referenceResolver = super.getReferenceResolver();
        String documentName = super.getName();
        if (referenceResolver != null && referenceResolver.canResolve(documentName) && referenceResolver instanceof FileReferenceResolver) {
            return new FileInputStream(((FileReferenceResolver)referenceResolver).getFile(documentName));
        }
        return super.getInputStream();
    }

    public static PDDocument loadPDFDocument(Document document) {
        PDDocument pdf;
        block9: {
            pdf = null;
            try {
                ReferenceResolver referenceResolver = document.getReferenceResolver();
                String documentName = document.getName();
                if (referenceResolver != null && referenceResolver.canResolve(documentName)) {
                    pdf = referenceResolver instanceof FileReferenceResolver ? PDDocument.load((File)((FileReferenceResolver)referenceResolver).getFile(documentName)) : PDDocument.load((InputStream)referenceResolver.getReference(documentName));
                    break block9;
                }
                try (InputStream is = document.getInputStream();){
                    pdf = PDDocument.load((InputStream)is);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return pdf;
    }

    public static CSLDocumentDataHandler<PDDocument> createPDFDocumentDataHandler(PDDocument content) {
        return new CSLDocumentDataHandler((Object)content, "application/pdf");
    }

    @Override
    public void close() throws IOException {
        if (this.parsedDocumentType != null) {
            ((PDDocument)this.parsedDocumentType).close();
        }
    }
}

