/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign.impl.pdfbox;

import de.governikus.csl.pdf.sign.OID;
import de.governikus.csl.pdf.sign.PAdESPartType;
import de.governikus.csl.pdf.sign.PDFSignMessageCode;
import de.governikus.csl.pdf.sign.PDFSignOptions;
import de.governikus.csl.pdf.sign.PDFSignatureForm;
import de.governikus.csl.pdf.sign.PDFSigningPrepareException;
import de.governikus.csl.pdf.sign.PDFVisualSignatureDetails;
import de.governikus.csl.pdf.sign.doc.PDFSignedDocument;
import de.governikus.csl.pdf.sign.impl.PDFSignOptionsImpl;
import de.governikus.csl.pdf.sign.impl.PDFSigningContext;
import de.governikus.csl.pdf.sign.impl.pdfbox.doc.impl.PDFDocumentImpl;
import de.governikus.csl.pdf.sign.impl.pdfbox.doc.impl.PDFSignedDocumentImpl;
import de.governikus.csl.pdf.sign.impl.pdfbox.doc.impl.PDFSimpleParser;
import de.governikus.csl.pdf.sign.impl.pdfbox.utils.PDFCMSPluginSigner;
import de.governikus.csl.pdf.sign.impl.pdfbox.utils.PDFSignatureField;
import de.governikus.csl.pdf.sign.impl.pdfbox.utils.PDFUAUtil;
import de.governikus.csl.pdf.sign.impl.pdfbox.utils.PDFUtils;
import de.governikus.csl.pdf.sign.impl.pdfbox.visual.PDFBoxVisualSignatureHelperImpl;
import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.sign.impl.AbstractSignPlugin;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DataToBeSigned;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Options;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.core.SignedDataResponseImpl;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPlugin;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.UnsignedProperties;
import de.governikus.csl.uom.sign.impl.PreRequestCheckerRegistry;
import de.governikus.csl.uom.sign.props.ContentTimestamp;
import de.governikus.csl.uom.sign.props.NoSigningTime;
import de.governikus.csl.uom.sign.props.PDFContactInfo;
import de.governikus.csl.uom.sign.props.PDFSignerReason;
import de.governikus.csl.uom.sign.props.ProductionPlace;
import de.governikus.csl.uom.sign.props.PropertiesUtil;
import de.governikus.csl.uom.sign.props.SignatureTimestamp;
import de.governikus.csl.uom.sign.props.SigningTime;
import de.governikus.csl.uom.util.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginType(id=Plugin.PluginID.SIGN_PDF, type=SignPlugin.class)
public class PDFSignPluginImpl
extends AbstractSignPlugin {
    private static final String ERROR_MESSAGE_MISSING_FIELD_OR_SIGNATURE = "PDSignatureField or PDSignature are required for signing.";
    private static final int PDF_SIGNATURE_SIZE_BASE_SIZE = 4096;
    static final List<Class<? extends Document>> DOCUMENT_OUTPUT_CLASSES = Collections.unmodifiableList(Arrays.asList(PDFSignedDocument.class));
    private static final Logger LOG = LoggerFactory.getLogger(PDFSignPluginImpl.class);
    private static final int CERTIFICATE_BASE_FACTOR = 2;
    private SignPlugin cmsSignPlugin;

    public PDFSignPluginImpl() throws CSLSignatureException {
        super(DOCUMENT_OUTPUT_CLASSES);
    }

    public PDFSignPluginImpl(SignPlugin cmsSignPlugin) throws CSLSignatureException {
        super(DOCUMENT_OUTPUT_CLASSES);
        this.cmsSignPlugin = PDFSignPluginImpl.assertSignPlugin((SignPlugin)cmsSignPlugin, (Plugin.PluginID)Plugin.PluginID.SIGN_CMS);
    }

    protected void checkPostRequirements(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws IOException, CSLSignatureException {
        Set<PDSignatureField> signatureFields = this.checkCreatePostSignatureFields(context);
        if (context.signatureOptions == null) {
            context.signatureOptions = new SignatureOptions();
        }
        if (context.signatureFields.isEmpty() && context.signature == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, ERROR_MESSAGE_MISSING_FIELD_OR_SIGNATURE);
        }
        LinkedHashSet<PDSignature> signatures = new LinkedHashSet<PDSignature>();
        for (PDSignatureField signatureField : signatureFields) {
            PDSignature signature = signatureField.getSignature();
            if (signature == null || context.existingSignatures.contains(signature) || signature.getCOSObject().containsKey(COSName.CONTENTS)) continue;
            signatures.add(signature);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("newly used signature field with signature: {}", (Object)signatureField.getPartialName());
        }
        if (context.signature != null && !context.existingSignatures.contains(context.signature)) {
            signatures.add((PDSignature)context.signature);
        }
    }

    private Set<PDSignatureField> checkCreatePostSignatureFields(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws IOException {
        Set<PDSignatureField> signatureFields = context.signatureFields;
        if (signatureFields == null) {
            throw new IllegalStateException(ERROR_MESSAGE_MISSING_FIELD_OR_SIGNATURE);
        }
        if (context.signatureFieldToBeSigned == null && context.signature == null) {
            throw new IllegalStateException(ERROR_MESSAGE_MISSING_FIELD_OR_SIGNATURE);
        }
        if (context.signatureFieldToBeSigned != null && ((PDSignatureField)context.signatureFieldToBeSigned).getSignature() == null) {
            throw new IllegalStateException("PDSignature is required for signing - not present at signature field.");
        }
        if (context.signature != null && context.signatureFieldToBeSigned != null && ((PDSignatureField)context.signatureFieldToBeSigned).getSignature() == null) {
            ((PDSignatureField)context.signatureFieldToBeSigned).setValue((PDSignature)context.signature);
        }
        return signatureFields;
    }

    protected void checkPreRequirements(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws CSLSignatureException {
        if (context.outputStream == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "OutputStream shouldn't be null");
        }
        if (context.certChain == null || context.certChain.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "CertificateChain required, please set one with setCertificateChain(...)");
        }
        if (context.privateKeyResource == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "private key resource required, please set one at request");
        }
        if (context.pAdESPartType == null) {
            PDSignature sigDict = null;
            if (context.signature == null) {
                if (context.signatureFields != null && !context.signatureFields.isEmpty()) {
                    sigDict = ((PDSignatureField)context.signatureFields.iterator().next()).getSignature();
                }
            } else {
                sigDict = (PDSignature)context.signature;
            }
            context.signature = sigDict;
            if (sigDict == null || sigDict.getFilter() == null || sigDict.getSubFilter() == null) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "PAdES level required, please set one.");
            }
        }
    }

    private PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> createContext(SignRequest signRequest, Environment env) throws CoreException {
        PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context = new PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions>(signRequest);
        SignOptions options = (SignOptions)signRequest.getOptions();
        context.pdfSignOptions = options instanceof PDFSignOptions ? (PDFSignOptions)options : null;
        context.visualSignatureDetails = context.pdfSignOptions == null ? null : context.pdfSignOptions.getVisualSignatureDetails();
        context.signatureFields = new LinkedHashSet();
        context.visualSignatureFields = context.visualSignatureDetails == null ? new LinkedHashSet() : context.visualSignatureDetails.getVisualSignatureFields();
        context.signature = null;
        context.signerInfo = (SignerInfo)options.getSignerInfos().iterator().next();
        PropertiesUtil.sort((SignerInfo)context.signerInfo, (SignPolicy)((SignPolicy)options.getPolicy()));
        context.algoIdSignature = context.signerInfo.getSignatureAlgorithmURI();
        context.unsignedProperties = (UnsignedProperties)context.signerInfo.getUnsignedProperties().clone();
        context.signedProperties = (SignedProperties)context.signerInfo.getSignedProperties().clone();
        context.existingSignatures = new LinkedHashSet<PDSignature>();
        context.privateKeyResource = (PrivateKeyResourceImpl)context.signerInfo.getKey();
        context.signerCert = (X509Certificate)context.privateKeyResource.getCertificate().certificate();
        context.certChain = context.privateKeyResource.getCertificateChain().certificates();
        context.env = env;
        return context;
    }

    public PDSignatureField createNewPDSignatureField(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws IOException {
        PDDocumentCatalog documentCatalog = ((PDDocument)context.pd).getDocumentCatalog();
        PDAcroForm acroForm = documentCatalog.getAcroForm();
        if (acroForm == null) {
            acroForm = new PDAcroForm((PDDocument)context.pd);
            documentCatalog.setAcroForm(acroForm);
        }
        return new PDSignatureField(acroForm);
    }

    private int getCertificateChainSize(List<Certificate> chain) throws CoreException {
        long result = 0L;
        for (Certificate c : chain) {
            try {
                result += (long)c.getEncoded().length;
            }
            catch (CertificateEncodingException e) {
                throw new CoreException((Throwable)e);
            }
        }
        if (result > Integer.MAX_VALUE) {
            throw new CoreException("CertificateChain size larger than Integer.MAX_VALUE");
        }
        return (int)result;
    }

    private String getSubjectCN(X509Certificate certificate) throws CoreException {
        try {
            X500Name x500name = new JcaX509CertificateHolder(certificate).getSubject();
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            String ret = IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
            ret = ret.replace("\\,", ",");
            ret = ret.replace("\\\"", "\"");
            ret = ret.replace("\\+", "+");
            ret = ret.replace("\\=", "=");
            ret = ret.replace("\\<", "<");
            ret = ret.replace("\\>", ">");
            ret = ret.replace("\\;", ";");
            ret = ret.replace("\\\\", "\\");
            return ret;
        }
        catch (Exception ex) {
            throw new CoreException("certificate no common name");
        }
    }

    private PDFDocumentImpl parseDocumentInt(Options<?> options, Document rawDocument) throws CSLSignatureException, IOException {
        Document d = new PDFSimpleParser().parseDocument(options, rawDocument);
        if (d instanceof PDFDocumentImpl) {
            return (PDFDocumentImpl)PDFDocumentImpl.class.cast(d);
        }
        throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to create PDFDocument instance internally");
    }

    protected void preConfiguration(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws IOException, CoreException {
        PDDocumentCatalog documentCatalog = ((PDDocument)context.pd).getDocumentCatalog();
        PDPageTree allPages = documentCatalog.getPages();
        this.adjustVisualSignatureFields(context, allPages);
        SigningTime signingTime = (SigningTime)PropertiesUtil.getSignedProperty(SigningTime.class, (SignedProperties)context.signedProperties, (boolean)true);
        if (signingTime == null) {
            context.signingTime = new SigningTime(new ConstraintSignPolicy.EncodingConstraint[0]);
        } else {
            context.signedProperties.remove((Object)signingTime);
            context.signingTime = signingTime;
        }
        context.signedProperties.add((Object)new NoSigningTime());
        if (context.pdfSignOptions != null) {
            context.subjectCommonName = null;
            context.signatureFieldName = context.pdfSignOptions.getSignatureFieldName();
        }
        if (context.subjectCommonName == null) {
            context.subjectCommonName = this.getSubjectCN(context.signerCert);
        }
        if (context.pdfSignOptions == null) {
            context.pdfSignOptions = this.createDefaultPDFOptions();
        }
        if (context.signatureOptions == null) {
            context.signatureOptions = new SignatureOptions();
        }
        this.calculatePreferredSignatureSize(context);
        PDSignature pdSignature = this.createPDSignature();
        PDSignatureField field = this.selectPDSignatureField(context, pdSignature);
        this.createPDFVisualSignatureDetails(context, field);
        this.handleSpecialOptions(context, pdSignature);
        context.contentType = OID.DATA;
        this.checkPAdES(context, pdSignature);
    }

    private void adjustVisualSignatureFields(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context, PDPageTree allPages) {
        if (context.visualSignatureFields != null) {
            for (PDFSignatureField sigField : context.visualSignatureFields) {
                if (sigField.getPageNo() <= 0 || sigField.getPageNo() > allPages.getCount()) {
                    throw new IllegalStateException("Page " + sigField.getPageNo() + " not available! Use one between these: 1 and " + allPages.getCount());
                }
                PDPage pdPage = allPages.get(sigField.getPageNo() - 1);
                if (pdPage == null) {
                    throw new IllegalStateException("Page " + sigField.getPageNo() + " not available! Use one between these: 1 and " + allPages.getCount());
                }
                if (sigField.getFieldName() == null || sigField.getFieldName().isEmpty()) {
                    throw new IllegalStateException("Signature FieldName should not be empty");
                }
                this.adjustExistingPDSignatureField(context, sigField, pdPage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPDFVisualSignatureDetails(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context, PDSignatureField field) throws IOException, CoreException {
        PDFVisualSignatureDetails pdfVisualSignatureDetails = context.pdfSignOptions.getVisualSignatureDetails();
        if (pdfVisualSignatureDetails != null && !context.newSignatureField) {
            PDFBoxVisualSignatureHelperImpl visualSignatureHelper = new PDFBoxVisualSignatureHelperImpl();
            visualSignatureHelper.setTempFile(null);
            this.recalculateVisSignature(context.pdfSignOptions, field, (PDDocument)context.pd);
            context.visibleSignature = visualSignatureHelper.handleVisibleSignature(context.pdfSignOptions, context.subjectCommonName, context.signingTime.getAny(), (PDDocument)context.pd);
            context.visibleSignatureAlternateText = visualSignatureHelper.getAlternativeText(context.pdfSignOptions, context.subjectCommonName, context.signingTime.getAny());
            FileInputStream vfis = new FileInputStream(context.visibleSignature);
            try (FileInputStream fis = vfis;){
                ((SignatureOptions)context.signatureOptions).setVisualSignature((InputStream)vfis);
            }
            finally {
                PDFUtils.closeStream(vfis);
            }
            Integer page = pdfVisualSignatureDetails.getPage();
            if (page != null && page == -1) {
                if (pdfVisualSignatureDetails.getCreateNewSignaturePage()) {
                    ((PDDocument)context.pd).getPages().add(new PDPage());
                }
                ((SignatureOptions)context.signatureOptions).setPage(((PDDocument)context.pd).getNumberOfPages() - 1);
            } else {
                ((SignatureOptions)context.signatureOptions).setPage(page == null ? 0 : page - 1);
            }
        }
    }

    private void handleSpecialOptions(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context, PDSignature pdSignature) {
        ProductionPlace productionPlace = (ProductionPlace)PropertiesUtil.getSignedProperty(ProductionPlace.class, (SignedProperties)context.signedProperties, (boolean)true);
        if (productionPlace == null) {
            pdSignature.setLocation(context.pdfSignOptions.getSignerLocation());
        } else {
            pdSignature.setLocation(productionPlace.toPDFSignerLocation());
        }
        PDFSignerReason reason = (PDFSignerReason)PropertiesUtil.getSignedProperty(PDFSignerReason.class, (SignedProperties)context.signedProperties, (boolean)true);
        if (reason == null) {
            pdSignature.setReason(context.pdfSignOptions.getSignerReason());
        } else {
            pdSignature.setReason(reason.getReason());
        }
        PDFContactInfo contactInfo = (PDFContactInfo)PropertiesUtil.getSignedProperty(PDFContactInfo.class, (SignedProperties)context.signedProperties, (boolean)true);
        if (contactInfo == null) {
            pdSignature.setContactInfo(context.pdfSignOptions.getSignerContactInfo());
        } else {
            pdSignature.setContactInfo(contactInfo.getContactInfo());
        }
        if (pdSignature.getSignDate() == null) {
            pdSignature.setSignDate(context.signingTime.getAny());
        }
        if (pdSignature.getFilter() == null) {
            String filter = context.pdfSignOptions.getFilter();
            if (filter == null || filter.isEmpty()) {
                pdSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
            } else {
                pdSignature.setFilter(COSName.getPDFName((String)filter));
            }
        }
    }

    private void checkPAdES(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context, PDSignature pdSignature) throws CSLSignatureException {
        if (PAdESPartType.BASIC.equals((Object)context.pAdESPartType)) {
            String subFilter = context.pdfSignOptions.getSubFilter();
            if (subFilter == null || subFilter.isEmpty()) {
                pdSignature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
            } else {
                pdSignature.setSubFilter(COSName.getPDFName((String)subFilter));
            }
        } else if (PAdESPartType.ENHANCED.equals((Object)context.pAdESPartType)) {
            String subFilter = context.pdfSignOptions.getSubFilter();
            if (subFilter == null || subFilter.isEmpty()) {
                pdSignature.setSubFilter(PDSignature.SUBFILTER_ETSI_CADES_DETACHED);
            } else {
                pdSignature.setSubFilter(COSName.getPDFName((String)subFilter));
            }
        } else if (PAdESPartType.DOCUMENT_TIMESTAMP.equals((Object)context.pAdESPartType)) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "Creating document timestamps isn't supported with PDFSignPluginImpl.");
        }
    }

    private PDSignatureField selectPDSignatureField(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context, PDSignature pdSignature) throws CSLSignatureException, IOException {
        PDSignatureField field = null;
        if (context.signatureFieldName != null) {
            Set findSignatureFields = context.signatureFields;
            for (PDSignatureField pdSignField : findSignatureFields) {
                if (!pdSignField.getPartialName().equals(context.signatureFieldName)) continue;
                field = pdSignField;
                if (field.getSignature() == null) break;
                throw new PDFSigningPrepareException("selected signature field already signed", PDFSignMessageCode.PDF_SIGNATURE_FIELD_TO_SIGN_ALREADY_SIGNED);
            }
            if (field == null) {
                field = this.createNewPDSignatureField(context);
                field.setPartialName(context.signatureFieldName);
                context.signatureFields.add(field);
                context.newSignatureField = true;
            }
            context.signatureFieldToBeSigned = field;
            field.setValue(pdSignature);
            context.signature = null;
        } else {
            context.signature = pdSignature;
        }
        return field;
    }

    private void adjustExistingPDSignatureField(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context, PDFSignatureField sigField, PDPage pdPage) {
        try {
            PDSignatureField pdSignatureField = this.createNewPDSignatureField(context);
            pdSignatureField.setPartialName(sigField.getFieldName());
            pdSignatureField.setAlternateFieldName(sigField.getAlternateFieldName());
            List widgets = pdSignatureField.getWidgets();
            for (PDAnnotationWidget widget : widgets) {
                PDRectangle mediaBox = pdPage.getMediaBox();
                PDRectangle rectangle = new PDRectangle();
                rectangle.setLowerLeftX(sigField.getX());
                rectangle.setLowerLeftY(mediaBox.getUpperRightY() - sigField.getY());
                rectangle.setUpperRightX(sigField.getX() + sigField.getWidth());
                rectangle.setUpperRightY(mediaBox.getUpperRightY() - sigField.getY() - sigField.getHeight());
                widget.setRectangle(rectangle);
                PDAppearanceDictionary pdAppearanceDictionary = new PDAppearanceDictionary();
                PDAppearanceStream appearanceStream = new PDAppearanceStream((PDDocument)context.pd);
                pdAppearanceDictionary.setNormalAppearance(appearanceStream);
                widget.setAppearance(pdAppearanceDictionary);
                widget.setPage(pdPage);
            }
            pdPage.getCOSObject().setNeedToBeUpdated(true);
            context.signatureFields.add(pdSignatureField);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error occured while transforming SignatureField.", e);
        }
    }

    private void calculatePreferredSignatureSize(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws CoreException {
        if (((SignatureOptions)context.signatureOptions).getPreferredSignatureSize() == 0) {
            try {
                int base = 4096;
                int certificateFactor = 2;
                if (!PropertiesUtil.findProperties(ContentTimestamp.class, (List)context.signedProperties).isEmpty()) {
                    base += 4096;
                    certificateFactor *= 2;
                }
                if (!PropertiesUtil.findProperties(SignatureTimestamp.class, (List)context.unsignedProperties).isEmpty()) {
                    base += 4096;
                    certificateFactor *= 2;
                }
                ((SignatureOptions)context.signatureOptions).setPreferredSignatureSize(base + this.getCertificateChainSize(context.certChain) * certificateFactor);
            }
            catch (Exception e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "The size of the certificate chain is larger as the expected Integer.MAX_VALUE");
            }
        }
    }

    private PDSignature createPDSignature() {
        PDSignature result = new PDSignature();
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating PDSignature: {}", (Object)result);
        }
        return result;
    }

    private PDFSignOptions createDefaultPDFOptions() {
        return new PDFSignOptionsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignedDataResponse sign(SignRequest signRequest, Environment env) throws CoreException {
        LOG.debug("entering PDF/PAdES sign ...");
        try {
            PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context = this.prepareSignature(signRequest, env);
            SignedDataResponse signedDataResponse = this.process(context);
            return signedDataResponse;
        }
        finally {
            LOG.debug("leaving PDF/PAdES sign");
        }
    }

    private SignedDataResponse process(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws CoreException {
        this.doSign(context);
        return this.createResult(context);
    }

    private SignedDataResponse createResult(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws CoreException {
        try {
            LOG.debug("response preparing ...");
            SimpleSignedData signedData = new SimpleSignedData(context.contents, (Document)new PDFSignedDocumentImpl(context.outputFile, UUID.randomUUID().toString(), context.outputFile.getAbsolutePath(), "application/pdf"));
            SignedDataResponseImpl signedDataResponseImpl = new SignedDataResponseImpl((SignedData)signedData);
            return signedDataResponseImpl;
        }
        catch (Exception e) {
            throw new CoreException("failed to sign at returning response with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            LOG.debug("response prepared");
        }
    }

    private void doSign(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws CoreException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PDF/PAdES sign processing ...");
        }
        try {
            this.createSignature(context);
        }
        catch (CoreException e) {
            this.closePDDocumentquietly(context);
            throw e;
        }
        catch (IOException e) {
            this.closePDDocumentquietly(context);
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign at closing PDF document: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.closePDDocumentquietly(context);
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            LOG.debug("PDF/PAdES sign processed");
        }
    }

    private PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> prepareSignature(SignRequest signRequest, Environment env) throws CoreException {
        LOG.debug("PDF/PAdES sign preparing ...");
        PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context = null;
        try {
            PDFSignPluginImpl.checkSignRequest((SignRequest)signRequest);
            SignOptions options = (SignOptions)signRequest.getOptions();
            context = this.createContext(signRequest, env);
            LOG.debug("PAdES check signature request");
            PreRequestCheckerRegistry.getRegistry().check(signRequest);
            if (PDFSignOptions.class.isInstance(options)) {
                context.pdfSignOptions = (PDFSignOptions)options;
                context.signatureForm = context.pdfSignOptions.getSignatureForm();
            } else {
                context.signatureForm = null;
            }
            context.contents = new ArrayList<Document>(((DataToBeSigned)signRequest.getDataToBeSigned().get(0)).getDocuments());
            this.readPDF(context, options);
            PDDocument parsed = (PDDocument)context.pdf.getParsed();
            context.pd = parsed;
            context.signatureFields.addAll(((PDDocument)context.pd).getSignatureFields());
            this.findExistingSignatureFields(context);
            context.outputFile = File.createTempFile("signed", ".pdf");
            context.outputStream = new FileOutputStream(context.outputFile);
            context.contents.set(0, context.pdf);
            if (context.signatureForm == null) {
                context.pAdESPartType = PAdESPartType.BASIC;
            } else if (context.signatureForm.ordinal() <= PDFSignatureForm.EPES.ordinal()) {
                context.pAdESPartType = PAdESPartType.ENHANCED;
            } else if (context.signatureForm.equals((Object)PDFSignatureForm.T)) {
                context.pAdESPartType = PAdESPartType.DOCUMENT_TIMESTAMP;
            }
            this.checkPreRequirements(context);
            this.preConfiguration(context);
            this.checkPostRequirements(context);
            if (this.cmsSignPlugin == null) {
                this.cmsSignPlugin = this.getAssertedSignPlugin(Plugin.PluginID.SIGN_CMS);
            }
            context.signer = new PDFCMSPluginSigner(this.cmsSignPlugin, context);
        }
        catch (CoreException e) {
            this.closePDDocumentquietly(context);
            throw e;
        }
        catch (IOException e) {
            this.closePDDocumentquietly(context);
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with io exception: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.closePDDocumentquietly(context);
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            LOG.debug("PDF/PAdES sign prepared");
        }
        return context;
    }

    private void closePDDocumentquietly(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) {
        if (context == null) {
            return;
        }
        if (context.pdf == null) {
            return;
        }
        PDDocument pdDocument = (PDDocument)context.pdf.getParsed();
        if (pdDocument == null) {
            return;
        }
        COSDocument cosDocument = pdDocument.getDocument();
        if (cosDocument == null || cosDocument.isClosed()) {
            return;
        }
        try {
            ((PDDocument)context.pdf.getParsed()).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readPDF(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context, SignOptions options) throws PDFSigningPrepareException, CoreException {
        try {
            context.pdf = this.parseDocumentInt((Options<?>)options, context.contents.get(0));
        }
        catch (IOException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign - reading pdf: " + e.getMessage(), (Throwable)e);
        }
    }

    private void findExistingSignatureFields(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws IOException {
        List existingSignatureFields = ((PDDocument)context.pd).getSignatureFields();
        if (existingSignatureFields != null) {
            for (PDSignatureField existingSignatureField : existingSignatureFields) {
                PDSignature signature = existingSignatureField.getSignature();
                if (signature == null || !(signature.getCOSObject() instanceof COSDictionary) || !signature.getCOSObject().containsKey(COSName.CONTENTS)) continue;
                context.existingSignatures.add(signature);
            }
        }
    }

    private void createSignature(PDFSigningContext<PDDocument, PDSignature, PDSignatureField, SignatureOptions> context) throws CoreException, IOException {
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        try (OutputStream output = context.outputStream;
             PDDocument lpd = (PDDocument)context.pd;){
            List<COSDictionary> previousSignatures = PDFUAUtil.getSignatureWidgets((PDDocument)context.pd);
            ((PDDocument)context.pd).addSignatureField(new ArrayList(context.signatureFieldToBeSigned != null ? Collections.singleton((PDSignatureField)context.signatureFieldToBeSigned) : Collections.emptySet()), context.signer, (SignatureOptions)context.signatureOptions);
            if (context.signature != null) {
                ((PDDocument)context.pd).addSignature((PDSignature)context.signature, context.signer, (SignatureOptions)context.signatureOptions);
            }
            List<COSDictionary> currentSignatures = PDFUAUtil.getSignatureWidgets((PDDocument)context.pd);
            PDFUAUtil.fixPDFUAFeatures((PDDocument)context.pd, previousSignatures, currentSignatures, PDFBoxVisualSignatureHelperImpl.adjustAlternateTextWithImagePresentHint(context.visibleSignatureAlternateText, context.visualSignatureDetails));
            ((PDDocument)context.pd).saveIncremental(output);
            output.flush();
        }
        catch (RuntimeOperatorException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with bc exception: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with io exception: " + e.getMessage(), (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with out of memory error: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            endTime = System.currentTimeMillis();
            LOG.info("signature created, time used: {} s", (Object)((endTime - startTime) / 1000L));
            ((PDDocument)context.pd).close();
        }
    }

    private void recalculateVisSignature(PDFSignOptions pdfSignOptions, PDSignatureField field, PDDocument doc) {
        if (field != null && pdfSignOptions != null) {
            double sw;
            double y2;
            PDAnnotationWidget widget = (PDAnnotationWidget)field.getWidgets().get(0);
            PDPage page = widget.getPage();
            PDRectangle rect = widget.getRectangle();
            double x1 = rect.getLowerLeftX();
            double x2 = rect.getUpperRightX();
            double y1 = rect.getLowerLeftY();
            if (y1 > (y2 = (double)rect.getUpperRightY())) {
                sw = y1;
                y1 = y2;
                y2 = sw;
            }
            if (x1 > x2) {
                sw = x1;
                x1 = x2;
                x2 = sw;
            }
            double width = x2 - x1;
            double height = y2 - y1;
            PDFVisualSignatureDetails visSigOptions = pdfSignOptions.getVisualSignatureDetails();
            visSigOptions.setAbsolutePositionX(x1);
            visSigOptions.setAbsolutePositionY(y1);
            visSigOptions.setPositionX(null);
            visSigOptions.setPositionY(null);
            visSigOptions.setSignatureWidth(width * 2.54 / 72.0);
            visSigOptions.setSignatureHeight(height * 2.54 / 72.0);
            PDDocumentCatalog documentCatalog = doc.getDocumentCatalog();
            PDPageTree allPages = documentCatalog.getPages();
            for (int i = 0; i < allPages.getCount(); ++i) {
                if (!allPages.get(i).equals((Object)page)) continue;
                visSigOptions.setPage(i + 1);
                break;
            }
        }
    }
}

