/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign;

import de.governikus.csl.pdf.sign.PDFSignMessageCode;
import de.governikus.csl.sign.CSLSignatureException;

public class PDFSigningPrepareException
extends CSLSignatureException {
    private static final long serialVersionUID = 6120956185119011279L;
    private final PDFSignMessageCode messageCode;

    public PDFSigningPrepareException(PDFSignMessageCode messageCode) throws CSLSignatureException {
        this(PDFSigningPrepareException.checkMessageCode(messageCode).toString(), messageCode);
    }

    private static PDFSignMessageCode checkMessageCode(PDFSignMessageCode messageCode) throws CSLSignatureException {
        if (messageCode == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "message code is required, null not permitted");
        }
        return messageCode;
    }

    public PDFSigningPrepareException(String message, PDFSignMessageCode messageCode) throws CSLSignatureException {
        super(CSLSignatureException.Failure.SIGNING_PREPARE, message);
        this.messageCode = PDFSigningPrepareException.checkMessageCode(messageCode);
    }

    public PDFSigningPrepareException(String message, Throwable cause, PDFSignMessageCode messageCode) throws CSLSignatureException {
        super(CSLSignatureException.Failure.SIGNING_PREPARE, message, cause);
        this.messageCode = PDFSigningPrepareException.checkMessageCode(messageCode);
    }

    public PDFSignMessageCode getMessageCode() {
        return this.messageCode;
    }
}

