/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pdf.sign;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public enum PDFSignatureInfo {
    DATE_DESC_VISIBLE(InfoType.TYPE_DATE, DescriptionType.DESCRIPTION_VISIBLE),
    DATE_DESC_INVISIBLE(InfoType.TYPE_DATE, DescriptionType.DESCRIPTION_INVISIBLE),
    LOCATION_DESC_VISIBLE(InfoType.TYPE_LOCATION, DescriptionType.DESCRIPTION_VISIBLE),
    LOCATION_DESC_INVISIBLE(InfoType.TYPE_LOCATION, DescriptionType.DESCRIPTION_INVISIBLE),
    REASON_DESC_VISIBLE(InfoType.TYPE_REASON, DescriptionType.DESCRIPTION_VISIBLE),
    REASON_DESC_INVISIBLE(InfoType.TYPE_REASON, DescriptionType.DESCRIPTION_INVISIBLE),
    SIGNER_DESC_VISIBLE(InfoType.TYPE_SIGNER, DescriptionType.DESCRIPTION_VISIBLE),
    SIGNER_DESC_INVISIBLE(InfoType.TYPE_SIGNER, DescriptionType.DESCRIPTION_INVISIBLE);

    public static final List<PDFSignatureInfo> DEFAULTS_VISIBLE;
    public static final List<PDFSignatureInfo> DEFAULTS_DESC_INVISIBLE;
    public static final List<PDFSignatureInfo> DEFAULTS;
    private final InfoType infoType;
    private final DescriptionType descriptionType;

    private PDFSignatureInfo(InfoType infoType, DescriptionType descriptionType) {
        this.infoType = infoType;
        this.descriptionType = descriptionType;
    }

    public static boolean isValid(List<PDFSignatureInfo> list) {
        boolean result = list == null || list.isEmpty() ? true : list.stream().filter(Objects::isNull).count() == 0L && list.stream().noneMatch(e -> list.indexOf(e) != list.lastIndexOf(e)) && list.stream().noneMatch(e -> list.stream().filter(f -> e.infoType == f.infoType).count() > 1L) && list.size() == 4;
        return result;
    }

    public boolean isVisible() {
        return this.descriptionType.isVisible();
    }

    public InfoType getInfoType() {
        return this.infoType;
    }

    public DescriptionType getDescriptionType() {
        return this.descriptionType;
    }

    static {
        DEFAULTS_VISIBLE = Collections.unmodifiableList(List.of(REASON_DESC_VISIBLE, SIGNER_DESC_VISIBLE, LOCATION_DESC_VISIBLE, DATE_DESC_VISIBLE));
        DEFAULTS_DESC_INVISIBLE = Collections.unmodifiableList(List.of(REASON_DESC_INVISIBLE, SIGNER_DESC_INVISIBLE, LOCATION_DESC_INVISIBLE, DATE_DESC_INVISIBLE));
        DEFAULTS = DEFAULTS_VISIBLE;
    }

    public static enum DescriptionType {
        DESCRIPTION_VISIBLE(true),
        DESCRIPTION_INVISIBLE(false);

        private final boolean visible;

        private DescriptionType(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }

    public static enum InfoType {
        TYPE_SIGNER,
        TYPE_LOCATION,
        TYPE_DATE,
        TYPE_REASON;

    }
}

