/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.soap;

import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.soap.SoapExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SoapResponseHandler
implements HttpResponseHandler<SOAPMessage> {
    private MessageFactory messageFactory;

    public SoapResponseHandler(MessageFactory messageFactory) throws SOAPException {
        this.messageFactory = messageFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SOAPMessage handleResponse(HttpResponse resp) throws IOException {
        this.checkResponseStatus(resp);
        MimeHeaders headers = this.createHeaders(resp);
        try (InputStream is = resp.getContent();){
            SOAPMessage sOAPMessage = this.messageFactory.createMessage(headers, is);
            return sOAPMessage;
        }
        catch (SOAPException e) {
            throw new SoapExceptionWrapper(e);
        }
    }

    private MimeHeaders createHeaders(HttpResponse resp) {
        List<HttpHeader> headers = resp.getHeader();
        MimeHeaders mimeHeaders = new MimeHeaders();
        if (headers != null) {
            for (HttpHeader header : headers) {
                mimeHeaders.addHeader(header.getName(), header.getValue());
            }
        }
        return mimeHeaders;
    }

    private void checkResponseStatus(HttpResponse resp) throws SoapExceptionWrapper {
        int status = resp.getStatus();
        if (status != 500 && status / 100 != 2) {
            resp.consumeContentQuietly();
            throw new SoapExceptionWrapper(new SOAPException("Bad response: " + status));
        }
    }
}

