/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.soap;

import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.csl.transport.soap.SoapEntity;
import de.governikus.csl.transport.soap.SoapExceptionWrapper;
import de.governikus.csl.transport.soap.SoapResponseHandler;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractSoapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSoapClient.class);
    private String protocol;
    protected MessageFactory messageFactory;
    protected HttpClient httpClient;

    public AbstractSoapClient() throws SOAPException {
        this.messageFactory = MessageFactory.newInstance();
        this.protocol = "SOAP 1.1 Protocol";
    }

    public AbstractSoapClient(String protocol) throws SOAPException {
        this.messageFactory = MessageFactory.newInstance((String)protocol);
        this.protocol = protocol;
    }

    protected SOAPMessage createSoapMessage(String soapBody) throws SOAPException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(soapBody));
        Document doc = db.parse(is);
        SOAPMessage message = this.messageFactory.createMessage();
        SOAPBody body = message.getSOAPBody();
        body.addDocument(doc);
        if (message.saveRequired()) {
            message.saveChanges();
        }
        return message;
    }

    protected SOAPMessage call(SOAPMessage request, URI to) throws SOAPException {
        HeaderFilterResult filteredHeaders = this.filterHeader(request);
        try {
            return this.httpClient.post(to, (HttpRequest)new SoapEntity(request, filteredHeaders.contentType, filteredHeaders.contentLength), new SoapResponseHandler(this.messageFactory), filteredHeaders.headers);
        }
        catch (ConnectionException e) {
            Throwable cause = e.getCause();
            if (cause != null && SoapExceptionWrapper.class.isInstance(cause)) {
                SoapExceptionWrapper sew = (SoapExceptionWrapper)SoapExceptionWrapper.class.cast(cause);
                throw sew.getDelegate();
            }
            throw new SOAPException((Throwable)e);
        }
        catch (SoapExceptionWrapper e) {
            throw e.getDelegate();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    protected SOAPMessage get(URI to) throws SOAPException {
        try {
            return this.httpClient.get(to, new SoapResponseHandler(this.messageFactory), new HttpHeader[0]);
        }
        catch (ConnectionException e) {
            Throwable cause = e.getCause();
            if (cause != null && SoapExceptionWrapper.class.isInstance(cause)) {
                SoapExceptionWrapper sew = (SoapExceptionWrapper)SoapExceptionWrapper.class.cast(cause);
                throw sew.getDelegate();
            }
            throw new SOAPException((Throwable)e);
        }
        catch (SoapExceptionWrapper e) {
            throw e.getDelegate();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    private HeaderFilterResult filterHeader(SOAPMessage request) {
        HttpHeader[] headers = null;
        String contentType = null;
        int contentLength = -1;
        MimeHeaders mimeHeaders = request.getMimeHeaders();
        if (mimeHeaders != null) {
            ArrayList<HttpHeader> headerList = new ArrayList<HttpHeader>();
            Iterator allHeaders = mimeHeaders.getAllHeaders();
            while (allHeaders.hasNext()) {
                MimeHeader mh = (MimeHeader)allHeaders.next();
                String name = mh.getName();
                if (name.equals("Content-Type")) {
                    contentType = mh.getValue();
                    continue;
                }
                if (name.equals("Content-Length")) {
                    try {
                        contentLength = Integer.parseInt(mh.getValue());
                    }
                    catch (NumberFormatException e) {
                        String msg = "Can't parse ContentLength-Header";
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(msg, (Throwable)e);
                        }
                        LOGGER.info(msg);
                    }
                    continue;
                }
                headerList.add(new HttpHeader(name, mh.getValue()));
            }
            headers = headerList.toArray(new HttpHeader[headerList.size()]);
        }
        if (headers == null) {
            headers = new HttpHeader[]{};
        }
        if (contentType == null) {
            if (this.protocol.equals("SOAP 1.1 Protocol")) {
                contentType = "text/xml";
            } else if (this.protocol.equals("SOAP 1.2 Protocol")) {
                contentType = "application/soap+xml";
            }
        }
        return new HeaderFilterResult(headers, contentType, contentLength);
    }

    private class HeaderFilterResult {
        private HttpHeader[] headers;
        private String contentType;
        private int contentLength;

        public HeaderFilterResult(HttpHeader[] headers, String contentType, int contentLength) {
            this.headers = headers;
            this.contentType = contentType;
            this.contentLength = contentLength;
        }
    }
}

