/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.proxy;

public class WildcardStringMatcher {
    private static final char WILDCARD = '*';
    private char[] wildCardPattern;
    private boolean ignoreCase;

    public WildcardStringMatcher(String pattern) {
        this.wildCardPattern = pattern.toCharArray();
    }

    public WildcardStringMatcher(String pattern, boolean ignoreCase) {
        String value = pattern;
        if (ignoreCase) {
            value = value.toLowerCase();
        }
        this.wildCardPattern = value.toCharArray();
        this.ignoreCase = ignoreCase;
    }

    public boolean matches(String value) {
        if (value == null) {
            return false;
        }
        if (this.ignoreCase) {
            return this.isMatch(value.toLowerCase().toCharArray());
        }
        return this.isMatch(value.toCharArray());
    }

    private boolean isMatch(char[] testee) {
        int testeeIndex = 0;
        int patternIndex = 0;
        int patternIndexAtOccurenceOfWildcard = -1;
        int testeeIndexAtOccurenceOfWildcard = -1;
        while (testeeIndex < testee.length) {
            if (patternIndex < this.wildCardPattern.length && this.wildCardPattern[patternIndex] == testee[testeeIndex]) {
                ++testeeIndex;
                ++patternIndex;
                continue;
            }
            if (patternIndex < this.wildCardPattern.length && this.wildCardPattern[patternIndex] == '*') {
                patternIndexAtOccurenceOfWildcard = patternIndex++;
                testeeIndexAtOccurenceOfWildcard = testeeIndex;
                continue;
            }
            if (patternIndexAtOccurenceOfWildcard != -1) {
                patternIndex = patternIndexAtOccurenceOfWildcard + 1;
                testeeIndex = testeeIndexAtOccurenceOfWildcard + 1;
                ++testeeIndexAtOccurenceOfWildcard;
                continue;
            }
            return false;
        }
        while (patternIndex < this.wildCardPattern.length && this.wildCardPattern[patternIndex] == '*') {
            ++patternIndex;
        }
        return patternIndex == this.wildCardPattern.length;
    }
}

