/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.proxy;

import de.governikus.csl.transport.proxy.WildcardStringMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProxyExceptionsResolver {
    private List<WildcardStringMatcher> wildcardMatchers = new ArrayList<WildcardStringMatcher>();
    private Map<String, String> hostnameExceptions = new HashMap<String, String>();
    private boolean caseSensitive = false;

    public ProxyExceptionsResolver() {
        this(false);
    }

    public ProxyExceptionsResolver(boolean caseSensitive) {
        this.hostnameExceptions.put("localhost", "localhost");
        this.hostnameExceptions.put("127.0.0.1", "127.0.0.1");
        this.caseSensitive = caseSensitive;
    }

    public void addProxyExceptions(List<String> proxyExceptions) {
        if (proxyExceptions == null) {
            return;
        }
        for (String proxyException : proxyExceptions) {
            this.addProxyException(proxyException);
        }
    }

    public void addProxyException(String proxyException) {
        if (proxyException == null || proxyException.isEmpty()) {
            return;
        }
        String exception = proxyException;
        if (!this.caseSensitive) {
            exception = exception.toLowerCase();
        }
        if (exception.contains("*")) {
            this.wildcardMatchers.add(new WildcardStringMatcher(exception));
        } else {
            this.hostnameExceptions.put(exception, exception);
        }
    }

    public boolean isProxyRequired(String hostname) {
        String host = hostname;
        if (!this.caseSensitive) {
            host = host.toLowerCase();
        }
        if (this.hostnameExceptions.containsKey(host)) {
            return false;
        }
        for (WildcardStringMatcher matcher : this.wildcardMatchers) {
            if (!matcher.matches(host)) continue;
            return false;
        }
        return true;
    }

    public int getNumExceptions() {
        return this.hostnameExceptions.size() + this.wildcardMatchers.size();
    }
}

