/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.entity.multipart;

import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.entity.multipart.MultipartConstants;
import de.governikus.csl.transport.entity.multipart.MultipartFormBodyPart;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;

public class MultipartFormRequest
implements HttpRequest {
    private String boundaryStr = this.createBoundary();
    private byte[] boundary = this.boundaryStr.getBytes(MultipartConstants.DEFAULT_ENCODING);
    private List<MultipartFormBodyPart> bodyParts;
    private String contentType = "multipart/form-data; boundary=" + this.boundaryStr;

    public MultipartFormRequest() {
        this.bodyParts = new ArrayList<MultipartFormBodyPart>();
    }

    public void addBodyPart(MultipartFormBodyPart bodyPart) {
        this.bodyParts.add(bodyPart);
    }

    private String createBoundary() {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            sb.append(MultipartConstants.BOUNDARY_CHARS[random.nextInt(MultipartConstants.BOUNDARY_CHARS.length)]);
        }
        return sb.toString();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentEncoding() {
        return MultipartConstants.DEFAULT_ENCODING.name();
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        for (MultipartFormBodyPart bodyPart : this.bodyParts) {
            IOUtils.write((byte[])MultipartConstants.SEPERATOR, (OutputStream)outstream);
            IOUtils.write((byte[])this.boundary, (OutputStream)outstream);
            IOUtils.write((byte[])MultipartConstants.NEWLINE, (OutputStream)outstream);
            bodyPart.writeTo(outstream);
            IOUtils.write((byte[])MultipartConstants.NEWLINE, (OutputStream)outstream);
        }
        IOUtils.write((byte[])MultipartConstants.SEPERATOR, (OutputStream)outstream);
        IOUtils.write((byte[])this.boundary, (OutputStream)outstream);
        IOUtils.write((byte[])MultipartConstants.SEPERATOR, (OutputStream)outstream);
    }

    public String getBoundaryStr() {
        return this.boundaryStr;
    }
}

