/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.transport.entity.multipart;

import de.governikus.csl.transport.entity.multipart.MultipartConstants;
import de.governikus.csl.transport.entity.multipart.MultipartFormBodyPart;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public abstract class AbstractMultipartFormBodyPart
implements MultipartFormBodyPart {
    protected String name;
    protected String contentType;
    protected String contentTransferEncoding;

    public AbstractMultipartFormBodyPart(String name) {
        this.name = name;
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.writeHeader(outstream);
        IOUtils.write((byte[])MultipartConstants.NEWLINE, (OutputStream)outstream);
        this.writeBody(outstream);
    }

    protected abstract void writeBody(OutputStream var1) throws IOException;

    private void writeHeader(OutputStream outstream) throws IOException {
        String additionalContentDisposition;
        StringBuilder sb = new StringBuilder();
        if (this.contentType != null) {
            sb.append("Content-Type: ");
            sb.append(this.contentType);
            sb.append("\r\n");
        }
        if (this.contentTransferEncoding != null) {
            sb.append("Content-Transfer-Encoding: ");
            sb.append(this.contentTransferEncoding);
            sb.append("\r\n");
        }
        sb.append("Content-Disposition: form-data;");
        if (this.name != null) {
            sb.append(" name=\"");
            sb.append(this.name);
            sb.append("\"");
        }
        if ((additionalContentDisposition = this.getAdditionalContentDisposition()) != null) {
            sb.append(";");
            sb.append(additionalContentDisposition);
        }
        IOUtils.write((byte[])sb.toString().getBytes(MultipartConstants.DEFAULT_ENCODING), (OutputStream)outstream);
        IOUtils.write((byte[])MultipartConstants.NEWLINE, (OutputStream)outstream);
    }

    protected String getAdditionalContentDisposition() {
        return null;
    }
}

